/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.salaryslip;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.encrypt.MultiEncryptNewService;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipPersonRecordDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipRecordDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipViewDTO;
import kd.swc.hsbp.common.dto.salary.CalTaskInfo;
import kd.swc.hsbp.common.enums.ReleaseStateEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hscs.business.salaryslip.utils.CalSalarySlipUtils;
import kd.swc.hscs.business.thread.CalSalaryRecoverThreadTask;
import kd.swc.hscs.business.thread.CalSalaryReleaseThreadTask;

public class CalSalarySlipHSCSService {
    private static final Log log = LogFactory.getLog(CalSalarySlipHSCSService.class);

    public void calRelease(String recordId, String calBatchId, Map<Long, Integer> dataPrecisionMap, Map<Long, CalTaskInfo> calTaskInfoMap, Boolean isUseOldView) {
        log.info("begin release,calBatchId = ", (Object)calBatchId);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", recordId));
        Map calBatchMap = (Map)appCache.get(String.format(Locale.ROOT, "calbatch_%s", calBatchId), Map.class);
        if (null == calBatchMap) {
            return;
        }
        List calPersonIdList = (List)calBatchMap.get("calPersonIdList");
        Long calTaskId = (Long)calBatchMap.get("calTaskId");
        CalTaskInfo taskInfo = calTaskInfoMap.get(calTaskId);
        String operationType = null;
        try {
            operationType = (String)calBatchMap.get("operationtype");
            CalSalarySlipViewDTO dto = (CalSalarySlipViewDTO)appCache.get("calSalarySlipView", CalSalarySlipViewDTO.class);
            MultiEncryptNewService service = new MultiEncryptNewService(dto.getEncryptType(), dto.getEncryptLevel());
            List splitList = SWCListUtils.split((List)calPersonIdList, (int)CalSalarySlipUtils.getThreadCalCount());
            for (List list : splitList) {
                CalSalaryReleaseThreadTask task = new CalSalaryReleaseThreadTask(RequestContext.get(), list, dto, service, calBatchId, recordId, operationType, taskInfo, dataPrecisionMap, isUseOldView);
                SWCThreadPoolFactory.getSalarySlipOpThreadpool().submit((Callable)task);
            }
        }
        catch (Exception e) {
            List<CalSalarySlipPersonRecordDTO> list = CalSalarySlipUtils.getCalTableRecordList(ReleaseStateEnum.RELEASEFAILED.getCode(), calPersonIdList);
            CalSalarySlipRecordDTO recordDTO = new CalSalarySlipRecordDTO(recordId, calTaskId, calBatchId, operationType, list, null);
            String resultKey = String.format(Locale.ROOT, "calbatch_result_%s", UUID.randomUUID().toString());
            appCache.put(resultKey, (Object)recordDTO);
            CalSalarySlipUtils.sendSaveMessage(recordId, resultKey);
        }
    }

    public void calRecover(String recordId, String calBatchId) {
        log.info("begin recover,calBatchId = {}", (Object)calBatchId);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", recordId));
        Map calBatchMap = (Map)appCache.get(String.format(Locale.ROOT, "calbatch_%s", calBatchId), Map.class);
        if (null == calBatchMap) {
            return;
        }
        List calPersonIdList = (List)calBatchMap.get("calPersonIdList");
        Long calTaskId = (Long)calBatchMap.get("calTaskId");
        String operationType = null;
        try {
            operationType = (String)calBatchMap.get("operationtype");
            List splitList = SWCListUtils.split((List)calPersonIdList, (int)CalSalarySlipUtils.getThreadCalCount());
            for (List list : splitList) {
                CalSalaryRecoverThreadTask task = new CalSalaryRecoverThreadTask(recordId, RequestContext.get(), calBatchId, calTaskId, list, operationType);
                SWCThreadPoolFactory.getSalarySlipOpThreadpool().submit((Callable)task);
            }
        }
        catch (Exception e) {
            List<CalSalarySlipPersonRecordDTO> list = CalSalarySlipUtils.getCalTableRecordList(ReleaseStateEnum.RELEASED.getCode(), calPersonIdList);
            CalSalarySlipRecordDTO recordDTO = new CalSalarySlipRecordDTO(recordId, calTaskId, calBatchId, operationType, list, null);
            String resultKey = String.format(Locale.ROOT, "calbatch_result_%s", UUID.randomUUID().toString());
            appCache.put(resultKey, (Object)recordDTO);
            CalSalarySlipUtils.sendSaveMessage(recordId, resultKey);
        }
    }
}

