/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.salaryslip;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipPersonRecordDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipRecordDTO;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.ReleaseStateEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hscs.business.thread.CalSalaryReleaseMsgThreadTask;

public class SaveCalSalarySlipRecord {
    private static final Log logger = LogFactory.getLog(SaveCalSalarySlipRecord.class);
    private Long taskId;
    private String recordId;
    private Long batchId;
    private int successCount;
    private int failCount;
    private String operationType;

    private void saveCalSalarySlipRecord(CalSalarySlipRecordDTO batchResult) {
        this.taskId = batchResult.getCalTaskId();
        this.recordId = batchResult.getRecordId();
        this.batchId = Long.parseLong(batchResult.getBatchId());
        this.operationType = batchResult.getOperationType();
        this.successCount = 0;
        this.failCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCalResultData(String recordId, String cacheKey) {
        long beginTime = System.currentTimeMillis();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", recordId));
        HashSet<String> finishSet = (HashSet<String>)appCache.get("calBatchFinishSet", Set.class);
        if (finishSet == null) {
            finishSet = new HashSet<String>(16);
        } else if (finishSet.contains(cacheKey)) {
            return;
        }
        CalSalarySlipRecordDTO batchResult = (CalSalarySlipRecordDTO)appCache.get(cacheKey, CalSalarySlipRecordDTO.class);
        if (null == batchResult) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            this.saveCalSalarySlipRecord(batchResult);
            this.saveOrUpdateSalarySlipData(batchResult.getCalSalarySlipList());
            List calPersonList = batchResult.getCalPersonList();
            HashMap<Long, String> calPersonSalaryStatusMap = new HashMap<Long, String>(calPersonList.size());
            for (CalSalarySlipPersonRecordDTO dto : calPersonList) {
                calPersonSalaryStatusMap.put(dto.getCalPersonId(), dto.getSalaryStatus());
            }
            for (CalSalarySlipPersonRecordDTO dto : calPersonList) {
                calPersonSalaryStatusMap.put(dto.getCalPersonId(), dto.getSalaryStatus());
            }
            this.updateCalTableSalaryStatus(calPersonSalaryStatusMap);
            this.saveCalSalarySlipDetail(calPersonSalaryStatusMap);
        }
        String lockKey = "_updateSaveSalarySlipProcess_" + String.valueOf(recordId);
        DLock lock = DLock.create((String)lockKey);
        try {
            if (lock.tryLock(30000L)) {
                this.updateCalBatch();
                this.updateCalTaskBatch();
                this.updateCalSalaryRecord(appCache);
            }
            finishSet.add(cacheKey);
            appCache.put("calBatchFinishSet", finishSet);
        }
        catch (Exception e) {
            logger.error("save operation or updatestate error,recordId = {}", (Object)recordId, (Object)e);
            this.unLock(CalPersonOperationEnum.OP_RECOVERSALARY.getOperationKey());
            this.unLock(CalPersonOperationEnum.OP_CREATESALARY.getOperationKey());
        }
        finally {
            lock.unlock();
            lock.close();
            appCache.remove(cacheKey);
            if (!"2".equals(this.operationType) && batchResult.getCalSalarySlipList() != null) {
                CalSalaryReleaseMsgThreadTask task = new CalSalaryReleaseMsgThreadTask(RequestContext.get(), batchResult.getCalSalarySlipList());
                SWCThreadPoolFactory.getCommonAsyncThreadpool().execute((Runnable)task);
            }
            logger.info("end save salarySlip data :{}", (Object)(System.currentTimeMillis() - beginTime));
        }
    }

    private void saveCalSalarySlipDetail(Map<Long, String> calTableSalaryStatusMap) {
        if (!calTableSalaryStatusMap.isEmpty()) {
            SWCDataServiceHelper calDetailHelper = new SWCDataServiceHelper("hsas_calsalaryslipdetail");
            DynamicObjectCollection list = new DynamicObjectCollection();
            DynamicObject tempCalDetail = null;
            Long userId = RequestContext.get().getCurrUserId();
            Date date = new Date();
            for (Map.Entry<Long, String> entry : calTableSalaryStatusMap.entrySet()) {
                tempCalDetail = calDetailHelper.generateEmptyDynamicObject();
                tempCalDetail.set("record", (Object)Long.parseLong(this.recordId));
                tempCalDetail.set("batch", (Object)this.batchId);
                tempCalDetail.set("caltask", (Object)this.taskId);
                tempCalDetail.set("calpersonid", (Object)entry.getKey());
                tempCalDetail.set("creator", (Object)userId);
                tempCalDetail.set("createtime", (Object)date);
                String salaryStatus = entry.getValue();
                if (!"2".equals(this.operationType) && ReleaseStateEnum.RELEASED.getCode().equals(salaryStatus)) {
                    ++this.successCount;
                    tempCalDetail.set("operationtype", (Object)"1");
                    tempCalDetail.set("salarystatus", (Object)"2");
                }
                if (ReleaseStateEnum.RELEASEFAILED.getCode().equals(salaryStatus)) {
                    ++this.failCount;
                    tempCalDetail.set("operationtype", (Object)"1");
                    tempCalDetail.set("salarystatus", (Object)"5");
                }
                if (ReleaseStateEnum.RECOVERED.getCode().equals(salaryStatus)) {
                    ++this.successCount;
                    tempCalDetail.set("operationtype", (Object)"1");
                    tempCalDetail.set("salarystatus", (Object)"4");
                }
                if ("2".equals(this.operationType) && ReleaseStateEnum.RELEASED.getCode().equals(salaryStatus)) {
                    ++this.successCount;
                    tempCalDetail.set("operationtype", (Object)"1");
                    tempCalDetail.set("salarystatus", (Object)"6");
                }
                list.add((Object)tempCalDetail);
            }
            calDetailHelper.save(list);
        }
    }

    private void updateCalTableSalaryStatus(Map<Long, String> calPersonSalaryStatusMap) {
        if (!calPersonSalaryStatusMap.isEmpty()) {
            DynamicObject[] dynamicObjects;
            SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
            for (DynamicObject dynamicObject : dynamicObjects = this.getCalPersonList(calPersonSalaryStatusMap.keySet())) {
                Long id = dynamicObject.getLong("id");
                String salaryStatus = calPersonSalaryStatusMap.get(id);
                dynamicObject.set("salarystatus", (Object)salaryStatus);
            }
            calPersonHelper.update(dynamicObjects);
        }
    }

    private DynamicObject[] getCalPersonList(Set<Long> calTableIdList) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        String selectProperties = "id,calmainid,salarystatus";
        QFilter filter = new QFilter("id", "in", calTableIdList);
        return calPersonHelper.query(selectProperties, new QFilter[]{filter});
    }

    private void saveOrUpdateSalarySlipData(List<CalSalarySlipDTO> calSalarySlipList) {
        if (null != calSalarySlipList && !calSalarySlipList.isEmpty()) {
            DynamicObject[] dynamicObjects;
            HashMap<Long, CalSalarySlipDTO> salarySlipUpdateIds = new HashMap<Long, CalSalarySlipDTO>(16);
            DynamicObject[] salarySlipSaveDatas = new DynamicObject[calSalarySlipList.size()];
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryslip");
            ArrayList<Long> salarySlipSavePersonIds = new ArrayList<Long>(10);
            int index = 0;
            for (CalSalarySlipDTO calSalarySlipDTO : calSalarySlipList) {
                if (calSalarySlipDTO.getUpdate().booleanValue()) {
                    salarySlipUpdateIds.put(calSalarySlipDTO.getPrimaryKey(), calSalarySlipDTO);
                    continue;
                }
                DynamicObject salarySlipData = helper.generateEmptyDynamicObject();
                this.setSalarySlipData(salarySlipData, calSalarySlipDTO);
                salarySlipSaveDatas[index] = salarySlipData;
                salarySlipSavePersonIds.add(calSalarySlipDTO.getCalpersonId());
                ++index;
            }
            this.updateSalarySlip(salarySlipSavePersonIds);
            QFilter filter = new QFilter("id", "in", salarySlipUpdateIds.keySet());
            for (DynamicObject object : dynamicObjects = helper.query("id,issend,sendtime", new QFilter[]{filter})) {
                Boolean isInvalidNotEdit;
                Long id = object.getLong("id");
                CalSalarySlipDTO calSalarySlipDTO = (CalSalarySlipDTO)salarySlipUpdateIds.get(id);
                String sendStatus = calSalarySlipDTO.getIssend();
                object.set("issend", (Object)sendStatus);
                Boolean bl = isInvalidNotEdit = calSalarySlipDTO.getInvalidNotEdit() == null ? Boolean.FALSE : calSalarySlipDTO.getInvalidNotEdit();
                if (!"1".equals(sendStatus) || isInvalidNotEdit.booleanValue()) continue;
                object.set("sendtime", (Object)calSalarySlipDTO.getSendtime());
            }
            helper.update(dynamicObjects);
            if (index > 0) {
                helper.save(salarySlipSaveDatas);
            }
        }
    }

    public void updateSalarySlip(List<Long> salarySlipSavePersonIds) {
        if (salarySlipSavePersonIds.isEmpty()) {
            return;
        }
        StringBuilder stateSql = new StringBuilder("update t_hsas_salaryslip set fislastversion = '0' where fcalpersonid in (");
        Object[] entryIds = salarySlipSavePersonIds.toArray();
        for (int i = 0; i < entryIds.length; ++i) {
            stateSql.append('?');
            if (i + 1 >= entryIds.length) continue;
            stateSql.append(',');
        }
        stateSql.append(" ) ");
        stateSql.append("and fislastversion = '1' ");
        SWCDbUtil.update((DBRoute)SWCConstants.SWC_ROUETE, (String)stateSql.toString(), (Object[])entryIds);
    }

    private void setSalarySlipData(DynamicObject salarySlipData, CalSalarySlipDTO calSalarySlipDTO) {
        salarySlipData.set("id", (Object)calSalarySlipDTO.getPrimaryKey());
        salarySlipData.set("person", (Object)calSalarySlipDTO.getPersonId());
        salarySlipData.set("salaryfile", (Object)calSalarySlipDTO.getSalaryfileId());
        salarySlipData.set("salaryfilev", (Object)calSalarySlipDTO.getSalaryfilevId());
        salarySlipData.set("payrolldate", (Object)calSalarySlipDTO.getPayrolldate());
        salarySlipData.set("calcount", (Object)calSalarySlipDTO.getCalcount());
        salarySlipData.set("startdate", (Object)calSalarySlipDTO.getStartdate());
        salarySlipData.set("enddate", (Object)calSalarySlipDTO.getEnddate());
        salarySlipData.set("paysubject", (Object)calSalarySlipDTO.getPaysubjectId());
        salarySlipData.set("paysubjectv", (Object)calSalarySlipDTO.getPaysubjectId());
        salarySlipData.set("caption", (Object)calSalarySlipDTO.getCaption());
        salarySlipData.set("remark", (Object)calSalarySlipDTO.getRemark());
        salarySlipData.set("salaryview", (Object)calSalarySlipDTO.getSalaryviewId());
        salarySlipData.set("salaryviewv", (Object)calSalarySlipDTO.getSalaryviewvId());
        salarySlipData.set("encryptlevel", (Object)calSalarySlipDTO.getEncryptLevel());
        salarySlipData.set("encrypttype", (Object)calSalarySlipDTO.getEncryptType());
        salarySlipData.set("caltask", (Object)this.taskId);
        salarySlipData.set("calpersonid", (Object)calSalarySlipDTO.getCalpersonId());
        salarySlipData.set("salaryslipdata", (Object)calSalarySlipDTO.getStructureJsonString());
        salarySlipData.set("issend", (Object)calSalarySlipDTO.getIssend());
        salarySlipData.set("creator", (Object)calSalarySlipDTO.getCreator());
        salarySlipData.set("modifier", (Object)calSalarySlipDTO.getModifier());
        salarySlipData.set("createtime", (Object)calSalarySlipDTO.getCreatetime());
        salarySlipData.set("sendtime", (Object)calSalarySlipDTO.getSendtime());
        salarySlipData.set("islastversion", (Object)calSalarySlipDTO.getLastVersion());
    }

    private void updateCalBatch() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calsalaryslipbatch");
        String selectProperties = "id,totalcount,successcount,failcount,salarystatus";
        QFilter filter = new QFilter("id", "=", (Object)this.batchId);
        DynamicObject obj = helper.queryOne(selectProperties, new QFilter[]{filter});
        int successBatchCount = this.successCount + obj.getInt("successcount");
        int failBatchCount = this.failCount + obj.getInt("failcount");
        obj.set("successcount", (Object)successBatchCount);
        obj.set("failcount", (Object)failBatchCount);
        int totalCount = obj.getInt("totalcount");
        if (successBatchCount + failBatchCount >= totalCount) {
            if ("2".equals(this.operationType)) {
                obj.set("salarystatus", (Object)"4");
            } else {
                obj.set("salarystatus", (Object)"2");
            }
        }
        helper.updateOne(obj);
    }

    private void updateCalTaskBatch() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltasksalarybatch");
        String selectProperties = "id,totalcount,successcount,failcount,salarystatus";
        QFilter filter = new QFilter("record.id", "=", (Object)Long.parseLong(this.recordId));
        filter.and(new QFilter("caltask.id", "=", (Object)this.taskId));
        DynamicObject obj = helper.queryOne(selectProperties, new QFilter[]{filter});
        int successBatchCount = this.successCount + obj.getInt("successcount");
        logger.info("salaryslip num is {}", (Object)successBatchCount);
        int failBatchCount = this.failCount + obj.getInt("failcount");
        obj.set("successcount", (Object)successBatchCount);
        obj.set("failcount", (Object)failBatchCount);
        int totalCount = obj.getInt("totalcount");
        if (successBatchCount + failBatchCount >= totalCount) {
            if ("2".equals(this.operationType)) {
                obj.set("salarystatus", (Object)"4");
                this.unLock(CalPersonOperationEnum.OP_RECOVERSALARY.getOperationKey());
            } else {
                obj.set("salarystatus", (Object)"2");
                this.unLock(CalPersonOperationEnum.OP_CREATESALARY.getOperationKey());
            }
        }
        helper.updateOne(obj);
    }

    private void updateCalSalaryRecord(ISWCAppCache appCache) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calsalarysliprecord");
        String selectProperties = "id,totalcount,successcount,failcount,salarystatus,endtime";
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(this.recordId));
        DynamicObject obj = helper.queryOne(selectProperties, new QFilter[]{filter});
        int successBatchCount = this.successCount + obj.getInt("successcount");
        int failBatchCount = this.failCount + obj.getInt("failcount");
        obj.set("successcount", (Object)successBatchCount);
        obj.set("failcount", (Object)failBatchCount);
        int totalCount = obj.getInt("totalcount");
        if (successBatchCount + failBatchCount >= totalCount) {
            if ("2".equals(this.operationType)) {
                obj.set("salarystatus", (Object)"4");
            } else {
                obj.set("salarystatus", (Object)"2");
            }
            obj.set("endtime", (Object)new Date());
            appCache.clear();
        }
        helper.updateOne(obj);
    }

    private void unLock(String key) {
        PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(this.taskId), (String)key);
    }
}

