/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.schedule;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.addperson.entity.CalPersonAddProgressInfo;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.vo.SWCOperationResult;
import kd.swc.hscs.business.addperson.helper.AddCalPersonHelper;
import kd.swc.hscs.business.addperson.service.CalAddPersonService;

public class AddCalPersonAsyncTask {
    private static final Log log = LogFactory.getLog(AddCalPersonAsyncTask.class);
    public static final int DEFAULT_SIZE = 500;
    private static final int THREAD_COUNT = 5;

    public void execute(Map<String, Object> arg1) throws KDException, InterruptedException {
        Long calTaskId = (Long)arg1.get("calTaskId");
        List fileIdList = (List)arg1.get("fileIdList");
        Boolean isExc = (Boolean)arg1.get("isExc");
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = taskHelper.queryOriginalOne("id,startdate,enddate,calrulev.id,calrulev.opentaxcal,payrolldate,period,period.id,period.name,period.startdate,period.enddate,paydate,exratedate,calfrequency.id,calcount,payrollgroup.id,payrollgroupv.id,payrollgroupv.islssuepayslip,ishandleproration,payrollscene.id,payrollscenev.id,tasktype", (Object)calTaskId);
        RequestContext ctx = RequestContext.get();
        int size = fileIdList.size();
        List subList = Lists.partition((List)fileIdList, (int)500);
        CountDownLatch countDownLatch = new CountDownLatch(subList.size());
        boolean isPublishSalSlip = PayrollTaskHelper.isPublishPaySlip((DynamicObject)task);
        Map<Long, String> onHoldBillMap = AddCalPersonHelper.getOnHoldBillMap(calTaskId);
        for (List fileIds : subList) {
            SWCThreadPoolFactory.getCalpersonSaveThreadPool().execute(() -> {
                try {
                    RequestContext.copyAndSet((RequestContext)ctx);
                    HashMap<String, SWCOperationResult> result = new HashMap(2);
                    try (TXHandle txHandle = TX.requiresNew();){
                        CalAddPersonService service = new CalAddPersonService(task, fileIds, onHoldBillMap, isPublishSalSlip);
                        service.setExc(isExc);
                        result = service.batchAddCalPerson();
                    }
                    AddCalPersonAsyncTask addCalPersonAsyncTask = this;
                    synchronized (addCalPersonAsyncTask) {
                        AddCalPersonHelper.setProgressToCache(calTaskId, size, result);
                    }
                }
                catch (Exception e) {
                    log.error("\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\u62a5\u9519\uff1a", (Throwable)e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        boolean await = countDownLatch.await(120L, TimeUnit.MINUTES);
        if (!await) {
            log.error("\u6dfb\u52a0\u4eba\u5458\u8d85\u65f6\uff1a{}", (Object)calTaskId);
        }
        CalPersonAddProgressInfo progress = (CalPersonAddProgressInfo)SWCAppCache.get((String)"hsas").get(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), CalPersonAddProgressInfo.class);
        progress.setStatus(2);
        SWCAppCache.get((String)"hsas").put(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), (Object)progress);
    }

    private static /* synthetic */ String lambda$null$2(String v1, String v2) {
        return v1;
    }

    private static /* synthetic */ String lambda$null$1(Exception e, Long o) {
        return e.toString();
    }

    private static /* synthetic */ Long lambda$null$0(Long o) {
        return o;
    }
}

