/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.schedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hscs.business.addperson.service.CalAddPersonService;

public class AddCalPersonForApiTask
implements Callable<List<Long>> {
    private static final Log log = LogFactory.getLog(AddCalPersonForApiTask.class);
    private CountDownLatch countDownLatch;
    private Long calTaskId;
    private List<Long> fileIdList;
    private RequestContext requestContext;
    private List<Long> calPersonIdList = new ArrayList<Long>(10);

    public AddCalPersonForApiTask(CountDownLatch countDownLatch, Long calTaskId, List<Long> fileIdList, RequestContext requestContext) {
        this.countDownLatch = countDownLatch;
        this.calTaskId = calTaskId;
        this.fileIdList = fileIdList;
        this.requestContext = requestContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        log.info("begin add calperson for api ");
        TXHandle txHandle = TX.requiresNew();
        try {
            SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
            DynamicObject task = taskHelper.queryOriginalOne(this.getTaskSelectProp(), (Object)this.calTaskId);
            CalAddPersonService service = new CalAddPersonService(task, this.fileIdList, new HashMap<Long, String>(), true);
            service.batchAddCalPerson();
        }
        catch (Exception exception) {
            log.error("api\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\u62a5\u9519\uff1a", (Throwable)exception);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
            this.countDownLatch.countDown();
        }
        this.calPersonIdList = this.getCalPersonIdsByTaskAndSalaryFile(this.calTaskId, this.fileIdList);
        log.info("finish add calperson for api ");
        return this.calPersonIdList;
    }

    private String getTaskSelectProp() {
        return "id,startdate,enddate,calrulev.id,payrolldate,period,period.id,period.name,paydate,exratedate,calfrequency.id,calcount,payrollgroup.id,payrollgroupv.id,payrollgroupv.islssuepayslip,ishandleproration,payrollscene.id";
    }

    public List<Long> getCalPersonIdsByTaskAndSalaryFile(Long taskId, List<Long> salaryFileIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("caltask", "=", (Object)taskId);
        filter.and("salaryfilev.id", "in", salaryFileIdList);
        DynamicObjectCollection datas = helper.queryOriginalCollection("id", new QFilter[]{filter});
        return datas.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }
}

