/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.schedule;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hscs.business.cal.service.HandleParamsBeforeCalService;
import kd.swc.hscs.business.thread.CancelCalThreadTask;

public class CancelCalAsyncTask {
    private static final Log log = LogFactory.getLog(CancelCalAsyncTask.class);
    private static final int DEFAULT_SIZE = 500;
    private static final int THREAD_COUNT = 4;

    public void execute(Map<String, Object> param) {
        Long calTaskId = (Long)param.get("calTaskId");
        String cancelType = (String)param.get("cancelType");
        List calPersonIdList = (List)param.get("calPersonIdList");
        Long calRecordId = (Long)param.get("calRecordId");
        log.info("CancelCal.execute start,calTaskId = {},calRecordId = {},cancelType = {}", new Object[]{calTaskId, calRecordId, cancelType});
        if (CollectionUtils.isEmpty((Collection)calPersonIdList)) {
            log.info("calPersonIdList is null");
            return;
        }
        this.batchExtractTask(calTaskId, calPersonIdList, calRecordId, cancelType);
        log.info("CancelCal.execute end,calTaskId = {},calRecordId = {},cancelType = {}", new Object[]{calTaskId, calRecordId, cancelType});
    }

    private void batchExtractTask(Long calTaskId, List<Long> calPersonIdList, Long calRecordId, String cancelType) {
        String stopOperateKey = null;
        if ("stopcal".equals(cancelType)) {
            String lockKey = "_addStopOperateKey_" + calRecordId;
            try (DLock lock = DLock.create((String)lockKey);){
                if (lock.tryLock(60000L)) {
                    ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", calRecordId));
                    stopOperateKey = UUID.randomUUID().toString();
                    log.info("calRecordId = {},stopOperateKey = {}", (Object)calRecordId, (Object)stopOperateKey);
                    appCache.put("stopLastOperateKey", (Object)stopOperateKey);
                }
            }
            catch (Exception ex) {
                log.error("batchExtractTask create dlock error", (Throwable)ex);
            }
        }
        DynamicObject calTask = HandleParamsBeforeCalService.getCalTaskInfo(calTaskId);
        List splitList = SWCListUtils.split(calPersonIdList, (int)500);
        CountDownLatch countDownLatch = new CountDownLatch(splitList.size());
        for (List tempIdList : splitList) {
            CancelCalThreadTask task = new CancelCalThreadTask(calTask, tempIdList, calRecordId, RequestContext.get(), countDownLatch, cancelType, stopOperateKey);
            SWCThreadPoolFactory.getCalCancelThreadpool().execute((Runnable)task);
        }
        try {
            countDownLatch.await();
            PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
            PayrollTaskHelper.delTaskAndAccRef((Long)calTaskId);
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
        }
    }
}

