/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.schedule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.calperson.IAddCalPersonExtService;
import kd.sdk.swc.hsas.common.events.calperson.AddJudeUpdateFieldsEvent;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.refreshperson.entity.CalPersonRefreshProgressInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.addperson.helper.AddCalPersonHelper;
import kd.swc.hscs.business.addperson.service.AddCalPersonExtService;
import kd.swc.hscs.business.addperson.service.CalAddPersonService;
import kd.swc.hscs.business.addperson.service.ProrationGenerateService;

public class GetRefreshListTask {
    public final Log log = LogFactory.getLog(GetRefreshListTask.class);
    public static final int DEFAULT_SIZE = 500;
    private static final int THREAD_COUNT = 5;
    private static List<String> propList = new ArrayList<String>(10);
    private static String selectProp;

    public void execute(Map<String, Object> arg1) throws KDException {
        ISWCAppCache cache = SWCAppCache.get((String)"cachekey_hsas_calperson_refresh");
        String refreshType = (String)arg1.get("refreshType");
        Long calTaskId = (Long)arg1.get("calTaskId");
        List sameFileHisIds = (List)arg1.get("sameFileHisIds");
        List sameFileIds = (List)arg1.get("sameFileIds");
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObject taskDy = taskHelper.queryOne((Object)calTaskId);
        QFilter taskFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        CalPersonRefreshProgressInfo calPersonRefreshProgressInfo = (CalPersonRefreshProgressInfo)cache.get(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId), CalPersonRefreshProgressInfo.class);
        Date startDate = calPersonRefreshProgressInfo.getStartDate();
        calPersonRefreshProgressInfo.setUpdateIds(new HashSet(16));
        calPersonRefreshProgressInfo.setUpdateFinish(0);
        if (!SWCStringUtils.equals((String)refreshType, (String)"add")) {
            int pageInt;
            int size = sameFileHisIds.size();
            int page = size % (pageInt = 500) == 0 ? size / pageInt : size / pageInt + 1;
            calPersonRefreshProgressInfo.setUpdateTotal(size);
            if (size == 0) {
                calPersonRefreshProgressInfo.setStatus(2);
                calPersonRefreshProgressInfo.setProgress(100);
            }
            cache.put(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId), (Object)calPersonRefreshProgressInfo);
            Map<Long, String> onHoldBillMap = AddCalPersonHelper.getOnHoldBillMap(calTaskId);
            boolean isPublishSalSlip = PayrollTaskHelper.isPublishPaySlip((DynamicObject)taskDy);
            for (int i = 0; i < page; ++i) {
                int start = i * pageInt;
                int pageEnd = start + pageInt;
                int end = Math.min(pageEnd, size);
                List fileHisIds = sameFileHisIds.subList(start, end);
                List fileIds = sameFileIds.subList(start, end);
                SWCThreadPoolFactory.getCalpersonQueryThreadPool().execute(() -> {
                    try {
                        CalAddPersonService service = new CalAddPersonService(taskDy, fileHisIds, onHoldBillMap, isPublishSalSlip);
                        DynamicObjectCollection newCalPersons = service.batchGetCalPerson();
                        List<String> extPropList = this.callExtAddFields();
                        ArrayList<String> allPropList = new ArrayList<String>(propList);
                        allPropList.addAll(extPropList);
                        StringBuilder sb = new StringBuilder(selectProp);
                        if (extPropList.size() > 0) {
                            sb.append(',');
                            sb.append(String.join((CharSequence)",", extPropList));
                        }
                        QFilter idFilter = new QFilter("salaryfile.id", "in", (Object)fileIds);
                        DynamicObject[] oldCalPersons = calPersonHelper.query(sb.toString(), new QFilter[]{idFilter, taskFilter}, "salaryfile.id desc");
                        HashSet<Long> updateIdsCache = new HashSet<Long>(16);
                        block4: for (int j = 0; j < newCalPersons.size(); ++j) {
                            DynamicObject newCalPerson = (DynamicObject)newCalPersons.get(j);
                            for (String prop : allPropList) {
                                String oldCalPersonProp;
                                String propPre = prop.split("\\.")[0];
                                String newCalPersonProp = newCalPerson.getString(propPre);
                                if (SWCStringUtils.equals((String)prop, (String)"salaryfilev.id")) {
                                    newCalPersonProp = newCalPerson.getString(prop);
                                }
                                if ((oldCalPersonProp = oldCalPersons[j].getString(prop)) == null) {
                                    oldCalPersonProp = "0";
                                }
                                if (newCalPersonProp == null) {
                                    newCalPersonProp = "0";
                                }
                                if (newCalPersonProp.equals(oldCalPersonProp)) continue;
                                this.log.info("updata  calperson,calpersonID = {},prop = {},newCalPersonProp = {},newCalPersonProp = {}", new Object[]{oldCalPersons[j].getLong("id"), prop, newCalPersonProp, oldCalPersonProp});
                                updateIdsCache.add(newCalPerson.getLong("salaryfilev.id"));
                                continue block4;
                            }
                        }
                        if (taskDy.getBoolean("ishandleproration")) {
                            try {
                                ProrationGenerateService prorationGenerateService = new ProrationGenerateService(taskDy, null);
                                prorationGenerateService.checkUpdate(newCalPersons, oldCalPersons, updateIdsCache);
                            }
                            catch (Exception exception) {
                                this.log.error("\u68c0\u67e5\u5206\u6bb5\u5907\u4efd\u5931\u8d25", (Throwable)exception);
                            }
                        }
                        this.setProgressToCache(calTaskId, newCalPersons.size(), updateIdsCache, startDate);
                    }
                    catch (Exception exception) {
                        this.log.error("\u5bf9\u6bd4\u662f\u5426\u9700\u8981\u66f4\u65b0\u5931\u8d25", (Throwable)exception);
                    }
                });
            }
        } else {
            calPersonRefreshProgressInfo.setProgress(100);
            calPersonRefreshProgressInfo.setStatus(2);
            cache.put(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId), (Object)calPersonRefreshProgressInfo);
        }
    }

    private List<String> callExtAddFields() {
        ArrayList<String> extPropList = new ArrayList<String>(10);
        AddJudeUpdateFieldsEvent event = new AddJudeUpdateFieldsEvent(extPropList);
        AddCalPersonExtService addCalPersonExtService = new AddCalPersonExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)addCalPersonExtService, IAddCalPersonExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.calperson.IAddCalPersonExtService#addJudeUpdateFields", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.addJudeUpdateFields(event);
            return null;
        });
        return extPropList;
    }

    private synchronized void setProgressToCache(long calTaskId, int finishCount, Set<Long> updateIdSet, Date startDate) {
        this.log.info("\u8bbe\u7f6e\u7f13\u5b58\uff0c\u6210\u529f\u6570{}", (Object)finishCount);
        ISWCAppCache cache = SWCAppCache.get((String)"cachekey_hsas_calperson_refresh");
        CalPersonRefreshProgressInfo progressInfo = (CalPersonRefreshProgressInfo)cache.get(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId), CalPersonRefreshProgressInfo.class);
        if (progressInfo.getStartDate().getTime() != startDate.getTime()) {
            return;
        }
        HashSet<Long> updateIds = progressInfo.getUpdateIds();
        int updateFinish = progressInfo.getUpdateFinish();
        int updateTotal = progressInfo.getUpdateTotal();
        if (updateIds == null) {
            updateIds = new HashSet<Long>(16);
        }
        updateIds.addAll(updateIdSet);
        progressInfo.setUpdateIds(updateIds);
        progressInfo.setUpdateFinish(updateFinish += finishCount);
        int progress = new BigDecimal(String.valueOf(updateFinish)).divide(new BigDecimal(String.valueOf(updateTotal)), 2, 1).multiply(new BigDecimal("100")).intValue();
        progressInfo.setProgress(progress / 2 + 50);
        if (updateFinish == updateTotal) {
            progressInfo.setStatus(2);
        }
        cache.put(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId), (Object)progressInfo);
    }

    static {
        propList.add("empnumber");
        propList.add("name");
        propList.add("filenumber");
        propList.add("org.id");
        propList.add("salaryfilev.id");
        propList.add("personhrv.id");
        propList.add("belongperiod");
        propList.add("calperiod.id");
        propList.add("employeev.id");
        propList.add("pernontspropv.id");
        propList.add("empentrelv.id");
        propList.add("trialperiodv.id");
        propList.add("empjobrelv.id");
        propList.add("perserlenv.id");
        propList.add("manascoperecordv.id");
        propList.add("empposorgrelhrv.id");
        propList.add("adminorg.id");
        propList.add("empgroup.id");
        propList.add("pertspropv.id");
        selectProp = "empnumber,name,filenumber,org.id,salaryfile.id,salaryfilev.id,personhrv.id,belongperiod,calperiod.id,employeev.id,pernontspropv.id,empentrelv.id,trialperiodv.id,empjobrelv.id,perserlenv.id,manascoperecordv.id,empposorgrelhrv.id,adminorg.id,empgroup.id,pertspropv.id";
    }
}

