/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.schedule;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.serverless.api.JobRequest;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.business.formula.utils.FormulaCacheUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalRequestStatusEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.enums.FailureTypeEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.helper.CalOperationHelper;
import kd.swc.hscs.business.cal.service.CalService;
import kd.swc.hscs.business.cal.service.HandleParamsBeforeCalService;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.business.thread.ServerlessJobThreadTask;
import kd.swc.hscs.common.enums.OperationTypeEnum;
import kd.swc.hscs.common.vo.CalOperationVO;
import org.jetbrains.annotations.Nullable;

public class SalaryCalculateAsyncTask {
    private static final Log log = LogFactory.getLog(SalaryCalculateAsyncTask.class);
    private static final String JOBNAME = "SalaryCalculateJob";
    private static final long ORGID = 100000L;
    private static final String VIEWTYPE = "15";
    private static final String USESERVERLESS_KEY = "useserverless";

    public void execute(Long calTaskId, Long recordId, String calType, boolean resultCheck, boolean isSyncCal, Map<Long, Map<String, Object>> responseMap) {
        log.info("SalaryCalculateAsyncTask  start, calTaskId = {},recordId = {},calType = {}", new Object[]{calTaskId, recordId, calType});
        Date startDate = new Date();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", recordId));
        List calBatchIdList = (List)appCache.get("calBatchIdList", List.class);
        if (CalUtils.isTerminationCal(recordId)) {
            return;
        }
        try {
            HandleParamsBeforeCalService handleParamsBeforeCalService = new HandleParamsBeforeCalService();
            handleParamsBeforeCalService.handleParamsBeforCal(calTaskId, recordId, calType);
            DynamicObjectCollection calDetailList = this.buildCalingCalDetailList(calBatchIdList, calTaskId, recordId, appCache);
            SWCDataServiceHelper calDetailHelper = new SWCDataServiceHelper("hsas_caldetail");
            calDetailHelper.save(calDetailList);
        }
        catch (Exception e) {
            log.error("handleParamsBeforCal fail", (Throwable)e);
            this.handleCalFail(calBatchIdList, calTaskId, recordId, appCache, e.getMessage(), calType);
            appCache.remove(String.format(Locale.ROOT, "cache_calPersonIdList_Key_%s", recordId));
            appCache.remove("calPersonFileRelMap");
            appCache.remove("oldCalStatusMap");
            appCache.remove(String.format(Locale.ROOT, "CALPARAM_%s_%s", recordId, calType));
            CalOperationVO operationVO = CalUtils.genCalOperationObj(RequestContext.get().getTraceId(), calType, 0, 0);
            CalUtils.addCalOperation(recordId, 0L, OperationTypeEnum.EXPAND.getCode(), startDate, operationVO);
            if (isSyncCal) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
            return;
        }
        if (CalUtils.isTerminationCal(recordId)) {
            return;
        }
        appCache.remove("calBatchIdList");
        appCache.remove("countryId");
        appCache.remove("calPersonFileRelMap");
        appCache.remove(String.format(Locale.ROOT, "cache_calPersonIdList_Key_%s", recordId));
        Boolean isUseServerless = this.getIsUseServerlessFlag();
        try {
            if (isUseServerless != null && isUseServerless.booleanValue() && !isSyncCal) {
                this.useServerless(String.valueOf(calTaskId), String.valueOf(recordId), calBatchIdList, resultCheck);
            } else {
                for (String batchId : calBatchIdList) {
                    this.batchCal(calTaskId, recordId, batchId, resultCheck, responseMap, isSyncCal);
                }
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
        CalOperationVO operationVO = CalUtils.genCalOperationObj(RequestContext.get().getTraceId(), calType, 0, 0);
        CalUtils.addCalOperation(recordId, 0L, OperationTypeEnum.EXPAND.getCode(), startDate, operationVO);
        log.info("SalaryCalculateAsyncTask end, calTaskId = {},recordId = {},calType = {}", new Object[]{calTaskId, recordId, calType});
    }

    private void batchCal(Long calTaskId, Long recordId, String batchId, boolean resultCheck, Map<Long, Map<String, Object>> responseMap, boolean isSyncCal) {
        Map<String, Object> params = this.getCalParamsMap(String.valueOf(calTaskId), String.valueOf(recordId), batchId, resultCheck);
        if (isSyncCal) {
            CalService calService = new CalService(String.valueOf(calTaskId), String.valueOf(recordId), batchId, isSyncCal, responseMap);
            calService.cal((List)params.get("calPersonIdList"), (String)params.get("calType"), false, true);
        } else {
            CalUtils.sendBatchCalMessage(params);
        }
    }

    @Nullable
    private Boolean getIsUseServerlessFlag() {
        Boolean isUseServerless = null;
        try {
            AppParam appParam = new AppParam();
            appParam.setAppId("/UHLXNRR9KPZ");
            appParam.setOrgId(Long.valueOf(100000L));
            appParam.setViewType(VIEWTYPE);
            isUseServerless = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)USESERVERLESS_KEY);
        }
        catch (Exception e) {
            log.error("get app parameter error", (Throwable)e);
            isUseServerless = false;
        }
        log.info("isUseServerless = {}", (Object)isUseServerless);
        return isUseServerless;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCalFail(List<String> calBatchIdList, Long calTaskId, Long recordId, ISWCAppCache appCache, String msg, String calType) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        List canCalPersonIdList = (List)appCache.get(String.format(Locale.ROOT, "cache_calPersonIdList_Key_%s", recordId), List.class);
        QFilter qFilter = new QFilter("id", "in", (Object)canCalPersonIdList);
        DynamicObject[] calPersons = calPersonHelper.query("id,calstatus", new QFilter[]{qFilter});
        Map<Long, DynamicObject> calPersonMap = Arrays.asList(calPersons).stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
        DynamicObjectCollection calDetailList = this.buildFailCalDetailList(calBatchIdList, calTaskId, recordId, appCache, msg, calPersonMap);
        SWCDataServiceHelper calRecordHelper = new SWCDataServiceHelper("hsas_calrecord");
        DynamicObject calRecord = calRecordHelper.queryOne("id,calstatus,endtime,sucesscount,failcount,modifytime", (Object)recordId);
        calRecord.set("calstatus", (Object)"2");
        calRecord.set("endtime", (Object)new Date());
        calRecord.set("modifytime", (Object)new Date());
        calRecord.set("sucesscount", (Object)0);
        calRecord.set("failcount", (Object)canCalPersonIdList.size());
        try (TXHandle txHandle = TX.requiresNew();){
            calRecordHelper.updateOne(calRecord);
            CalRequestHelper.updateCalRequest((Long)recordId, (String)CalRequestStatusEnum.FINISHED.getCode());
            calPersonHelper.update(calPersonMap.values().toArray(new DynamicObject[calPersonMap.size()]));
            SWCDataServiceHelper calDetailHelper = new SWCDataServiceHelper("hsas_caldetail");
            calDetailHelper.save(calDetailList);
            this.updateProgress(recordId, canCalPersonIdList.size());
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_CAL.getOperationKey());
            PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
            if (SWCStringUtils.equals((String)"preTaxCal", (String)calType)) {
                String countryId = (String)appCache.get("countryId", String.class);
                CalOperationHelper.invokeTaxReleaseOpResource(String.valueOf(recordId), countryId);
            }
        }
    }

    private void updateProgress(Long recordId, int failCount) {
        ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", recordId));
        FormulaCacheUtils.updateProgress((ISWCAppCache)calProgressAppCache, (int)0, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "pretax_cal_progress_%s", recordId));
        FormulaCacheUtils.updateProgress((ISWCAppCache)calProgressAppCache, (int)0, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "tax_cal_progress_%s", recordId));
        FormulaCacheUtils.updateProgress((ISWCAppCache)calProgressAppCache, (int)0, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "calrecord_progress_%s", recordId));
    }

    private DynamicObjectCollection buildFailCalDetailList(List<String> calBatchIdList, Long calTaskId, Long recordId, ISWCAppCache appCache, String msg, Map<Long, DynamicObject> calPersonMap) {
        Map calPersonFileRelMap = (Map)appCache.get("calPersonFileRelMap", Map.class);
        DynamicObjectCollection calDetailList = new DynamicObjectCollection();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_caldetail");
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (String calBatchId : calBatchIdList) {
            Map calBatchMap = (Map)appCache.get(String.format(Locale.ROOT, "calbatch_%s", calBatchId), Map.class);
            List calPersonIdList = (List)calBatchMap.get("calPersonIdList");
            if (calPersonIdList == null) continue;
            for (Long calPersonId : calPersonIdList) {
                DynamicObject calDetail = (DynamicObject)type.createInstance();
                calDetail.set("calpersonid", (Object)calPersonId);
                calDetail.set("salaryfile", calPersonFileRelMap.get(String.valueOf(calPersonId)));
                calDetail.set("record", (Object)recordId);
                calDetail.set("batch", (Object)calBatchId);
                calDetail.set("caltask", (Object)calTaskId);
                calDetail.set("calstatus", (Object)CalStatusEnum.FAIL.getCode());
                calDetail.set("failtype", (Object)FailureTypeEnum.ANALYSIS_FAIL.getCode());
                if (msg != null && msg.length() > 900) {
                    calDetail.set("failmsg", (Object)msg.substring(0, 900));
                } else {
                    calDetail.set("failmsg", (Object)msg);
                }
                calDetail.set("creator", (Object)userId);
                calDetail.set("createtime", (Object)date);
                calDetail.set("modifier", (Object)userId);
                calDetail.set("modifytime", (Object)date);
                calDetailList.add((Object)calDetail);
                DynamicObject calPerson = calPersonMap.get(calPersonId);
                String calStatus = this.getCalStatusWhenFail(calPerson.getString("calstatus"));
                calPerson.set("calstatus", (Object)calStatus);
            }
            appCache.remove(String.format(Locale.ROOT, "calbatch_%s", calBatchId));
        }
        return calDetailList;
    }

    private String getCalStatusWhenFail(String calStatus) {
        String state = SWCStringUtils.equals((String)calStatus, (String)CalStateEnum.CALING.getCode()) ? CalStateEnum.PRECAL_ERROR.getCode() : (SWCStringUtils.equals((String)calStatus, (String)CalStateEnum.PRECAL_CALED.getCode()) ? CalStateEnum.PUSHTAX_ERROR.getCode() : (SWCStringUtils.equals((String)calStatus, (String)CalStateEnum.TAX_CALED.getCode()) ? CalStateEnum.AFTERCAL_ERROR.getCode() : calStatus));
        return state;
    }

    private DynamicObjectCollection buildCalingCalDetailList(List<String> calBatchIdList, Long calTaskId, Long recordId, ISWCAppCache appCache) {
        Map calPersonFileRelMap = (Map)appCache.get("calPersonFileRelMap", Map.class);
        DynamicObjectCollection calDetailList = new DynamicObjectCollection();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_caldetail");
        Map calBatchMap = null;
        DynamicObject calDetail = null;
        List calPersonIdList = null;
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (String calBatchId : calBatchIdList) {
            calBatchMap = (Map)appCache.get(String.format(Locale.ROOT, "calbatch_%s", calBatchId), Map.class);
            calPersonIdList = (List)calBatchMap.get("calPersonIdList");
            if (calPersonIdList == null) continue;
            for (Long calPersonId : calPersonIdList) {
                calDetail = (DynamicObject)type.createInstance();
                calDetail.set("calpersonid", (Object)calPersonId);
                calDetail.set("salaryfile", calPersonFileRelMap.get(String.valueOf(calPersonId)));
                calDetail.set("record", (Object)recordId);
                calDetail.set("batch", (Object)calBatchId);
                calDetail.set("caltask", (Object)calTaskId);
                calDetail.set("calstatus", (Object)CalStatusEnum.CALING.getCode());
                calDetail.set("creator", (Object)userId);
                calDetail.set("createtime", (Object)date);
                calDetail.set("modifier", (Object)userId);
                calDetail.set("modifytime", (Object)date);
                calDetailList.add((Object)calDetail);
            }
        }
        return calDetailList;
    }

    private void useServerless(String calTaskId, String recordId, List<String> calBatchIdList, boolean resultCheck) {
        JobRequest jobTask = null;
        Map<String, Object> params = null;
        ServerlessJobThreadTask task = null;
        for (String calBatchId : calBatchIdList) {
            params = this.getCalParamsMap(calTaskId, recordId, calBatchId, resultCheck);
            jobTask = new JobRequest(JOBNAME, (Serializable)((Object)params));
            task = new ServerlessJobThreadTask(jobTask, RequestContext.get());
            SWCThreadPoolFactory.getServerlessCreateThreadpool().execute((Runnable)task);
        }
    }

    private Map<String, Object> getCalParamsMap(String calTaskId, String recordId, String calBatchId, boolean resultCheck) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", recordId));
        Map calBatchMap = (Map)appCache.get(String.format(Locale.ROOT, "calbatch_%s", calBatchId), Map.class);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("calTaskId", calTaskId);
        params.put("calRecordId", recordId);
        params.put("calBatchId", calBatchId);
        params.put("calType", calBatchMap.get("calType"));
        params.put("calPersonIdList", calBatchMap.get("calPersonIdList"));
        params.put("resultcheck", resultCheck);
        params.put("mqSendTime", System.currentTimeMillis());
        appCache.remove(String.format(Locale.ROOT, "calbatch_%s", calBatchId));
        return params;
    }
}

