/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.schedule.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.refreshperson.entity.CalPersonRefreshProgressInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class GetRefreshListHelper {
    private static final Log logger = LogFactory.getLog(GetRefreshListHelper.class);

    public static Map<String, Object> getRefreshIdMap(Long calTaskId, List<Long> selectIds) {
        DynamicObject[] oldCalPersons;
        DynamicObject[] fileDys;
        Date startDate = new Date();
        CalPersonRefreshProgressInfo progressInfo = GetRefreshListHelper.createProgressInfo(calTaskId);
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter taskFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        QFilter exceptionFilter = new QFilter("addfiletype", "=", (Object)"1");
        DynamicObject[] exceptionCalPerson = calPersonHelper.query("salaryfilev.id,salaryfilev.boid", new QFilter[]{taskFilter, exceptionFilter});
        ArrayList exceptionCalPersonBoId = new ArrayList(10);
        Arrays.stream(exceptionCalPerson).forEach(e -> exceptionCalPersonBoId.add(e.getLong("salaryfilev.boid")));
        List salaryFileHisIds = CalPersonHelper.getCouldAddPersonListForRefresh((Long)calTaskId);
        logger.info("getRefreshaddList {}", (Object)salaryFileHisIds.size());
        List exceptionSalaryFileHisIds = CalPersonHelper.getExceptionForRefresh((Long)calTaskId, exceptionCalPersonBoId);
        exceptionSalaryFileHisIds.forEach(o -> {
            if (!salaryFileHisIds.contains(o)) {
                salaryFileHisIds.add(o);
            }
        });
        Collections.sort(salaryFileHisIds);
        ArrayList<Long> salaryFileIds = new ArrayList<Long>(10);
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter fileIdFilter = new QFilter("id", "in", (Object)salaryFileHisIds);
        for (DynamicObject file : fileDys = fileHelper.query("boid", new QFilter[]{fileIdFilter}, "id asc")) {
            if (exceptionCalPersonBoId.contains(file.getLong("boid"))) {
                if (exceptionSalaryFileHisIds.contains(file.getLong("id"))) {
                    salaryFileIds.add(file.getLong("boid"));
                    continue;
                }
                salaryFileHisIds.remove(file.getLong("id"));
                continue;
            }
            salaryFileIds.add(file.getLong("boid"));
        }
        Set<Long> oldSalaryFileIds = new HashSet<Long>(10);
        ArrayList<Long> oldSalaryFileIdsIsCal = new ArrayList<Long>(10);
        ArrayList sameFileHisIds = new ArrayList(10);
        ArrayList<Long> sameFileIds = new ArrayList<Long>(10);
        HashSet addIds = new HashSet(10);
        QFilter[] qFilters = new QFilter[]{taskFilter};
        for (DynamicObject oldCalPerson : oldCalPersons = calPersonHelper.query("salaryfile.id,calstatus,onholdstatus", qFilters)) {
            boolean unHold;
            boolean unCal = SWCStringUtils.equals((String)oldCalPerson.getString("calstatus"), (String)CalStateEnum.UNCAL.getCode());
            boolean bl = unHold = SWCStringUtils.equals((String)oldCalPerson.getString("onholdstatus"), (String)"") || oldCalPerson.getInt("onholdstatus") == OnHoldStatusEnum.STATUS_RELEASE.getCode();
            if (unCal && unHold) {
                oldSalaryFileIds.add(oldCalPerson.getLong("salaryfile.id"));
                continue;
            }
            oldSalaryFileIdsIsCal.add(oldCalPerson.getLong("salaryfile.id"));
        }
        for (int i = 0; i < salaryFileIds.size(); ++i) {
            long newSalaryFileId = (Long)salaryFileIds.get(i);
            if (oldSalaryFileIds.remove(newSalaryFileId)) {
                sameFileHisIds.add(salaryFileHisIds.get(i));
                sameFileIds.add(newSalaryFileId);
                continue;
            }
            if (oldSalaryFileIdsIsCal.contains(newSalaryFileId)) continue;
            addIds.add(salaryFileHisIds.get(i));
        }
        if (!selectIds.isEmpty()) {
            QFilter selectIdFilter = new QFilter("id", "in", selectIds);
            DynamicObject[] selectDys = calPersonHelper.query("salaryfile.id", new QFilter[]{selectIdFilter});
            List selectFileIds = Arrays.stream(selectDys).map(o -> o.getLong("salaryfile.id")).collect(Collectors.toList());
            Iterator sameFileIterator = sameFileIds.iterator();
            Iterator sameFileHisIterator = sameFileHisIds.iterator();
            Iterator delFileIterator = oldSalaryFileIds.iterator();
            while (sameFileIterator.hasNext()) {
                Long fileId = (Long)sameFileIterator.next();
                sameFileHisIterator.next();
                if (selectFileIds.contains(fileId)) continue;
                sameFileIterator.remove();
                sameFileHisIterator.remove();
            }
            while (delFileIterator.hasNext()) {
                if (selectFileIds.contains(delFileIterator.next())) continue;
                delFileIterator.remove();
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ISWCAppCache cache = SWCAppCache.get((String)"cachekey_hsas_calperson_refresh");
        progressInfo = (CalPersonRefreshProgressInfo)cache.get(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId), CalPersonRefreshProgressInfo.class);
        if (progressInfo == null) {
            return resultMap;
        }
        if (progressInfo.getStartDate().getTime() / 1000L != startDate.getTime() / 1000L) {
            return resultMap;
        }
        QFilter delFilter = new QFilter("salaryfile", "in", oldSalaryFileIds);
        delFilter.and("caltask.id", "=", (Object)calTaskId);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
        if (authorizedDataRuleQFilter != null) {
            for (QFilter qFilter : authorizedDataRuleQFilter) {
                delFilter.and(qFilter);
            }
        } else {
            delFilter.and("1", "!=", (Object)1);
        }
        DynamicObjectCollection delPersons = calPersonHelper.queryOriginalCollection("salaryfile.id", new QFilter[]{delFilter});
        oldSalaryFileIds = delPersons.stream().map(o -> o.getLong("salaryfile.id")).collect(Collectors.toSet());
        progressInfo.setAddIds(addIds);
        progressInfo.setDelIds(oldSalaryFileIds);
        cache.put(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId), (Object)progressInfo);
        resultMap.put("sameFileIds", sameFileIds);
        resultMap.put("sameFileHisIds", sameFileHisIds);
        return resultMap;
    }

    private static CalPersonRefreshProgressInfo createProgressInfo(Long calTaskId) {
        ISWCAppCache cache = SWCAppCache.get((String)"cachekey_hsas_calperson_refresh");
        CalPersonRefreshProgressInfo calPersonRefreshProgressInfo = new CalPersonRefreshProgressInfo();
        calPersonRefreshProgressInfo.setStatus(1);
        calPersonRefreshProgressInfo.setStartDate(new Date());
        calPersonRefreshProgressInfo.setShowInProgress(true);
        cache.put(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId), (Object)calPersonRefreshProgressInfo);
        return calPersonRefreshProgressInfo;
    }
}

