/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.schedule.salaryslip;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.serverless.api.JobRequest;
import kd.bos.serverless.api.ServerlessFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.dto.salary.CalTaskInfo;
import kd.swc.hscs.business.salaryslip.utils.CalSalarySlipUtils;
import kd.swc.hscs.business.thread.CalSalaryReleaseServerlessJobThreadTask;

public class CalSalaryReleaseAsyncTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(CalSalaryReleaseAsyncTask.class);
    private static final String JOBNAME = "CalSalaryReleaseJob";
    private static final String USESERVERLESS_KEY = "useserverless";
    private Map<Long, Integer> dataprecisionMap;
    private Map<Long, CalTaskInfo> calTaskInfoMap;

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        String recordId = String.valueOf(params.get("recordId"));
        log.info("CalSalaryReleaseAsyncTask  start, recordId = {}", (Object)recordId);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", recordId));
        List calBatchIdList = (List)appCache.get("calBatchIdList", List.class);
        List calTaskIdList = (List)appCache.get("calTaskIdList", List.class);
        Boolean isUseOldView = (Boolean)appCache.get("calIsUseOldView", Boolean.class);
        Boolean isUseServerLess = null;
        try {
            this.instanceDataPrecisionMap();
            DynamicObject[] objects = this.getTaskDataByTaskId(calTaskIdList);
            HashMap<Long, List<Long>> calRulevIdMap = new HashMap<Long, List<Long>>(calTaskIdList.size());
            this.getCalTaskInfo(objects, calRulevIdMap);
            this.findSalaryItem(calRulevIdMap);
            AppParam appParam = CalSalarySlipUtils.getAppParam();
            isUseServerLess = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)USESERVERLESS_KEY);
            log.info("isUseServerLess ={}", (Object)isUseServerLess);
            if (isUseServerLess != null && isUseServerLess.booleanValue()) {
                this.useServerless(recordId, calBatchIdList, isUseOldView);
            } else {
                Map<String, Object> calParams = null;
                for (String batchId : calBatchIdList) {
                    calParams = this.getCalParamsMap(recordId, batchId, isUseOldView);
                    CalSalarySlipUtils.sendBatchCalMessage(calParams);
                }
            }
            log.info("SalaryCalculateAsyncTask end,recordId = {}", (Object)recordId);
        }
        catch (Exception e) {
            log.error("get app parameter error", (Throwable)e);
        }
    }

    private void useServerless(String recordId, List<String> calBatchIdList, Boolean isUseOldView) {
        JobRequest jobTask = null;
        Map<String, Object> params = null;
        CalSalaryReleaseServerlessJobThreadTask task = null;
        for (String calBatchId : calBatchIdList) {
            params = this.getCalParamsMap(recordId, calBatchId, isUseOldView);
            jobTask = new JobRequest(JOBNAME, (Serializable)((Object)params));
            task = new CalSalaryReleaseServerlessJobThreadTask(jobTask, RequestContext.get());
            SWCThreadPoolFactory.getServerlessCreateThreadpool().execute((Runnable)task);
        }
    }

    private Map<String, Object> getCalParamsMap(String recordId, String calBatchId, Boolean isUseOldView) {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("calRecordId", recordId);
        params.put("calBatchId", calBatchId);
        params.put("calIsUseOldView", isUseOldView);
        params.put("data_precision", this.dataprecisionMap);
        params.put("caltask_relation", this.calTaskInfoMap);
        return params;
    }

    private void submit(String batchId, JobRequest jobTask, List<String> failSubmitList) {
        int timeout = 3600;
        String msg = null;
        log.info("submit serverless job begin,jobId={}", (Object)jobTask.getJobid());
        try {
            ServerlessFactory.createSubmitter().submit(jobTask, timeout);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            failSubmitList.add(batchId);
            msg = ResManager.loadKDString((String)"\u6279\u6b21\u4e3a\u201c{0}\u201d\u63d0\u4ea4\u6269\u5bb9\u5931\u8d25\uff1a\u6269\u5bb9\u4efb\u52a1ID\u4e3a{1}\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a{2}\u3002", (String)"SalaryCalculateAsyncTask_0", (String)"swc-hscs-business", (Object[])new Object[0]);
            log.error(MessageFormat.format(msg, batchId, jobTask.getJobid(), e.getMessage()));
        }
        msg = ResManager.loadKDString((String)"\u6279\u6b21\u4e3a\u201c{0}\u201d\u63d0\u4ea4\u6269\u5bb9\u6210\u529f\uff0c\u6269\u5bb9\u4efb\u52a1ID\u4e3a{1}\u3002", (String)"SalaryCalculateAsyncTask_1", (String)"swc-hscs-business", (Object[])new Object[0]);
        log.info(MessageFormat.format(msg, batchId, jobTask.getJobid()));
    }

    private void instanceDataPrecisionMap() {
        if (this.dataprecisionMap == null) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_dataprecision");
            QFilter filter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
            DynamicObject[] objects = helper.query("id,scale", new QFilter[]{filter});
            this.dataprecisionMap = new HashMap<Long, Integer>(objects.length);
            for (DynamicObject dynamicObject : objects) {
                this.dataprecisionMap.put(dynamicObject.getLong("id"), dynamicObject.getInt("scale"));
            }
        }
    }

    private DynamicObject[] getTaskDataByTaskId(List<Long> calTaskIdList) {
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter taskFilter = new QFilter("id", "in", calTaskIdList);
        DynamicObject[] taskObjects = taskHelper.query("id,payrolldate,tasktype,paydate,calcount,STARTDATE,ENDDATE,calrulev.id,payrollgroupv.currency,payrollgroup.id", new QFilter[]{taskFilter});
        return taskObjects;
    }

    private Map<Long, List<Long>> getSumViewListMapByGroupId(DynamicObject[] tasks) {
        HashSet<Long> payGroupIdSet = new HashSet<Long>(16);
        for (DynamicObject task : tasks) {
            payGroupIdSet.add(task.getLong("payrollgroupv.id"));
        }
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter filter = new QFilter("id", "in", payGroupIdSet);
        DynamicObject[] payGroupCol = taskHelper.query("id,payrollgrpmulsum", new QFilter[]{filter});
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(16);
        for (DynamicObject payGroup : payGroupCol) {
            List sumViewList = payGroup.getDynamicObjectCollection("payrollgrpmulsum").stream().map(data -> data.getLong("fbasedataid.id")).collect(Collectors.toList());
            map.put(payGroup.getLong("id"), sumViewList);
        }
        return map;
    }

    private void getCalTaskInfo(DynamicObject[] taskObjects, Map<Long, List<Long>> calRulevIdMap) {
        this.calTaskInfoMap = new HashMap<Long, CalTaskInfo>(taskObjects.length);
        Map<Long, List<Long>> sumViewListMap = this.getSumViewListMapByGroupId(taskObjects);
        for (DynamicObject taskObject : taskObjects) {
            Long id = taskObject.getLong("id");
            Long calCurrencyId = taskObject.getLong("payrollgroupv.currency.id");
            int calCurrencyScale = taskObject.getInt("payrollgroupv.currency.amtprecision");
            Long calRulevId = taskObject.getLong("calrulev.id");
            Date payrolldate = taskObject.getDate("payrolldate");
            Long calcount = taskObject.getLong("calcount");
            Date startdate = taskObject.getDate("STARTDATE");
            Date enddate = taskObject.getDate("ENDDATE");
            CalTaskInfo taskInfo = new CalTaskInfo();
            taskInfo.setTaskId(id);
            taskInfo.setCalCurrencyId(calCurrencyId);
            taskInfo.setCalCurrencyScale(Integer.valueOf(calCurrencyScale));
            taskInfo.setCalrulevId(calCurrencyId);
            taskInfo.setCalrulevId(calRulevId);
            taskInfo.setPayrollDate(payrolldate);
            taskInfo.setCalCount(calcount);
            taskInfo.setStartDate(startdate);
            taskInfo.setEndDate(enddate);
            taskInfo.setPayDate(taskObject.getDate("paydate"));
            taskInfo.setPayrollgroupId(Long.valueOf(taskObject.getLong("payrollgroup.id")));
            taskInfo.setTaskType(taskObject.getString("tasktype"));
            taskInfo.setSalarySlipSumViewList((List)sumViewListMap.getOrDefault(taskObject.getLong("payrollgroupv.id"), new ArrayList()));
            this.calTaskInfoMap.put(id, taskInfo);
            List taskIdList = calRulevIdMap.getOrDefault(calRulevId, new ArrayList());
            taskIdList.add(id);
            calRulevIdMap.put(calRulevId, taskIdList);
        }
    }

    private void findSalaryItem(Map<Long, List<Long>> calRulevIdMap) {
        DynamicObject[] calRuleDatas;
        SWCDataServiceHelper taskRuleHelper = new SWCDataServiceHelper("hsas_calrule");
        QFilter taskRuleFilter = new QFilter("id", "in", calRulevIdMap.keySet());
        for (DynamicObject calRuleData : calRuleDatas = taskRuleHelper.query("id,totalsalary,netsalary,calruleitementry.salaryitem,calruleitementry.ispayoutitem", new QFilter[]{taskRuleFilter})) {
            Long id = calRuleData.getLong("id");
            DynamicObjectCollection itemCollection = calRuleData.getDynamicObjectCollection("calruleitementry");
            HashSet<Long> payItemIdSet = new HashSet<Long>(16);
            for (DynamicObject itemData : itemCollection) {
                long salaryItemId = itemData.getLong("salaryitem.id");
                if (!itemData.getString("ispayoutitem").equals("1")) continue;
                payItemIdSet.add(salaryItemId);
            }
            List<Long> taskIds = calRulevIdMap.get(id);
            if (taskIds == null) continue;
            taskIds.forEach(taskId -> {
                CalTaskInfo taskInfo = this.calTaskInfoMap.get(taskId);
                taskInfo.setTotalSalaryItemId(Long.valueOf(calRuleData.getLong("totalsalary.id")));
                taskInfo.setNetSalaryItemId(Long.valueOf(calRuleData.getLong("netsalary.id")));
                taskInfo.setPayItemIdSet(payItemIdSet);
            });
        }
    }
}

