/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.thread;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hscs.business.cal.result.ResultCheckService;
import kd.swc.hscs.common.vo.CalResultVO;

public class CalResultCheckTask
implements Callable<Object> {
    private static final Log log = LogFactory.getLog(CalResultCheckTask.class);
    private List<CalResultVO> calResultList;
    private DynamicObject task;
    private Map<Long, DynamicObject> successCalMap;
    private List<Map<String, Object>> tempResultList;
    private DynamicObject checkSchemeObj;
    private RequestContext requestContext;

    public CalResultCheckTask(List<CalResultVO> calResultList, DynamicObject task, Map<Long, DynamicObject> successCalMap, List<Map<String, Object>> tempResultList, RequestContext requestContext, DynamicObject checkSchemeObj) {
        this.calResultList = calResultList;
        this.task = task;
        this.successCalMap = successCalMap;
        this.tempResultList = tempResultList;
        this.requestContext = requestContext;
        this.checkSchemeObj = checkSchemeObj;
    }

    @Override
    public Object call() {
        try {
            RequestContext.copyAndSet((RequestContext)this.requestContext);
            String traceId = this.getTraceId();
            log.info("begin calResultCheck,traceId:{}", (Object)traceId);
            ResultCheckService resultCheckService = new ResultCheckService();
            resultCheckService.saveResultCheckData(this.checkSchemeObj, this.successCalMap, this.calResultList, this.tempResultList, this.task);
        }
        catch (Exception exception) {
            log.error("saveResultCheckData error ", (Throwable)exception);
        }
        return null;
    }

    private String getTraceId() {
        return UUID.randomUUID().toString();
    }
}

