/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.thread;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipPersonRecordDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipRecordDTO;
import kd.swc.hsbp.common.enums.ReleaseStateEnum;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hscs.business.salaryslip.utils.CalSalarySlipUtils;

public class CalSalaryRecoverThreadTask
implements Callable<String> {
    private static final Log log = LogFactory.getLog(CalSalaryRecoverThreadTask.class);
    private String recordId;
    private RequestContext requestContext;
    private String calBatchId;
    private Long calTaskId;
    private String operationType;
    private List<Long> calList;

    public CalSalaryRecoverThreadTask(String recordId, RequestContext requestContext, String calBatchId, Long calTaskId, List<Long> calList, String operationType) {
        this.recordId = recordId;
        this.requestContext = requestContext;
        this.calBatchId = calBatchId;
        this.calTaskId = calTaskId;
        this.calList = calList;
        this.operationType = operationType;
    }

    @Override
    public String call() {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        String threadName = Thread.currentThread().getName();
        log.info("begin recover call,calBatchId={},thread name = {}", (Object)this.calBatchId, (Object)threadName);
        List<Long> salarySlipList = null;
        ArrayList<CalSalarySlipDTO> calSalarySlipList = new ArrayList<CalSalarySlipDTO>(this.calList.size());
        try {
            salarySlipList = this.getSalarySlipIds(calSalarySlipList);
            String resultString = (String)SWCMServiceUtils.invokeSWCService((String)"hspp", (String)"IHSPPService", (String)"clearSalaryByIds", (Object[])new Object[]{salarySlipList});
            log.error("hspp recover status:{}", (Object)resultString);
            CalSalarySlipUtils.setCalSalarySlipList(resultString, calSalarySlipList, "3");
            if ("success".equals(resultString)) {
                this.salarySlipSuccess(calSalarySlipList);
            } else {
                this.salarySlipFail(calSalarySlipList);
            }
        }
        catch (Exception e) {
            log.error("Recover call fail,calBatchId={}", (Object)this.calBatchId);
            this.salarySlipFail(calSalarySlipList);
        }
        return null;
    }

    private List<Long> getSalarySlipIds(List<CalSalarySlipDTO> calSalarySlipList) {
        SWCDataServiceHelper salarySlipHelper = new SWCDataServiceHelper("hsas_salaryslip");
        QFilter idsReleasedFilter = new QFilter("calpersonid", "in", this.calList);
        QFilter sendFilter = new QFilter("issend", "in", Arrays.asList("1", "0"));
        DynamicObject[] salarySlipDyObj = salarySlipHelper.query("id,issend", new QFilter[]{idsReleasedFilter, sendFilter});
        ArrayList<Long> salarySlipList = new ArrayList<Long>(salarySlipDyObj.length);
        for (DynamicObject dynamicObject : salarySlipDyObj) {
            Long id = dynamicObject.getLong("id");
            CalSalarySlipDTO dto = new CalSalarySlipDTO();
            dto.setPrimaryKey(id);
            dto.setUpdate(Boolean.TRUE);
            dto.setModifier(RequestContext.get().getUserId());
            calSalarySlipList.add(dto);
            salarySlipList.add(id);
        }
        return salarySlipList;
    }

    private void salarySlipFail(List<CalSalarySlipDTO> calSalarySlipList) {
        log.info("exception calSalary,calBatchId = {}", (Object)this.calBatchId);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", this.recordId));
        List<CalSalarySlipPersonRecordDTO> list = CalSalarySlipUtils.getCalTableRecordList(ReleaseStateEnum.RELEASED.getCode(), this.calList);
        CalSalarySlipRecordDTO recordDTO = new CalSalarySlipRecordDTO(this.recordId, this.calTaskId, this.calBatchId, this.operationType, list, calSalarySlipList);
        String resultKey = String.format(Locale.ROOT, "calbatch_result_%s", UUID.randomUUID().toString());
        appCache.put(resultKey, (Object)recordDTO);
        CalSalarySlipUtils.sendSaveMessage(this.recordId, resultKey);
    }

    private void salarySlipSuccess(List<CalSalarySlipDTO> calSalarySlipList) {
        log.info("exception calSalary,calBatchId = {}", (Object)this.calBatchId);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", this.recordId));
        List<CalSalarySlipPersonRecordDTO> list = CalSalarySlipUtils.getCalTableRecordList(ReleaseStateEnum.RECOVERED.getCode(), this.calList);
        CalSalarySlipRecordDTO recordDTO = new CalSalarySlipRecordDTO(this.recordId, this.calTaskId, this.calBatchId, this.operationType, list, calSalarySlipList);
        String resultKey = String.format(Locale.ROOT, "calbatch_result_%s", UUID.randomUUID().toString());
        appCache.put(resultKey, (Object)recordDTO);
        CalSalarySlipUtils.sendSaveMessage(this.recordId, resultKey);
    }
}

