/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.thread;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipMSGDTO;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class CalSalaryReleaseMsgThreadTask
implements Runnable {
    private static final Log log = LogFactory.getLog(CalSalaryReleaseMsgThreadTask.class);
    private RequestContext requestContext;
    private List<CalSalarySlipDTO> calSalarySlipList;

    public CalSalaryReleaseMsgThreadTask(RequestContext requestContext, List<CalSalarySlipDTO> calSalarySlipList) {
        this.requestContext = requestContext;
        this.calSalarySlipList = calSalarySlipList;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        this.releaseSendMsg(this.calSalarySlipList);
    }

    private void releaseSendMsg(List<CalSalarySlipDTO> calSalarySlipList) {
        Map<Long, Long> personIdMapByUserIds = this.getPersonIdsMapByUserIdIds(calSalarySlipList.stream().map(CalSalarySlipDTO::getPersonId).collect(Collectors.toList()));
        calSalarySlipList.forEach(calSalarySlipDTO -> calSalarySlipDTO.setUserId((Long)personIdMapByUserIds.get(calSalarySlipDTO.getPersonId())));
        for (CalSalarySlipDTO salarySlipDTO : calSalarySlipList) {
            List<MessageInfo> infos = this.initMessageInfo(salarySlipDTO);
            for (MessageInfo info : infos) {
                MessageCenterServiceHelper.sendMessage((MessageInfo)info);
            }
        }
    }

    private List<MessageInfo> initMessageInfo(CalSalarySlipDTO salarySlipDTO) {
        List msgdtos = salarySlipDTO.getMsgdtos();
        ArrayList<MessageInfo> infos = new ArrayList<MessageInfo>(msgdtos.size());
        for (CalSalarySlipMSGDTO msgdto : msgdtos) {
            MessageInfo info = new MessageInfo();
            info.setUserIds(Collections.singletonList(salarySlipDTO.getUserId()));
            info.setType("message");
            info.setEntityNumber("hsas_salaryslip");
            info.setBizDataId(salarySlipDTO.getPrimaryKey());
            info.setTplScene(msgdto.getTplScenel());
            info.setNotifyType(msgdto.getNotifyType());
            info.setTag(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u67e5\u8be2\u901a\u77e5", (String)"CalSalaryReleaseMsgThreadTask_0", (String)"swc-hscs-business", (Object[])new Object[0]));
            info.setTitle(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u67e5\u8be2\u901a\u77e5", (String)"CalSalaryReleaseMsgThreadTask_0", (String)"swc-hscs-business", (Object[])new Object[0]));
            String startDate = salarySlipDTO.getStartdate() == null ? "" : SWCDateTimeUtils.format((Date)salarySlipDTO.getStartdate(), (String)"yyyy-MM-dd");
            String endDate = salarySlipDTO.getEnddate() == null ? "" : SWCDateTimeUtils.format((Date)salarySlipDTO.getEnddate(), (String)"yyyy-MM-dd");
            info.setContent(MessageFormat.format(ResManager.loadKDString((String)"{0}-{1}\u7684\u85aa\u8d44\u6570\u636e\u5df2\u53d1\u81f3\u79fb\u52a8\u7aef\u5de5\u8d44\u6761\u5e94\u7528\u4e2d\uff0c\u53ef\u524d\u5f80\u67e5\u8be2\uff0c\u8c22\u8c22\u3002", (String)"CalSalaryReleaseMsgThreadTask_1", (String)"swc-hscs-business", (Object[])new Object[0]), startDate, endDate));
            infos.add(info);
        }
        return infos;
    }

    private Map<Long, Long> getPersonIdsMapByUserIdIds(List<Long> personIds) {
        HashMap<Long, Long> personUserRelMap = new HashMap<Long, Long>(16);
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>(16);
        idMaps.put("person", personIds);
        Map resultMap = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        Boolean success = (Boolean)resultMap.get("success");
        if (success.booleanValue()) {
            Map data = (Map)resultMap.get("data");
            data.forEach((personId, userInfo) -> personUserRelMap.put((Long)personId, (Long)userInfo.get("user")));
        }
        return personUserRelMap;
    }
}

