/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.servicehelper;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>(16);

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230\u3002", (String)"ServiceFactory_0", (String)"swc-hscs-servicehelper", (Object[])new Object[0]), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put("IHSCSService", "kd.swc.hscs.mservice.HSCSService");
        serviceMap.put("IHSCSCostService", "kd.swc.hscs.mservice.HSCSCostService");
        serviceMap.put("ICalTableService", "kd.swc.hscs.mservice.CalTableService");
        serviceMap.put("IDataGradeCalService", "kd.swc.hscs.mservice.DataGradeCalService");
        serviceMap.put("IFuncCheckService", "kd.swc.hscs.mservice.FuncCheckService");
        serviceMap.put("ICalPersonService", "kd.swc.hscs.mservice.CalPersonService");
        serviceMap.put("ISalarySlipService", "kd.swc.hscs.mservice.SalarySlipService");
        serviceMap.put("IImportTaskService", "kd.swc.hscs.mservice.ImportTaskService");
        serviceMap.put("IPayDetailService", "kd.swc.hscs.mservice.PayDetailService");
        serviceMap.put("IHSCSCostAllotDetailService", "kd.swc.hscs.mservice.HSCSCostAllotDetailService");
        serviceMap.put("ISalaryCalToolService", "kd.swc.hscs.mservice.SalaryCalToolService");
    }
}

