/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.mservice;

import com.google.common.collect.Lists;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.swc.hsbp.business.addperson.entity.CalPersonAddProgressInfo;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.proration.HandleProrationHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonLockEnum;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskVO;
import kd.swc.hscs.business.addperson.helper.AddCalPersonHelper;
import kd.swc.hscs.business.addperson.service.CalAddPersonService;
import kd.swc.hscs.business.schedule.AddCalPersonAsyncTask;
import kd.swc.hscs.business.schedule.AddCalPersonForApiTask;
import kd.swc.hscs.business.schedule.GetRefreshListTask;
import kd.swc.hscs.business.schedule.RefreshCalPersonTask;
import kd.swc.hscs.business.schedule.helper.GetRefreshListHelper;
import kd.swc.hscs.business.schedule.helper.UpdateCalPersonHelper;
import kd.swc.hscs.mservice.api.ICalPersonService;

public class CalPersonService
implements ICalPersonService {
    private static final Log log = LogFactory.getLog(CalPersonService.class);
    private static final ExecutorService addPersonExecutorService = ThreadPools.newExecutorService((String)"apiAddCapPersonPool", (int)2);

    public String addCalPersonWhenCreateTask(Long calTaskId) {
        String error = CalPersonHelper.tryLock((Long)calTaskId, (CalPersonLockEnum)CalPersonLockEnum.ADD);
        if (SWCStringUtils.isNotEmpty((String)error)) {
            return error;
        }
        log.info("HSCSService.addCalPersonWhenCreateTask: add calperson handle request start,calTaskId={}", (Object)calTaskId);
        this.addCalPersonWhenCreateTask(calTaskId, null);
        log.info("HSCSService.addCalPersonWhenCreateTask: add calperson handle request end,calTaskId={}", (Object)calTaskId);
        return null;
    }

    private String addCalPersonWhenCreateTask(Long calTaskId, Long trackerId) {
        log.info("add calperson handle request start,calTaskId={}", (Object)calTaskId);
        RequestContext ctx = RequestContext.get();
        HashMap<String, Constable> addpersonParams = new HashMap<String, Constable>(16);
        addpersonParams.put("calTaskId", calTaskId);
        addpersonParams.put("isExc", Boolean.FALSE);
        CalPersonAddProgressInfo progress = new CalPersonAddProgressInfo();
        progress.setPageSize(500);
        progress.setStartDate(new Date());
        progress.setStatus(0);
        SWCAppCache.get((String)"hsas").put(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), (Object)progress);
        ThreadPools.executeOnce((String)"SALARYADDPERSON_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            log.info("asyncService.addPerson");
            try {
                List couldAddPersonList = CalPersonHelper.getCouldAddPersonList((Long)calTaskId, (Long)trackerId);
                progress.setFileIds(couldAddPersonList);
                progress.setTotal(couldAddPersonList.size());
                progress.setRemain(couldAddPersonList.size());
                SWCAppCache.get((String)"hsas").put(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), (Object)progress);
                addpersonParams.put("fileIdList", (Constable)((Object)couldAddPersonList));
                AddCalPersonAsyncTask asyncService = new AddCalPersonAsyncTask();
                asyncService.execute(addpersonParams);
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u4eba\u5458\u62a5\u9519", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
            }
            finally {
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_ADDCALPERSON.getOperationKey());
                CalPersonHelper.releaseLock((Long)calTaskId);
            }
        });
        log.info("add calperson handle request end,calTaskId={}", (Object)calTaskId);
        return null;
    }

    public String addCalPersonByTemplateWhenCreateTask(Long calTaskId, Long trackerId) {
        String error = CalPersonHelper.tryLock((Long)calTaskId, (CalPersonLockEnum)CalPersonLockEnum.ADD);
        if (SWCStringUtils.isNotEmpty((String)error)) {
            return error;
        }
        log.info("HSCSService.addCalPersonByTemplateWhenCreateTask: add calperson handle request start,calTaskId={}", (Object)calTaskId);
        this.addCalPersonWhenCreateTask(calTaskId, trackerId);
        log.info("HSCSService.addCalPersonByTemplateWhenCreateTask: add calperson handle request end,calTaskId={}", (Object)calTaskId);
        return null;
    }

    public String addCalPerson(Long calTaskId, List<Long> fileIdList, Boolean isExc) {
        String error = CalPersonHelper.tryLock((Long)calTaskId, (CalPersonLockEnum)CalPersonLockEnum.ADD);
        if (SWCStringUtils.isNotEmpty((String)error)) {
            return error;
        }
        log.info("add calperson handle request start,calTaskId={}", (Object)calTaskId);
        HashMap<String, Object> addpersonParams = new HashMap<String, Object>(16);
        addpersonParams.put("calTaskId", calTaskId);
        addpersonParams.put("fileIdList", fileIdList);
        addpersonParams.put("isExc", isExc);
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"SALARYADDPERSON_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            CalPersonAddProgressInfo progress = (CalPersonAddProgressInfo)SWCAppCache.get((String)"hsas").get(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), CalPersonAddProgressInfo.class);
            progress.setPageSize(500);
            SWCAppCache.get((String)"hsas").put(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), (Object)progress);
            AddCalPersonAsyncTask asyncService = new AddCalPersonAsyncTask();
            try {
                if (!isExc.booleanValue()) {
                    List couldAddPersonList = CalPersonHelper.getCouldAddPersonList((Long)calTaskId);
                    List unenableFiles = fileIdList.stream().filter(id -> !couldAddPersonList.contains(id)).collect(Collectors.toList());
                    if (unenableFiles.size() > 0) {
                        fileIdList.removeAll(unenableFiles);
                    }
                    for (Long unenableFile : unenableFiles) {
                        progress.getFailMap().put(unenableFile, ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6dfb\u52a0\u6761\u4ef6\u7684\u6863\u6848\u7248\u672c\u3002", (String)"ExcCalPersonF7List_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    }
                    progress.setFail(progress.getFailMap().size());
                    progress.setRemain(progress.getTotal() - progress.getSuccess() - progress.getFail());
                    progress.setFinish(progress.getFailMap().size());
                    SWCAppCache.get((String)"hsas").put(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), (Object)progress);
                }
                asyncService.execute(addpersonParams);
            }
            catch (Throwable e) {
                log.error("\u6dfb\u52a0\u4eba\u5458\u62a5\u9519", e);
                throw new KDBizException(e, new ErrorCode("", e.toString()), new Object[0]);
            }
            finally {
                if (isExc.booleanValue()) {
                    PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_ADDEXCCALPERSON.getOperationKey());
                } else {
                    PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_ADDCALPERSON.getOperationKey());
                }
                CalPersonHelper.releaseLock((Long)calTaskId);
                AddCalPersonHelper.addAddPerosnLog((Long)calTaskId, (Boolean)isExc);
            }
        });
        log.info("add calperson handle request end,calTaskId={}", (Object)calTaskId);
        return null;
    }

    public List<Long> addCalPersonForApi(Long calTaskId, List<Long> fileIdList, Boolean updateExistPerson) {
        ArrayList<Long> personIdList = new ArrayList<Long>(fileIdList.size());
        log.info("taskId:{},fileIdList:{}", (Object)calTaskId, fileIdList);
        Map existPersonFileIdMap = AddCalPersonHelper.assembleExistFileIdList((Long)calTaskId, fileIdList);
        log.info("existPersonFileIdMap:{}", (Object)existPersonFileIdMap);
        if (fileIdList.size() == 0 && !updateExistPerson.booleanValue()) {
            return existPersonFileIdMap.keySet().stream().collect(Collectors.toList());
        }
        if (existPersonFileIdMap.size() > 0 && updateExistPerson.booleanValue()) {
            ArrayList<Long> waitDelPersonIdList = new ArrayList<Long>(existPersonFileIdMap.size());
            List uncalPerson = AddCalPersonHelper.getUncalPerson(existPersonFileIdMap.keySet());
            for (Map.Entry entry : existPersonFileIdMap.entrySet()) {
                Long personId = (Long)entry.getKey();
                if (!uncalPerson.contains(personId)) continue;
                waitDelPersonIdList.add(personId);
                fileIdList.add((Long)entry.getValue());
            }
            this.deleteExistPerson(calTaskId, waitDelPersonIdList);
        }
        List salaryFileVidList = CalPersonHelper.getSalaryFileHisByRule((Long)calTaskId, new HashSet<Long>(fileIdList));
        log.info("salaryFileVidList:{}", (Object)salaryFileVidList);
        List partitions = Lists.partition((List)salaryFileVidList, (int)500);
        log.info("addCalPersonForApi.partitions.size:{}", (Object)partitions.size());
        ArrayList<Future<List<Long>>> futureList = new ArrayList<Future<List<Long>>>(partitions.size());
        CountDownLatch countDownLatch = new CountDownLatch(partitions.size());
        ArrayList<AddCalPersonForApiTask> taskList = new ArrayList<AddCalPersonForApiTask>(partitions.size());
        for (List partition : partitions) {
            AddCalPersonForApiTask task = new AddCalPersonForApiTask(countDownLatch, calTaskId, partition, RequestContext.get());
            taskList.add(task);
        }
        try {
            List futures = addPersonExecutorService.invokeAll(taskList);
            futureList.addAll(futures);
            boolean await = countDownLatch.await(60L, TimeUnit.MINUTES);
            if (await) {
                this.dealCalPersonIdList(personIdList, futureList);
            }
        }
        catch (Exception exception) {
            log.error("api \u6dfb\u52a0\u6838\u7b97\u540d\u5355\u5931\u8d25", (Throwable)exception);
        }
        return personIdList;
    }

    private void deleteExistPerson(Long calTaskId, List<Long> waitDelPersonIdList) {
        AddCalPersonHelper personHelper = new AddCalPersonHelper();
        personHelper.delCalPerson(waitDelPersonIdList);
        personHelper.delCalPersonAndDelCalPersonMark(calTaskId, waitDelPersonIdList);
        personHelper.deleteProration(waitDelPersonIdList);
        personHelper.cleanPersonCoverData(waitDelPersonIdList);
        personHelper.updatePersonCount(calTaskId);
    }

    private void dealCalPersonIdList(List<Long> personIdList, List<Future<List<Long>>> futureList) {
        futureList.forEach(future -> {
            try {
                List result = (List)future.get();
                personIdList.addAll(result);
            }
            catch (Exception exception) {
                log.info("dealCalPersonIdList Error:", (Object)exception);
            }
        });
    }

    public String updateCalPerson(Long calTaskId, List<Long> addFileIdList, List<Long> delFileIdList, List<Long> updateFileIdList) {
        String error = CalPersonHelper.tryLock((Long)calTaskId, (CalPersonLockEnum)CalPersonLockEnum.UPDATE);
        if (SWCStringUtils.isNotEmpty((String)error)) {
            return error;
        }
        log.info("refresh calperson handle request start,calTaskId={}", (Object)calTaskId);
        HashMap<String, Long> refreshPersonParams = new HashMap<String, Long>(16);
        refreshPersonParams.put("calTaskId", calTaskId);
        ThreadPools.executeOnce((String)"UPDATE_POOL_ASYNC", () -> {
            try {
                Map refreshListParams = UpdateCalPersonHelper.getRefreshIdMap((Long)calTaskId, (List)addFileIdList, (List)updateFileIdList, (List)delFileIdList);
                refreshPersonParams.putAll(refreshListParams);
                RefreshCalPersonTask asyncService = new RefreshCalPersonTask();
                asyncService.execute(refreshPersonParams);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u4eba\u5458\u62a5\u9519", (Throwable)e);
            }
        });
        log.info("refresh calperson handle request end,calTaskId={}", (Object)calTaskId);
        return null;
    }

    public String getCalRefreshList(Long calTaskId, List<Long> selectIds, String refreshType) {
        log.info("get calPersonRefreshList handle request start,calTaskId={}", (Object)calTaskId);
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)("SALARYREFRESHPERSON_POOL_ASYNC" + calTaskId), () -> {
            try {
                RequestContext.copyAndSet((RequestContext)ctx);
                Map getRefreshListParams = GetRefreshListHelper.getRefreshIdMap((Long)calTaskId, (List)selectIds);
                if (getRefreshListParams.isEmpty()) {
                    return;
                }
                getRefreshListParams.put("refreshType", refreshType);
                getRefreshListParams.put("calTaskId", calTaskId);
                log.info("asyncService.addPerson");
                GetRefreshListTask asyncService = new GetRefreshListTask();
                asyncService.execute(getRefreshListParams);
            }
            catch (Exception exception) {
                log.error("\u83b7\u53d6\u66f4\u65b0\u5217\u8868\u5931\u8d25", (Throwable)exception);
            }
        });
        log.info("add calperson handle request end,calTaskId={}", (Object)calTaskId);
        return null;
    }

    public List<Long> addPerson(Long calTaskId, List<Long> fileIdList) {
        List<Long> salaryFileVidList;
        Boolean isExc;
        log.info("taskId:{},fileIdList:{}", (Object)calTaskId, fileIdList);
        Map existPersonFileIdMap = AddCalPersonHelper.assembleExistFileIdList((Long)calTaskId, fileIdList);
        log.info("existPersonFileIdMap:{}", (Object)existPersonFileIdMap);
        if (fileIdList.size() == 0) {
            return existPersonFileIdMap.keySet().stream().collect(Collectors.toList());
        }
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = taskHelper.queryOriginalOne(this.getTaskSelectProp(), (Object)calTaskId);
        String taskType = task.getString("tasktype");
        Boolean bl = isExc = SWCStringUtils.equals((String)"0", (String)taskType) ? Boolean.TRUE : Boolean.FALSE;
        if (isExc.booleanValue()) {
            List<Long> validSalaryFileIdList = this.assembleValidSalaryFileId(calTaskId);
            validSalaryFileIdList.removeIf(single -> !fileIdList.contains(single));
            if (SWCListUtils.isEmpty(validSalaryFileIdList)) {
                log.info("\u53ef\u6dfb\u52a0\u7684\u6863\u6848\u96c6\u5408\u4e3a\u7a7a");
                return new ArrayList<Long>(0);
            }
            validSalaryFileIdList = this.filterOnHold(task.getDate("enddate"), validSalaryFileIdList);
            salaryFileVidList = this.getEXCFileVids(task, validSalaryFileIdList);
        } else {
            CalPayRollTaskVO taskVO = CalPersonHelper.queryCalPayRollTask((Long)calTaskId, (Long)RequestContext.get().getCurrUserId());
            log.info("matchSalaryFileVIdList.fileIdList:{}", fileIdList);
            salaryFileVidList = CalPersonHelper.getSalaryFileHisByRule((Long)calTaskId, new HashSet<Long>(fileIdList));
        }
        CalAddPersonService service = new CalAddPersonService(task, salaryFileVidList, new HashMap(0), true);
        service.setExc(isExc);
        service.batchAddCalPerson();
        PayrollTaskHelper.updateCalpayrollTaskPersonCount((Long)calTaskId);
        return this.getCalPersonIdsByTaskAndSalaryFile(calTaskId, fileIdList);
    }

    private List<Long> getEXCFileVids(DynamicObject taskDy, List<Long> validSalaryFileIdList) {
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("boid", "in", validSalaryFileIdList);
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        filter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        filter.and("paystatus", "=", (Object)"1");
        filter.and("salaryfile.status", "=", (Object)"C");
        filter.and(CalPersonService.getDateFilter(taskDy.getDate("startdate"), taskDy.getDate("enddate")));
        HashSet<Long> fileIds = new HashSet<Long>(validSalaryFileIdList.size());
        ArrayList<Long> fileVids = new ArrayList<Long>(validSalaryFileIdList.size());
        try (DataSet dataSet = fileHelper.queryDataSet("getSalaryFileVid", "id,boid,bsed", filter.toArray(), "boid asc,bsed desc");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (!fileIds.add(row.getLong("boid"))) continue;
                fileVids.add(row.getLong("id"));
            }
        }
        catch (Exception exception) {
            log.error("");
        }
        return fileVids;
    }

    private static QFilter getDateFilter(Date startDate, Date endDate) {
        QFilter brledFilter = new QFilter("bsled", ">=", (Object)startDate);
        QFilter filter = new QFilter("bsed", "<=", (Object)endDate);
        brledFilter.or(QFilter.isNull((String)"bsled"));
        filter.and(brledFilter);
        return filter;
    }

    private List<Long> filterOnHold(Date taskEndDate, List<Long> fileIds) {
        HashSet<Long> retSalaryFileIdSet = new HashSet<Long>(fileIds.size());
        SWCDataServiceHelper onHoldFileHelper = new SWCDataServiceHelper("hsas_onholdfile");
        QFilter filter = new QFilter("salaryfile.id", "in", fileIds);
        DynamicObjectCollection onHoldFileDyArr = onHoldFileHelper.queryOriginalCollection("salaryfile.id,status,startdate,isallowcal", filter.toArray(), "createtime asc");
        if (onHoldFileDyArr == null || onHoldFileDyArr.size() == 0) {
            return fileIds;
        }
        HashMap<Long, ArrayList<DynamicObject>> onHoldMap = new HashMap<Long, ArrayList<DynamicObject>>(16);
        for (DynamicObject onHoldFileObj : onHoldFileDyArr) {
            Long salaryFileId = onHoldFileObj.getLong("salaryfile.id");
            ArrayList<DynamicObject> onHoldFileList = (ArrayList<DynamicObject>)onHoldMap.get(salaryFileId);
            if (onHoldFileList == null) {
                onHoldFileList = new ArrayList<DynamicObject>(10);
            }
            onHoldFileList.add(onHoldFileObj);
            onHoldMap.put(salaryFileId, onHoldFileList);
        }
        for (Long salaryFileId : fileIds) {
            List onHoldFileList = (List)onHoldMap.get(salaryFileId);
            if (onHoldFileList == null || onHoldFileList.size() == 0) {
                retSalaryFileIdSet.add(salaryFileId);
                continue;
            }
            for (DynamicObject onHoldFileObj : onHoldFileList) {
                Date startDate;
                String isAllowCal = onHoldFileObj.getString("isallowcal");
                if (SWCStringUtils.equals((String)isAllowCal, (String)"1")) {
                    retSalaryFileIdSet.add(salaryFileId);
                    continue;
                }
                String status = onHoldFileObj.getString("status");
                if (SWCStringUtils.equals((String)status, (String)" ") || SWCStringUtils.equals((String)status, (String)String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()))) {
                    retSalaryFileIdSet.add(salaryFileId);
                    continue;
                }
                if (!SWCStringUtils.equals((String)status, (String)String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode())) && !SWCStringUtils.equals((String)status, (String)String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode())) && !SWCStringUtils.equals((String)status, (String)String.valueOf(OnHoldStatusEnum.STATUS_TOPAY.getCode())) || (startDate = onHoldFileObj.getDate("startdate")) == null) continue;
                startDate = HandleProrationHelper.replaceDateTime((Date)startDate, (String)"23:59:59");
                taskEndDate = HandleProrationHelper.replaceDateTime((Date)taskEndDate, (String)"23:59:59");
                if (startDate.getTime() > taskEndDate.getTime()) {
                    retSalaryFileIdSet.add(salaryFileId);
                    continue;
                }
                retSalaryFileIdSet.remove(salaryFileId);
            }
        }
        return new ArrayList<Long>(retSalaryFileIdSet);
    }

    private List<Long> assembleValidSalaryFileId(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = helper.queryOriginalOne("payrollgroup.id,taskstatus,startdate,enddate", (Object)calTaskId);
        List fileIdsByTask = CalPersonHelper.getFileIdsByTask((Long)calTaskId);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        QFilter fileIdsByTaskFilter = new QFilter("boid", "not in", (Object)fileIdsByTask);
        QFilter dateRangeFilter = new QFilter("payrollgroup", "=", (Object)task.getLong("payrollgroup.id"));
        BaseDataHisHelper.addHisCurrFilter((QFilter)dateRangeFilter);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"47150e89000000ac");
        if (authorizedDataRuleQFilter == null) {
            filterList.add(new QFilter("1", "=", (Object)2));
        } else if (!authorizedDataRuleQFilter.isEmpty()) {
            filterList.addAll(authorizedDataRuleQFilter);
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        filterList.add(statusFilter);
        filterList.add(fileIdsByTaskFilter);
        filterList.add(dateRangeFilter);
        helper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObjectCollection salaryFileObjs = helper.queryOriginalCollection("id", filterList.toArray(new QFilter[0]));
        if (SWCListUtils.isEmpty((List)salaryFileObjs)) {
            return new ArrayList<Long>(0);
        }
        return salaryFileObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> getCalPersonIdsByTaskAndSalaryFile(Long taskId, List<Long> salaryFileIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("caltask", "=", (Object)taskId);
        filter.and("salaryfile.id", "in", salaryFileIdList);
        DynamicObjectCollection datas = helper.queryOriginalCollection("id", new QFilter[]{filter});
        return datas.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    private String getTaskSelectProp() {
        return "id,tasktype,startdate,enddate,calrulev.id,payrolldate,period,period.id,period.name,paydate,exratedate,calfrequency.id,calcount,payrollgroup.id,payrollgroupv.id,payrollgroupv.islssuepayslip,ishandleproration,payrollscene.id";
    }
}

