/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.exchangerate.helper.ExchangeRateHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.costallot.helper.CostCreateAllotDetailHelper;
import kd.swc.hscs.business.costallot.util.CostAllotUtils;
import kd.swc.hscs.mservice.api.IHSCSCostAllotDetailService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class HSCSCostAllotDetailService
implements IHSCSCostAllotDetailService {
    private static final Log LOGGER = LogFactory.getLog(HSCSCostAllotDetailService.class);
    private static final int BATCH_SIZE = 10000;
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MESSAGE = "message";
    private static Set<String> RESERVE_FIELDS = new HashSet<String>(Arrays.asList("caltask", "strategy", "costallottask", "success", "message"));
    private static Set<String> STRATEGIES = new HashSet<String>(Arrays.asList("1", "2", "3"));
    private static List<String> MUST_INPUT_FIELDS = new ArrayList<String>(Arrays.asList("caltask", "strategy"));
    private Map<String, ExchangeRateInfo> exrateMap = new HashMap<String, ExchangeRateInfo>(16);

    public void generateAllotDetail(Long calTaskId, Long recordId, List<Long> calPersonIdList, String strategy, List<Long> salaryFileList, String batchId) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("caltask", calTaskId);
        param.put("recordId", recordId);
        param.put("batchId", batchId);
        param.put("strategy", strategy);
        param.put("calPersonIdList", calPersonIdList);
        param.put("salaryfiles", salaryFileList);
        this.generateAllotDetailCore(param);
    }

    private void generateAllotDetailCore(Map<String, Object> param) {
        Long calTaskId = MapUtils.getLong(param, (Object)"caltask");
        Long recordId = MapUtils.getLong(param, (Object)"recordId");
        String batchId = MapUtils.getString(param, (Object)"batchId");
        String strategy = MapUtils.getString(param, (Object)"strategy");
        List calPersonIdList = (List)param.get("calPersonIdList");
        List salaryFileList = (List)param.get("salaryfiles");
        if (StringUtils.isNotBlank((CharSequence)batchId)) {
            DynamicObject[] calPersonArr = CostCreateAllotDetailHelper.queryCalPersonIdsByCalTaskId((Long)calTaskId, (List)salaryFileList, (String)"1");
            calPersonIdList = Arrays.stream(calPersonArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            recordId = CostCreateAllotDetailHelper.saveCostRecordInfo((int)calPersonArr.length, (String)String.valueOf(calTaskId), (String)"1");
        }
        LOGGER.info("HSCSCostAllotDetailService generateAllotDetailCore 1-1");
        DynamicObject costAdapterObj = CostCreateAllotDetailHelper.queryCostAdapterIdByCalTaskId((Long)calTaskId);
        Long costAllotDyId = null;
        QFilter taskFilter = new QFilter("caltask", "=", (Object)calTaskId);
        SWCDataServiceHelper allotTaskHelper = new SWCDataServiceHelper("pcs_allottask");
        DynamicObject dynamicObject = allotTaskHelper.queryOne("id", new QFilter[]{taskFilter});
        costAllotDyId = dynamicObject != null ? Long.valueOf(dynamicObject.getLong("id")) : CostCreateAllotDetailHelper.saveCostAllocationInfo((Long)calTaskId, (Long)costAdapterObj.getLong("id"));
        param.put("costallottask", costAllotDyId);
        LOGGER.info("HSCSCostAllotDetailService generateAllotDetailCore 1-2");
        List subList = Lists.partition(calPersonIdList, (int)10000);
        for (List batchList : subList) {
            CostAllotUtils.sendBatchCostAllotMessage((Long)calTaskId, (Long)costAllotDyId, (Long)recordId, (String)strategy, (DynamicObject)costAdapterObj, (List)batchList, (int)calPersonIdList.size(), (List)salaryFileList, (String)batchId);
        }
        LOGGER.info("HSCSCostAllotDetailService generateAllotDetailCore 1-3");
    }

    public Map<String, Object> generateAllotDetails(Map<String, Object> param) {
        if (null == param) {
            return null;
        }
        param.put(KEY_SUCCESS, Boolean.TRUE);
        List data = (List)param.get("data");
        if (CollectionUtils.isEmpty((Collection)data)) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MESSAGE, "Input param is Empty!");
            return param;
        }
        if (data.size() > 1000) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MESSAGE, "Data size over 1000!");
            return param;
        }
        for (Map rec : data) {
            this.doVerifyAndSave(rec);
        }
        return param;
    }

    private void doVerifyAndSave(Map<String, Object> record) {
        if (MapUtils.isEmpty(record)) {
            return;
        }
        try {
            record.put(KEY_SUCCESS, Boolean.TRUE);
            if (this.checkMustInput(record) && this.checkValue(record)) {
                record.put("batchId", RequestContext.get().getTraceId());
                if (!"2".equals(MapUtils.getString(record, (Object)"strategy"))) {
                    record.put("salaryfiles", Collections.EMPTY_LIST);
                }
                this.generateAllotDetailCore(record);
            }
        }
        catch (Exception exp) {
            LOGGER.error("Execution Failure.", (Throwable)exp);
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, "Execution failure!");
        }
        this.filterParamRetentionFields(record);
    }

    private boolean checkMustInput(Map<String, Object> record) {
        boolean isPass = true;
        ArrayList<String> notPassFields = new ArrayList<String>(2);
        for (String field : MUST_INPUT_FIELDS) {
            if (!SWCObjectUtils.isEmpty((Object)record.get(field))) continue;
            isPass = false;
            notPassFields.add(field);
        }
        if (!isPass) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u5fc5\u586b\u3002", (String)"HSCSCostAllotDetailService_0", (String)"swc-hscs-mservice", (Object[])new Object[0]), notPassFields.stream().collect(Collectors.joining("\u3001"))));
            return false;
        }
        List<Long> salaryFiles = this.getLongList((List)record.get("salaryfiles"));
        if ("2".equals(MapUtils.getString(record, (Object)"strategy")) && CollectionUtils.isEmpty(salaryFiles)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u751f\u6210\u7b56\u7565\u4e3a\u201c\u90e8\u5206\u6863\u6848\u751f\u6210\u201d\uff0c\u85aa\u8d44\u6863\u6848\u5fc5\u586b\u3002", (String)"HSCSCostAllotDetailService_1", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkValue(Map<String, Object> record) {
        return this.checkStrategy(record) && this.checkCalTask(record) && this.checkSalaryFiles(record);
    }

    private boolean checkCalTask(Map<String, Object> record) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        Long calTaskId = MapUtils.getLong(record, (Object)"caltask");
        DynamicObject calTask = helper.queryOne((Object)calTaskId);
        if (SWCObjectUtils.isEmpty((Object)calTask)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u4e0d\u5b58\u5728\u3002", (String)"HSCSCostAllotDetailService_2", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        HashSet<String> invalidStatus = new HashSet<String>(Arrays.asList(CalPayrollTaskStateEnum.CREATE.getCode(), CalPayrollTaskStateEnum.UNCAL.getCode(), CalPayrollTaskStateEnum.DISUSED.getCode(), CalPayrollTaskStateEnum.CALPROCESSING.getCode()));
        if (invalidStatus.contains(calTask.getString("taskstatus"))) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u4efb\u52a1\u72b6\u6001\u4e0d\u80fd\u662f\u201c\u5df2\u521b\u5efa\u3001\u672a\u8ba1\u7b97\u3001\u5df2\u5e9f\u5f03\u3001\u5904\u7406\u4e2d\u201d\u3002", (String)"HSCSCostAllotDetailService_4", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        if ("2".equals(calTask.getString("tasktype"))) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u7684\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u201c\u5386\u53f2\u6570\u636e\u5bfc\u5165\u201d\u3002", (String)"HSCSCostAllotDetailService_19", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        if (!this.checkCostAllotOpen(record, calTask)) {
            return false;
        }
        if (!this.checkCalculating(record, calTask)) {
            return false;
        }
        if (!this.checkCostAdaptorExists(record, calTask)) {
            return false;
        }
        if (!this.checkSalaryItemIsAllot(record, calTask)) {
            return false;
        }
        if (!this.checkStructExists(record, calTask)) {
            return false;
        }
        if (!this.checkRateExists(record, calTask)) {
            return false;
        }
        if (!this.checkCalTaskCostSetup(record, calTask)) {
            return false;
        }
        return this.checkCalPerson(record, calTask);
    }

    private boolean checkStrategy(Map<String, Object> record) {
        if (!STRATEGIES.contains(MapUtils.getString(record, (Object)"strategy"))) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u751f\u6210\u7b56\u7565\u4e0d\u5b58\u5728\u3002", (String)"HSCSCostAllotDetailService_6", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkSalaryFiles(Map<String, Object> record) {
        List<Long> salaryFileIds = this.getLongList((List)record.get("salaryfiles"));
        if (!"2".equals(MapUtils.getString(record, (Object)"strategy")) || CollectionUtils.isEmpty(salaryFileIds)) {
            return true;
        }
        return this.checkSalaryFileExists(record) && this.checkSalaryFileCalTask(record) && this.checkCostSetupExists(record);
    }

    private boolean checkCostAllotOpen(Map<String, Object> record, DynamicObject calTask) {
        SWCDataServiceHelper sceneHelper = new SWCDataServiceHelper("hsas_payrollscene");
        Long payrollSceneVid = calTask.getLong("payrollscenev.id");
        DynamicObject payrollScene = sceneHelper.queryOne("schemeaftercal.costallot", (Object)payrollSceneVid);
        if (SWCObjectUtils.isEmpty((Object)payrollScene) || !payrollScene.getBoolean("schemeaftercal.costallot")) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u573a\u666f\u5173\u8054\u7684\u6838\u7b97\u540e\u5904\u7406\u65b9\u6848\u9700\u6253\u5f00\u6210\u672c\u5206\u644a\u5f00\u5173\u3002", (String)"HSCSCostAllotDetailService_3", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkCalculating(Map<String, Object> record, DynamicObject calTask) {
        DynamicObject[] allotTasks;
        SWCDataServiceHelper costAllocationHelper = new SWCDataServiceHelper("pcs_allottask");
        for (DynamicObject allotTask : allotTasks = costAllocationHelper.query("id,caltask,costtaskstatus", new QFilter[]{new QFilter("caltask.id", "=", (Object)calTask.getLong("id"))})) {
            if (!"2".equals(allotTask.getString("costtaskstatus"))) continue;
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u5173\u8054\u7684\u6210\u672c\u5206\u644a\u4efb\u52a1\u6b63\u5728\u8ba1\u7b97\u4e2d\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"HSCSCostAllotDetailService_10", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkCostAdaptorExists(Map<String, Object> record, DynamicObject calTask) {
        SWCDataServiceHelper costAdaptionMapHelper = new SWCDataServiceHelper("pcs_costadaptionmap");
        Long payrollGroupVid = calTask.getLong("payrollgroupv.id");
        Object[] costAdaptionMaps = costAdaptionMapHelper.query("costadaption,source", new QFilter[]{new QFilter("mapobj", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP), new QFilter("source", "=", (Object)payrollGroupVid), new QFilter("status", "=", (Object)"C")});
        if (SWCArrayUtils.isEmpty((Object[])costAdaptionMaps) || SWCObjectUtils.isEmpty((Object)costAdaptionMaps[0].getDynamicObject("costadaption"))) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6240\u5c5e\u85aa\u8d44\u6838\u7b97\u7ec4\u6ca1\u6709\u5bf9\u5e94\u7684\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"HSCSCostAllotDetailService_11", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        record.put("costadaption", costAdaptionMaps[0].getDynamicObject("costadaption"));
        return true;
    }

    private boolean checkSalaryItemIsAllot(Map<String, Object> record, DynamicObject calTask) {
        DynamicObject[] calRuleHisObjs;
        Long calRuleVid = calTask.getLong("calrulev.id");
        SWCDataServiceHelper calRuleHisHelper = new SWCDataServiceHelper("hsas_calrule");
        for (DynamicObject calRuleHis : calRuleHisObjs = calRuleHisHelper.query("fid,salaryitem,iscostallot", new QFilter[]{new QFilter("id", "=", (Object)calRuleVid)})) {
            DynamicObjectCollection calRuleItemEntryColl = calRuleHis.getDynamicObjectCollection("calruleitementry");
            for (DynamicObject calRuleItemEntry : calRuleItemEntryColl) {
                if (!calRuleItemEntry.getBoolean("iscostallot")) continue;
                return true;
            }
        }
        record.put(KEY_SUCCESS, Boolean.FALSE);
        record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u8ba1\u7b97\u89c4\u5219\u4e2d\u65e0\u53c2\u4e0e\u6210\u672c\u5206\u644a\u7684\u85aa\u916c\u9879\u76ee\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"HSCSCostAllotDetailService_12", (String)"swc-hscs-mservice", (Object[])new Object[0]));
        return false;
    }

    private boolean checkStructExists(Map<String, Object> record, DynamicObject calTask) {
        SWCDataServiceHelper costAllocationHelper = new SWCDataServiceHelper("pcs_costallocation");
        DynamicObject costAllocation = costAllocationHelper.queryOne("costtaskstatus,id,caltask", new QFilter[]{new QFilter("caltask.id", "=", (Object)calTask.getLong("id"))});
        if (SWCObjectUtils.isEmpty((Object)costAllocation) || !SWCStringUtils.equals((String)"1", (String)costAllocation.getString("costtaskstatus"))) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6ca1\u6709\u751f\u6210\u5206\u644a\u7ed3\u6784\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"HSCSCostAllotDetailService_13", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkRateExists(Map<String, Object> record, DynamicObject calTask) {
        DynamicObject costAdaption = (DynamicObject)record.get("costadaption");
        String currencyId = costAdaption.getString("currency.id");
        String currencyName = costAdaption.getString("currency.name");
        long exrateTableId = calTask.getLong("payrollgroupv.exratetable.id");
        String exrateTableName = calTask.getString("payrollgroupv.exratetable.name");
        long calCurrencyId = calTask.getLong("payrollgroupv.currency.id");
        String calCurrencyName = calTask.getString("payrollgroupv.currency.name");
        Date exrateDate = calTask.getDate("exratedate");
        String exrateDateStr = SWCDateTimeUtils.format((Date)exrateDate, (String)"yyyy-MM-dd");
        ExchangeRateInfo calCurrency2CostCurrencyRate = this.getExrate(calCurrencyId, Long.valueOf(currencyId), exrateDate, exrateTableId);
        if (calCurrency2CostCurrencyRate == null) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u5728\u201c{0}\u201d\u6c47\u7387\u8868\u4e2d\uff0c\u672a\u627e\u5230\u65e5\u671f\u4e3a{1}\u201c{2}\u201d\u5151\u201c{3}\u201d\u7684\u6c47\u7387\u3002", (String)"HSCSCostAllotDetailService_14", (String)"swc-hscs-mservice", (Object[])new Object[0]), exrateTableName, exrateDateStr, calCurrencyName, currencyName));
            return false;
        }
        ExchangeRateInfo costCurrency2CalCurrencyRate = this.getExrate(Long.valueOf(currencyId), calCurrencyId, exrateDate, exrateTableId);
        if (costCurrency2CalCurrencyRate == null) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u5728\u201c{0}\u201d\u6c47\u7387\u8868\u4e2d\uff0c\u672a\u627e\u5230\u65e5\u671f\u4e3a{1}\u201c{2}\u201d\u5151\u201c{3}\u201d\u7684\u6c47\u7387\u3002", (String)"HSCSCostAllotDetailService_14", (String)"swc-hscs-mservice", (Object[])new Object[0]), exrateTableName, exrateDateStr, currencyName, calCurrencyName));
            return false;
        }
        return true;
    }

    private boolean checkCalTaskCostSetup(Map<String, Object> record, DynamicObject calTask) {
        QFilter qFilter = new QFilter("caltask.id", "=", (Object)calTask.getLong("id"));
        Date payrollDate = calTask.getDate("payrolldate");
        DynamicObject costAdaption = (DynamicObject)record.get("costadaption");
        Long orgId = costAdaption.getLong("createorg.id");
        qFilter.and(new QFilter("belongperiod", "=", (Object)payrollDate));
        qFilter.and(new QFilter("hrorg.id", "=", (Object)orgId));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costsetuprst");
        Object[] costSetupRstArr = helper.query("caltask.id, enable", new QFilter[]{qFilter});
        if (SWCArrayUtils.isEmpty((Object[])costSetupRstArr)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u65e0\u5bf9\u5e94\u7684\u6210\u672c\u5206\u644a\u7ed3\u6784\u3002", (String)"HSCSCostAllotDetailService_15", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        for (Object costSetupRst : costSetupRstArr) {
            if (!"0".equals(costSetupRst.getString("enable"))) continue;
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u5bf9\u5e94\u7684\u6210\u672c\u5206\u644a\u7ed3\u6784\u4efb\u52a1\u5b58\u5728\u65e0\u6548\u6210\u672c\u5206\u644a\u7ed3\u6784\u3002", (String)"HSCSCostAllotDetailService_16", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkCalPerson(Map<String, Object> record, DynamicObject calTask) {
        List<Long> salaryFileIds = this.getLongList((List)record.get("salaryfiles"));
        String strategy = MapUtils.getString(record, (Object)"strategy");
        Long calTaskId = calTask.getLong("id");
        Object[] calPersonArr = this.queryCalPersonIdsByCalTaskId(calTaskId, salaryFileIds, strategy);
        if (SWCArrayUtils.isEmpty((Object[])calPersonArr)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u4e0b\u6ca1\u6709\u5df2\u5ba1\u6838\u4e14\u5206\u644a\u72b6\u6001\u4e0d\u4e3a\u5df2\u751f\u6210\u7684\u6838\u7b97\u8bb0\u5f55\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"HSCSCostAllotDetailService_17", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        List calSalaryFileIds = Arrays.stream(calPersonArr).map(dy -> dy.getLong("salaryfile.id")).collect(Collectors.toList());
        HashSet existsSalaryFileIds = Sets.newHashSet(this.getExistSalaryFileNumber(calTaskId));
        calSalaryFileIds.removeIf(id -> existsSalaryFileIds.contains(id));
        if (CollectionUtils.isEmpty(calSalaryFileIds)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u4e0b\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6863\u6848\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"HSCSCostAllotDetailService_18", (String)"swc-hscs-mservice", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkSalaryFileExists(Map<String, Object> record) {
        List<Long> salaryFileIds = this.getLongList((List)record.get("salaryfiles"));
        QFilter sfFilter = new QFilter("id", "in", salaryFileIds);
        SWCDataServiceHelper sfHelper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject[] salaryFiles = sfHelper.query("id", new QFilter[]{sfFilter});
        Set salaryFileIdsInDB = Arrays.stream(salaryFiles).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        ArrayList<Long> notExistsList = new ArrayList<Long>(10);
        for (Long salaryFileId : salaryFileIds) {
            if (salaryFileIdsInDB.contains(salaryFileId)) continue;
            notExistsList.add(salaryFileId);
        }
        if (CollectionUtils.isNotEmpty(notExistsList)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0d\u5b58\u5728\uff1a\u201c{0}\u201d\u3002", (String)"HSCSCostAllotDetailService_7", (String)"swc-hscs-mservice", (Object[])new Object[0]), notExistsList.stream().map(item -> String.valueOf(item)).collect(Collectors.joining("\u3001"))));
            return false;
        }
        return true;
    }

    private boolean checkSalaryFileCalTask(Map<String, Object> record) {
        List<Long> salaryFileIds = this.getLongList((List)record.get("salaryfiles"));
        Long calTaskId = MapUtils.getLong(record, (Object)"caltask");
        SWCDataServiceHelper cpHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("caltask", "=", (Object)calTaskId);
        calPersonFilter.and("salaryfile.id", "in", salaryFileIds);
        DynamicObject[] calPersons = cpHelper.query("salaryfile.id", new QFilter[]{calPersonFilter});
        Set correctSalaryFileIds = Arrays.stream(calPersons).map(dy -> dy.getLong("salaryfile.id")).collect(Collectors.toSet());
        ArrayList<Long> invalidIds = new ArrayList<Long>(10);
        for (Long salaryFileId : salaryFileIds) {
            if (correctSalaryFileIds.contains(salaryFileId)) continue;
            invalidIds.add(salaryFileId);
        }
        if (CollectionUtils.isNotEmpty(invalidIds)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u5173\u8054\u7684\u6838\u7b97\u540d\u5355\u7684\u6838\u7b97\u4efb\u52a1\u4e0e\u5f53\u524d\u4f20\u5165\u7684\u6838\u7b97\u4efb\u52a1\u4e0d\u4e00\u81f4\uff1a\u201c{0}\u201d\u3002", (String)"HSCSCostAllotDetailService_8", (String)"swc-hscs-mservice", (Object[])new Object[0]), invalidIds.stream().map(item -> String.valueOf(item)).collect(Collectors.joining("\u3001"))));
            return false;
        }
        return true;
    }

    private boolean checkCostSetupExists(Map<String, Object> record) {
        List<Long> salaryFileIds = this.getLongList((List)record.get("salaryfiles"));
        Long calTaskId = MapUtils.getLong(record, (Object)"caltask");
        DynamicObject[] costSetupArr = this.queryCostSetUpArr(calTaskId, salaryFileIds);
        Set costSetupSalaryFileIds = Arrays.stream(costSetupArr).map(dy -> dy.getLong("salaryfile.id")).collect(Collectors.toSet());
        ArrayList<Long> unGenerateIds = new ArrayList<Long>(10);
        for (Long salaryFileId : salaryFileIds) {
            if (costSetupSalaryFileIds.contains(salaryFileId)) continue;
            unGenerateIds.add(salaryFileId);
        }
        if (CollectionUtils.isNotEmpty(unGenerateIds)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u6240\u9009\u85aa\u8d44\u6863\u6848\u201c{0}\u201d\u672a\u751f\u6210\u5206\u644a\u7ed3\u6784\uff0c\u4e0d\u80fd\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"HSCSCostAllotDetailService_9", (String)"swc-hscs-mservice", (Object[])new Object[0]), unGenerateIds.stream().map(item -> String.valueOf(item)).collect(Collectors.joining("\u3001"))));
            return false;
        }
        return true;
    }

    private DynamicObject[] queryCostSetUpArr(Long calTaskId, List<Long> salaryfileList) {
        SWCDataServiceHelper costSetupRstHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        QFilter calTaskFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        calTaskFilter.and(new QFilter("salaryfile.id", "in", salaryfileList));
        String properties = "caltask,salaryfile";
        return costSetupRstHelper.query(properties, new QFilter[]{calTaskFilter});
    }

    private void filterParamRetentionFields(Map<String, Object> record) {
        Iterator<Map.Entry<String, Object>> iterator = record.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (RESERVE_FIELDS.contains(entry.getKey())) continue;
            iterator.remove();
        }
    }

    private ExchangeRateInfo getExrate(Long oriCurId, Long targetCurId, Date exrateDate, Long exrateTableId) {
        if (oriCurId.equals(targetCurId)) {
            ExchangeRateInfo exchangeRateInfo = new ExchangeRateInfo();
            exchangeRateInfo.setExchangeRate(BigDecimal.ONE);
            return exchangeRateInfo;
        }
        String exrateKey = String.format("exrate_%d_%d_%s", oriCurId, targetCurId, SWCDateTimeUtils.format((Date)exrateDate, (String)"yyyyMMdd"));
        ExchangeRateInfo exchangeRateInfo = this.exrateMap.get(exrateKey);
        if (exchangeRateInfo == null) {
            try {
                exchangeRateInfo = ExchangeRateHelper.getExchangeRateInfo((Long)oriCurId, (Long)targetCurId, (Long)exrateTableId, (Date)exrateDate);
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u6c47\u7387\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
            if (exchangeRateInfo == null || exchangeRateInfo.getExchangeRate() == null) {
                return null;
            }
            this.exrateMap.put(exrateKey, exchangeRateInfo);
        }
        return exchangeRateInfo;
    }

    private DynamicObject[] queryCalPersonIdsByCalTaskId(Long calTaskId, List<Long> salaryFileList, String strategy) {
        QFilter calPersonFilter = new QFilter("caltask", "=", (Object)calTaskId);
        if ("2".equals(strategy) && !CollectionUtils.isEmpty(salaryFileList)) {
            calPersonFilter.and(new QFilter("salaryfile.id", "in", salaryFileList));
        }
        if (SWCStringUtils.equals((String)"3", (String)strategy)) {
            calPersonFilter.and(new QFilter("allotstatus", "!=", (Object)"B"));
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        return calPersonHelper.query("id,caltask.id,salaryfile.id", new QFilter[]{calPersonFilter});
    }

    private List<Long> getExistSalaryFileNumber(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        QFilter taskQFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        DynamicObject[] queryResult = helper.query("salaryfile.id", new QFilter[]{taskQFilter});
        ArrayList<Long> salaryFileList = new ArrayList<Long>(queryResult.length);
        for (DynamicObject dynamicObject : queryResult) {
            long salaryFileId = dynamicObject.getLong("salaryfile.id");
            salaryFileList.add(salaryFileId);
        }
        return salaryFileList;
    }

    private List<Long> getLongList(List<Object> objects) {
        if (CollectionUtils.isEmpty(objects)) {
            return null;
        }
        ArrayList<Long> longList = new ArrayList<Long>(objects.size());
        for (Object obj : objects) {
            Number answer = HSCSCostAllotDetailService.getNumber(obj);
            Long value = answer == null ? null : (answer instanceof Long ? (Long)answer : Long.valueOf(answer.longValue()));
            longList.add(value);
        }
        return longList;
    }

    public static Number getNumber(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return (Number)value;
            }
            if (value instanceof String) {
                try {
                    String text = (String)value;
                    return NumberFormat.getInstance().parse(text);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

