/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.mservice;

import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.swc.hscs.business.hisdata.check.DataCheckService;
import kd.swc.hscs.business.hisdata.writein.ImportTaskUnWriteInService;
import kd.swc.hscs.business.hisdata.writein.ImportTaskWriteInService;
import kd.swc.hscs.mservice.api.IImportTaskService;

public class ImportTaskService
implements IImportTaskService {
    private static final Log log = LogFactory.getLog(ImportTaskService.class);

    public void hisDataCheck(Long verifyId, Long importTaskId, String writeTaskType) {
        log.info("async hisDataCheck start,verifyId={}", (Object)verifyId);
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"IMPORTTASK_DATACHECK_IN_POOL_ASYNC", () -> {
            log.info("DataCheckService.checkData ,tranceId={}", (Object)ctx.getTraceId());
            RequestContext.copyAndSet((RequestContext)ctx);
            DataCheckService checkService = new DataCheckService(verifyId, importTaskId, writeTaskType);
            checkService.checkData();
        });
        log.info("async hisDataCheck  end,verifyId={}", (Object)verifyId);
    }

    public void writeIn(Long importTaskId, Long verifyRecordId) {
        log.info("async writeIn start,importTaskId={}", (Object)importTaskId);
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"IMPORTTASK_WRITE_IN_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            new ImportTaskWriteInService().writeIn(importTaskId, verifyRecordId);
            log.info("writeIn asyncService.execute,tranceId={}", (Object)ctx.getTraceId());
        });
        log.info("async writeIn request end,importTaskId={}", (Object)importTaskId);
    }

    public void unWriteIn(Long importTaskId, Long verifyRecordId) {
        log.info("async unWriteIn start,importTaskId={}", (Object)importTaskId);
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"IMPORTTASK_WRITE_IN_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            new ImportTaskUnWriteInService().unWriteIn(importTaskId, verifyRecordId);
            log.info("unWriteIn asyncService.execute,tranceId={}", (Object)ctx.getTraceId());
        });
        log.info("async unWriteIn request end,importTaskId={}", (Object)importTaskId);
    }
}

