/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.encrypt.MultiEncryptNewService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.dto.salary.RepeatSalarySlipDTO;
import kd.swc.hsbp.common.dto.salary.SalaryCalTableDTO;
import kd.swc.hsbp.common.dto.salary.SalarySlipDTO;
import kd.swc.hsbp.common.enums.EncryptLevelEnum;
import kd.swc.hsbp.common.enums.EncryptTypeEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.login.SalaryPwdHelper;
import kd.swc.hspp.mservice.api.IHSPPService;

public class HSPPService
implements IHSPPService {
    private static final Log logger = LogFactory.getLog(HSPPService.class);
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String releaseSalary(SalarySlipDTO salarySlipDTO) {
        Long currUserId = salarySlipDTO.getCurrUserId();
        Date currentDate = new Date();
        Date sendTime = salarySlipDTO.getSendTime();
        long releaseTimeStamp = sendTime.getTime();
        SWCDataServiceHelper salaryCalendarHelper = new SWCDataServiceHelper("hspp_salarycalendar");
        SWCDataServiceHelper salaryDetailHelper = new SWCDataServiceHelper("hspp_salaryslipdetail");
        SWCDataServiceHelper salarySlipStatusHelper = new SWCDataServiceHelper("hspp_salaryslipstatus");
        List salaryCalTableDTOList = salarySlipDTO.getSalaryCalTableDTOList();
        int dataSize = salaryCalTableDTOList.size();
        DynamicObject[] salarycalendarArrays = new DynamicObject[dataSize];
        DynamicObject[] salaryslipdetailArrays = new DynamicObject[dataSize];
        DynamicObject[] salaryslipstatusArrays = new DynamicObject[dataSize];
        try (TXHandle txHandle = TX.requiresNew();){
            for (int i = 0; i < dataSize; ++i) {
                DynamicObject slipStatusObject;
                DynamicObject detailObject;
                DynamicObject calendarObject;
                SalaryCalTableDTO salaryCalTableDTO = (SalaryCalTableDTO)salaryCalTableDTOList.get(i);
                long calendarPrimaryKey = salaryCalTableDTO.getSalarySlipCalendarId();
                salarycalendarArrays[i] = calendarObject = this.setCalendarObject(salaryCalendarHelper, currUserId, currentDate, sendTime, releaseTimeStamp, calendarPrimaryKey, salarySlipDTO, salaryCalTableDTO);
                salaryslipdetailArrays[i] = detailObject = this.setDetailObject(salaryDetailHelper, currUserId, currentDate, salarySlipDTO.getEncryptType(), calendarPrimaryKey, releaseTimeStamp, salaryCalTableDTO);
                salaryslipstatusArrays[i] = slipStatusObject = this.setStatusObject(salarySlipStatusHelper, currUserId, currentDate, calendarPrimaryKey, salarySlipDTO, salaryCalTableDTO);
                salaryCalTableDTOList.set(i, null);
            }
            salaryCalendarHelper.save(salarycalendarArrays);
            salaryDetailHelper.save(salaryslipdetailArrays);
            salarySlipStatusHelper.save(salaryslipstatusArrays);
        }
        return SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String repeatReleaseSalary(List<RepeatSalarySlipDTO> mainSalarySlipDTOList) {
        Date currentDate = new Date();
        SWCDataServiceHelper salaryCalendarHelper = new SWCDataServiceHelper("hspp_salarycalendar");
        SWCDataServiceHelper salaryDetailHelper = new SWCDataServiceHelper("hspp_salaryslipdetail");
        SWCDataServiceHelper salarySlipStatusHelper = new SWCDataServiceHelper("hspp_salaryslipstatus");
        int dataSize = mainSalarySlipDTOList.size();
        DynamicObject[] salarycalendarArrays = new DynamicObject[dataSize];
        DynamicObject[] salaryslipdetailArrays = new DynamicObject[dataSize];
        DynamicObject[] salaryslipstatusArrays = new DynamicObject[dataSize];
        try (TXHandle txHandle = TX.requiresNew();){
            for (int i = 0; i < dataSize; ++i) {
                DynamicObject slipStatusObject;
                DynamicObject detailObject;
                DynamicObject calendarObject;
                RepeatSalarySlipDTO salarySlipDTO = mainSalarySlipDTOList.get(i);
                Long currUserId = salarySlipDTO.getCurrUserId();
                long releaseTimeStamp = salarySlipDTO.getSendTime().getTime();
                SalaryCalTableDTO salaryCalTableDTO = salarySlipDTO.getSalaryCalTableDTO();
                long calendarPrimaryKey = salaryCalTableDTO.getSalarySlipCalendarId();
                salarycalendarArrays[i] = calendarObject = this.setCalendarObjectByRepeat(salaryCalendarHelper, currUserId, currentDate, calendarPrimaryKey, salarySlipDTO, salaryCalTableDTO);
                salaryslipdetailArrays[i] = detailObject = this.setDetailObject(salaryDetailHelper, currUserId, currentDate, salarySlipDTO.getEncryptType(), calendarPrimaryKey, releaseTimeStamp, salaryCalTableDTO);
                salaryslipstatusArrays[i] = slipStatusObject = this.setStatusObjectByRepeat(salarySlipStatusHelper, currUserId, currentDate, calendarPrimaryKey, salarySlipDTO, salaryCalTableDTO);
                mainSalarySlipDTOList.set(i, null);
            }
            salaryCalendarHelper.save(salarycalendarArrays);
            salaryDetailHelper.save(salaryslipdetailArrays);
            salarySlipStatusHelper.save(salaryslipstatusArrays);
        }
        return SUCCESS;
    }

    private DynamicObject setStatusObject(SWCDataServiceHelper salarySlipStatusHelper, Long currUserId, Date currentDate, long calendarPrimaryKey, SalarySlipDTO salarySlipDTO, SalaryCalTableDTO salaryCalTableDTO) {
        DynamicObject slipStatusObject = salarySlipStatusHelper.generateEmptyDynamicObject();
        slipStatusObject.set("slip", (Object)salaryCalTableDTO.getSlipId());
        slipStatusObject.set("salarycalendar", (Object)calendarPrimaryKey);
        slipStatusObject.set("encryptlevel", (Object)salarySlipDTO.getEncryptLevel());
        slipStatusObject.set("encrypttype", (Object)salarySlipDTO.getEncryptType());
        slipStatusObject.set("encrypt", (Object)salarySlipDTO.getEncryptId());
        slipStatusObject.set("secretkey", (Object)salarySlipDTO.getSecretkeyId());
        slipStatusObject.set("invalidtime", (Object)salarySlipDTO.getInvalidTime());
        slipStatusObject.set("isview", (Object)"0");
        slipStatusObject.set("isconfirm", (Object)"0");
        slipStatusObject.set("isrecycle", (Object)"0");
        slipStatusObject.set("creator", (Object)currUserId);
        slipStatusObject.set("modifier", (Object)currUserId);
        slipStatusObject.set("createtime", (Object)currentDate);
        slipStatusObject.set("iscompress", (Object)Boolean.TRUE);
        return slipStatusObject;
    }

    private DynamicObject setStatusObjectByRepeat(SWCDataServiceHelper salarySlipStatusHelper, Long currUserId, Date currentDate, long calendarPrimaryKey, RepeatSalarySlipDTO salarySlipDTO, SalaryCalTableDTO salaryCalTableDTO) {
        DynamicObject slipStatusObject = salarySlipStatusHelper.generateEmptyDynamicObject();
        slipStatusObject.set("slip", (Object)salaryCalTableDTO.getSlipId());
        slipStatusObject.set("salarycalendar", (Object)calendarPrimaryKey);
        slipStatusObject.set("encryptlevel", (Object)salarySlipDTO.getEncryptLevel());
        slipStatusObject.set("encrypttype", (Object)salarySlipDTO.getEncryptType());
        slipStatusObject.set("encrypt", (Object)salarySlipDTO.getEncryptId());
        slipStatusObject.set("secretkey", (Object)salarySlipDTO.getSecretkeyId());
        slipStatusObject.set("invalidtime", (Object)salarySlipDTO.getInvalidTime());
        slipStatusObject.set("isview", (Object)"0");
        slipStatusObject.set("isconfirm", (Object)"0");
        slipStatusObject.set("isrecycle", (Object)"0");
        slipStatusObject.set("creator", (Object)currUserId);
        slipStatusObject.set("modifier", (Object)currUserId);
        slipStatusObject.set("createtime", (Object)currentDate);
        slipStatusObject.set("iscompress", (Object)Boolean.TRUE);
        return slipStatusObject;
    }

    private DynamicObject setDetailObject(SWCDataServiceHelper salaryDetailHelper, Long currUserId, Date currentDate, String encryptType, long calendarPrimaryKey, long releaseTimeStamp, SalaryCalTableDTO salaryCalTableDTO) {
        DynamicObject detailObject = salaryDetailHelper.generateEmptyDynamicObject();
        String encrykey = HSPPService.getEncryKey(calendarPrimaryKey, salaryCalTableDTO.getPersonId(), releaseTimeStamp);
        detailObject.set("encrykey", (Object)encrykey);
        detailObject.set("salaryslipdata", (Object)salaryCalTableDTO.getStructureSalary());
        detailObject.set("creator", (Object)currUserId);
        detailObject.set("modifier", (Object)currUserId);
        detailObject.set("createtime", (Object)currentDate);
        return detailObject;
    }

    private DynamicObject setCalendarObject(SWCDataServiceHelper salaryCalendarHelper, Long currUserId, Date currentDate, Date sendTime, long releaseTimeStamp, long calendarPrimaryKey, SalarySlipDTO salarySlipDTO, SalaryCalTableDTO salaryCalTableDTO) {
        DynamicObject calendarObject = salaryCalendarHelper.generateEmptyDynamicObject();
        calendarObject.set("caption", (Object)salarySlipDTO.getCaption());
        calendarObject.set("remark", (Object)salarySlipDTO.getRemark());
        calendarObject.set("salaryview", (Object)salarySlipDTO.getSalaryViewId());
        calendarObject.set("salaryviewv", (Object)salarySlipDTO.getSalaryViewVId());
        calendarObject.set("id", (Object)calendarPrimaryKey);
        calendarObject.set("person", (Object)salaryCalTableDTO.getPersonId());
        calendarObject.set("salaryfile", (Object)salaryCalTableDTO.getSalaryFileId());
        calendarObject.set("salaryfilev", (Object)salaryCalTableDTO.getSalaryFileVId());
        calendarObject.set("payrolldate", (Object)salaryCalTableDTO.getPayRollDate());
        calendarObject.set("calcount", (Object)salaryCalTableDTO.getCalCount());
        calendarObject.set("startdate", (Object)salaryCalTableDTO.getStartDate());
        calendarObject.set("enddate", (Object)salaryCalTableDTO.getEndDate());
        calendarObject.set("paysubject", (Object)salaryCalTableDTO.getPaySubjectId());
        calendarObject.set("paysubjectv", (Object)salaryCalTableDTO.getPaySubjectVId());
        calendarObject.set("payrollgrp", (Object)salaryCalTableDTO.getPayrollgroupId());
        calendarObject.set("salcalendarmulsum", (Object)this.getMulBaseDataDyColl(calendarObject, salarySlipDTO.getSalarySlipSumViewList()));
        calendarObject.set("salaryslipdata", (Object)salaryCalTableDTO.getStructureSumSalary());
        calendarObject.set("releasetime", (Object)sendTime);
        calendarObject.set("releaseTimeStamp", (Object)releaseTimeStamp);
        calendarObject.set("creator", (Object)currUserId);
        calendarObject.set("createtime", (Object)currentDate);
        calendarObject.set("modifier", (Object)currUserId);
        calendarObject.set("paydate", (Object)salaryCalTableDTO.getPayDate());
        return calendarObject;
    }

    private DynamicObject setCalendarObjectByRepeat(SWCDataServiceHelper salaryCalendarHelper, Long currUserId, Date currentDate, long calendarPrimaryKey, RepeatSalarySlipDTO salarySlipDTO, SalaryCalTableDTO salaryCalTableDTO) {
        DynamicObject calendarObject = salaryCalendarHelper.generateEmptyDynamicObject();
        calendarObject.set("caption", (Object)salarySlipDTO.getCaption());
        calendarObject.set("remark", (Object)salarySlipDTO.getRemark());
        calendarObject.set("salaryview", (Object)salarySlipDTO.getSalaryViewId());
        calendarObject.set("salaryviewv", (Object)salarySlipDTO.getSalaryViewVId());
        calendarObject.set("id", (Object)calendarPrimaryKey);
        calendarObject.set("person", (Object)salaryCalTableDTO.getPersonId());
        calendarObject.set("salaryfile", (Object)salaryCalTableDTO.getSalaryFileId());
        calendarObject.set("salaryfilev", (Object)salaryCalTableDTO.getSalaryFileVId());
        calendarObject.set("payrolldate", (Object)salaryCalTableDTO.getPayRollDate());
        calendarObject.set("calcount", (Object)salaryCalTableDTO.getCalCount());
        calendarObject.set("startdate", (Object)salaryCalTableDTO.getStartDate());
        calendarObject.set("enddate", (Object)salaryCalTableDTO.getEndDate());
        calendarObject.set("paysubject", (Object)salaryCalTableDTO.getPaySubjectId());
        calendarObject.set("paysubjectv", (Object)salaryCalTableDTO.getPaySubjectVId());
        calendarObject.set("payrollgrp", (Object)salaryCalTableDTO.getPayrollgroupId());
        calendarObject.set("salcalendarmulsum", (Object)this.getMulBaseDataDyColl(calendarObject, salarySlipDTO.getSalarySlipSumViewList()));
        calendarObject.set("salaryslipdata", (Object)salaryCalTableDTO.getStructureSumSalary());
        calendarObject.set("releasetime", (Object)salarySlipDTO.getSendTime());
        calendarObject.set("releaseTimeStamp", (Object)salarySlipDTO.getSendTime().getTime());
        calendarObject.set("paydate", (Object)salaryCalTableDTO.getPayDate());
        calendarObject.set("creator", (Object)currUserId);
        calendarObject.set("createtime", (Object)currentDate);
        calendarObject.set("modifier", (Object)currUserId);
        return calendarObject;
    }

    private static String getEncryKey(long salarySlipId, long personId, long releasetimestamp) {
        ArrayList<String> secretKeyList = new ArrayList<String>(10);
        secretKeyList.add(String.valueOf(salarySlipId));
        secretKeyList.add(String.valueOf(personId));
        secretKeyList.add(String.valueOf(releasetimestamp));
        MultiEncryptNewService service = new MultiEncryptNewService(EncryptTypeEnum.ENCRYPT_TYPE_INTERNATIONAL, EncryptLevelEnum.ENCRYPT_LEVEL_ORDINARY);
        return service.getEncryKey(secretKeyList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clearSalaryByFieldParam() {
        List<String> tableList = Arrays.asList("T_HSPP_SALARYSLIPSTATUS", "T_HSPP_SALARYSLIPDETAIL", "T_HSPP_SALARYCALENDAR", "T_HSPP_SALARYCALENDAR_L", "T_HSPP_SALCALENDARMULSUM");
        try (TXHandle txHandle = TX.requiresNew();){
            for (String tableName : tableList) {
                String ksql = "truncate table ?;";
                ksql = ksql.replace("?", tableName);
                SWCDbUtil.execute((DBRoute)SWCConstants.HSPP_ROUETE, (String)ksql, (Object[])new Object[0]);
            }
        }
        return SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clearSalaryByIds(List<Long> salarySlipIds) {
        DynamicObject[] salaryCalendarArray;
        DynamicObject[] salarySlipStatusArray;
        SWCDataServiceHelper salarySlipStatusHelper = new SWCDataServiceHelper("hspp_salaryslipstatus");
        SWCDataServiceHelper salarySlipDetailHelper = new SWCDataServiceHelper("hspp_salaryslipdetail");
        SWCDataServiceHelper salaryCalendarHelper = new SWCDataServiceHelper("hspp_salarycalendar");
        int length = salarySlipIds.size();
        ArrayList<Long> salaryCalendarList = new ArrayList<Long>(length);
        HashMap<Long, String> encryptMap = new HashMap<Long, String>(length);
        QFilter statusFilter = new QFilter("slip", "in", salarySlipIds);
        for (DynamicObject dynamicObject : salarySlipStatusArray = salarySlipStatusHelper.query("slip,salarycalendar.id,encrypttype", new QFilter[]{statusFilter})) {
            Long salaryCalendar = dynamicObject.getLong("salarycalendar.id");
            String encryptType = dynamicObject.getString("encrypttype");
            salaryCalendarList.add(salaryCalendar);
            encryptMap.put(salaryCalendar, encryptType);
        }
        ArrayList<String> encryKeyList = new ArrayList<String>(length);
        QFilter calendarFilter = new QFilter("id", "in", salaryCalendarList);
        for (DynamicObject salaryCalendar : salaryCalendarArray = salaryCalendarHelper.query("id,person.id,releasetimestamp", new QFilter[]{calendarFilter})) {
            Long id = salaryCalendar.getLong("id");
            Long personId = salaryCalendar.getLong("person.id");
            Long releasetimestamp = salaryCalendar.getLong("releasetimestamp");
            String encryptType = (String)encryptMap.get(id);
            if (!StringUtils.isNotEmpty((CharSequence)encryptType)) continue;
            String encryKey = HSPPService.getEncryKey(id, personId, releasetimestamp);
            encryKeyList.add(encryKey);
        }
        try (TXHandle tXHandle = TX.requiresNew();){
            QFilter detailDelete = new QFilter("encrykey", "in", encryKeyList);
            salarySlipDetailHelper.deleteByFilter(new QFilter[]{detailDelete});
            salaryCalendarHelper.deleteByFilter(new QFilter[]{calendarFilter});
            salarySlipStatusHelper.deleteByFilter(new QFilter[]{statusFilter});
        }
        return SUCCESS;
    }

    public String getPwdByPersonId(Long personId) {
        DynamicObject pwdObject = SalaryPwdHelper.getPwdObjectByPersonId((Long)personId);
        return pwdObject == null ? null : pwdObject.getString("password");
    }

    public Map<String, Object> authenticatePwdByPersonId(Long hrPersonId, String password) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DynamicObject pwdObject = SalaryPwdHelper.getPwdObjectByPersonId((Long)hrPersonId);
        if (pwdObject == null || SWCStringUtils.isEmpty((String)pwdObject.getString("password"))) {
            resultMap.put("isExist", Boolean.FALSE);
            resultMap.put("authenticate", Boolean.FALSE);
        } else {
            resultMap.put("isExist", Boolean.TRUE);
            resultMap.put("authenticate", SalaryPwdHelper.checkPassWord((String)String.valueOf(hrPersonId), (String)pwdObject.getString("password"), (String)password));
        }
        return resultMap;
    }

    private DynamicObjectCollection getMulBaseDataDyColl(DynamicObject dyObj, List<Long> fieldValueIds) {
        DynamicObjectCollection dyColl = dyObj.getDynamicObjectCollection("salcalendarmulsum");
        DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
        for (Long fieldValueId : fieldValueIds) {
            DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
            DynamicObject personDy = this.getDynamicObjectById("hsbs_salslipsumview", fieldValueId);
            mulBasedataDy.set("fbasedataid", (Object)personDy);
            dyColl.add((Object)mulBasedataDy);
        }
        return dyColl;
    }

    private DynamicObject getDynamicObjectById(String entityName, Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return id == null || id == 0L ? null : new DynamicObject((DynamicObjectType)type, (Object)id);
    }
}

