/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.mservice.update;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.LoginUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.PasswordEncryptUtil;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class SalarySlipPWUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SalarySlipPWUpdateService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.updateData();
        }
        catch (Exception e) {
            logger.error("SalarySlipPWUpdateService error", (Throwable)e);
        }
        return result;
    }

    public void updateData() {
        List<Object[]> paramsList;
        StringBuilder setSql = new StringBuilder();
        setSql.append("fpassword_enp").append(" = ? ").append(", ").append("fpassword").append(" = ? ");
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append("t_hspp_salaryslippwd");
        sql.append(" set ").append((CharSequence)setSql);
        sql.append("where ").append("fid").append(" = ?");
        for (int batchIndex = 0; batchIndex < 10000 && !CollectionUtils.isEmpty(paramsList = this.getUpdateParamsList()); ++batchIndex) {
            SWCDbUtil.executeBatch((DBRoute)SWCConstants.HSPP_ROUETE, (String)sql.toString(), paramsList);
        }
    }

    private List<Object[]> getUpdateParamsList() {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        StringBuilder fieldsSql = new StringBuilder();
        fieldsSql.append("fid");
        StringBuilder whereSql = new StringBuilder();
        fieldsSql.append(',').append("fpassword_enp");
        fieldsSql.append(',').append("fpersonid");
        whereSql.append("fpersonid").append(" != 0 ");
        whereSql.append(" and ");
        whereSql.append("fpassword_enp").append(" is not null ");
        StringBuilder sql = new StringBuilder();
        sql.append("select top 10000 ").append((CharSequence)fieldsSql).append(" from ").append("t_hspp_salaryslippwd").append(" where ").append("fid").append(" is not null ").append("and (").append((CharSequence)whereSql).append(')');
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryEncodeUpdateEntryDataService", (DBRoute)SWCConstants.HSPP_ROUETE, (String)sql.toString(), (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Object id = row.get("fid");
                String personId = row.getString("fpersonid");
                Object[] params = new Object[3];
                String valueEnp = row.getString("fpassword_enp");
                String value = Encrypters.decode((String)valueEnp);
                params[0] = null;
                params[1] = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)value, (String)LoginUtils.getCorrectUserIDSalt((String)personId));
                params[2] = id;
                paramsList.add(params);
            }
            ArrayList<Object[]> arrayList = paramsList;
            return arrayList;
        }
    }
}

