/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.login;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hspp.business.login.SalaryPwdHelper;
import kd.swc.hspp.business.mservice.person.IPersonService;
import kd.swc.hspp.business.permissions.PermissionHelper;

public class SalaryPwdForgetPlugin
extends AbstractMobFormPlugin {
    private static final Log logger = LogFactory.getLog(SalaryPwdForgetPlugin.class);
    private static final String DONOTHING_SENDMSG = "donothing_sendmsg";
    private static final String DONOTHING_CONFIEM = "donothing_confirm";
    private static final String TEXTFIELD_PHONE = "textfield_phone";
    private static final String TEXTFIELD_CODE = "textfield_code";
    private static final String TEXTFIELD_CODEGET = "textfield_codeget";
    private static final String LABELAP_SENDMSG = "labelap_sendmsg";
    private static final String CODE_REGET = "code_reget";
    private static final String COUNTDOWNAP = "countdownap";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addCountDownListener();
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        boolean isHavePermission = PermissionHelper.salarySlipIsHavePermission((IFormView)this.getView(), (String)"47150e89000000ac");
        if (!isHavePermission) {
            return;
        }
        Long personId = 0L;
        Tuple tuple = IPersonService.getInstance().getPersonInfo();
        if (((Boolean)tuple.item1).booleanValue()) {
            personId = ((Map)tuple.item2).getOrDefault("person", 0L);
        }
        this.getPageCache().put("personid", String.valueOf(personId));
        this.setCodeFlexVisible(Boolean.TRUE, Boolean.FALSE);
    }

    public void afterBindData(EventObject event) {
        super.beforeBindData(event);
        SalaryPwdHelper.setPageBtnEnableCache((String)this.getView().getPageId(), (Boolean)Boolean.TRUE);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        super.propertyChanged(args);
        switch (fieldKey = args.getProperty().getName()) {
            case "textfield_phone": {
                if (!this.isValidPersonPhone()) break;
                SalaryPwdHelper.setControlField((AbstractMobFormPlugin)this, (String)TEXTFIELD_PHONE, (Boolean)Boolean.TRUE);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String formOp;
        super.beforeDoOperation(args);
        switch (formOp = ((FormOperate)args.getSource()).getOperateKey()) {
            case "donothing_confirm": {
                boolean flag = SalaryPwdHelper.isBtnEnable((String)this.getView().getPageId());
                if (!flag) {
                    args.setCancel(true);
                    return;
                }
                if (this.isValidPersonPhone()) {
                    this.validPhoneCode(args);
                    break;
                }
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String formOp;
        switch (formOp = ((FormOperate)args.getSource()).getOperateKey()) {
            case "donothing_sendmsg": {
                this.sendMessage();
                break;
            }
            case "donothing_confirm": {
                SalaryPwdHelper.setPageBtnEnableCache((String)this.getView().getPageId(), (Boolean)Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"btnconfirm", LABELAP_SENDMSG});
                this.clearInput();
                SalaryPwdHelper.redirectPageByFormId((AbstractMobFormPlugin)this, (String)"hspp_mobpwdreset");
                break;
            }
        }
    }

    private void clearInput() {
        this.getModel().beginInit();
        this.getModel().setValue(TEXTFIELD_PHONE, (Object)"");
        this.getModel().setValue(TEXTFIELD_CODE, (Object)"");
        this.getModel().setValue(TEXTFIELD_CODEGET, (Object)"");
        this.getModel().endInit();
        this.getView().updateView(TEXTFIELD_PHONE);
        this.getView().updateView(TEXTFIELD_CODE);
        this.getView().updateView(TEXTFIELD_CODEGET);
        SalaryPwdHelper.setControlField((AbstractMobFormPlugin)this, (String)TEXTFIELD_PHONE, (Boolean)Boolean.TRUE);
        SalaryPwdHelper.setControlField((AbstractMobFormPlugin)this, (String)TEXTFIELD_CODE, (Boolean)Boolean.TRUE);
        SalaryPwdHelper.setControlField((AbstractMobFormPlugin)this, (String)TEXTFIELD_CODEGET, (Boolean)Boolean.TRUE);
    }

    private void sendMessage() {
        String personId = this.getPageCache().get("personid");
        String phone = (String)this.getModel().getValue(TEXTFIELD_PHONE);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("personId", Long.parseLong(personId));
        paramMap.put("phone", phone);
        ApiResult apiResult = SalaryPwdHelper.sendCodeMessage(paramMap);
        if (apiResult.getSuccess()) {
            String msg = ((JSONObject)apiResult.getData()).getString("msg");
            SalaryPwdHelper.setMessageValue((AbstractMobFormPlugin)this, (String)msg);
            this.setCodeFlexVisible(Boolean.FALSE, Boolean.TRUE);
            this.startCountDown();
        } else {
            SalaryPwdHelper.setControlField((AbstractMobFormPlugin)this, (String)TEXTFIELD_PHONE, (Boolean)Boolean.FALSE);
            SalaryPwdHelper.setMessageValue((AbstractMobFormPlugin)this, (String)apiResult.getMessage());
        }
    }

    private void setCodeFlexVisible(Boolean flexGet, Boolean flexInput) {
        this.getView().setVisible(flexGet, new String[]{LABELAP_SENDMSG});
        this.getView().setVisible(flexInput, new String[]{CODE_REGET});
    }

    private void startCountDown() {
        CountDown countDown = (CountDown)this.getControl(COUNTDOWNAP);
        countDown.setDuration(59);
        this.getView().updateView(COUNTDOWNAP);
    }

    private void addCountDownListener() {
        CountDown phoneNewCountDown = (CountDown)this.getControl(COUNTDOWNAP);
        phoneNewCountDown.addCountDownListener(new CountDownListener(){

            public void onCountDownEnd(CountDownEvent evt) {
                SalaryPwdForgetPlugin.this.getView().getModel().setValue(SalaryPwdForgetPlugin.TEXTFIELD_CODE, null);
                SalaryPwdForgetPlugin.this.setCodeFlexVisible(Boolean.TRUE, Boolean.FALSE);
            }
        });
    }

    private void validPhoneCode(BeforeDoOperationEventArgs args) {
        String codeGet = this.getModel().getDataEntity().getString(TEXTFIELD_CODEGET);
        String personId = this.getPageCache().get("personid");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("personId", Long.parseLong(personId));
        paramMap.put("code", codeGet);
        ApiResult apiResult = SalaryPwdHelper.validPhoneCode(paramMap);
        if (!apiResult.getSuccess()) {
            args.setCancel(true);
            SalaryPwdHelper.setMessageValue((AbstractMobFormPlugin)this, (String)apiResult.getMessage());
            SalaryPwdHelper.setControlField((AbstractMobFormPlugin)this, (String)TEXTFIELD_CODEGET, (Boolean)Boolean.FALSE);
            SalaryPwdHelper.setControlField((AbstractMobFormPlugin)this, (String)TEXTFIELD_CODE, (Boolean)Boolean.FALSE);
        }
    }

    private boolean isValidPersonPhone() {
        String phone = (String)this.getModel().getValue(TEXTFIELD_PHONE);
        ApiResult apiResult = SalaryPwdHelper.isValidPersonPhone((String)phone, (Long)RequestContext.get().getCurrUserId());
        boolean success = apiResult.getSuccess();
        if (!success) {
            SalaryPwdHelper.setControlField((AbstractMobFormPlugin)this, (String)TEXTFIELD_PHONE, (Boolean)Boolean.FALSE);
            SalaryPwdHelper.setMessageValue((AbstractMobFormPlugin)this, (String)apiResult.getMessage());
        }
        return success;
    }
}

