/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.login;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hspp.business.login.SalaryPwdHelper;
import kd.swc.hspp.business.mservice.person.IPersonService;
import kd.swc.hspp.business.permissions.PermissionHelper;

public class SalaryPwdLoginPlugin
extends AbstractMobFormPlugin {
    private static final String DONOTHING_RELOGIN = "donothing_relogin";
    private static final String DONOTHING_FORGETPAWD = "donothing_forgetpwd";
    private static final String LABELAP_NAME = "labelap_namelogin";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        SWCDataServiceHelper nameHelper = new SWCDataServiceHelper("bos_user");
        DynamicObject nameObject = nameHelper.queryOne("name", new QFilter[]{new QFilter("id", "=", (Object)RequestContext.get().getCurrUserId())});
        String name = nameObject.getString("name");
        SalaryPwdHelper.setLabelValue((AbstractFormPlugin)this, (String)LABELAP_NAME, (String)name);
    }

    public void afterBindData(EventObject event) {
        SalaryPwdHelper.setPageBtnEnableCache((String)this.getView().getPageId(), (Boolean)Boolean.TRUE);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String formOp;
        super.beforeDoOperation(args);
        switch (formOp = ((FormOperate)args.getSource()).getOperateKey()) {
            case "donothing_relogin": {
                boolean flag = SalaryPwdHelper.isBtnEnable((String)this.getView().getPageId());
                if (!flag) {
                    args.setCancel(true);
                    return;
                }
                String isSum = (String)this.getView().getFormShowParameter().getCustomParam("isSum");
                if (this.isPerm(isSum) && this.validPerson()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String formOp;
        switch (formOp = ((FormOperate)args.getSource()).getOperateKey()) {
            case "donothing_relogin": {
                SalaryPwdHelper.redirectPageByIsSum((AbstractMobFormPlugin)this);
                this.clearInput();
                break;
            }
            case "donothing_forgetpwd": {
                this.clearInput();
                SalaryPwdHelper.redirectPageByFormId((AbstractMobFormPlugin)this, (String)"hspp_pwdforget");
                break;
            }
            case "donothing_clean": {
                SalaryPwdHelper.deleteSalaryPwd((AbstractMobFormPlugin)this);
                SalaryPwdHelper.redirectPageByFormId((AbstractMobFormPlugin)this, (String)"hspp_mobpwdinit");
                break;
            }
        }
    }

    private void clearInput() {
        this.getModel().setValue("textfield_pwd", (Object)"");
        SalaryPwdHelper.setControlField((AbstractMobFormPlugin)this, (String)"textfield_pwd", (Boolean)Boolean.TRUE);
    }

    private boolean validPerson() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String loginCode = dataEntity.getString("textfield_pwd");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("newPwd", loginCode);
        map.put("personId", this.getPersonId());
        ApiResult apiResult = SalaryPwdHelper.authenticatePassword(map);
        boolean success = apiResult.getSuccess();
        SalaryPwdHelper.setControlField((AbstractMobFormPlugin)this, (String)"textfield_pwd", (Boolean)Boolean.FALSE);
        if (!success) {
            SalaryPwdHelper.setMessageValue((AbstractMobFormPlugin)this, (String)apiResult.getMessage());
        }
        return success;
    }

    private Long getPersonId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long personId = (Long)formShowParameter.getCustomParam("personid");
        if (personId != null) {
            return personId;
        }
        Tuple tuple = IPersonService.getInstance().getPersonInfo();
        if (((Boolean)tuple.item1).booleanValue()) {
            personId = ((Map)tuple.item2).getOrDefault("person", 0L);
        }
        return personId;
    }

    private boolean isPerm(String isSum) {
        if (PermissionHelper.isHaveSalarySlipPermission((String)isSum, null, (String)"47150e89000000ac")) {
            return true;
        }
        this.getView().showErrorNotification(PermissionHelper.getSalarySlipNoPermTips((String)isSum));
        return false;
    }
}

