/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.login.pc;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.swc.hsbp.business.servicehelper.SWCCertCommonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hspp.business.mservice.person.IPersonService;
import kd.swc.hspp.business.permissions.PermissionHelper;
import kd.swc.hspp.common.constants.LoginStatusEnum;

public class AbstractSalarySlipPlugin
extends AbstractFormPlugin {
    static final String JUMP_PAGE = "jumppage";
    static final String PAGE_ID = "pageId";
    static final String MSG = "msg";

    public void preOpenForm(PreOpenFormEventArgs args) {
        Boolean isCert;
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        String isPerm = (String)formShowParameter.getCustomParam("isPerm");
        boolean isHavePermission = PermissionHelper.isHavePcSalarySlipPermission((String)"0", (String)isPerm, (String)"47150e89000000ac");
        if (!isHavePermission) {
            args.setCancel(true);
            args.setCancelMessage(PermissionHelper.getSalarySlipNoPermTips((String)"0"));
        }
        if ((isCert = (Boolean)formShowParameter.getCustomParam("verifyCert")) != null && isCert.booleanValue()) {
            return;
        }
        Long personId = this.getCurPersonId(formShowParameter);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_personhr");
        DynamicObject personHr = helper.queryOne("id,personindexid", new QFilter[]{new QFilter("id", "=", (Object)personId)});
        Boolean result = Boolean.FALSE;
        if (personHr != null) {
            Map verifyCert = SWCCertCommonHelper.verifyCert((String)"/US+X3ECAB+C", (String)"hspp_pcsalaryslipdetail", Collections.singletonList(personHr.getLong("personindexid")));
            result = Optional.ofNullable(verifyCert).map(cert -> (Boolean)cert.get("result")).orElse(Boolean.FALSE);
        }
        if (!result.booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4f7f\u7528\u8bb8\u53ef\uff0c\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SalaryPwdInitPlugin_0", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            args.setCancel(true);
            args.setCancelMessage(msg);
        }
    }

    private Long getCurPersonId(FormShowParameter formShowParameter) {
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("personid"));
        if (personId != null) {
            return personId;
        }
        Tuple tuple = IPersonService.getInstance().getPersonInfo();
        if (((Boolean)tuple.item1).booleanValue()) {
            personId = ((Map)tuple.item2).getOrDefault("person", 0L);
        }
        return personId;
    }

    protected Long getPersonId() {
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("personid"));
        if (personId != null) {
            return personId;
        }
        Tuple tuple = IPersonService.getInstance().getPersonInfo();
        if (((Boolean)tuple.item1).booleanValue()) {
            personId = ((Map)tuple.item2).getOrDefault("person", 0L);
        }
        return personId;
    }

    void jumpPage(LoginStatusEnum statusEnum) {
        this.jumpPage(statusEnum, "");
    }

    void jumpPage(LoginStatusEnum statusEnum, String msg) {
        IFormView preBankCardView = this.getView().getParentView();
        if (preBankCardView == null) {
            return;
        }
        if (!"hspp_pcsalaryslipshow".equals(preBankCardView.getEntityId())) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue(PAGE_ID, this.getView().getEntityId());
        option.setVariableValue(MSG, msg);
        option.setVariableValue("loginStatus", String.valueOf(statusEnum.getCode()));
        preBankCardView.invokeOperation(JUMP_PAGE, option);
        this.getView().sendFormAction(preBankCardView);
    }

    FieldTip showValidateTip(boolean isSuccess, String field) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(isSuccess);
        fieldTip.setFieldKey(field);
        return fieldTip;
    }

    boolean isPerm(String isSum) {
        if (PermissionHelper.isHavePcSalarySlipPermission((String)isSum, null, (String)"47150e89000000ac")) {
            return true;
        }
        this.getView().showErrorNotification(PermissionHelper.getSalarySlipNoPermTips((String)isSum));
        return false;
    }
}

