/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.login.pc;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.swc.hspp.business.login.SalaryPwdHelper;
import kd.swc.hspp.common.constants.LoginStatusEnum;
import kd.swc.hspp.formplugin.web.login.pc.AbstractSalarySlipPlugin;

public class SalarySlipForgetPlugin
extends AbstractSalarySlipPlugin {
    private static final String CODE_INPUT = "codeinput";
    private static final String CODE_GET = "codeget";
    private static final String TEXTFIELD_PHONE = "phone";
    private static final String COUNTDOWNAP = "countdownap";
    private static final String VERIFY_NUMBER = "verifynumber";
    private static final String OK = "ok";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addCountDownListener();
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.setCodeFlexVisible(Boolean.TRUE);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        super.propertyChanged(args);
        switch (fieldKey = args.getProperty().getName()) {
            case "phone": {
                this.isValidPersonPhone();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String formOp;
        super.beforeDoOperation(args);
        switch (formOp = ((FormOperate)args.getSource()).getOperateKey()) {
            case "ok": {
                if (this.isValidPersonPhone()) {
                    this.validPhoneCode(args);
                    break;
                }
                args.setCancel(true);
                break;
            }
            case "codeget": {
                this.sendMessage();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String formOp;
        switch (formOp = ((FormOperate)args.getSource()).getOperateKey()) {
            case "ok": {
                this.jumpPage(LoginStatusEnum.RESET);
                break;
            }
        }
    }

    private void setCodeFlexVisible(Boolean isGet) {
        this.getView().setVisible(isGet, new String[]{CODE_GET});
        this.getView().setVisible(Boolean.valueOf(isGet == false), new String[]{CODE_INPUT});
    }

    private boolean isValidPersonPhone() {
        String phone = this.getModel().getDataEntity().getString(TEXTFIELD_PHONE);
        ApiResult apiResult = SalaryPwdHelper.isValidPersonPhone((String)phone, (Long)RequestContext.get().getCurrUserId());
        boolean success = apiResult.getSuccess();
        this.getView().showFieldTip(this.showValidateTip(success, TEXTFIELD_PHONE));
        if (!success) {
            this.getView().showErrorNotification(apiResult.getMessage());
        }
        return success;
    }

    private void sendMessage() {
        Long personId = this.getPersonId();
        String phone = this.getModel().getDataEntity().getString(TEXTFIELD_PHONE);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("personId", personId);
        paramMap.put(TEXTFIELD_PHONE, phone);
        ApiResult apiResult = SalaryPwdHelper.sendCodeMessage(paramMap);
        boolean success = apiResult.getSuccess();
        this.getView().showFieldTip(this.showValidateTip(success, TEXTFIELD_PHONE));
        if (success) {
            String msg = ((JSONObject)apiResult.getData()).getString("msg");
            this.getView().showSuccessNotification(msg);
            this.startCountDown();
            this.setCodeFlexVisible(Boolean.FALSE);
        } else {
            this.getView().showErrorNotification(apiResult.getMessage());
        }
    }

    private void validPhoneCode(BeforeDoOperationEventArgs args) {
        String codeNumber = this.getModel().getDataEntity().getString(VERIFY_NUMBER);
        Long personId = this.getPersonId();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("personId", personId);
        paramMap.put("code", codeNumber);
        ApiResult apiResult = SalaryPwdHelper.validPhoneCode(paramMap);
        boolean success = apiResult.getSuccess();
        this.getView().showFieldTip(this.showValidateTip(success, VERIFY_NUMBER));
        if (!success) {
            args.setCancel(true);
            this.getView().showErrorNotification(apiResult.getMessage());
        }
    }

    private void startCountDown() {
        CountDown countDown = (CountDown)this.getControl(COUNTDOWNAP);
        countDown.setDuration(59);
        this.getView().updateView(COUNTDOWNAP);
    }

    private void addCountDownListener() {
        CountDown phoneNewCountDown = (CountDown)this.getControl(COUNTDOWNAP);
        phoneNewCountDown.addCountDownListener(new CountDownListener(){

            public void onCountDownEnd(CountDownEvent evt) {
                SalarySlipForgetPlugin.this.getModel().setValue(SalarySlipForgetPlugin.VERIFY_NUMBER, null);
                SalarySlipForgetPlugin.this.setCodeFlexVisible(Boolean.TRUE);
            }
        });
    }
}

