/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.login.pc;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.login.SalaryPwdHelper;
import kd.swc.hspp.common.constants.LoginStatusEnum;
import kd.swc.hspp.formplugin.web.login.pc.AbstractSalarySlipPlugin;

public class SalarySlipInitPlugin
extends AbstractSalarySlipPlugin {
    private static final String TEXTFIELD_NEWPAWD = "newpwd";
    private static final String TEXTFIELD_VERIFYPAWD = "verifypwd";
    private static final String LOGIN = "login";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        Long personId = this.getPersonId();
        Integer statusCode = (Integer)this.getView().getFormShowParameter().getCustomParam("loginStatus");
        LoginStatusEnum statusEnum = LoginStatusEnum.getLoginStatusByCode((Integer)statusCode);
        if (LoginStatusEnum.RESET == statusEnum) {
            SalaryPwdHelper.setLabelValue((AbstractFormPlugin)this, (String)"labelap", (String)" ");
        } else if (SalaryPwdHelper.isPersonExist((Long)personId)) {
            this.jumpPage(LoginStatusEnum.LOGINING);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        super.propertyChanged(args);
        switch (fieldKey = args.getProperty().getName()) {
            case "newpwd": {
                this.verifyPassword("1");
                break;
            }
            case "verifypwd": {
                this.verifyPassword("2");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String formOp;
        super.beforeDoOperation(args);
        switch (formOp = ((FormOperate)args.getSource()).getOperateKey()) {
            case "login": {
                if (this.isPerm("0") && this.verifyPassword("3") && this.saveOrUpdatePassWord()) {
                    this.jumpPage(LoginStatusEnum.LOGINING, ResManager.loadKDString((String)"\u8bbe\u7f6e\u5bc6\u7801\u6210\u529f", (String)"SalarySlipInitPlugin_0", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
                    break;
                }
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean verifyPassword(String verifyType) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String newLoginCode = dataEntity.getString(TEXTFIELD_NEWPAWD);
        String verifyLoginCode = dataEntity.getString(TEXTFIELD_VERIFYPAWD);
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("newPwd", newLoginCode);
        map.put("verifyPwd", verifyLoginCode);
        map.put("verifyType", verifyType);
        ApiResult verify = SalaryPwdHelper.verify(map);
        boolean success = verify.getSuccess();
        if ("1".equals(verifyType)) {
            this.getView().showFieldTip(this.showValidateTip(success, TEXTFIELD_NEWPAWD));
        } else if ("2".equals(verifyType)) {
            this.getView().showFieldTip(this.showValidateTip(success, TEXTFIELD_VERIFYPAWD));
        } else {
            if (SWCStringUtils.isEmpty((String)newLoginCode)) {
                this.getView().showFieldTip(this.showValidateTip(success, TEXTFIELD_NEWPAWD));
            }
            if (SWCStringUtils.isEmpty((String)verifyLoginCode)) {
                this.getView().showFieldTip(this.showValidateTip(success, TEXTFIELD_VERIFYPAWD));
            }
        }
        if (!success) {
            this.getView().showErrorNotification(verify.getMessage());
        }
        return success;
    }

    private boolean saveOrUpdatePassWord() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String newLoginCode = dataEntity.getString(TEXTFIELD_NEWPAWD);
        String verifyLoginCode = dataEntity.getString(TEXTFIELD_VERIFYPAWD);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("newPwd", newLoginCode);
        map.put("verifyPwd", verifyLoginCode);
        map.put("personId", this.getPersonId());
        ApiResult apiResult = SalaryPwdHelper.saveOrUpdatePersonPwd(map);
        boolean success = apiResult.getSuccess();
        if (!success) {
            this.getView().showErrorNotification(apiResult.getMessage());
        } else {
            HashMap<String, String> parameterMap = new HashMap<String, String>(16);
            parameterMap.put("hrPersonId", String.valueOf(this.getPersonId()));
            DispatchServiceHelper.invokeBizService((String)"swc", (String)"hcdm", (String)"IAdjConfirmBillService", (String)"salarySplitResetPWDClearAdjConfirmCache", (Object[])new Object[]{parameterMap});
        }
        return success;
    }
}

