/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.login.pc;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hspp.business.login.SalaryPwdHelper;
import kd.swc.hspp.common.constants.LoginStatusEnum;
import kd.swc.hspp.formplugin.web.login.pc.AbstractSalarySlipPlugin;

public class SalarySlipLoginPlugin
extends AbstractSalarySlipPlugin {
    private static final String LOGIN = "login";
    private static final String FORGET = "forget";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        String userName = RequestContext.get().getUserName();
        SalaryPwdHelper.setLabelValue((AbstractFormPlugin)this, (String)"labelap", (String)String.format(Locale.ROOT, ResManager.loadKDString((String)"Hi\uff0c%s\uff0c\u8bf7\u8f93\u5165\u5de5\u8d44\u6761\u67e5\u8be2\u5bc6\u7801\u3002", (String)"SalarySlipLoginPlugin_0", (String)"swc-hspp-formplugin", (Object[])new Object[0]), userName));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String formOp;
        super.beforeDoOperation(args);
        switch (formOp = ((FormOperate)args.getSource()).getOperateKey()) {
            case "login": {
                if (this.isPerm("0") && this.validPerson()) {
                    this.jumpPage(LoginStatusEnum.LOGINED_DETAIL);
                    break;
                }
                args.setCancel(true);
                break;
            }
            case "forget": {
                this.jumpPage(LoginStatusEnum.RESET);
                break;
            }
        }
    }

    private boolean validPerson() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String loginCode = dataEntity.getString("newpwd");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("newPwd", loginCode);
        map.put("personId", this.getPersonId());
        ApiResult apiResult = SalaryPwdHelper.authenticatePassword(map);
        boolean success = apiResult.getSuccess();
        this.getView().showFieldTip(this.showValidateTip(true, "newpwd"));
        if (!success) {
            this.getView().showErrorNotification(apiResult.getMessage());
        }
        return success;
    }
}

