/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.mobile;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hspp.common.events.mobile.SalaryLabelApEvent;
import kd.sdk.swc.hspp.formplugin.mobile.ISalaryBaseExtService;
import kd.swc.hsbp.business.servicehelper.SWCCertCommonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.control.SWCFlexPanelAp;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.permissions.PermissionHelper;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.business.salaryslip.context.ContextHolder;
import kd.swc.hspp.common.model.SalaryCalendarModel;
import kd.swc.hspp.common.model.SalarySlipInitModel;
import kd.swc.hspp.formplugin.web.mobile.DefaultSalaryBaseExtService;

public class MobileSalaryBasePlugin
extends AbstractMobFormPlugin {
    public final Log logger = LogFactory.getLog(MobileSalaryBasePlugin.class);
    private static final String SALARYSLIPDETAIL = "salaryslipdetail";
    private static final String FLEXSUM = "flexsum";
    protected static final String PANEL_SALARYITEM = "panel_salaryitem";
    private static final String FLEXNOTDATA = "flexnotdata";
    private static final String TOTALFLEX = "totalflex";
    private static final String NETFLEX = "netflex";
    private static final String TOTALLAB = "totallab";
    private static final String NETLAB = "netlab";
    static final String FLEXPANELAP_DESCRIPTION = "flexpanelap_description";
    private static final String SUMDOWN = "sumdown";
    private static final String SUMUP = "sumup";
    protected static final String SELECTTIME = "selecttime";
    protected static final String OPENEYE = "openeye";
    protected static final String CLOSEEYE = "closeeye";
    private static final String AMOUNT_TABLE = "amountTable";
    private static final String AMOUNT_LIST = "amountList";
    private static final String IMAGE_BLANK_SALARYSLIP = "/images/mobile/emotion/zanwuchaxunneirong_224_128.png";
    static final String TOTALSALARY = "totalSalary";
    static final String NETSALARY = "netSalary";
    private static final String TIMELABEL = "timelabel";
    private static final String TIME_CACHE = "time_cache";
    private static final int TIME_YEAR = 1;
    private static final int TIME_YM = 2;
    private static final String SALARYSLIPDETAILSUM = "salaryslipdetailsum";
    public static final String CACHE_KEY_ENDDATE = "cache_date";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String formOp;
        super.beforeDoOperation(args);
        switch (formOp = ((FormOperate)args.getSource()).getOperateKey()) {
            case "openeye": {
                this.setEncryptLab(Boolean.FALSE);
                this.setAmountLabByEncrypt(Boolean.FALSE);
                break;
            }
            case "closeeye": {
                this.setEncryptLab(Boolean.TRUE);
                this.setAmountLabByEncrypt(Boolean.TRUE);
                break;
            }
            case "sumdown": {
                this.setShowSumAmountLab(Boolean.TRUE);
                this.setAmountLabShow(Boolean.TRUE);
                break;
            }
            case "sumup": {
                this.setShowSumAmountLab(Boolean.FALSE);
                this.setAmountLabShow(Boolean.FALSE);
                break;
            }
            case "salaryslipdetailsum": {
                this.toSalarySlipSetailSum();
                break;
            }
        }
    }

    private void toSalarySlipSetailSum() {
        boolean hasViewPermssion = PermissionHelper.isHaveSalarySlipPermission((String)"1", null, (String)"47150e89000000ac");
        if (!hasViewPermssion) {
            String message = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6211\u7684\u85aa\u8d44\u6c47\u603b\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MobileSalaryBasePlugin_1", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("hspp_salaryslipdetailsum");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (key.startsWith("labelap_amount")) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            args.setControl((Control)label);
        }
        if (key.startsWith(TOTALSALARY) || key.startsWith(NETSALARY)) {
            Container control = new Container();
            control.setKey(key);
            control.setView(this.getView());
            args.setControl((Control)control);
        }
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        String key;
        switch (key = customEventArgs.getEventName()) {
            case "handleDate": {
                ArrayList<Date> dateList = new ArrayList<Date>(2);
                String eventArgs = customEventArgs.getEventArgs();
                this.setTimeDateCache(eventArgs, dateList);
                this.initContextHolder();
                SalarySlipInitModel initModel = new SalarySlipInitModel();
                initModel.setDateList(dateList);
                this.initData(initModel);
                ContextHolder.destory();
                break;
            }
        }
    }

    public Date getSlipEndDate() {
        Date slipEndDate = null;
        String slipEndDateString = this.getView().getPageCache().get(CACHE_KEY_ENDDATE);
        if (SWCStringUtils.isNotEmpty((String)slipEndDateString)) {
            try {
                slipEndDate = SWCDateTimeUtils.parseDate((String)slipEndDateString, (String)"yyyy-MM");
            }
            catch (ParseException ex) {
                this.logger.info("slipEndDate error : {}", (Object)ex.getMessage());
            }
        } else {
            slipEndDate = ContextHolder.getSalarySlipEndDate();
        }
        return slipEndDate == null ? new Date() : slipEndDate;
    }

    public void initContextHolder() {
        ContextHolder.init();
        ContextHolder.setQueryDate((String)ContextHolder.getSalarySlipQueryParam());
    }

    public void initData(SalarySlipInitModel initModel) {
        boolean isContain;
        Date slipEndDate = this.getSlipEndDate();
        if (slipEndDate == null) {
            initModel.setCancel(true);
            this.logger.info("slipEndDate is null");
            return;
        }
        List pageDateList = initModel.getDateList();
        if (pageDateList.isEmpty()) {
            this.logger.info("queryDate is null");
            initModel.setCancel(true);
            return;
        }
        Tuple personQueryDate = ContextHolder.getSalarySlipQueryDateParam();
        Date minDate = (Date)personQueryDate.item1;
        Date maxDate = (Date)personQueryDate.item2;
        if (maxDate != null) {
            Date dateLast = SalarySlipHelper.getDateLast((Date)slipEndDate);
            maxDate = dateLast.after(maxDate) ? dateLast : maxDate;
        }
        this.setSelectTimeDateRange(minDate == null || maxDate == null ? new ArrayList<String>(10) : Arrays.asList(SWCDateTimeUtils.format((Date)minDate, (String)"yyyy-MM"), SWCDateTimeUtils.format((Date)maxDate, (String)"yyyy-MM")));
        Date startDate = (Date)pageDateList.get(0);
        Date endDate = (Date)pageDateList.get(1);
        Tuple dateInterval = SalarySlipHelper.getDateInterval((Date)minDate, (Date)maxDate, (Date)startDate, (Date)endDate);
        if (dateInterval == null) {
            String msg = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u65e5\u671f\u4e0d\u5728\u53ef\u67e5\u8be2\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalarySlipCalendarPlugin_3", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            initModel.setCancel(true);
            initModel.setCancelMessage(msg);
            return;
        }
        boolean bl = isContain = !startDate.equals(dateInterval.item1) || !endDate.equals(dateInterval.item2);
        if (isContain) {
            this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u67e5\u8be2{0}\uff5e{1}\u7684\u5de5\u8d44\u6761\u3002", (String)"SalarySlipCalendarPlugin_2", (String)"swc-hspp-formplugin", (Object[])new Object[0]), SWCDateTimeUtils.format((Date)((Date)dateInterval.item1), (String)"yyyy-MM"), SWCDateTimeUtils.format((Date)((Date)dateInterval.item2), (String)"yyyy-MM")));
        }
        ContextHolder.setStartEndDate((Date)((Date)dateInterval.item1), (Date)((Date)dateInterval.item2));
    }

    private void setTimeDateCache(String eventArgs, List<Date> dateList) {
        JSONObject json = JSON.parseObject((String)eventArgs);
        int dateType = (Integer)json.get((Object)"dateType");
        JSONArray dateVal = (JSONArray)json.get((Object)"dateVal");
        if (1 == dateType) {
            String yearString = dateVal.getString(0);
            ((Label)this.getView().getControl(TIMELABEL)).setText(yearString);
            this.getView().getPageCache().put(TIME_CACHE, eventArgs);
            int year = Integer.parseInt(yearString);
            if (dateList == null) {
                return;
            }
            dateList.add(SalarySlipHelper.getYearFirst((int)year));
            dateList.add(SalarySlipHelper.getYearLast((int)year));
        }
        if (2 == dateType) {
            try {
                Object[] array = new String[dateVal.size()];
                array = (String[])dateVal.toArray(array);
                String dateString = StringUtils.join((Object[])array, (String)"\uff5e");
                ((Label)this.getView().getControl(TIMELABEL)).setText(dateString);
                this.getView().getPageCache().put(TIME_CACHE, eventArgs);
                if (dateList == null) {
                    return;
                }
                dateList.add(SalarySlipHelper.getDateFirst((Date)SWCDateTimeUtils.parseDate((String)array[0])));
                dateList.add(SalarySlipHelper.getDateLast((Date)SWCDateTimeUtils.parseDate((String)array[1])));
            }
            catch (Exception e) {
                this.logger.info("get date error {}", (Object)e.getMessage());
            }
        }
    }

    protected List<Date> getPageDate(Date slipEndDate) {
        ArrayList<Date> dateList = new ArrayList<Date>(2);
        String jsonString = this.getView().getPageCache().get(TIME_CACHE);
        if (SWCStringUtils.isEmpty((String)jsonString)) {
            int year = SWCDateTimeUtils.getYear((Date)slipEndDate);
            String yearString = String.valueOf(year);
            ((Label)this.getView().getControl(TIMELABEL)).setText(yearString);
            JSONObject json = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)yearString);
            json.put("dateVal", (Object)jsonArray);
            json.put("dateType", (Object)1);
            this.getView().getPageCache().put(TIME_CACHE, json.toString());
            return Arrays.asList(SalarySlipHelper.getYearFirst((int)year), SalarySlipHelper.getYearLast((int)year));
        }
        this.setTimeDateCache(jsonString, dateList);
        return dateList;
    }

    protected List<String> getTimeControlDefaultDate() {
        String jsonString = this.getView().getPageCache().get(TIME_CACHE);
        if (SWCStringUtils.isEmpty((String)jsonString)) {
            int year = SWCDateTimeUtils.getYear((Date)this.getSlipEndDate());
            ArrayList<String> dateList = new ArrayList<String>();
            dateList.add(String.valueOf(year));
            return dateList;
        }
        JSONObject json = JSON.parseObject((String)jsonString);
        JSONArray dateVal = (JSONArray)json.get((Object)"dateVal");
        return dateVal.toJavaList(String.class);
    }

    protected void setSelectTimeDateRange(List<String> dateRange) {
        this.getView().getPageCache().put("dateRange", JSON.toJSONString(dateRange));
    }

    protected void openSelectTimeControl(String datePanelType) {
        String startDate;
        List<String> defaultDate;
        String dateRange = this.getView().getPageCache().get("dateRange");
        List<String> dateRangeList = new ArrayList(10);
        if (SWCStringUtils.isNotEmpty((String)dateRange)) {
            dateRangeList = (List)JSON.parseObject((String)dateRange, List.class);
        }
        if ((defaultDate = this.getTimeControlDefaultDate()).size() == 1 && dateRangeList.size() == 2) {
            String defaultDateStart = defaultDate.get(0);
            String dateRangeStart = (String)dateRangeList.get(0);
            String dateRangeEnd = (String)dateRangeList.get(1);
            startDate = defaultDateStart.compareTo(dateRangeStart) < 0 ? dateRangeStart : (defaultDateStart.compareTo(dateRangeEnd) > 0 ? dateRangeEnd : defaultDateStart);
            defaultDate.set(0, startDate);
        }
        if (defaultDate.size() == 2 && dateRangeList.size() == 2) {
            String endDate;
            String defaultDateStart = defaultDate.get(0);
            String defaultDateEnd = defaultDate.get(1);
            String dateRangeStart = (String)dateRangeList.get(0);
            String dateRangeEnd = (String)dateRangeList.get(1);
            if (defaultDateEnd.compareTo(dateRangeStart) < 0) {
                startDate = dateRangeStart;
                endDate = dateRangeStart;
            } else if (defaultDateStart.compareTo(dateRangeEnd) > 0) {
                startDate = dateRangeEnd;
                endDate = dateRangeEnd;
            } else {
                startDate = defaultDateStart.compareTo(dateRangeStart) > 0 ? defaultDateStart : dateRangeStart;
                endDate = defaultDateEnd.compareTo(dateRangeEnd) < 0 ? defaultDateEnd : dateRangeEnd;
            }
            defaultDate.set(0, startDate);
            defaultDate.set(1, endDate);
        }
        if (dateRangeList.isEmpty()) {
            dateRangeList.add("");
            dateRangeList.add("");
        }
        CustomControl customControl = (CustomControl)this.getView().getControl("timecontrolap");
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        HashMap<String, Object> content = new HashMap<String, Object>(16);
        content.put("datePanelType", datePanelType);
        content.put("defaultDate", defaultDate.toArray());
        content.put("dateRange", dateRangeList.toArray());
        content.put("customFormat", "YYYY-MM");
        data.put("data", content);
        data.put("eventName", "openDatePanel");
        data.put("eventStatus", "update");
        data.put("times", System.currentTimeMillis());
        customControl.setData(data);
    }

    protected void redirectPageOnReplace(String msg) {
        PermissionHelper.setErrorPageInfo((IFormView)this.getView(), (String)msg, (String)IMAGE_BLANK_SALARYSLIP, (Boolean)Boolean.TRUE);
    }

    private void setAmountLabByEncrypt(Boolean isEncryptLab) {
        String amountString = this.getView().getPageCache().get(AMOUNT_TABLE);
        if (StringUtils.isEmpty((CharSequence)amountString)) {
            return;
        }
        Map amountMap = (Map)SerializationUtils.deSerializeFromBase64((String)amountString);
        amountMap.forEach((labKey, amountContent) -> {
            Label label = (Label)this.getView().getControl(labKey);
            label.setText(isEncryptLab != false ? "******" : amountContent);
        });
    }

    private void setAmountLabShow(Boolean isShow) {
        String amountString = this.getView().getPageCache().get(AMOUNT_LIST);
        if (StringUtils.isEmpty((CharSequence)amountString)) {
            return;
        }
        List amountList = (List)SerializationUtils.deSerializeFromBase64((String)amountString);
        this.getView().setVisible(isShow, amountList.toArray(new String[0]));
    }

    protected void setQueryDataFlex(Boolean isHaveData) {
        this.getView().setVisible(isHaveData, new String[]{FLEXPANELAP_DESCRIPTION, CLOSEEYE, OPENEYE, PANEL_SALARYITEM, TOTALFLEX, NETFLEX, SUMDOWN, SUMUP, TOTALLAB, NETLAB});
        this.getView().setVisible(Boolean.valueOf(isHaveData == false), new String[]{FLEXNOTDATA});
    }

    protected void setEncryptLab(Boolean isEncrypt) {
        this.getView().setVisible(isEncrypt, new String[]{CLOSEEYE});
        this.getView().setVisible(Boolean.valueOf(isEncrypt == false), new String[]{OPENEYE});
        ContextHolder.updateSaveEncryptType((int)(isEncrypt != false ? 1 : 0));
    }

    private void setShowSumAmountLab(Boolean isShow) {
        this.getView().setVisible(isShow, new String[]{SUMUP});
        this.getView().setVisible(Boolean.valueOf(isShow == false), new String[]{SUMDOWN});
    }

    boolean isSameYear(Date dateOne, Date dateTwo) {
        return SWCDateTimeUtils.getYear((Date)dateOne) - SWCDateTimeUtils.getYear((Date)dateTwo) == 0;
    }

    protected void countAmount(Map<Long, SalaryCalendarModel> salaryCalendarModelMap, Map<Long, DynamicObject> currencyMap, boolean isEncrypt) {
        HashMap<String, LinkedHashMap> salaryTable = new HashMap<String, LinkedHashMap>(16);
        salaryCalendarModelMap.values().stream().sorted().forEach(salaryCalendarModel -> {
            Long calCurrencyId = salaryCalendarModel.getCalCurrencyId();
            if (calCurrencyId != null) {
                LinkedHashMap<Long, BigDecimal> totalSalaryMap = salaryTable.getOrDefault(TOTALSALARY, new LinkedHashMap());
                BigDecimal totalSalary = (BigDecimal)totalSalaryMap.get(calCurrencyId);
                BigDecimal modelTotalSalary = salaryCalendarModel.getTotalSalary();
                if (totalSalary != null) {
                    if (modelTotalSalary != null) {
                        totalSalaryMap.put(calCurrencyId, totalSalary.add(modelTotalSalary));
                    }
                } else {
                    totalSalaryMap.put(calCurrencyId, modelTotalSalary);
                }
                salaryTable.put(TOTALSALARY, totalSalaryMap);
                LinkedHashMap<Long, BigDecimal> netSalaryMap = salaryTable.getOrDefault(NETSALARY, new LinkedHashMap());
                BigDecimal netSalary = (BigDecimal)netSalaryMap.get(calCurrencyId);
                BigDecimal modelNetSalary = salaryCalendarModel.getNetSalary();
                if (netSalary != null) {
                    if (modelNetSalary != null) {
                        netSalaryMap.put(calCurrencyId, netSalary.add(modelNetSalary));
                    }
                } else {
                    netSalaryMap.put(calCurrencyId, modelNetSalary);
                }
                salaryTable.put(NETSALARY, netSalaryMap);
            }
        });
        LinkedHashMap<String, Map<Long, String>> salaryFormatMap = new LinkedHashMap<String, Map<Long, String>>(16);
        salaryTable.forEach((rowKey, value) -> {
            Map orDefault = salaryFormatMap.getOrDefault(rowKey, new HashMap(16));
            value.forEach((calCurrencyId, decimal) -> {
                String amount = "-";
                DynamicObject currency = (DynamicObject)currencyMap.get(calCurrencyId);
                if (currency != null && decimal != null) {
                    decimal = decimal.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                    amount = currency.getString("sign") + SalarySlipHelper.fmtMicrometer((String)decimal.toPlainString());
                }
                if (currency != null) {
                    orDefault.put(currency.getLong("id"), amount);
                } else {
                    orDefault.put(0L, amount);
                }
                salaryFormatMap.put((String)rowKey, orDefault);
            });
        });
        this.createSalarySumFlex(salaryFormatMap, isEncrypt);
    }

    private void createSalarySumFlex(Map<String, Map<Long, String>> salaryFormatMap, boolean isEncrypt) {
        LinkedHashMap<String, String> amountMap = new LinkedHashMap<String, String>(16);
        Map<Long, String> totalSalaryList = salaryFormatMap.get(TOTALSALARY) == null ? Collections.singletonMap(0L, "-") : salaryFormatMap.get(TOTALSALARY);
        Map<Long, String> netSalaryList = salaryFormatMap.get(NETSALARY) == null ? Collections.singletonMap(0L, "-") : salaryFormatMap.get(NETSALARY);
        ArrayList<String> amountList = new ArrayList<String>(10);
        amountList.addAll(this.createSumFlexPanelApByLogo(isEncrypt, TOTALFLEX, totalSalaryList, amountMap));
        amountList.addAll(this.createSumFlexPanelApByLogo(isEncrypt, NETFLEX, netSalaryList, amountMap));
        this.getView().setVisible(Boolean.valueOf(totalSalaryList.size() > 1), new String[]{SUMDOWN});
        this.getView().setVisible(Boolean.FALSE, new String[]{SUMUP});
        this.getView().setVisible(Boolean.FALSE, amountList.toArray(new String[0]));
        this.getView().getPageCache().put(AMOUNT_LIST, SerializationUtils.serializeToBase64(amountList));
        this.getView().getPageCache().put(AMOUNT_TABLE, SerializationUtils.serializeToBase64(amountMap));
    }

    private List<String> createSumFlexPanelApByLogo(boolean isEncrypt, String flexKey, Map<Long, String> salaryList, Map<String, String> amountMap) {
        FlexPanelAp sumSalaryFlexPanelAp = this.createSumSalaryAllFlexPanelAp(flexKey);
        ArrayList<String> amountList = new ArrayList<String>(10);
        for (Map.Entry<Long, String> data : salaryList.entrySet()) {
            Long currencyId = data.getKey();
            String content = data.getValue();
            FlexPanelAp sumSalaryPanelAp = this.createSumSalaryFlexPanelAp(flexKey, currencyId, sumSalaryFlexPanelAp);
            amountList.add(sumSalaryPanelAp.getKey());
            this.createAmountControls(sumSalaryPanelAp, isEncrypt, content, amountMap);
        }
        SalaryLabelApEvent salaryLabelApEvent = new SalaryLabelApEvent();
        salaryLabelApEvent.setType(flexKey);
        List items = sumSalaryFlexPanelAp.getItems();
        for (ControlAp item : items) {
            FlexPanelAp flexPanelAp = (FlexPanelAp)item;
            salaryLabelApEvent.setAllLabelAps(flexPanelAp.getItems());
        }
        this.redrawSalaryLabelApExtService(salaryLabelApEvent);
        this.getView().updateControlMetadata(flexKey, sumSalaryFlexPanelAp.createControl());
        if (amountList.size() >= 1) {
            amountList.remove(0);
        }
        return amountList;
    }

    private void redrawSalaryLabelApExtService(SalaryLabelApEvent salaryLabelApEvent) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new DefaultSalaryBaseExtService(), ISalaryBaseExtService.class, (String)"kd.sdk.swc.hspp.formplugin.mobile.ISalaryBaseExtService#redrawSalaryLabelAp", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.redrawSalaryLabelAp(salaryLabelApEvent);
            return null;
        });
        this.logger.info("ISalaryBaseExtService end event");
    }

    private FlexPanelAp createSumSalaryAllFlexPanelAp(String panelKey) {
        return new SWCFlexPanelAp.Builder(panelKey).setWrap(false).setDirection("column").setAlignItems("stretch").setGrow(0).setShrink(0).build();
    }

    private FlexPanelAp createSumSalaryFlexPanelAp(String panelKey, Long currencyId, FlexPanelAp sumSalaryAllFlexPanelAp) {
        FlexPanelAp flexPanelAp = new SWCFlexPanelAp.Builder(panelKey + UUID.randomUUID().toString() + "-" + currencyId).setWrap(false).setDirection("column").setAlignItems("stretch").setGrow(0).setShrink(0).setHeight("36px").build();
        sumSalaryAllFlexPanelAp.getItems().add(flexPanelAp);
        return flexPanelAp;
    }

    private void createAmountControls(FlexPanelAp sumSalaryFlex, boolean isEncrypt, String content, Map<String, String> amountMap) {
        List flexItems = sumSalaryFlex.getItems();
        String key = "labelap_amount-" + sumSalaryFlex.getKey();
        amountMap.put(key, content);
        flexItems.add(this.createSalaryAmountLabelAp(isEncrypt, key, content));
    }

    private LabelAp createSalaryAmountLabelAp(boolean isEncrypt, String key, String content) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(isEncrypt ? "******" : content));
        labelAp.setFontSize(22);
        labelAp.setForeColor("#FFFFFF");
        return labelAp;
    }

    protected boolean verifyCert() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String verifyCertFlag = (String)formShowParameter.getCustomParam("verifyCertFlag");
        if (SWCStringUtils.isEmpty((String)verifyCertFlag)) {
            String personIdStr = (String)formShowParameter.getCustomParam("personid");
            Long personId = 0L;
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_personhr");
            personId = SWCStringUtils.isEmpty((String)personIdStr) ? ContextHolder.getPersonId() : Long.valueOf(personIdStr);
            DynamicObject personHr = helper.queryOne("id,personindexid", new QFilter[]{new QFilter("id", "=", (Object)personId)});
            if (personHr == null) {
                return false;
            }
            String formId = this.getView().getFormShowParameter().getFormId();
            Map verifyCert = SWCCertCommonHelper.verifyCert((String)"/US+X3ECAB+C", (String)formId, Collections.singletonList(personHr.getLong("personindexid")));
            return Optional.ofNullable(verifyCert).map(cert -> (Boolean)cert.get("result")).orElse(Boolean.FALSE);
        }
        return true;
    }
}

