/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.mobile;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.permissions.PermissionHelper;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.business.salaryslip.context.ContextHolder;
import kd.swc.hspp.business.salaryslip.pojo.dto.SalaryCalendarDTO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalaryCalendarVO;
import kd.swc.hspp.common.constants.MonthEnum;
import kd.swc.hspp.common.model.SalaryCalendarModel;
import kd.swc.hspp.common.model.SalarySlipInitModel;
import kd.swc.hspp.formplugin.web.mobile.MobileSalaryBasePlugin;

public class MobileSalaryCalendarPlugin
extends MobileSalaryBasePlugin {
    private static final Log logger = LogFactory.getLog(MobileSalaryCalendarPlugin.class);
    private static final String SALARYSLIP = "salaryslip";
    private static final String SLIPCONTENT = "slipcontent";
    private static final String ONLAB = "onlab";
    private static final String DOWNLAB = "downlab";
    private static final String MONTH_SYMBOL = "card";
    private static final String PX_1 = "1px";
    private static final String PX_0 = "0px";
    public static final String CACHE_KEY_CUSTOMER_DATA_MAP = "customer_data_map";
    public static final String EMPTY_STR = "";
    private static final String ISVIEW = "isview";
    private static final String REDCODE = "redcode";
    public static final String PERCHFLEX = "perchflex";
    public static final String DETAIL_FORM_CLOSED = "detailFormClosed";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.initContextHolder();
        if (this.afterCreateNewData()) {
            SalarySlipInitModel initModel = new SalarySlipInitModel();
            Tuple dateTuple = ContextHolder.getSalarySlipQueryDateParam();
            Date slipEndDate = this.getSlipEndDate();
            if (dateTuple.item1 != null && slipEndDate.before((Date)dateTuple.item1)) {
                slipEndDate = dateTuple.item2 != null ? (Date)dateTuple.item2 : new Date();
            }
            initModel.setDateList(this.getPageDate(slipEndDate));
            this.initData(initModel);
        }
        ContextHolder.destory();
    }

    @Override
    public void initData(SalarySlipInitModel initModel) {
        super.initData(initModel);
        if (initModel.isCancel()) {
            this.setQueryDataFlex(Boolean.FALSE);
            HashMap<String, Object> customDataMap = new HashMap<String, Object>(16);
            customDataMap.put("msg", initModel.getCancelMessage());
            customDataMap.put("payrollList", new ArrayList(10));
            CustomControl ctrl = (CustomControl)this.getView().getControl("customcontrolap");
            if (ctrl != null) {
                ctrl.setData(customDataMap);
            }
            return;
        }
        PermissionHelper.setPageVisible((IFormView)this.getView(), (Boolean)Boolean.TRUE);
        DynamicObject[] dynamicObjects = ContextHolder.getSalarySlipStatus();
        Boolean isHaveData = dynamicObjects.length != 0;
        this.setQueryDataFlex(isHaveData);
        if (!isHaveData.booleanValue()) {
            this.setCustomCtrlData(new ArrayList<SalaryCalendarVO>(10));
            return;
        }
        boolean isEncrypt = ContextHolder.getEncryptType();
        this.setEncryptLab(isEncrypt);
        this.createSalaryCalendarFlexPanelAp(isEncrypt);
    }

    private void showInfoFlex() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        map.put("vi", Boolean.TRUE);
        this.getView().updateControlMetadata(PERCHFLEX, map);
    }

    private void setCustomCtrlData(List<SalaryCalendarVO> dataList) {
        HashMap<String, Object> customDataMap = new HashMap<String, Object>(16);
        if (dataList.isEmpty()) {
            customDataMap.put("msg", ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u53ef\u5c1d\u8bd5\u4fee\u6539\u7b5b\u9009\u6761\u4ef6\u3002", (String)"SalarySlipCalendarPlugin_1", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
        }
        customDataMap.put("payrollList", dataList);
        CustomControl ctrl = (CustomControl)this.getView().getControl("customcontrolap");
        if (ctrl != null) {
            ctrl.setData(customDataMap);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String formOp;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (formOp = source.getOperateKey()) {
            case "openeye": {
                this.encryptCustomerCtrlData(false);
                break;
            }
            case "closeeye": {
                this.encryptCustomerCtrlData(true);
                break;
            }
            case "updatedata": {
                OperateOption option = source.getOption();
                String isConfirm = option.getVariableValue("isConfirm", EMPTY_STR);
                if (SWCStringUtils.isEmpty((String)isConfirm)) {
                    return;
                }
                String unConfirmCount = this.getView().getPageCache().get("unConfirmCount");
                if (SWCStringUtils.isEmpty((String)unConfirmCount)) {
                    return;
                }
                long unConfirmCur = Long.parseLong(unConfirmCount) - 1L;
                if (unConfirmCur <= 0L) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap_description"});
                    return;
                }
                this.showStatFlexPanel(unConfirmCur);
                break;
            }
            case "updateconfirmdata": {
                this.updateConfirmStatus(args);
                break;
            }
            case "selecttime": {
                this.openSelectTimeControl("1");
                break;
            }
        }
    }

    private void updateConfirmStatus(BeforeDoOperationEventArgs eventArgs) {
        FormOperate source = (FormOperate)eventArgs.getSource();
        OperateOption option = source.getOption();
        String salaryCalendarId = option.getVariableValue("salaryCalendarId", EMPTY_STR);
        Map<Integer, List<SalaryCalendarModel>> customerDataMap = this.getSalaryCalendarModelData();
        for (Map.Entry<Integer, List<SalaryCalendarModel>> next : customerDataMap.entrySet()) {
            List<SalaryCalendarModel> salaryCalendarModelList;
            if (next == null || (salaryCalendarModelList = next.getValue()) == null) continue;
            for (SalaryCalendarModel calendarModel : salaryCalendarModelList) {
                if (calendarModel == null) continue;
                Long calendarModelId = calendarModel.getId();
                String calendarModelIdStr = EMPTY_STR;
                if (calendarModelId != null) {
                    calendarModelIdStr = calendarModelId.toString();
                }
                if (!calendarModelIdStr.equals(salaryCalendarId)) continue;
                calendarModel.setConfirm(true);
            }
        }
        boolean isEncrypt = ContextHolder.getEncryptType();
        if (isEncrypt) {
            this.setCustomerCtrlData(customerDataMap, true);
        } else {
            this.setCustomerCtrlData(customerDataMap, false);
        }
    }

    private void showStatFlexPanel(long unConfirmCount) {
        String statLabelApKey = "label_description";
        Label label = (Label)this.getView().getControl(statLabelApKey);
        label.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u6709%s\u4efd\u5de5\u8d44\u6761\u5f85\u786e\u8ba4\u3002", (String)"MobileSalaryCalendarPlugIn_11", (String)"swc-hspp-formplugin", (Object[])new Object[0]), unConfirmCount));
        this.getView().getPageCache().put("unConfirmCount", String.valueOf(unConfirmCount));
    }

    private void createSalaryCalendarFlexPanelAp(boolean isEncrypt) {
        DynamicObject[] dynamicObjects = ContextHolder.getSalarySlipStatus();
        Map salaryCalendarModelMap = ContextHolder.getSalaryCalendarModelMap();
        Map currencyMap = ContextHolder.getCurrencyMap();
        Map salarySlipViewMap = ContextHolder.getSalarySlipViewMap();
        long unConfirmCount = 0L;
        HashMap<Integer, List<SalaryCalendarModel>> customerDataMap = new HashMap<Integer, List<SalaryCalendarModel>>(16);
        String salarySlipQueryParam = ContextHolder.getSalarySlipQueryParam();
        for (DynamicObject dynamicObject : dynamicObjects) {
            ArrayList<SalaryCalendarModel> lists;
            DynamicObject currency;
            Date time = dynamicObject.getDate("salarycalendar." + salarySlipQueryParam);
            int releaseMonth = SWCDateTimeUtils.getMonth((Date)time);
            SalaryCalendarModel salaryCalendarModel = (SalaryCalendarModel)salaryCalendarModelMap.get(dynamicObject.getLong("salarycalendar.id"));
            DynamicObject salaryViewV = (DynamicObject)salarySlipViewMap.get(dynamicObject.getLong("salarycalendar.salaryviewv.id"));
            if (salaryViewV != null) {
                boolean isNeedConfirm = salaryViewV.getBoolean("isneedconfirm");
                if (isNeedConfirm && !salaryCalendarModel.isConfirm()) {
                    ++unConfirmCount;
                }
                salaryCalendarModel.setNeedConfirm(isNeedConfirm);
                salaryCalendarModel.setSalarySlipViewVersionId(Long.valueOf(salaryViewV.getLong("id")));
            }
            if ((currency = (DynamicObject)currencyMap.get(salaryCalendarModel.getCalCurrencyId())) != null) {
                salaryCalendarModel.setCalSign(currency.getString("sign"));
                salaryCalendarModel.setScale(currency.getInt("amtprecision"));
            }
            if ((lists = (ArrayList<SalaryCalendarModel>)customerDataMap.get(releaseMonth)) == null) {
                lists = new ArrayList<SalaryCalendarModel>(10);
            }
            lists.add(salaryCalendarModel);
            customerDataMap.put(releaseMonth, lists);
        }
        this.countAmount(salaryCalendarModelMap, currencyMap, isEncrypt);
        if (unConfirmCount > 0L) {
            this.showStatFlexPanel(unConfirmCount);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap_description"});
        }
        this.setCustomerCtrlData(customerDataMap, isEncrypt);
    }

    private void setCustomerCtrlData(Map<Integer, List<SalaryCalendarModel>> customerDataMap, boolean isEncrypt) {
        ArrayList<SalaryCalendarVO> salaryCalendarVOS = new ArrayList<SalaryCalendarVO>(10);
        for (Map.Entry<Integer, List<SalaryCalendarModel>> customMap : customerDataMap.entrySet()) {
            SalaryCalendarVO salaryCalendarVO;
            List<SalaryCalendarModel> salaryCalendarModelList;
            Integer monthVal;
            if (customMap == null || (monthVal = customMap.getKey()) == null || (salaryCalendarModelList = customMap.getValue()) == null || salaryCalendarModelList.isEmpty() || (salaryCalendarVO = this.putDataInMonthDataMap(monthVal, salaryCalendarModelList)) == null) continue;
            salaryCalendarVOS.add(salaryCalendarVO);
        }
        Collections.sort(salaryCalendarVOS, (t1, t2) -> t2.getMonth() - t1.getMonth());
        this.getView().getPageCache().put(CACHE_KEY_CUSTOMER_DATA_MAP, JSON.toJSONString(customerDataMap));
        if (isEncrypt) {
            for (SalaryCalendarVO salaryCalendarVO : salaryCalendarVOS) {
                if (salaryCalendarVO == null) continue;
                String showAmountType = ContextHolder.getShowAmountType();
                List data = salaryCalendarVO.getData();
                if (data == null) continue;
                for (SalaryCalendarDTO calendarDTO : data) {
                    calendarDTO.setPay(SWCStringUtils.equals((String)"2", (String)showAmountType) ? EMPTY_STR : "******");
                    calendarDTO.setCurrencySign(EMPTY_STR);
                }
            }
        }
        this.setCustomCtrlData(salaryCalendarVOS);
    }

    private SalaryCalendarVO putDataInMonthDataMap(Integer monthVal, List<SalaryCalendarModel> salaryCalendarModelList) {
        if (monthVal == null) {
            return null;
        }
        ArrayList<SalaryCalendarDTO> calendarDTOList = new ArrayList<SalaryCalendarDTO>(10);
        for (SalaryCalendarModel salaryCalendarModel : salaryCalendarModelList) {
            String amount;
            if (salaryCalendarModel == null) continue;
            SalaryCalendarDTO salaryCalendarDTO = new SalaryCalendarDTO();
            salaryCalendarDTO.setCaption(salaryCalendarModel.getCaption());
            Long calendarModelId = salaryCalendarModel.getId();
            if (calendarModelId != null) {
                salaryCalendarDTO.setId(calendarModelId.toString());
            }
            String dateRange = salaryCalendarModel.getDateRange();
            dateRange = dateRange.replace("~", " ~ ");
            salaryCalendarDTO.setDateRange(dateRange);
            boolean needConfirm = salaryCalendarModel.isNeedConfirm();
            salaryCalendarDTO.setNeedConfirm(needConfirm);
            boolean confirm = salaryCalendarModel.isConfirm();
            salaryCalendarDTO.setConfirm(confirm);
            String showConfirm = EMPTY_STR;
            if (needConfirm) {
                showConfirm = confirm ? ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"MobileSalaryCalendarDetailPlugin_2", (String)"swc-hspp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f85\u786e\u8ba4", (String)"MobileSalaryCalendarDetailPlugin_1", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            }
            salaryCalendarDTO.setShowConfirm(showConfirm);
            salaryCalendarDTO.setView(salaryCalendarModel.isView());
            salaryCalendarDTO.setCurrencySign(salaryCalendarModel.getCalSign());
            String showAmountType = ContextHolder.getShowAmountType();
            BigDecimal paySalary = null;
            switch (showAmountType) {
                case "0": {
                    paySalary = salaryCalendarModel.getNetSalary();
                    break;
                }
                case "1": {
                    paySalary = salaryCalendarModel.getTotalSalary();
                    break;
                }
            }
            if (paySalary == null) {
                amount = "-";
                salaryCalendarDTO.setCurrencySign(EMPTY_STR);
            } else {
                BigDecimal decimal = paySalary.setScale(salaryCalendarModel.getScale(), RoundingMode.HALF_UP);
                amount = SalarySlipHelper.fmtMicrometer((String)decimal.toPlainString());
            }
            salaryCalendarDTO.setPay(SWCStringUtils.equals((String)"2", (String)showAmountType) ? EMPTY_STR : amount);
            calendarDTOList.add(salaryCalendarDTO);
        }
        SalaryCalendarVO mothSalaryCalendarVO = new SalaryCalendarVO();
        mothSalaryCalendarVO.setMonth(monthVal);
        mothSalaryCalendarVO.setShowMonth(MonthEnum.getShowByMonth((Integer)monthVal));
        mothSalaryCalendarVO.setData(calendarDTOList);
        return mothSalaryCalendarVO;
    }

    @Override
    public void customEvent(CustomEventArgs customEventArgs) {
        String eventArgs;
        super.customEvent(customEventArgs);
        String eventName = customEventArgs.getEventName();
        if ("showForm".equals(eventName) && !SWCStringUtils.isEmpty((String)(eventArgs = customEventArgs.getEventArgs()))) {
            JSONObject jsonObject = (JSONObject)JSON.parse((String)eventArgs);
            Object monthObj = jsonObject.get((Object)"month");
            String id = (String)jsonObject.get((Object)"id");
            Integer month = null;
            if (monthObj instanceof Number) {
                month = ((Number)monthObj).intValue();
            } else if (monthObj instanceof String) {
                month = Integer.parseInt((String)monthObj);
            }
            SWCDataServiceHelper salaryCalendarHelper = new SWCDataServiceHelper("hspp_salarycalendar");
            DynamicObject salaryCalendar = salaryCalendarHelper.queryOne((Object)id);
            if (salaryCalendar == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u5df2\u56de\u6536\uff0c\u65e0\u6cd5\u67e5\u770b\u660e\u7ec6\u3002", (String)"MobileSalaryCalendarPlugIn_15", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
                this.doRemoveRecyculeDataAndUpdateCache(id);
                return;
            }
            Map<Integer, List<SalaryCalendarModel>> customerDataMapOfSorted = this.getSalaryCalendarModelData();
            List<SalaryCalendarModel> salaryCalendarModelList = customerDataMapOfSorted.get(month);
            for (SalaryCalendarModel salaryCalendarModel : salaryCalendarModelList) {
                Long calendarModelId = salaryCalendarModel.getId();
                String calendarModelStrId = null;
                if (calendarModelId != null) {
                    calendarModelStrId = calendarModelId.toString();
                }
                if (!Objects.equals(id, calendarModelStrId)) continue;
                this.openSalarySlipDetail(month, salaryCalendarModel);
                break;
            }
        }
    }

    private void openSalarySlipDetail(Integer month, SalaryCalendarModel salaryCalendarModel) {
        if (salaryCalendarModel == null) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_salaryslipdetail");
        QFilter qFilter = new QFilter("encrykey", "=", (Object)salaryCalendarModel.getEncryptKey());
        int count = helper.count("hspp_salaryslipdetail", new QFilter[]{qFilter});
        if (count == 1) {
            this.updateViewStatus(salaryCalendarModel);
            Long id = salaryCalendarModel.getId();
            String idStr = EMPTY_STR;
            if (id != null) {
                idStr = id.toString();
            }
            Map<Integer, List<SalaryCalendarModel>> customerDataMap = this.getSalaryCalendarModelData();
            List<SalaryCalendarModel> salaryCalendarModelList = customerDataMap.get(month);
            for (SalaryCalendarModel calendarModel : salaryCalendarModelList) {
                String calendarModelStrId;
                Long calendarModelId = calendarModel.getId();
                if (calendarModelId == null || !Objects.equals(idStr, calendarModelStrId = calendarModelId.toString())) continue;
                calendarModel.setView(true);
            }
            boolean isEncrypt = ContextHolder.getEncryptType();
            if (isEncrypt) {
                this.setCustomerCtrlData(customerDataMap, true);
            } else {
                this.setCustomerCtrlData(customerDataMap, false);
            }
            MobileFormShowParameter parameter = new MobileFormShowParameter();
            parameter.setFormId("hspp_mobilesaldetail");
            parameter.setCustomParam("calendarInfo", (Object)SerializationUtils.serializeToBase64((Object)salaryCalendarModel));
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DETAIL_FORM_CLOSED));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "detailFormClosed": {
                this.removeRecycleDataAndUpdateCache(returnData);
                break;
            }
        }
    }

    private void removeRecycleDataAndUpdateCache(Object returnData) {
        if (returnData instanceof Map) {
            Boolean isRecycle;
            Map returnMap = (Map)returnData;
            Boolean bl = isRecycle = returnMap.get("isRecycle") == null ? Boolean.FALSE : (Boolean)returnMap.get("isRecycle");
            if (isRecycle.booleanValue()) {
                Long salaryCalendarIdLong = (Long)returnMap.get("salaryCalendarId");
                String salaryCalendarId = EMPTY_STR;
                if (salaryCalendarIdLong != null) {
                    salaryCalendarId = salaryCalendarIdLong.toString();
                }
                this.doRemoveRecyculeDataAndUpdateCache(salaryCalendarId);
            }
        }
    }

    private void updateViewStatus(SalaryCalendarModel salaryCalendarModel) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_salaryslipstatus");
        QFilter filter = new QFilter("salarycalendar.id", "=", (Object)salaryCalendarModel.getId());
        DynamicObject dobj = helper.queryOne(ISVIEW, new QFilter[]{filter});
        if (dobj != null && !dobj.getBoolean(ISVIEW)) {
            dobj.set(ISVIEW, (Object)"1");
            helper.saveOne(dobj);
            salaryCalendarModel.setView(true);
        }
    }

    private void doRemoveRecyculeDataAndUpdateCache(String salaryCalendarId) {
        Map<Integer, List<SalaryCalendarModel>> customerDataMapOfSorted = this.getSalaryCalendarModelData();
        for (Map.Entry<Integer, List<SalaryCalendarModel>> next : customerDataMapOfSorted.entrySet()) {
            List<SalaryCalendarModel> salaryCalendarModelList;
            if (next == null || (salaryCalendarModelList = next.getValue()) == null) continue;
            Iterator<SalaryCalendarModel> modelIterator = salaryCalendarModelList.iterator();
            while (modelIterator.hasNext()) {
                SalaryCalendarModel salaryCalendarModel = modelIterator.next();
                if (salaryCalendarModel == null) continue;
                Long calendarModelId = salaryCalendarModel.getId();
                String calendarModelIdStr = EMPTY_STR;
                if (calendarModelId != null) {
                    calendarModelIdStr = calendarModelId.toString();
                }
                if (!calendarModelIdStr.equals(salaryCalendarId)) continue;
                modelIterator.remove();
            }
        }
        boolean isEncrypt = ContextHolder.getEncryptType();
        if (isEncrypt) {
            this.setCustomerCtrlData(customerDataMapOfSorted, true);
        } else {
            this.setCustomerCtrlData(customerDataMapOfSorted, false);
        }
    }

    public void encryptCustomerCtrlData(boolean isEncrypt) {
        Map<Integer, List<SalaryCalendarModel>> customerDataMapOfSorted = this.getSalaryCalendarModelData();
        this.setCustomerCtrlData(customerDataMapOfSorted, isEncrypt);
        ContextHolder.updateSaveEncryptType((int)(isEncrypt ? 1 : 0));
    }

    private Map<Integer, List<SalaryCalendarModel>> getSalaryCalendarModelData() {
        String customerDataMapStr = this.getView().getPageCache().get(CACHE_KEY_CUSTOMER_DATA_MAP);
        return (Map)JSON.parseObject((String)customerDataMapStr, (TypeReference)new TypeReference<Map<Integer, List<SalaryCalendarModel>>>(){}, (Feature[])new Feature[0]);
    }

    private boolean afterCreateNewData() {
        Tuple tuple = ContextHolder.getPersonTuple();
        boolean hasViewPermssion = PermissionHelper.isHaveSalarySlipPermission((String)"1", null, (String)"47150e89000000ac");
        this.getView().setVisible(Boolean.valueOf(hasViewPermssion), new String[]{"showsalaryslipdetailsum"});
        if (!((Boolean)tuple.item1).booleanValue()) {
            this.showInfoFlex();
            String msg = ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"MobileSalaryCalendarPlugIn_14", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            this.redirectPageOnReplace(msg);
            return false;
        }
        if (!this.verifyCert()) {
            this.showInfoFlex();
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4f7f\u7528\u8bb8\u53ef\uff0c\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SalaryPwdInitPlugin_0", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            this.redirectPageOnReplace(msg);
            return false;
        }
        if (!ContextHolder.salarySlipExist().booleanValue()) {
            this.showInfoFlex();
            String msg = ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u67e5\u8be2\u5de5\u8d44\u6761\u3002", (String)"MobileSalaryCalendarPlugIn_16", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            this.redirectPageOnReplace(msg);
            return false;
        }
        Date slipEndDate = ContextHolder.getSalarySlipEndDate();
        this.getView().getPageCache().put("cache_date", SWCDateTimeUtils.format((Date)slipEndDate, (String)"yyyy-MM"));
        return true;
    }
}

