/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.mobile;

import com.alibaba.fastjson.JSON;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.dto.salary.IssueFlowInfoDTO;
import kd.swc.hsbp.common.dto.salary.StructureSalaryDTO;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.permissions.PermissionHelper;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.business.salaryslip.detaildata.SalarySlipDataService;
import kd.swc.hspp.business.salaryslip.pojo.SalaryCardTypeEnum;
import kd.swc.hspp.business.salaryslip.pojo.dto.SalaryCardDTO;
import kd.swc.hspp.business.salaryslip.pojo.dto.SalaryCardEyeStatusDTO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalaryCardVO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalaryDetailVO;
import kd.swc.hspp.common.model.SalaryCalendarModel;
import kd.swc.hspp.common.utils.ShowPageUtils;

public class MobileSalaryDetailPlugin
extends AbstractMobFormPlugin {
    private static final String SEPAREATE = "\\|\\|";
    public static final String CUSTOMER_CARD_DATA_MAP = "customerCardDataMap";
    public static final String CARDLISTAP = "cardlistap";
    private Log log = LogFactory.getLog(MobileSalaryDetailPlugin.class);
    public static final String CASH_LOGO_RELATIVE = "icons/mobile/other/hr_xj_42_42.png";
    public static final String COMMON_BANK_LOGO_RELATIVE = "kingdee/hr/images/pc/other/image_COMlogo.png";
    public static final String BANK_BG_RELATIVE = "images/mobile/business_pic/hr_yhkbg_327_150.png";
    public static final String CASH_BG_RELATIVE = "images/mobile/business_pic/xinjin_327_150.png";
    private static final String PANEL_SALARYITEM = "panel_salaryitem";
    private static final String SHOWTYPE = "showtype";
    private static final String LABELAP_CURRENCY = "labelap_currency";
    private static final String LABELAP_ISSUEDAMOUNT = "labelap_issuedamount";
    private static final String FLEXPANELAP_CONFIRM = "flexpanelap_confirm";
    private static final String PANEL_PAYFLOW = "panel_payflow";
    private static final String PANEL_NOTICE = "panel_notice";
    private static final String LABELAP_DESCRIPTION = "labelap_description";
    private static final String LABELAP_CALCURRENCY = "labelap_calcurrency";
    private static final String LABELAP_ORICURRENCY = "labelap_oricurrency";
    private static final String IMAG_CLOSE = "imag_close";
    private static final String LABELAP_CONFIRM = "labelap_confirm";
    private static final String DONOTHING_OK = "donothing_ok";
    private static final String VIEWNOTICE = "viewnotice";
    private static final String ISVIEW = "isview";
    private static final String ISCONFIRM = "isconfirm";
    private static final String NEED_CONFIRM = "needConfirm";
    private static final String PAYMENT_SUBJECT = "paymentSubject";
    private static final String DATE_RANGE = "daterange";
    private static final String CAL_SIGN = "calSign";
    private static final String SUM_AMOUNT = "sumAmount";
    private static final String CAL_ARRAY = "calArray";
    private static final String ORI_ARRAY = "oriArray";
    private static final String SHOWVALUE = "showvalue";
    private static final String CURRENCY = "currency";
    private static final String NAME = "name";
    private static final String SUMMARY = "summary";
    private static final String CAPTION = "caption";
    private static final String CACHE_ITEM_AMOUNT_LIST = "cache_item_amount_list";
    private static final String CACHE_CURRENCY_TYPE = "cache_currency_type";
    private static final String UNCONFIRMED = "unconfirmed";
    private static final String CONFIRMED = "confirmed";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{LABELAP_ORICURRENCY, LABELAP_CALCURRENCY, LABELAP_CONFIRM});
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        boolean isHavePermission = PermissionHelper.salarySlipIsHavePermission((IFormView)this.getView(), (String)"47150e89000000ac", (String)"");
        if (!isHavePermission) {
            return;
        }
        SalaryCalendarModel salaryCalendarModel = this.getSalaryCalendarModel();
        if (salaryCalendarModel == null) {
            return;
        }
        this.setHeadData(salaryCalendarModel);
        Tuple slipData = SalarySlipHelper.getSalarySlipData((SalaryCalendarModel)salaryCalendarModel);
        StructureSalaryDTO salarySlipData = (StructureSalaryDTO)slipData.item2;
        if (salarySlipData == null) {
            if (((Boolean)slipData.item1).booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u5df2\u56de\u6536\uff0c\u65e0\u6cd5\u67e5\u770b\u660e\u7ec6\u3002", (String)"MobileSalaryCalendarPlugIn_15", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u6570\u636e\u89e3\u5bc6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MobileSalaryDetailPlugin_15", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{"contentflex"});
            }
            return;
        }
        this.getSalaryItemMap(salaryCalendarModel.getSalarySlipViewVersionId(), salarySlipData, salaryCalendarModel);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String formOp = ((FormOperate)args.getSource()).getOperateKey();
        SalaryCalendarModel salaryCalendarModel = this.getSalaryCalendarModel();
        if (salaryCalendarModel == null) {
            return;
        }
        switch (formOp) {
            case "donothing_ok": {
                this.updateConfirmStatus(salaryCalendarModel.getId());
                break;
            }
            case "viewnotice": {
                String remark = salaryCalendarModel.getRemark();
                HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                HashMap<String, String> customParam = new HashMap<String, String>(16);
                paramMap.put("formId", "hspp_mobileremarkdialog");
                paramMap.put("showType", ShowType.Floating);
                paramMap.put("formName", ResManager.loadKDString((String)"\u85aa\u8d44\u660e\u7ec6", (String)"MobileSalaryDetailPlugin_8", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
                customParam.put("remarkinfo", remark);
                paramMap.put("customParam", customParam);
                ShowPageUtils.showMobileForm(paramMap, (AbstractFormPlugin)this);
                break;
            }
        }
    }

    private SalaryCalendarModel getSalaryCalendarModel() {
        boolean isHaveData;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object calendarModel = customParams.get("calendarInfo");
        boolean bl = isHaveData = calendarModel != null;
        if (!isHaveData) {
            return null;
        }
        return (SalaryCalendarModel)SerializationUtils.deSerializeFromBase64((String)((String)calendarModel));
    }

    private void setHeadData(SalaryCalendarModel salaryCalendarModel) {
        IFormView view = this.getView();
        view.setVisible(Boolean.TRUE, new String[]{"labelap_caption", "labelap_daterange", LABELAP_ISSUEDAMOUNT});
        ShowPageUtils.setLabelValue((IFormView)view, (String)"labelap_caption", (String)salaryCalendarModel.getCaption());
        String dateRange = salaryCalendarModel.getDateRange();
        dateRange = dateRange.replace("~", " ~ ");
        ShowPageUtils.setLabelValue((IFormView)view, (String)"labelap_daterange", (String)("(" + dateRange + ")"));
        if (salaryCalendarModel.isNeedConfirm()) {
            this.setConfirmedLab(salaryCalendarModel.isConfirm());
        } else {
            view.setVisible(Boolean.FALSE, new String[]{CONFIRMED, UNCONFIRMED, FLEXPANELAP_CONFIRM});
        }
        String remark = salaryCalendarModel.getRemark();
        if (SWCStringUtils.isNotEmpty((String)remark)) {
            ShowPageUtils.setLabelValue((IFormView)view, (String)"label_description", (String)remark);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{PANEL_NOTICE});
        }
    }

    private void setConfirmedLab(Boolean isConfirm) {
        this.getView().setVisible(isConfirm, new String[]{CONFIRMED});
        this.getView().setVisible(Boolean.valueOf(isConfirm == false), new String[]{UNCONFIRMED});
        this.getView().setVisible(Boolean.valueOf(isConfirm == false), new String[]{FLEXPANELAP_CONFIRM});
    }

    private void getSalaryItemMap(long salaryViewVid, StructureSalaryDTO structureSalaryDTO, SalaryCalendarModel salaryCalendarModel) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryslipview");
        DynamicObject slipViewV = helper.queryOne((Object)salaryViewVid);
        this.analyzeSlipData(slipViewV, structureSalaryDTO, salaryCalendarModel);
    }

    private void analyzeSlipData(DynamicObject slipViewV, StructureSalaryDTO structureSalaryDTO, SalaryCalendarModel salaryCalendarModel) {
        SalarySlipDataService salaryDataService = new SalarySlipDataService();
        salaryDataService.setStructureSalaryDTO(structureSalaryDTO);
        salaryDataService.setSalaryCalendarModel(salaryCalendarModel);
        List salaryDetailVOList = salaryDataService.getDetailDataList();
        SalarySlipHelper.setHeadSummaryData((IFormView)this.getView(), (List)salaryDataService.getSummaryDetailList());
        if (salaryDetailVOList.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_SALARYITEM});
        }
        Map<String, List<SalaryDetailVO>> detailDataMap = this.getCustomerDetailDataMap(salaryDetailVOList);
        CustomControl ctrl = (CustomControl)this.getView().getControl("detaillistap");
        if (ctrl != null) {
            ctrl.setData(detailDataMap);
        }
        List issueFlowInfoDTOList = structureSalaryDTO.getIssueFlowInfoDTOList();
        if (slipViewV.getBoolean("isshowpayflow") && CollectionUtils.isNotEmpty((Collection)issueFlowInfoDTOList)) {
            this.analyzePayDetailData(issueFlowInfoDTOList);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CARDLISTAP});
        }
    }

    public Map<String, List<SalaryDetailVO>> getCustomerDetailDataMap(List<SalaryDetailVO> salaryDetailVOList) {
        HashMap<String, List<SalaryDetailVO>> map = new HashMap<String, List<SalaryDetailVO>>(16);
        if (salaryDetailVOList == null) {
            salaryDetailVOList = new ArrayList<SalaryDetailVO>(10);
        }
        map.put("payDetailList", salaryDetailVOList);
        return map;
    }

    private void analyzePayDetailData(List<IssueFlowInfoDTO> issueFlowInfoDTOList) {
        Map<Long, String> beBankMap = this.getBaseDataPropMapById("bd_bebank", NAME, issueFlowInfoDTOList.stream().map(IssueFlowInfoDTO::getBeBankId).collect(Collectors.toSet()));
        Map<Long, String> relationMap = this.getBaseDataPropMapById("hbss_payrollacrelation", NAME, issueFlowInfoDTOList.stream().map(IssueFlowInfoDTO::getPayRollacrelId).collect(Collectors.toSet()));
        Map<Long, String> currencyMap = this.getBaseDataPropMapById("bd_currency", "sign", issueFlowInfoDTOList.stream().map(IssueFlowInfoDTO::getPayCurrencyId).collect(Collectors.toSet()));
        ArrayList<SalaryCardVO> cardVOList = new ArrayList<SalaryCardVO>(10);
        String userName = RequestContext.get().getUserName();
        boolean isBankCardEncrypt = this.isBankCardEncrypt();
        boolean isUserNameEncrypt = this.isUserNameEncrypt();
        boolean isBankNameEncrypt = this.isBankNameEncrypt();
        boolean isAccountRelEncrypt = this.isAccountRelationEncrypt();
        for (int index = 0; index < issueFlowInfoDTOList.size(); ++index) {
            String cardId;
            SalaryCardDTO card;
            IssueFlowInfoDTO issueFlowInfoDTO = issueFlowInfoDTOList.get(index);
            Boolean mustBankCard = issueFlowInfoDTO.getMustBankCard();
            if (mustBankCard.booleanValue()) {
                String bankName = beBankMap.getOrDefault(issueFlowInfoDTO.getBeBankId(), "");
                card = new SalaryCardDTO();
                cardId = UUID.randomUUID().toString();
                card.setId(cardId);
                card.setRelation(relationMap.getOrDefault(issueFlowInfoDTO.getPayRollacrelId(), ""));
                String accountUserName = issueFlowInfoDTO.getReceiverName();
                card.setAccountName(accountUserName);
                String bankCardNum = issueFlowInfoDTO.getBankAccount();
                card.setOpenEye(Boolean.TRUE);
                card.setNumber(bankCardNum);
                card.setName(bankName);
                String logoUrl = COMMON_BANK_LOGO_RELATIVE;
                String imgUrl = BANK_BG_RELATIVE;
                HashMap bankLogoMapOfRelativePathMap = SalarySlipHelper.getBankLogoMapOfRelativePath();
                if (bankLogoMapOfRelativePathMap == null) {
                    bankLogoMapOfRelativePathMap = new HashMap(16);
                }
                for (Map.Entry entry : bankLogoMapOfRelativePathMap.entrySet()) {
                    if (!bankName.contains((CharSequence)entry.getKey())) continue;
                    logoUrl = (String)entry.getValue();
                }
                card.setImg(imgUrl);
                card.setLogo(logoUrl);
                SalaryCardVO salaryCardVO = new SalaryCardVO();
                salaryCardVO.setType(SalaryCardTypeEnum.BANK_TYPE.getType());
                salaryCardVO.setCurrencySign(currencyMap.getOrDefault(issueFlowInfoDTO.getPayCurrencyId(), ""));
                salaryCardVO.setPay(SalarySlipHelper.fmtMicrometer((String)issueFlowInfoDTO.getPayAmount()));
                salaryCardVO.setCard(card);
                if (isBankCardEncrypt || isUserNameEncrypt || isBankNameEncrypt || isAccountRelEncrypt) {
                    salaryCardVO.setShowEye(Boolean.TRUE);
                } else {
                    salaryCardVO.setShowEye(Boolean.FALSE);
                }
                cardVOList.add(salaryCardVO);
                continue;
            }
            String currencySign = currencyMap.getOrDefault(issueFlowInfoDTO.getPayCurrencyId(), "");
            card = new SalaryCardDTO();
            cardId = UUID.randomUUID().toString();
            card.setId(cardId);
            card.setRelation(ResManager.loadKDString((String)"\u672c\u4eba", (String)"MobileSalaryDetailPlugin_7", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            card.setAccountName(userName);
            card.setOpenEye(Boolean.TRUE);
            card.setNumber("");
            card.setName(ResManager.loadKDString((String)"\u73b0\u91d1\u6536\u6b3e", (String)"MobileSalaryDetailPlugin_11", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            card.setLogo(CASH_LOGO_RELATIVE);
            card.setImg(CASH_BG_RELATIVE);
            card.setOpenEye(Boolean.TRUE);
            SalaryCardVO salaryCardVO = new SalaryCardVO();
            salaryCardVO.setType(SalaryCardTypeEnum.CASH_TYPE.getType());
            salaryCardVO.setCurrencySign(currencySign);
            salaryCardVO.setPay(SalarySlipHelper.fmtMicrometer((String)issueFlowInfoDTO.getPayAmount()));
            salaryCardVO.setCard(card);
            if (isUserNameEncrypt || isAccountRelEncrypt) {
                salaryCardVO.setShowEye(Boolean.TRUE);
            } else {
                salaryCardVO.setShowEye(Boolean.FALSE);
            }
            cardVOList.add(salaryCardVO);
        }
        String jsonString = JSON.toJSONString(cardVOList);
        this.getPageCache().put(CUSTOMER_CARD_DATA_MAP, jsonString);
        this.maskingCardData(cardVOList);
        Map<String, Object> customerCardDataMap = this.getCustomerCardDataMap(cardVOList);
        CustomControl ctrl = (CustomControl)this.getView().getControl(CARDLISTAP);
        this.getView().setVisible(Boolean.TRUE, new String[]{CARDLISTAP});
        if (ctrl != null) {
            ctrl.setData(customerCardDataMap);
        }
    }

    public Map<String, Object> maskingCardDataByNeed(List<SalaryCardEyeStatusDTO> eyeStatusList) {
        String cardVOListJson = this.getView().getPageCache().get(CUSTOMER_CARD_DATA_MAP);
        List cardVOList = JSON.parseArray((String)cardVOListJson, SalaryCardVO.class);
        ArrayList<SalaryCardVO> maskingDataList = new ArrayList<SalaryCardVO>(10);
        if (cardVOList == null) {
            return null;
        }
        maskingDataList.addAll(cardVOList);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hrpi_perbankcard");
        IDataEntityProperty bankCardNumProp = mainEntityType.findProperty("bankcardnum");
        IDataEntityProperty userNameProp = mainEntityType.findProperty("username");
        IDataEntityProperty accountRelationProp = mainEntityType.findProperty("accountrelation");
        IDataEntityProperty bankDeposItProp = mainEntityType.findProperty("bankdeposit");
        DynamicObject bankObj = BusinessDataServiceHelper.newDynamicObject((String)"hrpi_perbankcard");
        boolean isBankCardEncrypt = this.isBankCardEncrypt();
        boolean isUserNameEncrypt = this.isUserNameEncrypt();
        boolean isBankNameEncrypt = this.isBankNameEncrypt();
        boolean isAccountRelEncrypt = this.isAccountRelationEncrypt();
        for (SalaryCardVO salaryCardVO : maskingDataList) {
            if (salaryCardVO == null || salaryCardVO.getCard() == null || eyeStatusList == null) continue;
            for (SalaryCardEyeStatusDTO statusDTO : eyeStatusList) {
                if (statusDTO == null || statusDTO.getId() == null || statusDTO.getOpenEye() == null) continue;
                String cardId = statusDTO.getId();
                Boolean openEye = statusDTO.getOpenEye();
                SalaryCardDTO cardDTO = salaryCardVO.getCard();
                String id = cardDTO.getId();
                if (!cardId.equals(id)) continue;
                if (!openEye.booleanValue()) {
                    Object valObj;
                    Object valObj2;
                    if (SalaryCardTypeEnum.BANK_TYPE.getType().equals(salaryCardVO.getType())) {
                        String bankCardNum = cardDTO.getNumber();
                        if (isBankCardEncrypt && (valObj2 = PrivacyCenterServiceHelper.getDesensitizeValueWithoutPerm((IDataEntityProperty)bankCardNumProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankObj, (Object)bankCardNum)) != null) {
                            bankCardNum = valObj2.toString();
                        }
                        cardDTO.setNumber(bankCardNum);
                        String bankName = cardDTO.getName();
                        if (isBankNameEncrypt && (valObj = PrivacyCenterServiceHelper.getDesensitizeValueWithoutPerm((IDataEntityProperty)bankDeposItProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankObj, (Object)bankName)) != null) {
                            bankName = valObj.toString();
                        }
                        cardDTO.setName(bankName);
                    }
                    String accountName = cardDTO.getAccountName();
                    if (isUserNameEncrypt && (valObj2 = PrivacyCenterServiceHelper.getDesensitizeValueWithoutPerm((IDataEntityProperty)userNameProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankObj, (Object)accountName)) != null) {
                        accountName = valObj2.toString();
                    }
                    String relation = cardDTO.getRelation();
                    if (isAccountRelEncrypt && (valObj = PrivacyCenterServiceHelper.getDesensitizeValueWithoutPerm((IDataEntityProperty)accountRelationProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankObj, (Object)relation)) != null) {
                        relation = valObj.toString();
                    }
                    cardDTO.setRelation(relation);
                    cardDTO.setAccountName(accountName);
                    cardDTO.setOpenEye(Boolean.FALSE);
                    continue;
                }
                cardDTO.setOpenEye(Boolean.TRUE);
            }
        }
        return this.getCustomerCardDataMap(maskingDataList);
    }

    public void maskingCardData(List<SalaryCardVO> cardVOList) {
        if (cardVOList == null) {
            return;
        }
        boolean isBankCardEncrypt = this.isBankCardEncrypt();
        boolean isUserNameEncrypt = this.isUserNameEncrypt();
        boolean isBankNameEncrypt = this.isBankNameEncrypt();
        boolean isAccountRelEncrypt = this.isAccountRelationEncrypt();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hrpi_perbankcard");
        IDataEntityProperty bankCardNumProp = mainEntityType.findProperty("bankcardnum");
        IDataEntityProperty userNameProp = mainEntityType.findProperty("username");
        IDataEntityProperty accountRelationProp = mainEntityType.findProperty("accountrelation");
        IDataEntityProperty bankDeposItProp = mainEntityType.findProperty("bankdeposit");
        DynamicObject bankCardObj = BusinessDataServiceHelper.newDynamicObject((String)"hrpi_perbankcard");
        for (SalaryCardVO salaryCardVO : cardVOList) {
            Object valObj;
            Object valObj2;
            SalaryCardDTO card;
            if (salaryCardVO == null || (card = salaryCardVO.getCard()) == null) continue;
            String type = salaryCardVO.getType();
            boolean openEye = true;
            if (SalaryCardTypeEnum.BANK_TYPE.getType().equals(type)) {
                String bankCardNum = card.getNumber();
                if (isBankCardEncrypt && (valObj2 = PrivacyCenterServiceHelper.getDesensitizeValueWithoutPerm((IDataEntityProperty)bankCardNumProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankCardObj, (Object)bankCardNum)) != null) {
                    bankCardNum = valObj2.toString();
                    openEye = false;
                }
                card.setNumber(bankCardNum);
                String bankName = card.getName();
                if (isBankNameEncrypt && (valObj = PrivacyCenterServiceHelper.getDesensitizeValueWithoutPerm((IDataEntityProperty)bankDeposItProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankCardObj, (Object)bankName)) != null) {
                    bankName = valObj.toString();
                    openEye = false;
                }
                card.setName(bankName);
            }
            String accountName = card.getAccountName();
            if (isUserNameEncrypt && (valObj2 = PrivacyCenterServiceHelper.getDesensitizeValueWithoutPerm((IDataEntityProperty)userNameProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankCardObj, (Object)accountName)) != null) {
                accountName = valObj2.toString();
                openEye = false;
            }
            card.setAccountName(accountName);
            String relation = card.getRelation();
            if (isAccountRelEncrypt && (valObj = PrivacyCenterServiceHelper.getDesensitizeValueWithoutPerm((IDataEntityProperty)accountRelationProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankCardObj, (Object)relation)) != null) {
                relation = valObj.toString();
                openEye = false;
            }
            card.setRelation(relation);
            if (SalaryCardTypeEnum.BANK_TYPE.getType().equals(type)) {
                salaryCardVO.setShowEye(Boolean.valueOf(isUserNameEncrypt || isBankCardEncrypt || isBankNameEncrypt || isAccountRelEncrypt));
            } else if (SalaryCardTypeEnum.CASH_TYPE.getType().equals(type)) {
                salaryCardVO.setShowEye(Boolean.valueOf(isUserNameEncrypt || isAccountRelEncrypt));
            }
            card.setOpenEye(Boolean.valueOf(openEye));
        }
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        String eventArgs;
        super.customEvent(customEventArgs);
        String eventName = customEventArgs.getEventName();
        if ("openEye".equals(eventName) && !SWCStringUtils.isEmpty((String)(eventArgs = customEventArgs.getEventArgs()))) {
            List eyeStatusDTOS = JSON.parseArray((String)eventArgs, SalaryCardEyeStatusDTO.class);
            Map<String, Object> customerCardDataMap = this.maskingCardDataByNeed(eyeStatusDTOS);
            CustomControl ctrl = (CustomControl)this.getView().getControl(CARDLISTAP);
            if (ctrl != null) {
                ctrl.setData(customerCardDataMap);
            }
        }
    }

    private Map<String, Object> getCustomerCardDataMap(List<SalaryCardVO> cardVOList) {
        HashMap<String, Object> cardMap = new HashMap<String, Object>(16);
        if (cardVOList == null) {
            cardVOList = new ArrayList<SalaryCardVO>(10);
        }
        cardMap.put("bankCardList", cardVOList);
        cardMap.put("title", ResManager.loadKDString((String)"\u53d1\u653e\u660e\u7ec6", (String)"MobileSalaryDetailPlugin_13", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
        return cardMap;
    }

    public boolean isBankCardEncrypt() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hrpi_perbankcard");
        IDataEntityProperty bankCardNumProp = mainEntityType.findProperty("bankcardnum");
        DynamicObject bankObj = BusinessDataServiceHelper.newDynamicObject((String)"hrpi_perbankcard");
        return PrivacyCenterServiceHelper.isDesensitizeFieldWithoutPerm((IDataEntityProperty)bankCardNumProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankObj);
    }

    public boolean isUserNameEncrypt() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hrpi_perbankcard");
        IDataEntityProperty userNameProp = mainEntityType.findProperty("username");
        DynamicObject bankObj = BusinessDataServiceHelper.newDynamicObject((String)"hrpi_perbankcard");
        return PrivacyCenterServiceHelper.isDesensitizeFieldWithoutPerm((IDataEntityProperty)userNameProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankObj);
    }

    public boolean isAccountRelationEncrypt() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hrpi_perbankcard");
        IDataEntityProperty accountRelationProp = mainEntityType.findProperty("accountrelation");
        DynamicObject bankObj = BusinessDataServiceHelper.newDynamicObject((String)"hrpi_perbankcard");
        return PrivacyCenterServiceHelper.isDesensitizeFieldWithoutPerm((IDataEntityProperty)accountRelationProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankObj);
    }

    public boolean isBankNameEncrypt() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hrpi_perbankcard");
        IDataEntityProperty nameProp = mainEntityType.findProperty("bankdeposit");
        DynamicObject bankObj = BusinessDataServiceHelper.newDynamicObject((String)"hrpi_perbankcard");
        return PrivacyCenterServiceHelper.isDesensitizeFieldWithoutPerm((IDataEntityProperty)nameProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankObj);
    }

    private Map<Long, String> getBaseDataPropMapById(String baseDataName, String selectField, Set<Long> idSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(baseDataName);
        QFilter filter = new QFilter("id", "in", idSet);
        DynamicObjectCollection collection = helper.queryOriginalCollection("id," + selectField, new QFilter[]{filter});
        return collection.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString(selectField)));
    }

    private void updateConfirmStatus(Long id) {
        SWCDataServiceHelper salaryCalendarHelper;
        DynamicObject salaryCalendar;
        if (id != null && (salaryCalendar = (salaryCalendarHelper = new SWCDataServiceHelper("hspp_salarycalendar")).queryOne((Object)id)) == null) {
            HashMap<String, Constable> returnDataMap = new HashMap<String, Constable>(16);
            returnDataMap.put("salaryCalendarId", id);
            returnDataMap.put("isRecycle", Boolean.valueOf(true));
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u8d44\u6761\u5df2\u56de\u6536\uff0c\u65e0\u9700\u786e\u8ba4\u3002", (String)"MobileSalaryDetailPlugin_12", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            this.getView().returnDataToParent(returnDataMap);
            this.getView().close();
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_salaryslipstatus");
        QFilter filter = new QFilter("salarycalendar.id", "=", (Object)id);
        DynamicObject dobj = helper.queryOne(ISCONFIRM, new QFilter[]{filter});
        if (dobj != null) {
            if (!dobj.getBoolean(ISCONFIRM)) {
                dobj.set(ISCONFIRM, (Object)"1");
                helper.saveOne(dobj);
            }
            this.setConfirmedLab(Boolean.TRUE);
            IFormView monthView = this.getView().getParentView();
            SalarySlipHelper.updateView((IFormView)this.getView(), (IFormView)monthView, null, (Boolean)Boolean.TRUE);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u5df2\u786e\u8ba4", (String)"MobileSalaryDetailPlugin_14", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            this.updateParentListConfirmStatus(id, monthView);
        }
    }

    private void updateParentListConfirmStatus(Long id, IFormView monthView) {
        OperateOption operation = OperateOption.create();
        if (id == null) {
            operation.setVariableValue("salaryCalendarId", "");
        } else {
            operation.setVariableValue("salaryCalendarId", id.toString());
        }
        monthView.invokeOperation("updateconfirmdata", operation);
        this.getView().sendFormAction(monthView);
    }
}

