/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.mobile.pc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.permissions.PermissionHelper;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.business.salaryslip.context.ContextHolder;
import kd.swc.hspp.business.salaryslip.pojo.dto.SalaryCalendarDTO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalaryCalendarVO;
import kd.swc.hspp.common.constants.MonthEnum;
import kd.swc.hspp.common.constants.SalarySlipPcConstants;
import kd.swc.hspp.common.model.SalaryCalendarModel;
import kd.swc.hspp.common.utils.ShowPageUtils;
import kd.swc.hspp.formplugin.web.login.pc.AbstractSalarySlipPlugin;

public class SalarySlipCalendarPlugin
extends AbstractSalarySlipPlugin
implements SalarySlipPcConstants {
    public final Log logger = LogFactory.getLog(SalarySlipCalendarPlugin.class);
    private static final String QUERYDATE = "querydate";
    private static final String QUERYDATA = "querydata";
    private static final String PERCHFLEX = "perchflex";
    private static final String CALFLEX = "calflex";
    private static final String CLOSE = "close";
    private static final String OPEN = "open";
    private static final String UPDATE_ALL = "all";
    private static final String UPDATE_ENCRYPT = "encrypt";
    private static final String UPDATE_PART = "part";
    private static final String CACHE_KEY_CAR_MAP = "cache_key_car_map";
    private static final String KNOW = "know";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.setCalendarFlexVisible(Boolean.TRUE);
        this.initContextHolder();
        if (this.afterCreateNewData()) {
            this.initData();
        }
        ContextHolder.destory();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String formOp = source.getOperateKey();
        if (CLOSE.equals(formOp)) {
            this.setCalendarFlexVisible(Boolean.FALSE);
        }
        if (OPEN.equals(formOp)) {
            this.setCalendarFlexVisible(Boolean.TRUE);
        }
        if ("closeeye".equals(formOp)) {
            this.setEncryptLab(Boolean.TRUE);
            this.setEncryptData(Boolean.TRUE);
        }
        if ("openeye".equals(formOp)) {
            this.setEncryptLab(Boolean.FALSE);
            this.setEncryptData(Boolean.FALSE);
        }
        if ("updatecar".equals(formOp)) {
            String calendarModelId = source.getOption().getVariableValue("calendarModelId");
            this.updateCarDataByCarId(calendarModelId, "updatecar");
        }
        if (QUERYDATA.equals(formOp)) {
            this.initContextHolder();
            this.initData();
            ContextHolder.destory();
        }
        if (KNOW.equals(formOp)) {
            int hidenTips = 0;
            ContextHolder.updateSaveShowTips((int)hidenTips);
            this.getView().getPageCache().put("cache_tips", String.valueOf(hidenTips));
            this.hiddenTips(hidenTips);
        }
    }

    public void customEvent(CustomEventArgs args) {
        String eventArgs;
        super.customEvent(args);
        String eventName = args.getEventName();
        if ("showForm".equals(eventName) && !SWCStringUtils.isEmpty((String)(eventArgs = args.getEventArgs()))) {
            JSONObject jsonObject = (JSONObject)JSON.parse((String)eventArgs);
            Integer month = jsonObject.getInteger("month");
            String id = jsonObject.getString("id");
            Map<Long, SalaryCalendarModel> calendarModelMap = this.getCacheSalaryCalendarModelMap();
            SalaryCalendarModel salaryCalendarModel = calendarModelMap.get(Long.parseLong(id));
            if (salaryCalendarModel != null) {
                if (!salaryCalendarModel.isView()) {
                    this.updateCarDataByCarId(id, "showdetail");
                    this.updateViewStatus(Long.parseLong(id));
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("calendarModel", JSON.toJSONString((Object)salaryCalendarModel));
                this.getView().invokeOperation("showdetail", option);
                return;
            }
            this.getView().updateView();
        }
    }

    private void initContextHolder() {
        ContextHolder.init();
        ContextHolder.setPersonId((Long)this.getPersonId());
        ContextHolder.setQueryDate((String)ContextHolder.getSalarySlipQueryParam());
    }

    private boolean afterCreateNewData() {
        Tuple tuple = ContextHolder.getPersonTuple();
        if (!((Boolean)tuple.item1).booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"MobileSalaryCalendarPlugIn_14", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            this.getView().setVisible(Boolean.FALSE, new String[]{CALFLEX});
            this.showPerchFlex(msg);
            return false;
        }
        if (!ContextHolder.salarySlipExist().booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u67e5\u8be2\u5de5\u8d44\u6761\u3002", (String)"MobileSalaryCalendarPlugIn_16", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            this.setCustomCtrlData(Collections.EMPTY_LIST, UPDATE_ALL);
            this.getView().setVisible(Boolean.FALSE, new String[]{CALFLEX});
            this.showPerchFlex(msg);
            return false;
        }
        Date slipEndDate = ContextHolder.getSalarySlipEndDate();
        this.getView().getPageCache().put("cache_date", SWCDateTimeUtils.format((Date)slipEndDate, (String)"yyyy-MM"));
        Tuple dateTuple = ContextHolder.getSalarySlipQueryDateParam();
        if (dateTuple.item1 != null && slipEndDate.before((Date)dateTuple.item1)) {
            slipEndDate = dateTuple.item2 != null ? (Date)dateTuple.item2 : new Date();
        }
        this.getModel().setValue(QUERYDATE, (Object)slipEndDate);
        this.getView().updateView(QUERYDATE);
        return true;
    }

    private void initData() {
        boolean isHaveData;
        boolean isContain;
        this.getView().getPageCache().remove(CACHE_KEY_CAR_MAP);
        Date slipEndDate = null;
        String slipEndDateString = this.getView().getPageCache().get("cache_date");
        if (SWCStringUtils.isNotEmpty((String)slipEndDateString)) {
            try {
                slipEndDate = SWCDateTimeUtils.parseDate((String)slipEndDateString, (String)"yyyy-MM");
            }
            catch (ParseException ex) {
                this.logger.info("slipEndDate parseDate error : {}", (Object)ex.getMessage());
            }
        } else {
            slipEndDate = ContextHolder.getSalarySlipEndDate();
        }
        Tuple personQueryDate = ContextHolder.getSalarySlipQueryDateParam();
        Date minDate = (Date)personQueryDate.item1;
        Date maxDate = (Date)personQueryDate.item2;
        if (maxDate != null && slipEndDate != null) {
            Date dateLast = SalarySlipHelper.getDateLast((Date)slipEndDate);
            maxDate = dateLast.after(maxDate) ? dateLast : maxDate;
        }
        DateEdit dateEdit = (DateEdit)this.getView().getControl(QUERYDATE);
        Date yearFirst = SalarySlipHelper.getYearFirst((Date)minDate);
        Date yearLast = SalarySlipHelper.getYearLast((Date)maxDate);
        if (yearFirst != null && yearLast != null) {
            dateEdit.setMinDate(yearFirst);
            dateEdit.setMaxDate(yearLast);
        } else {
            this.updateControlMetadata("min");
            this.updateControlMetadata("max");
        }
        this.getView().updateView(QUERYDATE);
        Tuple<Date, Date> queryDate = this.getQueryDate();
        if (queryDate == null) {
            this.logger.info("queryDate is null");
            return;
        }
        Tuple dateInterval = SalarySlipHelper.getDateInterval((Date)minDate, (Date)maxDate, (Date)((Date)queryDate.item1), (Date)((Date)queryDate.item2));
        if (dateInterval == null) {
            String msg = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u65e5\u671f\u4e0d\u5728\u53ef\u67e5\u8be2\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalarySlipCalendarPlugin_3", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            this.setCustomCtrlData(Collections.EMPTY_LIST, UPDATE_ALL);
            this.showPerchFlex(msg);
            return;
        }
        boolean bl = isContain = !((Date)queryDate.item1).equals(dateInterval.item1) || !((Date)queryDate.item2).equals(dateInterval.item2);
        if (isContain) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u67e5\u8be2{0}\uff5e{1}\u7684\u5de5\u8d44\u6761\u3002", (String)"SalarySlipCalendarPlugin_2", (String)"swc-hspp-formplugin", (Object[])new Object[0]), SWCDateTimeUtils.format((Date)((Date)dateInterval.item1), (String)"yyyy-MM"), SWCDateTimeUtils.format((Date)((Date)dateInterval.item2), (String)"yyyy-MM")));
        }
        ContextHolder.setStartEndDate((Date)((Date)dateInterval.item1), (Date)((Date)dateInterval.item2));
        DynamicObject[] dynamicObjects = ContextHolder.getSalarySlipStatus();
        boolean bl2 = isHaveData = dynamicObjects.length != 0;
        if (!isHaveData) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5e74\u4efd\u6682\u65e0\u5de5\u8d44\u6761\u8bb0\u5f55\u3002", (String)"SalarySlipCalendarPlugin_0", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            this.setCustomCtrlData(Collections.EMPTY_LIST, UPDATE_ALL);
            this.showPerchFlex(msg);
            return;
        }
        boolean isEncrypt = ContextHolder.getEncryptType();
        this.setEncryptLab(isEncrypt);
        PermissionHelper.setPageVisible((IFormView)this.getView(), (Boolean)Boolean.TRUE);
        Map<Long, SalaryCalendarModel> salaryCalendarModelMap = this.getSalaryCalendarModelMap();
        this.setSalaryCalendarData(salaryCalendarModelMap);
        String hidenTips = this.getView().getPageCache().get("cache_tips");
        int showtips = null == hidenTips ? ContextHolder.getShowTips() : Integer.parseInt(hidenTips);
        this.hiddenTips(showtips);
    }

    private Tuple<Date, Date> getQueryDate() {
        Date date = this.getModel().getDataEntity().getDate(QUERYDATE);
        if (date != null) {
            int year = SWCDateTimeUtils.getYear((Date)date);
            return new Tuple((Object)SalarySlipHelper.getYearFirst((int)year), (Object)SalarySlipHelper.getYearLast((int)year));
        }
        return null;
    }

    private void showPerchFlex(String msg) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        map.put("vi", Boolean.TRUE);
        this.getView().updateControlMetadata(PERCHFLEX, map);
        this.getView().setVisible(Boolean.TRUE, new String[]{PERCHFLEX});
        this.getView().setVisible(Boolean.FALSE, new String[]{"contentflex"});
        ShowPageUtils.setLabelValue((IFormView)this.getView(), (String)"laberror", (String)msg);
    }

    private void setCustomCtrlData(List<SalaryCalendarVO> dataList, String updateType) {
        HashMap<String, Object> customDataMap = new HashMap<String, Object>(16);
        if (dataList.isEmpty()) {
            customDataMap.put("msg", ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u53ef\u5c1d\u8bd5\u4fee\u6539\u7b5b\u9009\u6761\u4ef6\u3002", (String)"SalarySlipCalendarPlugin_1", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            this.setCustomData("detaillistap", "payDetailList", new ArrayList(10));
            this.setCustomData("cardlistap", "bankCardList", new ArrayList(10));
        }
        customDataMap.put("payrollList", dataList);
        customDataMap.put("updateType", updateType);
        CustomControl ctrl = (CustomControl)this.getView().getControl("customcontrolap");
        if (ctrl != null) {
            ctrl.setData(customDataMap);
        }
    }

    private void setCustomData(String key, String jsonKey, Object data) {
        CustomControl ctrl = (CustomControl)this.getView().getControl(key);
        if (ctrl != null) {
            JSONObject json = new JSONObject();
            json.put(jsonKey, data);
            json.put("times", (Object)System.currentTimeMillis());
            ctrl.setData((Object)json);
        }
    }

    private void setCalendarFlexVisible(Boolean isVisible) {
        this.getView().setVisible(Boolean.valueOf(isVisible == false), new String[]{OPEN});
        this.getView().setVisible(isVisible, new String[]{CALFLEX, CLOSE});
    }

    private void setEncryptLab(Boolean isEncrypt) {
        this.getView().getPageCache().put("customer_encrypt", String.valueOf(isEncrypt));
        this.getView().setVisible(isEncrypt, new String[]{"closeeye"});
        this.getView().setVisible(Boolean.valueOf(isEncrypt == false), new String[]{"openeye"});
        ContextHolder.updateSaveEncryptType((int)(isEncrypt != false ? 1 : 0));
    }

    private void setEncryptData(Boolean isEncrypt) {
        Map<Long, SalaryCalendarModel> salaryCalendarModelMap = this.getCacheSalaryCalendarModelMap();
        List<SalaryCalendarVO> salaryCalendarList = this.getSalaryCalendarData(salaryCalendarModelMap);
        if (salaryCalendarList.isEmpty()) {
            this.getView().updateView();
            return;
        }
        if (isEncrypt.booleanValue()) {
            this.encryptedData(salaryCalendarList);
        }
        this.setCustomCtrlData(salaryCalendarList, UPDATE_ENCRYPT);
        this.getView().setVisible(isEncrypt, new String[]{"closeeye"});
        this.getView().setVisible(Boolean.valueOf(isEncrypt == false), new String[]{"openeye"});
    }

    private List<SalaryCalendarVO> getSalaryCalendarData(Map<Long, SalaryCalendarModel> salaryCalendarModelMap) {
        LinkedHashMap monthMap = new LinkedHashMap(salaryCalendarModelMap.size());
        salaryCalendarModelMap.forEach((id, calendarModel) -> {
            String month = calendarModel.getMonth();
            Integer monthInt = Integer.parseInt(month);
            SalaryCalendarVO salaryCalendarVO = monthMap.getOrDefault(month, new SalaryCalendarVO(monthInt, MonthEnum.getShowByMonth((Integer)monthInt), new ArrayList(10)));
            salaryCalendarVO.getData().add(this.createSalaryCalendar((SalaryCalendarModel)calendarModel));
            monthMap.put(month, salaryCalendarVO);
        });
        ArrayList<SalaryCalendarVO> salaryCalendarList = new ArrayList<SalaryCalendarVO>(monthMap.values());
        return salaryCalendarList;
    }

    private void encryptedData(List<SalaryCalendarVO> salaryCalendarList) {
        String showAmountType = ContextHolder.getShowAmountType();
        salaryCalendarList.forEach(data -> {
            List calendarDTOList = data.getData();
            if (calendarDTOList != null) {
                for (SalaryCalendarDTO calendarDTO : calendarDTOList) {
                    calendarDTO.setPay(SWCStringUtils.equals((String)"2", (String)showAmountType) ? "" : "******");
                    calendarDTO.setCurrencySign("");
                }
            }
        });
    }

    private Map<Long, SalaryCalendarModel> getCacheSalaryCalendarModelMap() {
        String dataString = this.getView().getPageCache().get(CACHE_KEY_CAR_MAP);
        if (SWCStringUtils.isNotEmpty((String)dataString)) {
            return (Map)JSON.parseObject((String)dataString, (TypeReference)new TypeReference<LinkedHashMap<Long, SalaryCalendarModel>>(){}, (Feature[])new Feature[0]);
        }
        return Collections.EMPTY_MAP;
    }

    private Map<Long, SalaryCalendarModel> getSalaryCalendarModelMap() {
        DynamicObject[] dynamicObjects = ContextHolder.getSalarySlipStatus();
        Map currencyMap = ContextHolder.getCurrencyMap();
        Map salarySlipViewMap = ContextHolder.getSalarySlipViewMap();
        Map salaryCalendarModelMap = ContextHolder.getSalaryCalendarModelMap();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject currency;
            SalaryCalendarModel salaryCalendarModel = (SalaryCalendarModel)salaryCalendarModelMap.get(dynamicObject.getLong("salarycalendar.id"));
            DynamicObject salaryViewV = (DynamicObject)salarySlipViewMap.get(dynamicObject.getLong("salarycalendar.salaryviewv.id"));
            if (salaryViewV != null) {
                boolean isNeedConfirm = salaryViewV.getBoolean("isneedconfirm");
                salaryCalendarModel.setNeedConfirm(isNeedConfirm);
                salaryCalendarModel.setSalarySlipViewVersionId(Long.valueOf(salaryViewV.getLong("id")));
                salaryCalendarModel.setShowPayFlow(Boolean.valueOf(salaryViewV.getBoolean("isshowpayflow")));
            }
            if ((currency = (DynamicObject)currencyMap.get(salaryCalendarModel.getCalCurrencyId())) == null) continue;
            salaryCalendarModel.setCalSign(currency.getString("sign"));
            salaryCalendarModel.setScale(currency.getInt("amtprecision"));
        }
        this.getView().getPageCache().put(CACHE_KEY_CAR_MAP, JSON.toJSONString((Object)salaryCalendarModelMap));
        return salaryCalendarModelMap;
    }

    private void setSalaryCalendarData(Map<Long, SalaryCalendarModel> salaryCalendarModelMap) {
        List<SalaryCalendarVO> salaryCalendarList = this.getSalaryCalendarData(salaryCalendarModelMap);
        boolean isEncrypt = ContextHolder.getEncryptType();
        if (isEncrypt) {
            this.encryptedData(salaryCalendarList);
        }
        this.setCustomCtrlData(salaryCalendarList, UPDATE_ALL);
    }

    private SalaryCalendarDTO createSalaryCalendar(SalaryCalendarModel salaryCalendarModel) {
        String amount;
        SalaryCalendarDTO salaryCalendarDTO = new SalaryCalendarDTO();
        salaryCalendarDTO.setCaption(salaryCalendarModel.getCaption());
        Long calendarModelId = salaryCalendarModel.getId();
        if (calendarModelId != null) {
            salaryCalendarDTO.setId(calendarModelId.toString());
        }
        String dateRange = salaryCalendarModel.getDateRange();
        dateRange = dateRange.replace("~", " ~ ");
        salaryCalendarDTO.setDateRange(dateRange);
        boolean needConfirm = salaryCalendarModel.isNeedConfirm();
        salaryCalendarDTO.setNeedConfirm(needConfirm);
        boolean confirm = salaryCalendarModel.isConfirm();
        salaryCalendarDTO.setConfirm(confirm);
        String showConfirm = "";
        if (needConfirm) {
            showConfirm = confirm ? ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"MobileSalaryCalendarDetailPlugin_2", (String)"swc-hspp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f85\u786e\u8ba4", (String)"MobileSalaryCalendarDetailPlugin_1", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
        }
        salaryCalendarDTO.setShowConfirm(showConfirm);
        salaryCalendarDTO.setView(salaryCalendarModel.isView());
        salaryCalendarDTO.setCurrencySign(salaryCalendarModel.getCalSign());
        String showAmountType = ContextHolder.getShowAmountType();
        BigDecimal paySalary = null;
        switch (showAmountType) {
            case "0": {
                paySalary = salaryCalendarModel.getNetSalary();
                break;
            }
            case "1": {
                paySalary = salaryCalendarModel.getTotalSalary();
                break;
            }
        }
        if (paySalary == null) {
            amount = "-";
            salaryCalendarDTO.setCurrencySign("");
        } else {
            BigDecimal decimal = paySalary.setScale(salaryCalendarModel.getScale(), RoundingMode.HALF_UP);
            amount = SalarySlipHelper.fmtMicrometer((String)decimal.toPlainString());
        }
        salaryCalendarDTO.setPay(SWCStringUtils.equals((String)"2", (String)showAmountType) ? "" : amount);
        return salaryCalendarDTO;
    }

    private void updateCarDataByCarId(String calendarModelId, String opName) {
        Long calendarId;
        Map<Long, SalaryCalendarModel> salaryCalendarModelMap = this.getCacheSalaryCalendarModelMap();
        SalaryCalendarModel salaryCalendarModel = salaryCalendarModelMap.get(calendarId = Long.valueOf(Long.parseLong(calendarModelId)));
        if (salaryCalendarModel == null) {
            this.getView().updateView();
            return;
        }
        if ("updatecar".equals(opName)) {
            salaryCalendarModel.setConfirm(true);
        } else if ("showdetail".equals(opName)) {
            salaryCalendarModel.setView(true);
        }
        this.getView().getPageCache().put(CACHE_KEY_CAR_MAP, JSON.toJSONString(salaryCalendarModelMap));
        HashMap<Long, SalaryCalendarModel> salaryCalendarPartModelMap = new HashMap<Long, SalaryCalendarModel>(16);
        salaryCalendarPartModelMap.put(calendarId, salaryCalendarModel);
        List<SalaryCalendarVO> salaryCalendarList = this.getSalaryCalendarData(salaryCalendarPartModelMap);
        if (salaryCalendarList.isEmpty()) {
            this.getView().updateView();
            return;
        }
        boolean encryptType = ContextHolder.getEncryptType();
        if (encryptType) {
            this.encryptedData(salaryCalendarList);
        }
        this.setCustomCtrlData(salaryCalendarList, UPDATE_PART);
    }

    private void updateViewStatus(Long id) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_salaryslipstatus");
        QFilter filter = new QFilter("salarycalendar.id", "=", (Object)id);
        DynamicObject dobj = helper.queryOne("isview", new QFilter[]{filter});
        if (dobj != null && !dobj.getBoolean("isview")) {
            dobj.set("isview", (Object)"1");
            helper.saveOne(dobj);
        }
    }

    private void hiddenTips(int showtips) {
        if (showtips == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tips"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tips"});
        }
    }

    private void updateControlMetadata(String dateKey) {
        HashMap<String, String> editor = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> item = new HashMap<String, HashMap<String, String>>(16);
        editor.put(dateKey, "");
        item.put("item", editor);
        this.getView().updateControlMetadata(QUERYDATE, item);
    }
}

