/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.mobile.pc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.dto.salary.StructureSalaryDTO;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.business.salaryslip.detaildata.BaseEncryptDataDecorator;
import kd.swc.hspp.business.salaryslip.detaildata.BaseSalarySlipDataService;
import kd.swc.hspp.business.salaryslip.detaildata.PcSalaryDataService;
import kd.swc.hspp.business.salaryslip.detaildata.SalarySlipDataService;
import kd.swc.hspp.common.constants.SalarySlipPcConstants;
import kd.swc.hspp.common.model.SalaryCalendarModel;
import kd.swc.hspp.common.utils.ShowPageUtils;

public class SalarySlipDetailPlugin
extends AbstractFormPlugin
implements SalarySlipPcConstants {
    private static final String UNCONFIRMED = "unconfirmed";
    private static final String CONFIRMED = "confirmed";
    private static final String SALARYCOMFIRM = "salarycomfirm";
    private static final String FLEXPANELAP_CONFIRM = "flexpanelap_confirm";
    private static final String PANEL_NOTICE = "panel_notice";
    private static final String LABELAP_DESCRIPTION = "label_description";
    private static final String ISCONFIRM = "isconfirm";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        PcSalaryDataService encryptData;
        String calendarModelString;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String formOp = source.getOperateKey();
        if ("showdetail".equals(formOp) && SWCStringUtils.isNotEmpty((String)(calendarModelString = source.getOption().getVariableValue("calendarModel")))) {
            SalaryCalendarModel salaryCalendarModel = (SalaryCalendarModel)JSON.parseObject((String)calendarModelString, SalaryCalendarModel.class);
            this.setHeadData(salaryCalendarModel);
            Tuple slipData = SalarySlipHelper.getSalarySlipData((SalaryCalendarModel)salaryCalendarModel);
            StructureSalaryDTO salarySlipData = (StructureSalaryDTO)slipData.item2;
            if (salarySlipData == null) {
                if (((Boolean)slipData.item1).booleanValue()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u5df2\u56de\u6536\uff0c\u65e0\u6cd5\u67e5\u770b\u660e\u7ec6\u3002", (String)"MobileSalaryCalendarPlugIn_15", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
                    this.getView().updateView();
                } else {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u6570\u636e\u89e3\u5bc6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MobileSalaryDetailPlugin_15", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexsumall", "flexdetail", "flexcard"});
                }
                return;
            }
            SalarySlipDataService salaryDataService = new SalarySlipDataService();
            salaryDataService.setStructureSalaryDTO(salarySlipData);
            salaryDataService.setSalaryCalendarModel(salaryCalendarModel);
            PcSalaryDataService encryptData2 = new PcSalaryDataService(this.getView(), (BaseSalarySlipDataService)salaryDataService);
            encryptData2.removeDataCache();
            String isEncrypt = this.getView().getPageCache().get("customer_encrypt");
            this.setEncryptData(Boolean.parseBoolean(isEncrypt), (BaseEncryptDataDecorator)encryptData2);
            this.showContentFlex();
        }
        if ("closeeye".equals(formOp)) {
            encryptData = new PcSalaryDataService(this.getView(), null);
            this.setEncryptData(Boolean.TRUE, (BaseEncryptDataDecorator)encryptData);
        }
        if ("openeye".equals(formOp)) {
            encryptData = new PcSalaryDataService(this.getView(), null);
            this.setEncryptData(Boolean.FALSE, (BaseEncryptDataDecorator)encryptData);
        }
        if (SALARYCOMFIRM.equals(formOp)) {
            String id = this.getView().getPageCache().get("calendarModelId");
            this.updateConfirmStatus(id);
        }
    }

    private void setHeadData(SalaryCalendarModel salaryCalendarModel) {
        IFormView view = this.getView();
        ShowPageUtils.setLabelValue((IFormView)view, (String)"labelap_caption", (String)salaryCalendarModel.getCaption());
        String dateRange = salaryCalendarModel.getDateRange();
        dateRange = dateRange.replace("~", " ~ ");
        ShowPageUtils.setLabelValue((IFormView)view, (String)"labelap_daterange", (String)dateRange);
        view.getPageCache().put("calendarModelId", String.valueOf(salaryCalendarModel.getId()));
        if (salaryCalendarModel.isNeedConfirm()) {
            this.setConfirmedLab(salaryCalendarModel.isConfirm());
        } else {
            view.setVisible(Boolean.FALSE, new String[]{CONFIRMED, UNCONFIRMED, FLEXPANELAP_CONFIRM});
        }
        String remark = salaryCalendarModel.getRemark();
        if (SWCStringUtils.isNotEmpty((String)remark)) {
            view.setVisible(Boolean.TRUE, new String[]{PANEL_NOTICE});
            ShowPageUtils.setLabelValue((IFormView)view, (String)LABELAP_DESCRIPTION, (String)remark);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{PANEL_NOTICE});
        }
    }

    private void setConfirmedLab(Boolean isConfirm) {
        this.getView().setVisible(isConfirm, new String[]{CONFIRMED});
        this.getView().setVisible(Boolean.valueOf(isConfirm == false), new String[]{UNCONFIRMED});
        this.getView().setVisible(Boolean.valueOf(isConfirm == false), new String[]{FLEXPANELAP_CONFIRM});
    }

    private void setCustomData(String key, String jsonKey, Object data) {
        CustomControl ctrl = (CustomControl)this.getView().getControl(key);
        if (ctrl != null) {
            if (SWCStringUtils.isNotEmpty((String)jsonKey)) {
                JSONObject json = new JSONObject();
                json.put(jsonKey, data);
                ctrl.setData((Object)this.getCustomData(jsonKey, data));
            } else {
                ctrl.setData(data);
            }
        }
    }

    private JSONObject getCustomData(String jsonKey, Object data) {
        JSONObject json = new JSONObject();
        if ("bankCardList".equals(jsonKey)) {
            json.put("title", (Object)ResManager.loadKDString((String)"\u53d1\u653e\u660e\u7ec6", (String)"MobileSalaryDetailPlugin_13", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
        }
        json.put(jsonKey, data);
        json.put("times", (Object)System.currentTimeMillis());
        return json;
    }

    private void setEncryptData(Boolean isEncrypt, BaseEncryptDataDecorator encryptData) {
        List detailDataList = encryptData.getDetailDataList(isEncrypt);
        List salaryCardList = encryptData.getSalaryCardList(isEncrypt);
        if (detailDataList.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdetail"});
            this.setCustomData("detaillistap", "payDetailList", detailDataList);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdetail"});
            this.setCustomData("detaillistap", "payDetailList", detailDataList);
        }
        if (salaryCardList.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexcard"});
            this.setCustomData("cardlistap", "bankCardList", salaryCardList);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexcard"});
            this.setCustomData("cardlistap", "bankCardList", salaryCardList);
        }
        SalarySlipHelper.setHeadSummaryData((IFormView)this.getView(), (List)encryptData.getSummaryDetailList(isEncrypt));
    }

    private void updateConfirmStatus(String id) {
        if (SWCStringUtils.isEmpty((String)id)) {
            this.getView().updateView();
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_salaryslipstatus");
        QFilter filter = new QFilter("salarycalendar.id", "=", (Object)Long.parseLong(id));
        DynamicObject dobj = helper.queryOne(ISCONFIRM, new QFilter[]{filter});
        if (dobj == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u8d44\u6761\u5df2\u56de\u6536\uff0c\u65e0\u9700\u786e\u8ba4\u3002", (String)"MobileSalaryDetailPlugin_12", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!dobj.getBoolean(ISCONFIRM)) {
            dobj.set(ISCONFIRM, (Object)"1");
            helper.saveOne(dobj);
        }
        this.setConfirmedLab(Boolean.TRUE);
        OperateOption option = OperateOption.create();
        option.setVariableValue("calendarModelId", id);
        this.getView().invokeOperation("updatecar", option);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u5df2\u786e\u8ba4", (String)"MobileSalaryDetailPlugin_14", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
    }

    private void showContentFlex() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        map.put("vi", Boolean.TRUE);
        this.getView().updateControlMetadata("contentflex", map);
        this.getView().setVisible(Boolean.TRUE, new String[]{"contentflex"});
    }
}

