/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.mobile.sum;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hspp.common.events.SalarySlipPersonVerifyEvent;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.dto.salary.SalaryItemInfoDTO;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.permissions.PermissionHelper;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.business.salaryslip.context.ContextHolder;
import kd.swc.hspp.business.salaryslip.detaildata.builddata.BuildDataEnum;
import kd.swc.hspp.business.salaryslip.pojo.dto.SalaryItemSumDTO;
import kd.swc.hspp.business.salaryslip.pojo.dto.SalarySumItemMonthDTO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalarySumVO;
import kd.swc.hspp.common.model.SalaryCalendarModel;
import kd.swc.hspp.common.model.SalarySlipDataBaseModel;
import kd.swc.hspp.common.model.SalarySlipDataGroupModel;
import kd.swc.hspp.common.model.SalarySlipDataItemModel;
import kd.swc.hspp.common.model.SalarySlipDataItemSumModel;
import kd.swc.hspp.common.model.SalarySlipDataStyleModel;
import kd.swc.hspp.common.model.SalarySlipInitModel;
import kd.swc.hspp.common.model.SalarySlipSumDetailModel;
import kd.swc.hspp.formplugin.web.mobile.MobileSalaryBasePlugin;

public class MobileSalarySumPlugin
extends MobileSalaryBasePlugin {
    private static final String SELECTSUMVIEW = "selectsumview";
    private static final String SUMVIEWFLEX = "sumviewflex";
    private static final String SUMVIEWVECTORAP = "sumviewvectorap";
    private static final String SUMVIEWLABEL = "sumviewlabel";
    private static final String SUMVIEWCALLBACK = "sumviewcallback";
    private static final String CACHEKEY_SUM_CUSTOMER_CTRL = "SUM_CUSTOMER_CTRL_DATA";
    private static final String SUMLISTAP = "sumlistap";
    private static final String PAYROLL_SUM_LIST = "payrollSumList";
    private static final String PANEL_DETAIL = "panel_detail";
    private static final String CACHE_KEY_IS_ENCRYPT_DATA = "isEncryptData";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.initContextHolder();
        if (this.afterCreateNewData()) {
            SalarySlipInitModel initModel = new SalarySlipInitModel();
            Tuple dateTuple = ContextHolder.getSalarySlipQueryDateParam();
            Date slipEndDate = this.getSlipEndDate();
            if (dateTuple.item1 != null && slipEndDate.before((Date)dateTuple.item1)) {
                slipEndDate = dateTuple.item2 != null ? (Date)dateTuple.item2 : new Date();
            }
            initModel.setDateList(this.getPageDate(slipEndDate));
            this.initData(initModel);
        }
        ContextHolder.destory();
    }

    @Override
    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (key.startsWith("openitem") || key.startsWith("closeitem")) {
            Container vectorSelectAp = new Container();
            vectorSelectAp.setKey(key);
            vectorSelectAp.setView(this.getView());
            vectorSelectAp.addClickListener((ClickListener)this);
            args.setControl((Control)vectorSelectAp);
        }
        if (key.startsWith("itemflex")) {
            Container control = new Container();
            control.setKey(key);
            control.setView(this.getView());
            args.setControl((Control)control);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.startsWith("openitem")) {
            key = key.replace("openitem", "");
            this.setItemVisible(Boolean.TRUE, key);
        }
        if (key.startsWith("closeitem")) {
            key = key.replace("closeitem", "");
            this.setItemVisible(Boolean.FALSE, key);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String formOp;
        super.beforeDoOperation(args);
        switch (formOp = ((FormOperate)args.getSource()).getOperateKey()) {
            case "selecttime": {
                this.openSelectTimeControl("2");
                break;
            }
            case "selectsumview": {
                IPageCache pageCache = this.getView().getPageCache();
                Map sumViewIdNameMap = SalarySlipHelper.getSumViewIdNameMap((Set)((Set)JSON.parseObject((String)pageCache.get("sumViewIds"), Set.class)));
                int size = sumViewIdNameMap.size();
                String selectId = pageCache.get("sumViewIdSelect");
                if (sumViewIdNameMap.isEmpty()) {
                    this.getView().updateView();
                    return;
                }
                if (size == 1 && sumViewIdNameMap.containsKey(selectId)) {
                    return;
                }
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("hspp_sumviewselect");
                showParameter.getOpenStyle().setShowType(ShowType.NonModal);
                showParameter.setShowTitle(true);
                StyleCss styleCss = new StyleCss();
                int num = Math.min(size, 6);
                styleCss.setHeight(50 + 44 * num + 34 + "px");
                showParameter.getOpenStyle().setInlineStyleCss(styleCss);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SUMVIEWCALLBACK));
                showParameter.setCustomParam("sumViewIdSelect", (Object)(sumViewIdNameMap.containsKey(selectId) ? selectId : ""));
                showParameter.setCustomParam("sumViewIds", (Object)sumViewIdNameMap);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "openeye": {
                this.openEyeOfCustomerData(false);
                break;
            }
            case "closeeye": {
                this.openEyeOfCustomerData(true);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        switch (actionId) {
            case "sumviewcallback": {
                if (returnData == null) break;
                Map params = (Map)returnData;
                String selectId = (String)params.get("sumViewIdSelect");
                this.getView().getPageCache().put("sumViewIdSelect", selectId);
                this.getView().updateView();
                break;
            }
        }
    }

    private void setItemVisible(Boolean isOpen, String key) {
        this.getView().setVisible(isOpen, new String[]{"itemflex" + key});
        this.getView().setVisible(Boolean.valueOf(isOpen == false), new String[]{"openitem" + key});
        this.getView().setVisible(isOpen, new String[]{"closeitem" + key});
    }

    private Map<Long, Map<String, SalarySlipSumDetailModel>> groupingSalaryItemBySumView(List<SalarySlipSumDetailModel> salarySlipSumDetailModelList, DynamicObject slipSumView) {
        DynamicObjectCollection entryEntity = slipSumView.getDynamicObjectCollection("entryentity");
        HashMap<Long, Map<String, SalarySlipSumDetailModel>> salaryItemIdSumInfoMap = new HashMap<Long, Map<String, SalarySlipSumDetailModel>>(16);
        for (DynamicObject entity : entryEntity) {
            DynamicObjectCollection subEntryEntity = entity.getDynamicObjectCollection("subentryentity");
            subEntryEntity.forEach(data -> {
                Long salaryItemId = data.getLong("salaryitem.id");
                salaryItemIdSumInfoMap.put(salaryItemId, new HashMap(16));
            });
        }
        QFilter itemFilter = new QFilter("id", "in", salaryItemIdSumInfoMap.keySet());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        DynamicObject[] itemArrays = helper.query("id,number,name,ispayoutitem,datatype.showtype", new QFilter[]{itemFilter});
        HashMap<Long, DynamicObject> itemMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject item : itemArrays) {
            itemMap.put(item.getLong("id"), item);
        }
        salarySlipSumDetailModelList.forEach(detail -> {
            List salaryItemInfoList = detail.getSalaryItemInfoList();
            if (salaryItemInfoList != null) {
                for (SalaryItemInfoDTO salaryItemInfo : salaryItemInfoList) {
                    Long salaryItemId = salaryItemInfo.getSalaryItemId();
                    Map salaryItemSumInfoMap = (Map)salaryItemIdSumInfoMap.get(salaryItemId);
                    if (salaryItemSumInfoMap == null) continue;
                    String key = SWCDateTimeUtils.format((Date)detail.getReleaseTime(), (String)"yyyy.MM") + "_" + salaryItemInfo.getCalCurrencyId();
                    SalarySlipSumDetailModel detailModel = salaryItemSumInfoMap.getOrDefault(key, new SalarySlipSumDetailModel());
                    salaryItemInfo.setShowType(((DynamicObject)itemMap.get(salaryItemId)).getString("datatype.showtype"));
                    detailModel.setCalendarId(detail.getCalendarId());
                    detailModel.setReleaseTime(detail.getReleaseTime());
                    detailModel.setCalCurrencyId(Long.valueOf(salaryItemInfo.getCalCurrencyId()));
                    List salaryItemInfos = detailModel.getSalaryItemInfoList();
                    if (salaryItemInfos.size() == 1) {
                        SalaryItemInfoDTO salaryItemInfoSum = (SalaryItemInfoDTO)salaryItemInfos.get(0);
                        String showType = salaryItemInfoSum.getShowType();
                        BuildDataEnum buildDataEnum = BuildDataEnum.getBuildDataEnum((String)showType);
                        buildDataEnum.sum(salaryItemInfoSum, salaryItemInfo);
                    } else {
                        salaryItemInfos.add(salaryItemInfo);
                    }
                    salaryItemSumInfoMap.put(key, detailModel);
                }
            }
        });
        return salaryItemIdSumInfoMap;
    }

    private Map<Long, List<SalarySlipSumDetailModel>> addItemByYear(Map<Long, Map<String, SalarySlipSumDetailModel>> salaryItemIdSumInfoMap, Map<Long, SalaryCalendarModel> salaryCalendarModelMap, Set<Date> dateSet) {
        List<Long> calCurrencySortList = salaryCalendarModelMap.values().stream().sorted().map(SalaryCalendarModel::getCalCurrencyId).distinct().collect(Collectors.toList());
        return this.buildSalaryItemMapSort(salaryItemIdSumInfoMap, dateSet, calCurrencySortList);
    }

    private Map<Long, List<SalarySlipSumDetailModel>> buildSalaryItemMapSort(Map<Long, Map<String, SalarySlipSumDetailModel>> salaryItemIdSumInfoMap, Set<Date> dateSet, List<Long> calCurrencySortList) {
        HashMap<Long, List<SalarySlipSumDetailModel>> salaryItemIdSumInfoSortMap = new HashMap<Long, List<SalarySlipSumDetailModel>>(salaryItemIdSumInfoMap.size());
        salaryItemIdSumInfoMap.forEach((salaryItemId, salaryItemSumInfoMap) -> {
            Map monthBetween = SalarySlipHelper.getMonthBetween((Set)dateSet);
            ArrayList salaryItemSumInfoList = new ArrayList(salaryItemSumInfoMap.values());
            salaryItemSumInfoList.forEach(data -> {
                Date releaseTime = data.getReleaseTime();
                String dateKey = SWCDateTimeUtils.format((Date)releaseTime, (String)"yyyy.MM");
                if (monthBetween.containsKey(dateKey)) {
                    monthBetween.put(dateKey, Boolean.TRUE);
                }
            });
            monthBetween.forEach((monthString, isHave) -> {
                try {
                    if (!isHave.booleanValue()) {
                        Date date = SWCDateTimeUtils.parseDate((String)monthString, (String)"yyyy.MM");
                        salaryItemSumInfoList.add(SalarySlipSumDetailModel.newEmptyInstance((Date)date, (Long)salaryItemId));
                    }
                }
                catch (ParseException e) {
                    this.logger.error("parseDate error:", (Throwable)e);
                }
            });
            List sortList = salaryItemSumInfoList.stream().sorted(Comparator.comparing(SalarySlipSumDetailModel::getReleaseTime, Comparator.reverseOrder()).thenComparingInt(model -> calCurrencySortList.indexOf(model.getCalCurrencyId()))).collect(Collectors.toList());
            salaryItemIdSumInfoSortMap.put((Long)salaryItemId, sortList);
        });
        return salaryItemIdSumInfoSortMap;
    }

    private void createGroupDetail(Map<Long, List<SalarySlipSumDetailModel>> salaryItemIdSumInfoSortMap, DynamicObject slipSumView, boolean isEncrypt) {
        Map currencyMap = ContextHolder.getCurrencyMap();
        Map salaryCalendarModelMap = ContextHolder.getSalaryCalendarModelMap();
        List<Long> calCurrencySortList = salaryCalendarModelMap.values().stream().sorted().map(SalaryCalendarModel::getCalCurrencyId).distinct().collect(Collectors.toList());
        boolean isGroup = slipSumView.getBoolean("isgroup");
        DynamicObjectCollection entryEntity = slipSumView.getDynamicObjectCollection("entryentity");
        ArrayList<SalarySlipDataGroupModel> groupModelList = new ArrayList<SalarySlipDataGroupModel>(entryEntity.size());
        SalarySlipDataStyleModel groupStyle = SalarySlipHelper.getStyle((int)16, (String)"700", (String)"#212121");
        SalarySlipDataStyleModel itemSumStyle = SalarySlipHelper.getStyle((int)14, (String)"400", (String)"#212121");
        SalarySlipDataStyleModel itemStyle = SalarySlipHelper.getStyle((int)12, (String)"400", (String)"#333333");
        for (DynamicObject entity : entryEntity) {
            SalarySlipDataGroupModel groupModel = new SalarySlipDataGroupModel();
            groupModel.setKey(entity.getString("id"));
            groupModel.setCaption(isGroup ? entity.getString("groupdisplayname") : "");
            groupModel.setStyleModel(groupStyle);
            DynamicObjectCollection subEntryEntity = entity.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntity : subEntryEntity) {
                Long salaryItemId = subEntity.getLong("salaryitem.id");
                boolean emptyDisplay = subEntity.getBoolean("isemptydisplay");
                String itemDisplayName = subEntity.getString("subgroupdisplayname");
                boolean zeroDisplay = subEntity.getBoolean("iszerodisplay");
                SalarySlipDataItemSumModel itemSumModel = new SalarySlipDataItemSumModel();
                String subEntityId = subEntity.getString("id");
                itemSumModel.setKey(subEntityId);
                itemSumModel.setCaption(itemDisplayName);
                itemSumModel.setEmptyDisplay(Boolean.valueOf(emptyDisplay));
                itemSumModel.setZeroDisplay(Boolean.valueOf(zeroDisplay));
                itemSumModel.setStyleModel(itemSumStyle);
                List<SalarySlipSumDetailModel> salaryItemSumInfoList = salaryItemIdSumInfoSortMap.get(salaryItemId);
                salaryItemSumInfoList.forEach(data -> {
                    String calendarId = data.getCalendarId();
                    Date releaseTime = data.getReleaseTime();
                    String caption = SWCDateTimeUtils.format((Date)releaseTime, (String)"yyyy.MM");
                    DynamicObject currency = (DynamicObject)currencyMap.get(data.getCalCurrencyId());
                    String calSign = currency == null ? "" : currency.getString("sign");
                    int scale = currency == null ? 2 : currency.getInt("amtprecision");
                    data.getSalaryItemInfoList().forEach(salaryItemInfo -> {
                        String showType = salaryItemInfo.getShowType();
                        SalarySlipDataItemModel itemModel = new SalarySlipDataItemModel();
                        itemModel.setKey(calendarId + subEntityId);
                        itemModel.setCaption(caption);
                        BuildDataEnum buildDataEnum = BuildDataEnum.getBuildDataEnum((String)showType);
                        buildDataEnum.isShow(Boolean.valueOf(emptyDisplay), Boolean.valueOf(zeroDisplay), (SalarySlipDataBaseModel)itemModel, salaryItemInfo);
                        if (itemModel.getShow().booleanValue()) {
                            buildDataEnum.exec((SalarySlipDataBaseModel)itemSumModel, (SalarySlipDataBaseModel)itemModel, salaryItemInfo, calSign, scale);
                            itemModel.setStyleModel(itemStyle);
                            itemSumModel.addSalarySlipDataItemModelList(itemModel);
                        }
                    });
                });
                Map currencyAmountMap = itemSumModel.getCurrencyAmountMap();
                if (currencyAmountMap.isEmpty()) {
                    if (emptyDisplay) {
                        itemSumModel.addShowValueList("-");
                    }
                } else {
                    calCurrencySortList.forEach(calCurrencyId -> {
                        BigDecimal sum = (BigDecimal)currencyAmountMap.get(calCurrencyId);
                        if (sum != null) {
                            DynamicObject currency = (DynamicObject)currencyMap.get(calCurrencyId);
                            String calSign = currency.getString("sign");
                            sum = sum.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                            String sumAmount = calSign + SalarySlipHelper.fmtMicrometer((String)sum.toPlainString());
                            itemSumModel.addShowValueList(sumAmount);
                        }
                    });
                }
                itemSumModel.setShow(Boolean.valueOf(itemSumModel.getShowValueList().size() > 0));
                if (!itemSumModel.getShow().booleanValue()) continue;
                groupModel.addSalarySlipDataItemSumModelList(itemSumModel);
            }
            groupModel.setShow(Boolean.valueOf(groupModel.getSalarySlipDataItemSumModelList().size() > 0));
            if (!groupModel.getShow().booleanValue()) continue;
            groupModelList.add(groupModel);
        }
        Map<String, List<SalarySumVO>> customerCtrlData = this.getCustomerCtrlData(groupModelList);
        this.getView().getPageCache().put(CACHEKEY_SUM_CUSTOMER_CTRL, SerializationUtils.serializeToBase64(customerCtrlData));
        if (isEncrypt) {
            this.encryptCustomerCtrlData(customerCtrlData);
        }
        this.setCustomerDataOfSum(customerCtrlData);
    }

    public void openEyeOfCustomerData(boolean isEncrypt) {
        String cacheData = this.getView().getPageCache().get(CACHEKEY_SUM_CUSTOMER_CTRL);
        if (SWCStringUtils.isEmpty((String)cacheData)) {
            return;
        }
        this.getView().getPageCache().put(CACHE_KEY_IS_ENCRYPT_DATA, String.valueOf(isEncrypt));
        Map customerCtrlData = (Map)SerializationUtils.deSerializeFromBase64((String)cacheData);
        if (isEncrypt) {
            this.encryptCustomerCtrlData(customerCtrlData);
            this.setCustomerDataOfSum(customerCtrlData);
        } else {
            this.setCustomerDataOfSum(customerCtrlData);
        }
        ContextHolder.updateSaveEncryptType((int)(isEncrypt ? 1 : 0));
    }

    private void encryptCustomerCtrlData(Map<String, List<SalarySumVO>> customerCtrlData) {
        List<SalarySumVO> salarySumVOList = customerCtrlData.get(PAYROLL_SUM_LIST);
        if (salarySumVOList != null) {
            for (SalarySumVO salarySumVO : salarySumVOList) {
                if (salarySumVO == null) continue;
                List data = salarySumVO.getData();
                this.encryptData(data);
            }
        }
    }

    protected void encryptData(List<SalaryItemSumDTO> data) {
        if (data == null) {
            return;
        }
        for (SalaryItemSumDTO itemSumDTO : data) {
            if (itemSumDTO == null) continue;
            this.encryptItemSumData(itemSumDTO);
            this.encryptItemMonthData(itemSumDTO);
        }
    }

    protected void encryptItemMonthData(SalaryItemSumDTO itemSumDTO) {
        List itemMonthDTOS = itemSumDTO.getData();
        if (itemMonthDTOS == null) {
            return;
        }
        for (SalarySumItemMonthDTO monthDTO : itemMonthDTOS) {
            List monthValues = monthDTO.getPay();
            if (monthValues == null) continue;
            int size = monthValues.size();
            ArrayList<String> newMonthValues = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                newMonthValues.add("******");
            }
            monthDTO.setPay(newMonthValues);
        }
    }

    protected void encryptItemSumData(SalaryItemSumDTO itemSumDTO) {
        List payList = itemSumDTO.getPay();
        if (payList != null) {
            int size = payList.size();
            ArrayList<String> newPayList = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                newPayList.add("******");
            }
            itemSumDTO.setPay(newPayList);
        }
    }

    private void setCustomerDataOfSum(Map<String, List<SalarySumVO>> customerCtrlData) {
        CustomControl sumListap = (CustomControl)this.getView().getControl(SUMLISTAP);
        if (sumListap != null) {
            sumListap.setData(customerCtrlData);
        }
    }

    public Map<String, List<SalarySumVO>> getCustomerCtrlData(List<SalarySlipDataGroupModel> groupModelList) {
        HashMap<String, List<SalarySumVO>> resultMap = new HashMap<String, List<SalarySumVO>>(16);
        resultMap.put(PAYROLL_SUM_LIST, new ArrayList(10));
        if (groupModelList == null) {
            return resultMap;
        }
        ArrayList<SalarySumVO> salarySumVOList = new ArrayList<SalarySumVO>(10);
        for (SalarySlipDataGroupModel dataGroupModel : groupModelList) {
            if (dataGroupModel == null) continue;
            SalarySumVO salarySumVO = new SalarySumVO();
            salarySumVO.setName(dataGroupModel.getCaption());
            ArrayList<SalaryItemSumDTO> salaryItemSumDTOS = new ArrayList<SalaryItemSumDTO>(10);
            List itemSumModelList = dataGroupModel.getSalarySlipDataItemSumModelList();
            if (itemSumModelList != null) {
                for (SalarySlipDataItemSumModel itemSumModel : itemSumModelList) {
                    SalaryItemSumDTO salaryItemSumDTO = new SalaryItemSumDTO();
                    salaryItemSumDTO.setName(itemSumModel.getCaption());
                    salaryItemSumDTO.setPay(itemSumModel.getShowValueList());
                    ArrayList<SalarySumItemMonthDTO> data = new ArrayList<SalarySumItemMonthDTO>(10);
                    List itemModelList = itemSumModel.getSalarySlipDataItemModelList();
                    this.addItemIntoData(itemModelList, data);
                    salaryItemSumDTO.setData(data);
                    salaryItemSumDTOS.add(salaryItemSumDTO);
                }
            }
            salarySumVO.setData(salaryItemSumDTOS);
            salarySumVOList.add(salarySumVO);
        }
        resultMap.put(PAYROLL_SUM_LIST, salarySumVOList);
        return resultMap;
    }

    protected void addItemIntoData(List<SalarySlipDataItemModel> itemModelList, List<SalarySumItemMonthDTO> data) {
        if (itemModelList != null) {
            for (SalarySlipDataItemModel itemModel : itemModelList) {
                if (itemModel == null) continue;
                SalarySumItemMonthDTO salarySumItemMonthDTO = new SalarySumItemMonthDTO();
                salarySumItemMonthDTO.setMonth(itemModel.getCaption());
                salarySumItemMonthDTO.setPay(itemModel.getShowValueList());
                data.add(salarySumItemMonthDTO);
            }
        }
    }

    private Long getKeyOrNull(Map<Long, Set<Long>> map) {
        Map.Entry<Long, Set<Long>> entry;
        String selectId = this.getView().getPageCache().get("sumViewIdSelect");
        if (SWCStringUtils.isNotEmpty((String)selectId)) {
            return Long.parseLong(selectId);
        }
        Long obj = null;
        Iterator<Map.Entry<Long, Set<Long>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext() && (obj = (entry = iterator.next()).getKey()) == null) {
        }
        return obj;
    }

    private boolean afterCreateNewData() {
        String queryPersonId = (String)this.getView().getFormShowParameter().getCustomParam("querypersonid");
        Tuple tuple = ContextHolder.getPersonTuple();
        ContextHolder.setPersonVerifyEvent((Long)(SWCStringUtils.isNotEmpty((String)queryPersonId) ? Long.parseLong(queryPersonId) : 0L));
        SalarySlipPersonVerifyEvent personVerifyEvent = ContextHolder.getPersonVerifyEvent();
        Boolean havePerm = personVerifyEvent.getHavePerm();
        if (!((Boolean)tuple.item1).booleanValue() && havePerm == null) {
            String msg = ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"MobileSalaryCalendarPlugIn_14", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            this.redirectPageOnReplace(msg);
            return false;
        }
        if (havePerm != null && !havePerm.booleanValue()) {
            this.redirectPageOnReplace(personVerifyEvent.getErrorMessage());
            return false;
        }
        if (!this.verifyCert()) {
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4f7f\u7528\u8bb8\u53ef\uff0c\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SalaryPwdInitPlugin_0", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            this.redirectPageOnReplace(msg);
            return false;
        }
        Date slipEndDate = ContextHolder.getSalarySlipEndDate();
        this.getView().getPageCache().put("cache_date", SWCDateTimeUtils.format((Date)slipEndDate, (String)"yyyy-MM"));
        return true;
    }

    @Override
    public void initData(SalarySlipInitModel initModel) {
        super.initData(initModel);
        PermissionHelper.setPageVisible((IFormView)this.getView(), (Boolean)Boolean.TRUE);
        if (initModel.isCancel()) {
            this.setQueryDataFlex(Boolean.FALSE);
            this.getView().setVisible(Boolean.FALSE, new String[]{SUMVIEWFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_DETAIL});
            this.setCustomerDataOfSum(new HashMap<String, List<SalarySumVO>>(16));
            Label errorLabel = (Label)this.getView().getControl("errorlabel");
            if (errorLabel != null) {
                errorLabel.setText(initModel.getCancelMessage());
            }
            return;
        }
        Map sumViewCalendarMap = ContextHolder.getSumViewCalendarMap();
        if (sumViewCalendarMap.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SUMVIEWFLEX});
            this.setQueryDataFlex(Boolean.FALSE);
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_DETAIL});
            this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u67e5\u8be2\u7684\u5de5\u8d44\u6761\u6c47\u603b\u65b9\u6848\u3002", (String)"MobileSalarySumPlugin_0", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{SUMVIEWFLEX});
        this.getView().setVisible(Boolean.valueOf(sumViewCalendarMap.size() != 1), new String[]{SUMVIEWVECTORAP});
        Long selectId = this.getKeyOrNull(sumViewCalendarMap);
        this.getView().getPageCache().put("sumViewIdSelect", String.valueOf(selectId));
        this.getView().getPageCache().put("sumViewIds", JSON.toJSONString(sumViewCalendarMap.keySet()));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salslipsumview");
        DynamicObject slipSumView = helper.queryOne((Object)selectId);
        ((Label)this.getView().getControl(SUMVIEWLABEL)).setText(slipSumView.getString("name"));
        ContextHolder.setCalendarSet((Set)sumViewCalendarMap.getOrDefault(selectId, new HashSet<Long>(1){
            private static final long serialVersionUID = -2542190072705103695L;
            {
                this.add(0L);
            }
        }));
        List salarySlipSumDetailModelList = ContextHolder.getSalarySlipSumDetailModelList();
        Boolean isHaveData = salarySlipSumDetailModelList.size() > 0;
        this.setQueryDataFlex(isHaveData);
        if (!isHaveData.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_DETAIL});
            Label errorLabel = (Label)this.getView().getControl("errorlabel");
            if (errorLabel != null) {
                errorLabel.setText(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u53ef\u5c1d\u8bd5\u4fee\u6539\u7b5b\u9009\u6761\u4ef6\u3002", (String)"MobileSalarySumPlugin_1", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_DETAIL});
        boolean isEncrypt = ContextHolder.getEncryptType();
        this.setEncryptLab(isEncrypt);
        Map<Long, Map<String, SalarySlipSumDetailModel>> salaryItemIdSumInfoMap = this.groupingSalaryItemBySumView(salarySlipSumDetailModelList, slipSumView);
        Map salaryCalendarModelMap = ContextHolder.getSalaryCalendarModelMap();
        Map currencyMap = ContextHolder.getCurrencyMap();
        this.countAmount(salaryCalendarModelMap, currencyMap, isEncrypt);
        Set<Date> dateSet = salarySlipSumDetailModelList.stream().map(SalarySlipSumDetailModel::getReleaseTime).collect(Collectors.toSet());
        Map<Long, List<SalarySlipSumDetailModel>> salaryItemIdSumInfoSortMap = this.addItemByYear(salaryItemIdSumInfoMap, salaryCalendarModelMap, dateSet);
        this.createGroupDetail(salaryItemIdSumInfoSortMap, slipSumView, isEncrypt);
    }
}

