/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.mobile.sum;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.swc.hsbp.common.control.SWCFlexPanelAp;
import kd.swc.hsbp.common.control.SWCLabelAp;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class MobileSalarySumViewSelectPlugin
extends AbstractMobFormPlugin {
    private static final String VIEWFLEX = "viewflex";
    private static final String VIEWNAMELAB = "viewnamelab";
    private static final String VIEWSELECTLAB = "viewselectlab";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String selectId = (String)formShowParameter.getCustomParam("sumViewIdSelect");
        Map sumViewIdNameMap = (Map)formShowParameter.getCustomParam("sumViewIds");
        this.createSumViewSelectFlex(selectId, sumViewIdNameMap);
        this.getView().getPageCache().put("sumViewIdSelect", selectId);
        this.getView().getPageCache().put("sumViewIds", JSON.toJSONString((Object)sumViewIdNameMap));
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (key.startsWith(VIEWSELECTLAB)) {
            Vector vectorSelectAp = new Vector();
            vectorSelectAp.setKey(key);
            vectorSelectAp.setView(this.getView());
            args.setControl((Control)vectorSelectAp);
        }
        if (key.startsWith(VIEWFLEX)) {
            Container control = new Container();
            control.setKey(key);
            control.addClickListener((ClickListener)this);
            control.setView(this.getView());
            args.setControl((Control)control);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.startsWith(VIEWFLEX)) {
            String id = key.replace(VIEWFLEX, "");
            String selectId = this.getView().getPageCache().get("sumViewIdSelect");
            this.getView().setVisible(Boolean.FALSE, new String[]{VIEWSELECTLAB + selectId});
            this.getView().setVisible(Boolean.TRUE, new String[]{VIEWSELECTLAB + id});
            this.getView().getPageCache().put("sumViewIdSelect", id);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        String selectId = this.getView().getPageCache().get("sumViewIdSelect");
        if (SWCStringUtils.isEmpty((String)selectId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c47\u603b\u65b9\u6848\u3002", (String)"MoblieSalarySumViewSelectPlugin_0", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        String idNameString = this.getView().getPageCache().get("sumViewIds");
        Map sumViewIdNameMap = (Map)JSON.parseObject((String)idNameString, Map.class);
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("sumViewNameSelect", sumViewIdNameMap.getOrDefault(selectId, ""));
        params.put("sumViewIdSelect", selectId);
        this.getView().returnDataToParent(params);
    }

    private void createSumViewSelectFlex(String selectId, Map<String, String> sumViewIdNameMap) {
        int size = sumViewIdNameMap.size();
        int num = size > 6 ? 6 : size;
        FlexPanelAp sumFlexPanelAp = this.createSumFlexPanelAp(num * 44);
        sumViewIdNameMap.forEach((viewId, name) -> {
            FlexPanelAp viewFlexPanelAp = this.createViewFlexPanelAp((String)viewId, (String)name);
            sumFlexPanelAp.getItems().add(viewFlexPanelAp);
            this.getView().setVisible(Boolean.valueOf(selectId.equals(viewId)), new String[]{VIEWSELECTLAB + viewId});
        });
        this.getView().updateControlMetadata("flexpanelap", sumFlexPanelAp.createControl());
    }

    private FlexPanelAp createViewFlexPanelAp(String viewId, String name) {
        FlexPanelAp panelAp = ((SWCFlexPanelAp.Builder)new SWCFlexPanelAp.Builder(VIEWFLEX + viewId).setWrap(false).setDirection("row").setAlignItems("center").setJustifyContent("space-between").setBorderBottom("0.5px_solid_#d9d9d9")).setGrow(0).setShrink(0).setHeight("44px").setClickable(true).build();
        LabelAp nameLabelAp = new SWCLabelAp.Builder(VIEWNAMELAB + viewId).setFontSize(14).setForeColor("#212121").setWidth(new LocaleString("90%")).setName(name).build();
        panelAp.getItems().add(nameLabelAp);
        VectorAp vectorSelectAp = new VectorAp();
        vectorSelectAp.setKey(VIEWSELECTLAB + viewId);
        vectorSelectAp.setForeColor("#276FF5");
        vectorSelectAp.setfontClass("kdfont kdfont-gouxuan");
        vectorSelectAp.setClickable(false);
        panelAp.getItems().add(vectorSelectAp);
        return panelAp;
    }

    private FlexPanelAp createSumFlexPanelAp(int height) {
        return ((SWCFlexPanelAp.Builder)((SWCFlexPanelAp.Builder)new SWCFlexPanelAp.Builder("flexpanelap").setWrap(false).setDirection("column").setAlignItems("stretch").setGrow(0).setShrink(0).setMarginLeft("12px")).setMarginRight("12px")).setHeight(height + "px").build();
    }
}

