/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.perbankcard;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.swc.hsbp.business.perbankcard.PerBankcardServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.bankcard.PerBankCardConstants;
import kd.swc.hspp.business.bankcard.PerBankCardHelper;
import kd.swc.hspp.business.bankcard.savestrategy.BaseSaveStrategy;
import kd.swc.hspp.business.bankcard.savestrategy.DirectSaveStrategy;
import kd.swc.hspp.business.bankcard.savestrategy.SubmitEditBillStrategy;
import kd.swc.hspp.business.mservice.ocr.IOcrService;
import kd.swc.hspp.business.mservice.ocr.entity.AlgoResultOrcData;
import kd.swc.hspp.business.mservice.ocr.entity.BankCardOrcInfo;
import kd.swc.hspp.business.mservice.person.IPersonService;
import kd.swc.hspp.business.mservice.salary.ISalaryPayService;
import kd.swc.hspp.business.permissions.PermissionHelper;

public class PerBankCardDetailPlugin
extends AbstractMobFormPlugin
implements PerBankCardConstants,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(PerBankCardDetailPlugin.class);
    private static final String KEY_HRPI = "hrpi";
    private static final String KEY_PER_BANK_CARD_SERVICE = "IHRPIPerBankCardService";
    private static final String KEY_DELETE_PER_BANK_CARD = "deletePerBankCard";
    private static final Pattern PATTERN = Pattern.compile("[0-9]*");
    private static final String DONOTHING_SAVE = "donothing_save";
    private static final String DONOTHING_CHANGE = "donothing_change";
    private static final String DONOTHING_DELETE = "donothing_delete";
    private static final String DONOTHING_CLOSE = "donothing_close";
    private static final String VIEWEDIT = "viewedit";
    private static final String SOURCEVID = "sourcevid";
    private static final String ORC = "selectPic";
    private static final String BD_BEBANK = "bankdepositedit";
    private static final Map<Boolean, BaseSaveStrategy> DEALDATAMAP = new ImmutableMap.Builder().put((Object)Boolean.TRUE, (Object)new SubmitEditBillStrategy()).put((Object)Boolean.FALSE, (Object)new DirectSaveStrategy()).build();

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit beBank = (BasedataEdit)this.getView().getControl(BD_BEBANK);
        beBank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject event) {
        boolean havePermission = PermissionHelper.isHavePermission((String)"hspp_bankcardperview", (String)"47150e89000000ac");
        PermissionHelper.setPagePermStatus((IFormView)this.getView(), (Boolean)havePermission, (String)ResManager.loadKDString((String)"\u6211\u7684\u94f6\u884c\u5361", (String)"PerBankCardDetailPlugin_9", (String)"swc-hspp-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"PerBankCardDetailPlugin_11", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
        if (!havePermission) {
            return;
        }
        Long personId = 0L;
        Long employeeId = 0L;
        Tuple tuple = IPersonService.getInstance().getPersonInfo();
        if (((Boolean)tuple.item1).booleanValue()) {
            personId = ((Map)tuple.item2).getOrDefault("person", 0L);
            employeeId = ((Map)tuple.item2).getOrDefault("employee", 0L);
        }
        this.getModel().setValue("employee", (Object)employeeId);
        this.getModel().setValue("person", (Object)personId);
        Long perBankCardId = (Long)this.getView().getFormShowParameter().getCustomParam("bankcardid");
        this.setInitField(perBankCardId);
        this.initTips();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName = event.getProperty().getName();
        if (BD_BEBANK.equals(propertyName)) {
            event.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884c", (String)"PerBankCardDetailPlugin_8", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_save": {
                boolean isCreate = this.getModel().getValue("perbankcard") == null;
                String permItemName = isCreate ? ResManager.loadKDString((String)"\u65b0\u589e", (String)"PerBankCardDetailPlugin_10", (String)"swc-hspp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fee\u6539", (String)"PerBankCardDetailPlugin_12", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
                String permItemId = isCreate ? "47156aff000000ac" : "4715a0df000000ac";
                boolean havePermission = PermissionHelper.isHavePermission((String)"hspp_bankcardperview", (String)permItemId);
                if (!havePermission) {
                    PermissionHelper.showNoPermTips((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u6211\u7684\u94f6\u884c\u5361", (String)"PerBankCardDetailPlugin_9", (String)"swc-hspp-formplugin", (Object[])new Object[0]), (String)permItemName);
                }
                args.setCancel(!havePermission || this.isBankCardNumber() || this.validateAttachment() || this.validateIsDelete() || this.validateBankCardNumRepeat());
                break;
            }
            case "donothing_change": {
                boolean havePermission = PermissionHelper.isHavePermission((String)"hspp_bankcardperview", (String)"4715a0df000000ac");
                if (!havePermission) {
                    PermissionHelper.showNoPermTips((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u6211\u7684\u94f6\u884c\u5361", (String)"PerBankCardDetailPlugin_9", (String)"swc-hspp-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fee\u6539", (String)"PerBankCardDetailPlugin_12", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(!havePermission);
                break;
            }
            case "donothing_close": {
                args.setCancel(this.validateIsChanged());
                break;
            }
            case "donothing_delete": {
                boolean havePermission = PermissionHelper.isHavePermission((String)"hspp_bankcardperview", (String)"4715e1f1000000ac");
                if (!havePermission) {
                    PermissionHelper.showNoPermTips((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u6211\u7684\u94f6\u884c\u5361", (String)"PerBankCardDetailPlugin_9", (String)"swc-hspp-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"PerBankCardDetailPlugin_13", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(DONOTHING_DELETE);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\uff1f", (String)"PerBankCardDetailPlugin_6", (String)"swc-hspp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5220\u9664\u540e\u94f6\u884c\u5361\u5b9e\u9645\u505c\u6b62\u4f7f\u7528\u65f6\u95f4\u53d7\u53d1\u85aa\u5468\u671f\u5f71\u54cd\uff0c\u4ee5\u85aa\u8d44\u4e13\u5458\u5904\u7406\u4e3a\u51c6\u3002", (String)"PerBankCardDetailPlugin_5", (String)"swc-hspp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener);
                break;
            }
            case "viewedit": {
                this.viewEditBillDetail();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "donothing_change": {
                this.getView().setStatus(OperationStatus.EDIT);
                this.uploadAttachment((Long)this.getView().getFormShowParameter().getCustomParam("bankcardid"));
                break;
            }
            case "donothing_save": {
                this.dealPerBankCard();
                break;
            }
            case "selectPic": {
                afterDoOperationEventArgs.getOperationResult();
                break;
            }
            case "donothing_close": {
                this.closeDeal();
                break;
            }
            case "donothing_delete": 
            case "viewedit": {
                this.bindAttachment((Long)this.getView().getFormShowParameter().getCustomParam("bankcardid"));
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        String eventName;
        switch (eventName = customEventArgs.getEventName()) {
            case "selectPic": {
                String eventArgs = customEventArgs.getEventArgs();
                LOGGER.info("ORC RESULT : {}", (Object)eventArgs);
                JSONObject picJson = JSON.parseObject((String)eventArgs);
                String imageBase64 = picJson.getString("fileData").replace("\r\n", "");
                AlgoResultOrcData orcData = IOcrService.getInstance().distinguishOcrImage("hrpi_perbankcard", "OPM-BankCard", imageBase64);
                this.ocrDataToPerBankCard(orcData);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "donothing_close": {
                if (MessageBoxResult.Yes != event.getResult()) break;
                this.closeDeal();
                break;
            }
            case "donothing_delete": {
                if (MessageBoxResult.Yes != event.getResult()) break;
                this.deletePerBankCard();
                break;
            }
        }
    }

    private void ocrDataToPerBankCard(AlgoResultOrcData orcData) {
        if (orcData == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u94f6\u884c\u8d26\u53f7\uff0c\u8bf7\u91cd\u65b0\u626b\u63cf\u3002", (String)"PerBankCardDetailPlugin_7", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            return;
        }
        if (orcData.getErrorCode() != 0) {
            this.getView().showErrorNotification(orcData.getDescription());
            return;
        }
        BankCardOrcInfo bankCardOrcInfo = (BankCardOrcInfo)JSON.parseObject((String)JSON.toJSONString((Object)orcData.getData()), BankCardOrcInfo.class);
        LOGGER.info("bankCardOrcInfo=={}", (Object)bankCardOrcInfo);
        String cardNo = bankCardOrcInfo.getCardNo();
        if (SWCStringUtils.isEmpty((String)cardNo)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u94f6\u884c\u8d26\u53f7\uff0c\u8bf7\u91cd\u65b0\u626b\u63cf\u3002", (String)"PerBankCardDetailPlugin_7", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("bankcardnumedit", (Object)cardNo.replaceAll(" ", ""));
    }

    private void closeDeal() {
        Long perBankCardId = this.getModel().getDataEntity().getLong("perbankcard.id");
        if (perBankCardId == 0L) {
            this.getView().close();
            return;
        }
        this.getView().getPageCache().put("attachment", "1");
        this.getView().updateView();
    }

    private void setInitField(Long perBankCardId) {
        if (null == perBankCardId || perBankCardId == 0L) {
            DynamicObject perBankCard = this.getModel().getDataEntity();
            this.getModel().setValue("usernameedit", (Object)perBankCard.getString("person.name"));
            DynamicObject accountRelation = perBankCard.getDynamicObject("accountrelationedit");
            if (accountRelation == null || !"1".equals(accountRelation.getString("enable")) || !"C".equals(accountRelation.getString("status"))) {
                this.getModel().setValue("accountrelationedit", null);
            }
            this.getView().updateView("contentflex");
            return;
        }
        SWCDataServiceHelper perBankCardHelper = new SWCDataServiceHelper("hrpi_perbankcard");
        QFilter idFilter = new QFilter("id", "=", (Object)perBankCardId);
        DynamicObject perBankCardObj = perBankCardHelper.queryOne("employee,person,bankcardnum,bankdeposit,username,accountrelation,cardpurpose,description,sourcevid", new QFilter[]{idFilter});
        DynamicObjectCollection doc = perBankCardObj.getDynamicObjectCollection("cardpurpose");
        this.getModel().setValue("bankcardnum", perBankCardObj.get("bankcardnum"));
        this.getModel().setValue("bankdeposit", perBankCardObj.get("bankdeposit"));
        this.getModel().setValue("username", perBankCardObj.get("username"));
        this.getModel().setValue("accountrelation", perBankCardObj.get("accountrelation"));
        this.getModel().setValue("cardpurpose", (Object)doc.stream().map(purpose -> purpose.getLong("fbasedataid_id")).toArray());
        this.getModel().setValue("description", perBankCardObj.get("description"));
        this.getModel().setValue("perbankcard", (Object)perBankCardId);
        this.getModel().setValue("bankcardnumedit", perBankCardObj.get("bankcardnum"));
        this.getModel().setValue(BD_BEBANK, perBankCardObj.get("bankdeposit"));
        this.getModel().setValue("usernameedit", perBankCardObj.get("username"));
        this.getModel().setValue("accountrelationedit", perBankCardObj.get("accountrelation"));
        this.getModel().setValue("cardpurposeedit", (Object)doc.stream().map(purpose -> purpose.getLong("fbasedataid_id")).toArray());
        this.getModel().setValue("descriptionedit", perBankCardObj.get("description"));
        this.setAuditFlex(perBankCardId);
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
        this.getView().updateView("contentflex");
        this.bindAttachment(perBankCardId);
    }

    private void bindAttachment(Long perBankCardId) {
        if (perBankCardId == null || perBankCardId == 0L) {
            return;
        }
        AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachment");
        List attachmentAttachmentData = attachment.getAttachmentData();
        attachmentAttachmentData.forEach(arg_0 -> ((AttachmentPanel)attachment).remove(arg_0));
        List attachmentData = AttachmentServiceHelper.getAttachments((String)"hrpi_perbankcard", (Object)perBankCardId, (String)"attachmentpanel");
        attachment.bindData(attachmentData);
    }

    private void uploadAttachment(Long perBankCardId) {
        if (perBankCardId == null || perBankCardId == 0L) {
            return;
        }
        AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachment");
        List attachmentData = AttachmentServiceHelper.getAttachments((String)"hrpi_perbankcard", (Object)perBankCardId, (String)"attachmentpanel");
        attachmentData.forEach(data -> data.put("uid", String.valueOf(data.get("uid")) + "-1"));
        attachment.upload(attachmentData);
        this.getView().updateView("attachment");
    }

    private void setAuditFlex(Long perBankCardId) {
        Long billId = ISalaryPayService.getInstance().getPerBankCardEditBillIdByPerBankCardId(perBankCardId);
        this.getView().getPageCache().put(SOURCEVID, String.valueOf(perBankCardId));
        this.getView().setVisible(Boolean.valueOf(billId != 0L), new String[]{"auditflex"});
    }

    private void viewEditBillDetail() {
        String sourcevid = this.getView().getPageCache().get(SOURCEVID);
        Long perBankCardId = (Long)ObjectConverter.convert((Object)sourcevid, Long.class, (boolean)true);
        Long billId = ISalaryPayService.getInstance().getPerBankCardEditBillIdByPerBankCardId(perBankCardId);
        if (billId == null || billId == 0L) {
            IFormView preBankCardView = this.getPreBankCardView();
            if (preBankCardView == null) {
                return;
            }
            preBankCardView.invokeOperation("donothing_refresh");
            this.getView().sendFormAction(preBankCardView);
            this.setInitField((Long)this.getView().getFormShowParameter().getCustomParam("bankcardid"));
            this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u65e0\u5ba1\u6279\u4e2d\u7684\u53d8\u66f4\u8bb0\u5f55\u3002", (String)"PerBankCardDetailPlugin_15", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            return;
        }
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setCustomParam("id", (Object)billId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId("hspp_bankcardbilldetail");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void initTips() {
        List promptString = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "labelap", this.getModel().getDataEntity()});
        String tipsValue = "";
        Iterator iterator = promptString.iterator();
        while (iterator.hasNext()) {
            String entry;
            tipsValue = entry = (String)iterator.next();
        }
        this.getView().setVisible(Boolean.valueOf(SWCStringUtils.isNotEmpty((String)tipsValue)), new String[]{"flexdesc"});
        Label label = (Label)this.getControl("labelap");
        label.setText(tipsValue);
    }

    private boolean validateIsChanged() {
        boolean dataChanged = this.getModel().getDataChanged();
        if (dataChanged) {
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(DONOTHING_CLOSE);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u9000\u51fa\uff1f", (String)"PerBankCardDetailPlugin_4", (String)"swc-hspp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u82e5\u76f4\u63a5\u9000\u51fa\uff0c\u5c06\u4e0d\u4f1a\u4fdd\u5b58\u672c\u6b21\u7ef4\u62a4\u7684\u94f6\u884c\u5361\u4fe1\u606f\u3002", (String)"PerBankCardDetailPlugin_3", (String)"swc-hspp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener);
        }
        return dataChanged;
    }

    private boolean validateAttachment() {
        AttachmentPanel att;
        List attachmentData;
        Boolean isAudit = PerBankcardServiceHelper.getAuditStatus();
        if (isAudit.booleanValue() && (attachmentData = (att = (AttachmentPanel)this.getView().getControl("attachment")).getAttachmentData()).isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u5361\u53d8\u66f4\u8bb0\u5f55\u5c06\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u7ef4\u62a4\u9644\u4ef6\u4fe1\u606f\u3002", (String)"PerBankCardDetailPlugin_14", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean validateIsDelete() {
        SWCDataServiceHelper perBankCardServiceHelper = new SWCDataServiceHelper("hrpi_perbankcard");
        long id = this.getModel().getDataEntity().getLong("perbankcard.id");
        if (id == 0L) {
            return false;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        QFilter deleteFilter = new QFilter("isdelete", "=", (Object)"1");
        boolean exists = perBankCardServiceHelper.isExists(new QFilter[]{idFilter, deleteFilter});
        if (exists) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u94f6\u884c\u5361\u5df2\u5220\u9664\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"PerBankCardDetailPlugin_1", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean validateBankCardNumRepeat() {
        boolean existSameCard;
        boolean isChange;
        String bankCardNum = this.getModel().getDataEntity().getString("bankcardnumedit");
        if (SWCStringUtils.isEmpty((String)bankCardNum)) {
            return false;
        }
        SWCDataServiceHelper perBankCardServiceHelper = new SWCDataServiceHelper("hrpi_perbankcard");
        QFilter bankCardNumFilter = new QFilter("bankcardnum", "=", (Object)bankCardNum);
        QFilter isDeleteFilter = new QFilter("isdelete", "=", (Object)"0");
        QFilter personFilter = new QFilter("person", "=", (Object)this.getModel().getDataEntity().getLong("person.id"));
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        boolean bl = isChange = null != this.getModel().getValue("perbankcard");
        if (isChange) {
            personFilter.and(new QFilter("id", "!=", (Object)this.getModel().getDataEntity().getLong("perbankcard.id")));
        }
        if (!(existSameCard = perBankCardServiceHelper.isExists(new QFilter[]{isCurrentVersionFilter, bankCardNumFilter, isDeleteFilter, personFilter}))) {
            return false;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u5df2\u5b58\u5728\u3002", (String)"PerBankCardDetailPlugin_2", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
        return true;
    }

    private boolean isBankCardNumber() {
        String cardNum = this.getModel().getDataEntity().getString("bankcardnumedit");
        boolean match = PATTERN.matcher(cardNum).matches();
        if (!match) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4ec5\u5141\u8bb8\u5f55\u5165\u6570\u5b57\u3002", (String)"PerBankCardDetailPlugin_0", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void dealPerBankCard() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Boolean auditStatus = PerBankcardServiceHelper.getAuditStatus();
        boolean isSuccess = DEALDATAMAP.get(auditStatus).dealData(this.getView(), dataEntity);
        if (isSuccess) {
            IFormView preBankCardView = this.getPreBankCardView();
            if (preBankCardView == null) {
                return;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("isNewShow", String.valueOf(auditStatus));
            preBankCardView.invokeOperation("donothing_refresh", option);
            this.getView().sendFormAction(preBankCardView);
            if (auditStatus.booleanValue() || dataEntity.getLong("perbankcard.id") == 0L) {
                this.getView().close();
            } else {
                this.getView().updateView();
            }
        }
    }

    private IFormView getPreBankCardView() {
        return this.getView().getParentView();
    }

    private void deletePerBankCard() {
        DynamicObject perBankCardDetail = this.getModel().getDataEntity();
        DynamicObject perBankCard = perBankCardDetail.getDynamicObject("perbankcard");
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        map.put("id", perBankCardDetail.getLong("perbankcard.id"));
        OperationResult operationResult = PerBankCardHelper.abandonEditBill((Long)perBankCard.getLong("id"));
        boolean success = operationResult.isSuccess();
        if (success) {
            success = (Boolean)SWCMServiceUtils.invokeHRMPService((String)KEY_HRPI, (String)KEY_PER_BANK_CARD_SERVICE, (String)KEY_DELETE_PER_BANK_CARD, (Object[])new Object[]{Boolean.TRUE, Collections.singletonList(map)});
            if (!success) {
                LOGGER.info("delete error,perBankCardId is : {}", (Object)perBankCard.getString("id"));
                return;
            }
            if (PerBankcardServiceHelper.getUpdateSettingStatus().booleanValue() && !PerBankCardHelper.updatePaySetting((Long)perBankCardDetail.getLong("person.id"))) {
                LOGGER.info("updatePaySetting error");
            }
            this.embedPreView();
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private void embedPreView() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("hspp_bankcardperview");
        parameter.getOpenStyle().setShowType(ShowType.ReplaceHomePage);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

