/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.perbankcard;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.perbankcard.PerBankcardServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hspp.business.bankcard.PerBankCardConstants;
import kd.swc.hspp.business.bankcard.PerBankCardHelper;
import kd.swc.hspp.common.constants.BankCardStyleEnum;

public class PerBankCardPagePlugin
extends AbstractMobFormPlugin
implements PerBankCardConstants {
    private static final String OPENBANKCARD = "donothing_openbankcard";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        Map perBankCardParam = (Map)this.getView().getFormShowParameter().getCustomParam("bankCardInfo");
        this.setBankCardInfoToPage(perBankCardParam);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "donothing_openbankcard": {
                Map perBankCardParam = (Map)this.getView().getFormShowParameter().getCustomParam("bankCardInfo");
                this.embedViewDetailPage(perBankCardParam.getOrDefault("bankcardid", 0L));
                break;
            }
            case "donothing_refresh": {
                this.refreshPage();
                break;
            }
        }
    }

    private void refreshPage() {
        Map perBankCardParam = (Map)this.getView().getFormShowParameter().getCustomParam("bankCardInfo");
        Long perBankCardId = perBankCardParam.getOrDefault("bankcardid", 0L);
        SWCDataServiceHelper perBankCardHelper = new SWCDataServiceHelper("hrpi_perbankcard");
        QFilter idFilter = new QFilter("id", "=", (Object)perBankCardId);
        DynamicObject perBankCardObj = perBankCardHelper.queryOne("employee,person,bankcardnum,bankdeposit,username,accountrelation,cardpurpose,description", new QFilter[]{idFilter});
        perBankCardParam = PerBankCardHelper.getBankCardMap((DynamicObject)perBankCardObj);
        this.setBankCardInfoToPage(perBankCardParam);
        Boolean auditStatus = PerBankcardServiceHelper.getAuditStatus();
        if (auditStatus.booleanValue()) {
            IFormView preBankCardView = this.getView().getParentView();
            OperateOption option = OperateOption.create();
            option.setVariableValue("isNewShow", String.valueOf(auditStatus));
            preBankCardView.invokeOperation("donothing_refresh", option);
            this.getView().sendFormAction(preBankCardView);
        }
    }

    private void embedViewDetailPage(Long perBankCardId) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("hspp_perbankdetail");
        parameter.setCustomParam("bankcardid", (Object)perBankCardId);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setBankCardInfoToPage(Map<String, Object> perBankCardParam) {
        if (perBankCardParam == null) {
            return;
        }
        this.setBankCardInfo(perBankCardParam);
    }

    private void setBankCardInfo(Map<String, Object> perBankCardParam) {
        String bankName = (String)perBankCardParam.getOrDefault("bankname", "");
        this.setLabelValue("bankname", bankName);
        this.setLabelValue("username", (String)perBankCardParam.getOrDefault("username", ""));
        this.setLabelValue("bankcardnum", (String)perBankCardParam.getOrDefault("bankcardnum", ""));
        List cardPurposeList = (List)perBankCardParam.get("cardpurpose");
        if (cardPurposeList == null) {
            return;
        }
        this.setCardPurpose(cardPurposeList);
        this.setLogoAndBackgroundImg(bankName);
    }

    private void setCardPurpose(List<String> cardPurposeList) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardpurpose0"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardpurpose1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardpurpose2"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardpurpose3"});
        for (int index = 0; index < cardPurposeList.size(); ++index) {
            this.setLabelValue("cardpurpose" + index, cardPurposeList.get(index));
            this.getView().setVisible(Boolean.TRUE, new String[]{"cardpurpose" + index});
        }
        this.getView().setVisible(Boolean.valueOf(cardPurposeList.size() > 4), new String[]{"cardpurposemore"});
    }

    private void setLabelValue(String labKey, String value) {
        Label label = (Label)this.getView().getControl(labKey);
        if (label != null) {
            label.setText(value);
        }
    }

    private void setLogoAndBackgroundImg(String bankName) {
        String imgUrl = BankCardStyleEnum.getBankCardImgByBankName((String)bankName);
        ((Container)this.getView().getControl("contentflex")).setBackgroundImg(imgUrl);
    }
}

