/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.perbankcard;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.control.SWCFlexPanelAp;
import kd.swc.hsbp.common.control.SWCLabelAp;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.bankcard.PerBankCardConstants;
import kd.swc.hspp.business.bankcard.PerBankCardHelper;
import kd.swc.hspp.business.mservice.person.IPersonService;
import kd.swc.hspp.business.mservice.privary.IPrivacyService;
import kd.swc.hspp.business.mservice.salary.ISalaryPayService;
import kd.swc.hspp.business.permissions.PermissionHelper;

public class PerBankCardPreViewPlugin
extends AbstractMobFormPlugin
implements PerBankCardConstants {
    private static final Log LOGGER = LogFactory.getLog(PerBankCardPreViewPlugin.class);
    private static final String NULL_IMAGE = "/images/mobile/emotion/zanwuchaxunneirong_224_128.png";
    private static final String CREATECARD = "createcard";
    private static final String PRIVACYLAB = "privacylab";
    private static final String CLOSE_CALLBACK = "close_callback";

    public void beforeBindData(EventObject event) {
        Long personId = 0L;
        Tuple tuple = IPersonService.getInstance().getPersonInfo();
        if (((Boolean)tuple.item1).booleanValue()) {
            personId = ((Map)tuple.item2).getOrDefault("person", 0L);
        }
        SWCPageCache cache = new SWCPageCache(this.getView());
        cache.put("personId", (Object)personId);
        this.setPerBankCardInfo(personId);
        this.privacySearch();
        this.setEditBill(personId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "openprivacydetail": {
                this.privacyViewDetailPage();
                break;
            }
            case "donothing_disagree": {
                this.openParentView();
                break;
            }
            case "donothing_refresh": {
                SWCPageCache cache = new SWCPageCache(this.getView());
                this.privacySearch();
                Long personId = (Long)cache.get("personId", Long.class);
                this.setPerBankCardInfo(personId);
                this.setEditBillMsg(Boolean.valueOf(operate.getOption().getVariableValue("isNewShow", "false")));
                this.setEditBill(personId);
                break;
            }
            case "createcard": {
                this.embedViewDetailPage();
                break;
            }
            case "vieweditbill": {
                SWCPageCache cache = new SWCPageCache(this.getView());
                Long personId = (Long)cache.get("personId", Long.class);
                this.viewEditBillPage(personId);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "close_callback": {
                this.openParentView();
                break;
            }
        }
    }

    private void privacySearch() {
        String formId = this.getView().getFormShowParameter().getFormId();
        Tuple result = IPrivacyService.getInstance().queryPrivacy(formId, "getPrivacySigningList");
        if (((Boolean)result.item1).booleanValue()) {
            Map responseMap = null;
            try {
                responseMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)result.item2), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                LOGGER.error("JSON ERROR :", (Object)e.getMessage());
            }
            if (responseMap == null) {
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(CLOSE_CALLBACK);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"PerBankCardPreViewPlugin_3", (String)"swc-hspp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u9690\u79c1\u58f0\u660e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PerBankCardPreViewPlugin_2", (String)"swc-hspp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, ConfirmTypes.Default, callBackListener);
                return;
            }
            Object isAgree = responseMap.get("isAgree");
            String content = (String)responseMap.get("content");
            String name = ResManager.loadKDString((String)"\u9690\u79c1\u58f0\u660e", (String)"PerBankCardPreViewPlugin_5", (String)"swc-hspp-formplugin", (Object[])new Object[0]);
            this.getView().getPageCache().put("privacydetail", content);
            if (!"1".equals(isAgree)) {
                Object id = responseMap.get("id");
                if (content != null && id != null) {
                    MobileFormShowParameter showParameter = new MobileFormShowParameter();
                    showParameter.setFormId("hspp_privacybounced");
                    showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                    showParameter.getOpenStyle().setTargetKey("perchflex");
                    showParameter.setCustomParam("privacydetail", (Object)content);
                    showParameter.setCustomParam("privacyname", (Object)name);
                    showParameter.setCustomParam("privacyid", id);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"perchflex"});
            }
        } else {
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(CLOSE_CALLBACK);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"PerBankCardPreViewPlugin_3", (String)"swc-hspp-formplugin", (Object[])new Object[0]), result.item2.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, callBackListener);
        }
    }

    private void setEditBill(Long personId) {
        this.getView().setVisible(Boolean.valueOf(ISalaryPayService.getInstance().havePerBankCardEditBillByPersonId(personId)), new String[]{"vieweditbill"});
    }

    private void setEditBillMsg(Boolean isNewShow) {
        if (isNewShow.booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u94f6\u884c\u5361\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u53ef\u5728\u53d8\u66f4\u8bb0\u5f55\u4e2d\u67e5\u770b\u5ba1\u6279\u8fdb\u5ea6\u3002", (String)"PerBankCardPreViewPlugin_6", (String)"swc-hspp-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        }
    }

    private void setPerBankCardInfo(Long personId) {
        DynamicObject[] bankCards = this.getPerBankCardsByPersonId(personId);
        Label myPerBankCard = (Label)this.getControl("myperbankcard");
        myPerBankCard.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6211\u7684\u94f6\u884c\u5361 (%s)", (String)"PerBankCardPreViewPlugin_0", (String)"swc-hspp-formplugin", (Object[])new Object[0]), bankCards.length));
        if (bankCards.length == 0) {
            FlexPanelAp noticeFlex = this.createBlankSalarySlipNotice();
            this.getView().updateControlMetadata("bankcardsinfo", noticeFlex.createControl());
            return;
        }
        FlexPanelAp bankCardInfoAp = this.createParentFlexPanelAp();
        for (DynamicObject bankCard : bankCards) {
            this.createBankCardPageFlex(bankCard, bankCardInfoAp);
            this.openPerBankCardForm(bankCard.getString("id"), bankCard);
        }
        this.getView().updateControlMetadata("bankcardsinfo", bankCardInfoAp.createControl());
    }

    private void openPerBankCardForm(String bankCardId, DynamicObject perBankCard) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setTargetKey(bankCardId);
        parameters.getOpenStyle().setShowType(ShowType.InContainer);
        parameters.setFormId("hspp_perbankcard");
        parameters.setCustomParam("bankCardInfo", (Object)PerBankCardHelper.getBankCardMap((DynamicObject)perBankCard));
        this.getView().showForm(parameters);
    }

    private FlexPanelAp createBlankSalarySlipNotice() {
        FlexPanelAp panelAp = ((SWCFlexPanelAp.Builder)new SWCFlexPanelAp.Builder("bankcardsinfo").setWrap(false).setDirection("column").setAlignItems("center").setFontSize(14).setGrow(1).setShrink(1).setPaddingTop("165px")).build();
        ImageAp imageAp = new ImageAp();
        imageAp.setKey("imageap_notice");
        imageAp.setImageKey(NULL_IMAGE);
        imageAp.setWidth(new LocaleString("224px"));
        imageAp.setHeight(new LocaleString("128px"));
        panelAp.getItems().add(imageAp);
        LabelAp labelAp = ((SWCLabelAp.Builder)new SWCLabelAp.Builder("labelap_notice").setFontSize(15).setForeColor("#666666").setName(ResManager.loadKDString((String)"\u6682\u65e0\u94f6\u884c\u5361", (String)"PerBankCardPreViewPlugin_1", (String)"swc-hspp-formplugin", (Object[])new Object[0])).setMarginTop("13px")).build();
        panelAp.getItems().add(labelAp);
        return panelAp;
    }

    private FlexPanelAp createParentFlexPanelAp() {
        return new SWCFlexPanelAp.Builder("bankcardsinfo").setWrap(false).setDirection("column").setAlignItems("center").setGrow(1).setShrink(1).setHeight("300px").build();
    }

    private void createBankCardPageFlex(DynamicObject perBankCard, FlexPanelAp bankCardAp) {
        String bankCardId = perBankCard.getString("id");
        FlexPanelAp panelAp = ((SWCFlexPanelAp.Builder)new SWCFlexPanelAp.Builder(bankCardId).setWidth("327px").setHeight("180px").setMargin("0px", "0px", "16px", "0px")).setRadius("16px").setDirection("column").setAlignItems("center").setFontSize(14).setGrow(0).setShrink(0).build();
        bankCardAp.getItems().add(panelAp);
    }

    private DynamicObject[] getPerBankCardsByPersonId(Long personId) {
        SWCDataServiceHelper bankHelper = new SWCDataServiceHelper("hrpi_perbankcard");
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter deleteFilter = new QFilter("isdelete", "=", (Object)"0");
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return bankHelper.query("bankdeposit,bankcardnum,username,accountrelation,cardpurpose", new QFilter[]{personFilter, deleteFilter, isCurrentVersionFilter}, "createtime desc");
    }

    private void embedViewDetailPage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("hspp_perbankdetail");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void privacyViewDetailPage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("hspp_privacystatement");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setCustomParam("issigned", (Object)Boolean.TRUE);
        parameter.setCustomParam("privacydetail", (Object)this.getView().getPageCache().get("privacydetail"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void viewEditBillPage(Long personId) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("hspp_bankcardbillperview");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setCustomParam("personId", (Object)personId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void openParentView() {
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (SWCStringUtils.isEmpty((String)parentFormId)) {
            PermissionHelper.setErrorPageInfo((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u65e0\u6cd5\u67e5\u770b\u201c\u6211\u7684\u94f6\u884c\u5361\u201d\uff0c\u8bf7\u7b7e\u7f72\u9690\u79c1\u58f0\u660e\u540e\u5237\u65b0\u91cd\u8bd5\u3002", (String)"PerBankCardPreViewPlugin_4", (String)"swc-hspp-formplugin", (Object[])new Object[0]), (String)NULL_IMAGE, (Boolean)Boolean.TRUE);
            return;
        }
        this.getView().close();
    }
}

