/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.perbankcard;

import java.text.MessageFormat;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Html;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.swc.hspp.business.bankcard.PerBankCardConstants;
import kd.swc.hspp.business.mservice.privary.IPrivacyService;

public class PrivacyBouncedPlugin
extends AbstractMobFormPlugin
implements PerBankCardConstants {
    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.setPrivacyConfirm();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "openprivacydetail": {
                this.privacyViewDetailPage();
                break;
            }
            case "donothing_agree": {
                this.agreePrivacy();
                break;
            }
            case "donothing_disagree": {
                this.getView().getParentView().invokeOperation("donothing_disagree");
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
        }
    }

    private void agreePrivacy() {
        Object privacyId = this.getView().getFormShowParameter().getCustomParam("privacyid");
        if (privacyId instanceof Long) {
            Tuple result = IPrivacyService.getInstance().signPrivacy((Long)privacyId);
            if (!((Boolean)result.item1).booleanValue()) {
                String errMsg = result.item2 == null ? ResManager.loadKDString((String)"\u7b7e\u7f72\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PrivacyBouncedPlugin_0", (String)"swc-hspp-formplugin", (Object[])new Object[0]) : String.valueOf(result.item2);
                this.getView().showErrorNotification(errMsg);
            }
            this.getView().getParentView().invokeOperation("donothing_refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void setPrivacyConfirm() {
        Html html = (Html)this.getView().getControl("htmlap");
        String privacy = (String)this.getView().getFormShowParameter().getCustomParams().get("privacyname");
        privacy = privacy.length() > 15 ? privacy.substring(0, 15) + "..." : privacy;
        String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\u60a8\u7ef4\u62a4\u7684\u94f6\u884c\u5361\u5c06\u7528\u4e8e\u85aa\u8d44\u53d1\u653e\u3002\u8bf7\u4ed4\u7ec6\u9605\u8bfb{1}\u3002\u5982\u60a8\u540c\u610f\uff0c\u70b9\u51fb\u201c\u540c\u610f\u201d\u53ef\u8fdb\u884c\u94f6\u884c\u5361\u4fe1\u606f\u7ef4\u62a4\u3002{2}", (String)"PrivacyBouncedPlugin_1", (String)"swc-hspp-formplugin", (Object[])new Object[0]), "<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%;color:#404040'>", "<span style='font-size:14px;color:#276FF5;margin-left: 5px;margin-right: 5px'>" + privacy + "</span>", "</div>");
        html.setConent(msg);
    }

    private void privacyViewDetailPage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("hspp_privacystatement");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setCustomParam("issigned", (Object)Boolean.FALSE);
        parameter.setCustomParam("privacydetail", this.getView().getFormShowParameter().getCustomParams().get("privacydetail"));
        parameter.setCustomParam("privacyid", this.getView().getFormShowParameter().getCustomParams().get("privacyid"));
        this.getView().showForm((FormShowParameter)parameter);
    }
}

