/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.perbankcard;

import java.util.EventObject;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.swc.hspp.business.bankcard.PerBankCardConstants;
import kd.swc.hspp.business.mservice.privary.IPrivacyService;
import kd.swc.hspp.business.mservice.privary.PrivacyServiceHelper;

public class PrivacyDetailPlugin
extends AbstractMobFormPlugin
implements PerBankCardConstants {
    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        PrivacyServiceHelper service = new PrivacyServiceHelper();
        service.setContent(this.getView());
        Boolean isSigned = (Boolean)this.getView().getFormShowParameter().getCustomParam("issigned");
        this.btnControl(isSigned);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "donothing_agree": {
                this.agreePrivacy();
                break;
            }
            case "donothing_disagree": {
                this.disagreePrivacy();
                break;
            }
        }
    }

    private void agreePrivacy() {
        Object privacyId = this.getView().getFormShowParameter().getCustomParam("privacyid");
        if (privacyId instanceof Long) {
            Tuple result = IPrivacyService.getInstance().signPrivacy((Long)privacyId);
            if (!((Boolean)result.item1).booleanValue()) {
                String errMsg = result.item2 == null ? ResManager.loadKDString((String)"\u7b7e\u7f72\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PrivacyDetailPlugin_0", (String)"swc-hspp-formplugin", (Object[])new Object[0]) : String.valueOf(result.item2);
                this.getView().showErrorNotification(errMsg);
            }
            this.openPerBankCardView();
        }
    }

    private IFormView getPreBankCardView() {
        String entityId = this.getView().getParentView().getEntityId();
        return "hspp_bankcardperview".equals(entityId) ? this.getView().getParentView() : this.getView().getParentView().getParentView();
    }

    private void disagreePrivacy() {
        IFormView preBankCardView = this.getPreBankCardView();
        preBankCardView.invokeOperation("donothing_disagree");
        this.getView().sendFormAction(preBankCardView);
        this.getView().close();
    }

    private void openPerBankCardView() {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("hspp_bankcardperview");
        showParameter.getOpenStyle().setShowType(ShowType.ReplaceHomePage);
        showParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void btnControl(Boolean isSigned) {
        this.getView().setVisible(Boolean.valueOf(isSigned == false), new String[]{"btnok", "btnno"});
        this.getView().setVisible(isSigned, new String[]{"btnback"});
    }
}

