/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.perbankcard.editbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.workflow.component.IApprovalRecord;
import kd.swc.hsbp.common.control.SWCLabelAp;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.bankcard.EditBillConstants;
import kd.swc.hspp.business.bankcard.PerBankCardHelper;
import kd.swc.hspp.business.mservice.salary.ISalaryPayService;
import kd.swc.hspp.business.permissions.PermissionHelper;

public class EditBillDetailPlugin
extends AbstractMobFormPlugin
implements EditBillConstants {
    public void afterBindData(EventObject event) {
        boolean havePermission = PermissionHelper.isHavePermission((String)"hspp_bankcardperview", (String)"47150e89000000ac");
        PermissionHelper.setPagePermStatus((IFormView)this.getView(), (Boolean)havePermission, (String)ResManager.loadKDString((String)"\u6211\u7684\u94f6\u884c\u5361", (String)"PerBankCardDetailPlugin_9", (String)"swc-hspp-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"PerBankCardDetailPlugin_11", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
        if (!havePermission) {
            return;
        }
        Long billId = (Long)ObjectConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("id"), Long.class, (boolean)true);
        this.setInitField(billId);
    }

    private void setInitField(Long billId) {
        String msg;
        DynamicObject billData = ISalaryPayService.getInstance().getPerBankCardEditBillDetailById(billId);
        if (billData == null) {
            return;
        }
        String editType = billData.getString("edittype");
        this.getModel().setValue("billno", (Object)billData.getString("billno"));
        this.getModel().setValue("createtime", (Object)billData.getDate("createtime"));
        this.getModel().setValue("edittype", (Object)editType);
        this.setWfsRecord(String.valueOf(billId));
        ArrayList statusList = new ArrayList(STATUSLIST);
        statusList.remove(billData.getString("billstatus"));
        this.getView().setVisible(Boolean.FALSE, (String[])statusList.stream().map(String::toLowerCase).toArray(String[]::new));
        DynamicObjectCollection entryEntity = billData.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            this.buildViewByEditType(editType, (DynamicObject)entryEntity.get(0));
        }
        if (SWCStringUtils.isNotEmpty((String)(msg = billData.getString("failmsg")))) {
            this.getView().showErrorNotification(msg);
        }
        this.getView().updateView("contentflex");
        this.setAttachment(billId);
    }

    private void setAttachment(Long billId) {
        List attachmentData = AttachmentServiceHelper.getAttachments((String)"hsas_perbceditbill", (Object)billId, (String)"attachmentpanel");
        AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachment");
        attachment.bindData(attachmentData);
    }

    private void setWfsRecord(String billId) {
        IApprovalRecord approvalRecord = (IApprovalRecord)this.getControl("approvalrecord");
        if (null != approvalRecord) {
            HashMap<String, String> shareParams = new HashMap<String, String>(16);
            shareParams.put("isPC", "false");
            approvalRecord.setParameters(shareParams);
            approvalRecord.setBusinessKey(billId);
        }
    }

    private void buildViewByEditType(String editType, DynamicObject billDataEntry) {
        HashMap<String, Consumer<DynamicObject>> editTypeMap = new HashMap<String, Consumer<DynamicObject>>(16);
        editTypeMap.put("0", this::buildViewEditTypeNew);
        editTypeMap.put("1", this::buildViewEditTypeEdit);
        Consumer function = (Consumer)editTypeMap.get(editType);
        if (function != null) {
            function.accept(billDataEntry);
        }
    }

    private void buildViewEditTypeNew(DynamicObject billDataEntry) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"editflex"});
        this.getModel().setValue("bankcardnum", (Object)billDataEntry.getString("modifybankaccount"));
        this.getModel().setValue("bankdeposit", billDataEntry.get("modifybank"));
        this.getModel().setValue("username", (Object)billDataEntry.getString("modifyreceivername"));
        this.getModel().setValue("accountrelation", billDataEntry.get("modifyreltype"));
        this.getModel().setValue("cardpurpose", billDataEntry.get("modifycardpurposemul"));
        this.getModel().setValue("description", (Object)billDataEntry.getString("description"));
    }

    private void buildViewEditTypeEdit(DynamicObject billDataEntry) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"newflex"});
        DynamicObject bankCard = billDataEntry.getDynamicObject("perbankcard");
        if (bankCard != null) {
            String modifyBankAccount = billDataEntry.getString("modifybankaccount");
            String bankCardNum = bankCard.getString("bankcardnum");
            this.setLabel("bankcardnumafter", bankCardNum.equals(modifyBankAccount), PerBankCardHelper.formattingBankCardNum((String)modifyBankAccount));
            this.setLabel("bankcardnumbefore", true, PerBankCardHelper.formattingBankCardNum((String)bankCardNum));
            Long modifyBankId = billDataEntry.getLong("modifybank.id");
            Long bankId = bankCard.getLong("bankdeposit.id");
            this.setLabel("bankdepositafter", bankId.equals(modifyBankId), billDataEntry.getString("modifybank.name"));
            this.setLabel("bankdepositbefore", true, bankCard.getString("bankdeposit.name"));
            String modifyReceiverName = billDataEntry.getString("modifyreceivername");
            String userName = bankCard.getString("username");
            this.setLabel("usernameafter", userName.equals(modifyReceiverName), modifyReceiverName);
            this.setLabel("usernamebefore", true, userName);
            Long modifyRelTypeId = billDataEntry.getLong("modifyreltype.id");
            Long relationId = bankCard.getLong("accountrelation.id");
            this.setLabel("accountrelationafter", relationId.equals(modifyRelTypeId), billDataEntry.getString("modifyreltype.name"));
            this.setLabel("accountrelationbefore", true, bankCard.getString("accountrelation.name"));
            DynamicObjectCollection modifyCardpurposeCol = billDataEntry.getDynamicObjectCollection("modifycardpurposemul");
            DynamicObjectCollection cardpurposeCol = bankCard.getDynamicObjectCollection("cardpurpose");
            Set modifyCardIdSet = modifyCardpurposeCol.stream().map(data -> data.getLong("fbasedataid_id")).collect(Collectors.toSet());
            List modifyCardNameList = modifyCardpurposeCol.stream().map(data -> data.getString("fbasedataid.name")).collect(Collectors.toList());
            Set cardIdSet = cardpurposeCol.stream().map(data -> data.getLong("fbasedataid_id")).collect(Collectors.toSet());
            List cardNameList = cardpurposeCol.stream().map(data -> data.getString("fbasedataid.name")).collect(Collectors.toList());
            this.setLabel("cardpurposeafter", cardIdSet.equals(modifyCardIdSet), String.join((CharSequence)" ; ", modifyCardNameList));
            this.setLabel("cardpurposebefore", true, String.join((CharSequence)" ; ", cardNameList));
            String modifyDescription = billDataEntry.getString("description");
            String description = bankCard.getString("description");
            this.setLabel("descriptionafter", SWCStringUtils.equals((String)description, (String)modifyDescription), modifyDescription);
            this.setLabel("descriptionbefore", true, description);
        }
    }

    private void setLabel(String key, boolean isEdit, String content) {
        LabelAp label = new SWCLabelAp.Builder(key).setFontSize(14).build();
        label.setForeColor(isEdit ? "#212121" : "#276FF5");
        label.setName(SWCStringUtils.isNotEmpty((String)content) ? new LocaleString(content) : new LocaleString("-"));
        this.getView().updateControlMetadata(label.getKey(), label.createControl());
    }
}

