/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.formplugin.web.perbankcard.editbill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.bankcard.EditBillConstants;
import kd.swc.hspp.business.mservice.person.IPersonService;
import kd.swc.hspp.business.mservice.salary.ISalaryPayService;
import kd.swc.hspp.business.permissions.PermissionHelper;
import kd.swc.hspp.business.viewhelper.EntryHelper;

public class EditBillPerviewPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener,
EditBillConstants {
    public void registerListener(EventObject event) {
        super.registerListener(event);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject event) {
        super.afterBindData(event);
        boolean havePermission = PermissionHelper.isHavePermission((String)"hspp_bankcardperview", (String)"47150e89000000ac");
        PermissionHelper.setPagePermStatus((IFormView)this.getView(), (Boolean)havePermission, (String)ResManager.loadKDString((String)"\u6211\u7684\u94f6\u884c\u5361", (String)"PerBankCardDetailPlugin_9", (String)"swc-hspp-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"PerBankCardDetailPlugin_11", (String)"swc-hspp-formplugin", (Object[])new Object[0]));
        if (!havePermission) {
            return;
        }
        this.initData();
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (SWCStringUtils.equals((String)"entryentity", (String)entryGrid.getKey())) {
            Long billId = entryGrid.getEntryData().getDataEntitys()[evt.getRow()].getLong("id");
            this.openDetailPage(billId);
            this.getView().invokeOperation("open");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String formOp = ((FormOperate)args.getSource()).getOperateKey();
        if ("refresh".equals(formOp)) {
            this.initData();
        }
    }

    private void initData() {
        DynamicObjectCollection billCol;
        Long personId = (Long)ObjectConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("personId"), Long.class, (boolean)true);
        if (personId == null || personId == 0L) {
            Tuple tuple = IPersonService.getInstance().getPersonInfo();
            if (((Boolean)tuple.item1).booleanValue()) {
                personId = ((Map)tuple.item2).getOrDefault("person", 0L);
            }
        }
        if ((billCol = ISalaryPayService.getInstance().getPerBankCardEditBillByPersonId(personId)).isEmpty()) {
            return;
        }
        EntryHelper.deleteEntry((IDataModel)this.getModel(), (String)"entryentity", null);
        ArrayList fieldMapList = new ArrayList(billCol.size());
        billCol.forEach(billData -> {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
            fieldMap.put("id", billData.getLong("id"));
            fieldMap.put("billno", billData.getString("billno"));
            fieldMap.put("createtime", billData.getDate("createtime"));
            fieldMap.put("edittype", billData.getString("edittype"));
            fieldMap.put("billstatus", billData.getString("billstatus"));
            fieldMapList.add(fieldMap);
        });
        EntryHelper.batchCreateNewEntryRow((IFormView)this.getView(), (String)"entryentity", fieldMapList);
        this.setCardEntryStatus();
    }

    private void setCardEntryStatus() {
        DynamicObjectCollection billCol = this.getModel().getEntryEntity("entryentity");
        CardEntry entry = (CardEntry)this.getControl("entryentity");
        for (int index = 0; index < billCol.size(); ++index) {
            String billStatus = ((DynamicObject)billCol.get(index)).getString("billstatus");
            ArrayList statusList = new ArrayList(STATUSLIST);
            statusList.remove(billStatus);
            List<String> labList = statusList.stream().map(String::toLowerCase).collect(Collectors.toList());
            EntryHelper.setCardEntryChildVisible((CardEntry)entry, (boolean)false, (int)index, (String[])labList.toArray(new String[0]));
        }
    }

    private void openDetailPage(Long billId) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setCustomParam("id", (Object)billId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId("hspp_bankcardbilldetail");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

