/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.common.constants;

import kd.hr.hbp.common.model.MultiLangEnumBridge;
import kd.swc.hsbp.common.util.SWCStringUtils;

public enum BankCardStyleEnum {
    CCB(new MultiLangEnumBridge("\u5efa\u8bbe\u94f6\u884c", "BankCardStyleEnum_0", "swc-hspp-common"), "/images/mobile/business_pic/jianshe_327_180.png"),
    CMB(new MultiLangEnumBridge("\u62db\u5546\u94f6\u884c", "BankCardStyleEnum_1", "swc-hspp-common"), "/images/mobile/business_pic/zhaoshang_327_180.png"),
    PSBC(new MultiLangEnumBridge("\u90ae\u653f\u50a8\u84c4\u94f6\u884c", "BankCardStyleEnum_2", "swc-hspp-common"), "/images/mobile/business_pic/youzheng_327_180.png"),
    ICBC(new MultiLangEnumBridge("\u5de5\u5546\u94f6\u884c", "BankCardStyleEnum_3", "swc-hspp-common"), "/images/mobile/business_pic/gongshangf_327_180.png"),
    BOC(new MultiLangEnumBridge("\u4e2d\u56fd\u94f6\u884c", "BankCardStyleEnum_5", "swc-hspp-common"), "/images/mobile/business_pic/zhongguo_327_180.png"),
    OTHER(new MultiLangEnumBridge("\u5176\u4ed6\u94f6\u884c", "BankCardStyleEnum_4", "swc-hspp-common"), "/images/mobile/business_pic/qita1_327_180.png");

    private MultiLangEnumBridge bankName;
    private String bankCardImg;

    private BankCardStyleEnum(MultiLangEnumBridge bankName, String bankCardImg) {
        this.bankName = bankName;
        this.bankCardImg = bankCardImg;
    }

    public String getBankNameString() {
        return this.bankName.loadKDString();
    }

    public String getBankCardImg() {
        return this.bankCardImg;
    }

    public static String getBankCardImgByBankName(String bankName) {
        BankCardStyleEnum[] bankCardStyleEnumArr;
        if (SWCStringUtils.isEmpty((String)bankName)) {
            return OTHER.getBankCardImg();
        }
        for (BankCardStyleEnum bankCardStyleEnum : bankCardStyleEnumArr = BankCardStyleEnum.values()) {
            if (!bankName.contains(bankCardStyleEnum.getBankNameString())) continue;
            return bankCardStyleEnum.getBankCardImg();
        }
        return OTHER.getBankCardImg();
    }
}

