/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.bankcard;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.ORM;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.bankcard.PerBankCardConstants;
import kd.swc.hspp.business.mservice.person.IPersonService;
import kd.swc.hspp.business.mservice.salary.ISalaryPayService;

public class PerBankCardHelper
implements PerBankCardConstants {
    private static final String ENCRYPTION_STRING = "**";
    private static final String KEY_ADD_PER_BANK_CARD = "addPerBankCardResult";
    private static final String KEY_MODIFY_PER_BANK_CARD = "modifyPerBankCardResult";

    public static Map<String, Object> getBankCardMap(DynamicObject perBankCard) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("bankcardid", perBankCard.getLong("id"));
        map.put("bankid", perBankCard.getLong("bankdeposit.id"));
        map.put("bankname", perBankCard.getString("bankdeposit.name"));
        map.put("bankcardnum", PerBankCardHelper.encryptionBankCardName(perBankCard.getString("bankcardnum")));
        map.put("cardpurpose", perBankCard.getDynamicObjectCollection("cardpurpose").stream().filter(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid") != null).map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList()));
        String userName = PerBankCardHelper.encryptionName(perBankCard.getString("username"));
        if (perBankCard.getString("accountrelation.name") != null) {
            userName = userName + "\uff08" + perBankCard.getString("accountrelation.name") + "\uff09";
        }
        map.put("username", userName);
        return map;
    }

    public static OperationResult abandonEditBill(Long bankCardId) {
        return ISalaryPayService.getInstance().abandonEditBillByPerBankCardId(bankCardId);
    }

    public static boolean updatePaySetting(Long personId) {
        return ISalaryPayService.getInstance().synUpdatePaySetting(personId);
    }

    public static OperationResult savePerBankCard(List<Map<String, Object>> attachmentData, DynamicObject perBankCardDetail) {
        long bankCardId;
        String methodKey;
        DynamicObject perBankCard = perBankCardDetail.getDynamicObject("perbankcard");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (perBankCard != null) {
            methodKey = KEY_MODIFY_PER_BANK_CARD;
            bankCardId = perBankCard.getLong("id");
            map.put("boid", perBankCard.getLong("boid"));
            map.put("number", perBankCard.getString("number"));
            attachmentData.forEach(data -> data.put("entityNum", "hrpi_perbankcard"));
        } else {
            methodKey = KEY_ADD_PER_BANK_CARD;
            bankCardId = ORM.create().genLongId("hrpi_perbankcard");
        }
        map.put("id", bankCardId);
        map.put("username", perBankCardDetail.getString("usernameedit"));
        map.put("bankdeposit.id", perBankCardDetail.getLong("bankdepositedit.id"));
        List cardPurposeList = perBankCardDetail.getDynamicObjectCollection("cardpurposeedit").stream().map(data -> data.getLong("fbasedataid_id")).collect(Collectors.toList());
        map.put("cardpurpose.id", cardPurposeList);
        map.put("accountrelation.id", perBankCardDetail.getLong("accountrelationedit.id"));
        map.put("bankcardnum", perBankCardDetail.getString("bankcardnumedit"));
        map.put("description", perBankCardDetail.getString("descriptionedit"));
        map.put("person.id", perBankCardDetail.getLong("person.id"));
        map.put("employee.id", perBankCardDetail.getLong("employee.id"));
        map.put("attachment", attachmentData);
        HashMap<String, Object> bankcardParam = new HashMap<String, Object>(16);
        bankcardParam.put("dataList", Collections.singletonList(map));
        return IPersonService.getInstance().opPerBankCard(methodKey, bankcardParam);
    }

    private static String encryptionName(String name) {
        int length;
        String encryptionName = name == null || (length = name.length()) < 2 ? ENCRYPTION_STRING : ENCRYPTION_STRING + name.substring(length - 1);
        return encryptionName;
    }

    private static String encryptionBankCardName(String name) {
        int length;
        String bankNumberEncrypt = "****";
        String encryptionName = name == null || (length = name.length()) <= 8 ? bankNumberEncrypt : name.substring(0, 4) + bankNumberEncrypt + " " + bankNumberEncrypt + name.substring(length - 4);
        return encryptionName;
    }

    public static String formattingBankCardNum(String bankCardNum) {
        String str = "";
        if (SWCStringUtils.isNotEmpty((String)bankCardNum)) {
            if (bankCardNum.length() >= 4) {
                str = bankCardNum.substring(0, 4) + " ";
                String substring = bankCardNum.substring(4);
                str = str + PerBankCardHelper.formattingBankCardNum(substring);
            } else {
                str = str + bankCardNum;
            }
        }
        return str;
    }
}

