/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.bankcard.savestrategy;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.perbankcard.PerBankcardServiceHelper;
import kd.swc.hspp.business.bankcard.PerBankCardHelper;
import kd.swc.hspp.business.bankcard.savestrategy.BaseSaveStrategy;

public class DirectSaveStrategy
implements BaseSaveStrategy {
    private static final Log LOGGER = LogFactory.getLog(DirectSaveStrategy.class);

    @Override
    public Boolean dealData(IFormView view, DynamicObject perBankCardDetail) {
        OperationResult operationResult;
        DynamicObject perBankCard = perBankCardDetail.getDynamicObject("perbankcard");
        if (!(perBankCard == null || (operationResult = PerBankCardHelper.abandonEditBill(perBankCard.getLong("id"))) != null && operationResult.isSuccess())) {
            if (operationResult != null) {
                view.showOperationResult(operationResult);
            }
            LOGGER.info("abandonEditBill error,perBankCardId is {}", (Object)perBankCard.getString("id"));
            return false;
        }
        AttachmentPanel att = (AttachmentPanel)view.getControl("attachment");
        List attachmentData = att.getAttachmentData();
        OperationResult operationResult2 = PerBankCardHelper.savePerBankCard(attachmentData, perBankCardDetail);
        if (operationResult2 == null || !operationResult2.isSuccess()) {
            if (operationResult2 != null) {
                view.showOperationResult(operationResult2);
            }
            LOGGER.info("savePerBankCard error");
            return false;
        }
        if (PerBankcardServiceHelper.getUpdateSettingStatus().booleanValue() && !PerBankCardHelper.updatePaySetting(perBankCardDetail.getLong("person.id"))) {
            LOGGER.info("updatePaySetting error");
        }
        return true;
    }
}

