/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.bankcard.savestrategy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.orm.ORM;
import kd.swc.hspp.business.bankcard.savestrategy.BaseSaveStrategy;
import kd.swc.hspp.business.mservice.salary.ISalaryPayService;

public class SubmitEditBillStrategy
implements BaseSaveStrategy {
    @Override
    public Boolean dealData(IFormView view, DynamicObject perBankCardDetail) {
        AttachmentPanel att = (AttachmentPanel)view.getControl("attachment");
        List attachmentData = att.getAttachmentData();
        Map<String, Object> param = this.buildParam(attachmentData, perBankCardDetail);
        OperationResult operationResult = ISalaryPayService.getInstance().abandonAndSubmitNewEditBill(param);
        if (!operationResult.isSuccess()) {
            view.showOperationResult(operationResult);
        }
        return operationResult.isSuccess();
    }

    private Map<String, Object> buildParam(List<Map<String, Object>> attachmentData, DynamicObject perBankCardDetail) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject perBankCard = perBankCardDetail.getDynamicObject("perbankcard");
        Long bankCardEditBillId = ORM.create().genLongId("hsas_perbceditbill");
        String editType = perBankCard == null ? "0" : "1";
        map.put("id", bankCardEditBillId);
        map.put("edittype", editType);
        map.put("person", perBankCardDetail.getLong("person.id"));
        map.put("employee", perBankCardDetail.getLong("employee.id"));
        HashMap<String, Object> bankCardMap = new HashMap<String, Object>(16);
        bankCardMap.put("perbankcard.id", perBankCard == null ? 0L : perBankCard.getLong("id"));
        bankCardMap.put("perbankcard.vid", perBankCard == null ? 0L : perBankCard.getLong("sourcevid"));
        bankCardMap.put("username", perBankCardDetail.getString("usernameedit"));
        bankCardMap.put("bankdeposit.id", perBankCardDetail.getLong("bankdepositedit.id"));
        List cardPurposeList = perBankCardDetail.getDynamicObjectCollection("cardpurposeedit").stream().map(data -> data.getLong("fbasedataid_id")).collect(Collectors.toList());
        bankCardMap.put("cardpurpose.id", cardPurposeList);
        bankCardMap.put("accountrelation.id", perBankCardDetail.getLong("accountrelationedit.id"));
        bankCardMap.put("bankcardnum", perBankCardDetail.getString("bankcardnumedit"));
        bankCardMap.put("description", perBankCardDetail.getString("descriptionedit"));
        bankCardMap.put("person.id", perBankCardDetail.getLong("person.id"));
        bankCardMap.put("employee.id", perBankCardDetail.getLong("employee.id"));
        bankCardMap.put("attachment", attachmentData);
        map.put("bankcard", bankCardMap);
        return map;
    }
}

