/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.cronjob;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class SalaryCalendarUpdatePayDateTask
extends AbstractTask {
    private static Log LOGGER = LogFactory.getLog(SalaryCalendarUpdatePayDateTask.class);
    private static final int BATCH_SIZE = 5000;
    private static final String TABLE_NAME = "t_hspp_salarycalendar";
    private static final String SQL = "select sc.fid,sss.fslipid  from t_hspp_salarycalendar sc left join t_hspp_salaryslipstatus sss on sc.fid=sss.fsalarycalendarid where sc.fpaydate is null";
    private DataSet rows = null;
    private int queryBatch = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        try {
            boolean flag = true;
            while (flag) {
                flag = this.updateSalaryCalendarPayDate();
            }
        }
        catch (Exception e) {
            LOGGER.error("SalaryCalendarUpdatePayDateTask execute error:", (Throwable)e);
        }
        finally {
            this.disableTask();
        }
        LOGGER.info("SalaryCalendarUpdatePayDateTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private boolean updateSalaryCalendarPayDate() {
        LOGGER.info("start to deal SalaryCalendar \uff1a{}", (Object)TABLE_NAME);
        if (this.rows == null) {
            this.rows = DB.queryDataSet((String)"querySalaryCalendarSQl", (DBRoute)SWCConstants.HSPP_ROUETE, (String)SQL);
        }
        if (this.queryBatch >= 1000) {
            this.rows.close();
            this.rows = DB.queryDataSet((String)"querySalaryCalendarSQl", (DBRoute)SWCConstants.HSPP_ROUETE, (String)SQL);
            this.queryBatch = 0;
            LOGGER.info("\u5b8c\u62101000\u6279\u6b21\u67e5\u8be2\u540e,dataset\u8fdb\u884c\u91cd\u7f6e,\u9632\u6b62\u8d85\u65f6!");
        }
        if (!this.rows.hasNext()) {
            return false;
        }
        HashMap<Long, Long> slipCarMap = new HashMap<Long, Long>(16);
        ArrayList<Long> slipids = new ArrayList<Long>(10);
        int count = 0;
        while (this.rows.hasNext()) {
            Row row = this.rows.next();
            Long fslipid = row.getLong("fslipid");
            slipCarMap.put(row.getLong("fid"), fslipid);
            if (fslipid != 0L) {
                slipids.add(fslipid);
            }
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryslip");
        QFilter pFilter = new QFilter("id", "in", slipids);
        DynamicObjectCollection slipCol = helper.queryOriginalCollection("id,caltask.id", new QFilter[]{pFilter});
        HashMap<Long, Long> salarySlipStatusMapTaskId = new HashMap<Long, Long>(slipCol.size());
        for (DynamicObject dynamicObject : slipCol) {
            salarySlipStatusMapTaskId.put(dynamicObject.getLong("id"), dynamicObject.getLong("caltask.id"));
        }
        helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter calPayRollTaskFilter = new QFilter("id", "in", salarySlipStatusMapTaskId.values());
        DynamicObjectCollection calPayRollTasks = helper.queryOriginalCollection("id,paydate", new QFilter[]{calPayRollTaskFilter});
        HashMap<Long, Date> calPayRollTaskMapPayDate = new HashMap<Long, Date>(calPayRollTasks.size());
        for (DynamicObject calPayRollTask : calPayRollTasks) {
            calPayRollTaskMapPayDate.put(calPayRollTask.getLong("id"), calPayRollTask.getDate("paydate"));
        }
        String updateSql = "update t_hspp_salarycalendar set fpaydate = ? where fid = ?";
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(10);
        for (Map.Entry entry : slipCarMap.entrySet()) {
            Long salarySlipStatusId = (Long)entry.getValue();
            Long taskId = (Long)salarySlipStatusMapTaskId.get(salarySlipStatusId);
            if (taskId != null && taskId != 0L) {
                Object[] obj;
                Date payDate = (Date)calPayRollTaskMapPayDate.get(taskId);
                if (payDate != null) {
                    obj = new Object[]{payDate, entry.getKey()};
                    updateList.add(obj);
                    continue;
                }
                obj = new Object[]{new Timestamp(SWCDateTimeUtils.getMaxBsled().getTime()), entry.getKey()};
                updateList.add(obj);
                continue;
            }
            Object[] obj = new Object[]{new Timestamp(SWCDateTimeUtils.getMaxBsled().getTime()), entry.getKey()};
            updateList.add(obj);
        }
        DB.executeBatch((DBRoute)SWCConstants.HSPP_ROUETE, (String)updateSql, updateList);
        return true;
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

