/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.cronjob;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.encrypt.MultiEncryptNewService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.dto.salary.SummaryInfoDTO;
import kd.swc.hsbp.common.enums.EncryptLevelEnum;
import kd.swc.hsbp.common.enums.EncryptTypeEnum;
import kd.swc.hsbp.common.util.SWCListUtils;

public class SalaryCalendarUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(SalaryCalendarUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_salaryslipstatus");
            String selectProperties = "id,salarycalendar.id,slip.id,salarycalendar.salaryslipdata";
            QFilter filter = new QFilter("salarycalendar.payrollgrp", "is null", null);
            filter.or(new QFilter("salarycalendar.payrollgrp", "=", (Object)0L));
            DynamicObjectCollection statusCol = helper.queryOriginalCollection(selectProperties, new QFilter[]{filter});
            if (statusCol == null || statusCol.size() == 0) {
                return;
            }
            HashBiMap slipCarMap = HashBiMap.create();
            for (DynamicObject statusDy : statusCol) {
                slipCarMap.put((Object)statusDy.getLong("slip.id"), (Object)statusDy.getLong("salarycalendar.id"));
            }
            helper = new SWCDataServiceHelper("hsas_salaryslip");
            QFilter pFilter = new QFilter("id", "in", (Object)slipCarMap.keySet());
            DynamicObjectCollection slipCol = helper.queryOriginalCollection("id,calpersonid,caltask.id", new QFilter[]{pFilter});
            HashMap<Long, DynamicObject> slipIdMap = new HashMap<Long, DynamicObject>(16);
            HashMap<Long, List> calTaskIdMap = new HashMap<Long, List>(16);
            for (DynamicObject slip : slipCol) {
                Long slipId = slip.getLong("id");
                Long taskId2 = slip.getLong("caltask.id");
                List calPersonList2 = calTaskIdMap.getOrDefault(taskId2, new ArrayList());
                calPersonList2.add(slip.getLong("calpersonid"));
                calTaskIdMap.put(taskId2, calPersonList2);
                slipIdMap.put(slipId, slip);
            }
            helper = new SWCDataServiceHelper("hsas_calpayrolltask");
            filter = new QFilter("id", "in", calTaskIdMap.keySet());
            DynamicObjectCollection taskCol = helper.queryOriginalCollection("id,calrulev.id,payrollgroupv.currency.id,payrollgroup.id", new QFilter[]{filter});
            Map<Long, Long> taskCurMap = taskCol.stream().collect(Collectors.toMap(task -> task.getLong("id"), task -> task.getLong("payrollgroupv.currency.id")));
            Map<Long, Long> calRuleIdMap = taskCol.stream().collect(Collectors.toMap(task -> task.getLong("id"), task -> task.getLong("calrulev.id")));
            Map<Long, Long> payRollIdMap = taskCol.stream().collect(Collectors.toMap(task -> task.getLong("id"), task -> task.getLong("payrollgroup.id")));
            helper = new SWCDataServiceHelper("hsas_calrule");
            QFilter ruleFilter = new QFilter("id", "in", calRuleIdMap.values());
            DynamicObjectCollection calRuleCol = helper.queryOriginalCollection("id,totalsalary.id,netsalary.id", new QFilter[]{ruleFilter});
            Map<Long, DynamicObject> calRuleMap = calRuleCol.stream().collect(Collectors.toMap(calRule -> calRule.getLong("id"), calRule -> calRule));
            HashMap calPersonIdEncryptMap = new HashMap(16);
            MultiEncryptNewService service = new MultiEncryptNewService(EncryptTypeEnum.ENCRYPT_TYPE_INTERNATIONAL, EncryptLevelEnum.ENCRYPT_LEVEL_ORDINARY);
            calTaskIdMap.forEach((taskId, calPersonList) -> {
                Long calRuleId = (Long)calRuleIdMap.get(taskId);
                DynamicObject calRule = (DynamicObject)calRuleMap.get(calRuleId);
                if (calRule != null) {
                    ArrayList<Long> itemIds = new ArrayList<Long>(2);
                    Long totalId = calRule.getLong("totalsalary.id");
                    itemIds.add(totalId);
                    Long netId = calRule.getLong("netsalary.id");
                    itemIds.add(netId);
                    List splits = SWCListUtils.split((List)calPersonList, (int)5000);
                    splits.forEach(split -> {
                        DynamicObject[] resultCol;
                        for (DynamicObject result : resultCol = this.batchQueryCalResult((List<Long>)split, (List<Long>)itemIds)) {
                            Long calPersonId = result.getLong("calpersonid");
                            SummaryInfoDTO summaryInfoDTO = new SummaryInfoDTO();
                            DynamicObjectCollection entrys = result.getDynamicObjectCollection("hsas_caltableentry");
                            entrys.forEach(data -> {
                                Long itemId = data.getLong("salaryitem.id");
                                BigDecimal value = data.getBigDecimal("calamountvalue");
                                if (totalId.equals(itemId)) {
                                    summaryInfoDTO.setTotalSalary(value);
                                }
                                if (netId.equals(itemId)) {
                                    summaryInfoDTO.setNetSalary(value);
                                }
                            });
                            summaryInfoDTO.setCalCurrencyId((Long)taskCurMap.get(taskId));
                            calPersonIdEncryptMap.put(calPersonId, service.encode(JSON.toJSONString((Object)summaryInfoDTO)));
                        }
                    });
                }
            });
            BiMap carSlipMap = slipCarMap.inverse();
            ArrayList calendarIdList = new ArrayList(carSlipMap.keySet());
            List splits = SWCListUtils.split(calendarIdList, (int)1000);
            helper = new SWCDataServiceHelper("hspp_salarycalendar");
            for (List calendarIds : splits) {
                DynamicObject[] collection;
                QFilter filterCar = new QFilter("id", "in", (Object)calendarIds);
                for (DynamicObject data : collection = helper.query("id,salaryslipdata,payrollgrp.id", new QFilter[]{filterCar})) {
                    Long calendarId = data.getLong("id");
                    Long slipId = (Long)carSlipMap.get((Object)calendarId);
                    DynamicObject slipDy = (DynamicObject)slipIdMap.get(slipId);
                    if (slipDy == null) continue;
                    Long calPersonId = slipDy.getLong("calpersonid");
                    Long taskId3 = slipDy.getLong("caltask.id");
                    String salaryData = (String)calPersonIdEncryptMap.get(calPersonId);
                    data.set("salaryslipdata", (Object)salaryData);
                    data.set("payrollgrp", (Object)payRollIdMap.get(taskId3));
                }
                helper.save(collection);
            }
            ScheduleManager serviceManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
            serviceManager.disableJob(taskInfo.getJobId());
            serviceManager.disableSchedule(taskInfo.getScheduleId());
        }
        catch (Exception e) {
            logger.error("update salaryCalendar failed", (Throwable)e);
        }
    }

    private DynamicObject[] batchQueryCalResult(List<Long> calPersonList, List<Long> itemList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("calpersonid", "in", calPersonList);
        filter.and(new QFilter("hsas_caltableentry.salaryitem", "in", itemList));
        return helper.query("calpersonid,hsas_caltableentry.calamountvalue,salaryitem.id", new QFilter[]{filter});
    }
}

