/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.cronjob;

import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.TransferUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.model.EncryptionScheme;
import kd.bos.permission.util.SchemeUtil;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.encrypt.KeyGenerator;
import kd.swc.hsbp.business.encrypt.MultiEncryptNewService;
import kd.swc.hsbp.business.encrypt.util.SecretTableUtil;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.EncryptLevelEnum;
import kd.swc.hsbp.common.enums.EncryptTypeEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.codec.binary.Base64;

public class SalarySlipEncryptUpdateTask
extends AbstractTask {
    private static Log LOGGER = LogFactory.getLog(SalarySlipEncryptUpdateTask.class);
    private static final int BATCH_SIZE = 5000;
    private static final String SQL = "select fid, fsalarycalendarid from t_hspp_salaryslipstatus where fencryptid = 0 and fsecretkeyid = 0";
    private int queryBatch = 0;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        this.updateSalarySlipEncrypt();
        this.disableTask();
        LOGGER.info("SalarySlipEncryptUpdateTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void updateSalarySlipEncrypt() {
        HashMap<Long, Long> waitDealMap = new HashMap<Long, Long>(5000);
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"salaryslip_encrypt");
        String encryptLevel = "";
        if (paramMap == null || paramMap.get("encryptlevel") == null) {
            LOGGER.info("updateSalarySlipEncrypt not param upgrade!");
            return;
        }
        encryptLevel = paramMap.get("encryptlevel").toString();
        String encryptType = "1";
        EncryptTypeEnum encryptTypeEnum = EncryptTypeEnum.getEncryptTypeEnumByCode((String)encryptType);
        EncryptLevelEnum encryptLevelEnum = EncryptLevelEnum.getEncryptLevelEnumByCode((String)encryptLevel);
        MultiEncryptNewService serviceNew = new MultiEncryptNewService(encryptTypeEnum, encryptLevelEnum);
        MultiEncryptService serviceOld = new MultiEncryptService(encryptTypeEnum, encryptLevelEnum);
        DataSet dataSet = this.getDbConnection("SalarySlipEncrypt.querySalaryCalendarSQl", SQL, new Object[0]);
        EncryptionScheme scheme = SchemeUtil.getEncryptionScheme((String)"STANDARD-AES-256");
        boolean isHaveScheme = scheme != null;
        try {
            while (dataSet.hasNext()) {
                if (!isHaveScheme) {
                    throw new KDBizException("STANDARD-AES-256 is null");
                }
                if (waitDealMap.size() < 5000) {
                    Row row = dataSet.next();
                    waitDealMap.put(row.getLong("fsalarycalendarid"), row.getLong("fid"));
                    continue;
                }
                this.dealAndSaveData(waitDealMap, serviceNew, serviceOld);
                if (this.queryBatch >= 1000) {
                    this.queryBatch = 0;
                    dataSet.close();
                    dataSet = this.getDbConnection("SalarySlipEncrypt.querySalaryCalendarSQl", SQL, new Object[0]);
                }
                waitDealMap.clear();
                ++this.queryBatch;
            }
            this.dealAndSaveData(waitDealMap, serviceNew, serviceOld);
        }
        catch (Exception exp) {
            LOGGER.error("updateSalarySlipEncrypt execute error: ", (Throwable)exp);
            throw new KDBizException((Throwable)exp, new ErrorCode("", exp.getMessage()), new Object[0]);
        }
        finally {
            dataSet.close();
        }
    }

    private void dealAndSaveData(Map<Long, Long> waitDealMap, MultiEncryptNewService serviceNew, MultiEncryptService serviceOld) {
        DynamicObject[] detailArray;
        DynamicObject[] calendarArray;
        HashMap<Long, String> sumDataMap = new HashMap<Long, String>(waitDealMap.size());
        HashMap<String, String> encryKeyMap = new HashMap<String, String>(waitDealMap.size());
        HashMap<String, List<String>> secretKeyMap = new HashMap<String, List<String>>(waitDealMap.size());
        HashMap<String, Long> calendarIdKeyMap = new HashMap<String, Long>(waitDealMap.size());
        SWCDataServiceHelper calendarHelper = new SWCDataServiceHelper("hspp_salarycalendar");
        QFilter calendarFilter = new QFilter("id", "in", waitDealMap.keySet());
        for (DynamicObject dynamicObject : calendarArray = calendarHelper.query("id,salaryslipdata,person,salaryfile,releasetimestamp", new QFilter[]{calendarFilter})) {
            String encodeSumData;
            Long id = dynamicObject.getLong("id");
            String salarySlipData = dynamicObject.getString("salaryslipdata");
            String decodeOld = serviceOld.decode(salarySlipData);
            if (SWCStringUtils.isEmpty((String)decodeOld) || SWCStringUtils.isEmpty((String)(encodeSumData = serviceNew.encode(decodeOld)))) continue;
            sumDataMap.put(id, encodeSumData);
            ArrayList<String> secretDetailKeyList = new ArrayList<String>(10);
            secretDetailKeyList.add(String.valueOf(id));
            String personId = String.valueOf(dynamicObject.getLong("person.id"));
            secretDetailKeyList.add(personId);
            secretDetailKeyList.add(dynamicObject.getString("releasetimestamp"));
            String encryKey = serviceOld.getEncryKey(secretDetailKeyList);
            encryKeyMap.put(encryKey, serviceNew.getEncryKey(secretDetailKeyList));
            secretKeyMap.put(encryKey, Arrays.asList(personId, String.valueOf(dynamicObject.getLong("salaryfile.id"))));
            calendarIdKeyMap.put(encryKey, id);
        }
        SWCDataServiceHelper detailHelper = new SWCDataServiceHelper("hspp_salaryslipdetail");
        QFilter filter = new QFilter("encrykey", "in", encryKeyMap.keySet());
        for (DynamicObject detail : detailArray = detailHelper.query("id,encrykey,salaryslipdata", new QFilter[]{filter})) {
            String encryOldKey = detail.getString("encrykey");
            String salarySlipData = detail.getString("salaryslipdata");
            List secretKeyList = (List)secretKeyMap.get(encryOldKey);
            String decodeData = serviceOld.decode(secretKeyList, salarySlipData);
            if (SWCStringUtils.isEmpty((String)decodeData)) {
                calendarIdKeyMap.remove(encryOldKey);
                continue;
            }
            String encodeData = serviceNew.encode(secretKeyList, decodeData);
            if (SWCStringUtils.isEmpty((String)encodeData)) {
                calendarIdKeyMap.remove(encryOldKey);
                continue;
            }
            detail.set("encrykey", encryKeyMap.get(encryOldKey));
            detail.set("salaryslipdata", (Object)encodeData);
        }
        HashSet<Long> hashSet = new HashSet<Long>(calendarIdKeyMap.values());
        for (DynamicObject calendarData : calendarArray) {
            Long id = calendarData.getLong("id");
            if (!hashSet.contains(id)) continue;
            calendarData.set("salaryslipdata", sumDataMap.get(id));
        }
        try (TXHandle txHandle = TX.requiresNew();){
            calendarHelper.save(calendarArray);
            detailHelper.save(detailArray);
            this.saveSalarySlipStatus(hashSet, waitDealMap, serviceNew.getEncryptId(), serviceNew.getSecretKeyId());
            txHandle.commit();
        }
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }

    private DataSet getDbConnection(String algoKey, String sql, Object[] params) {
        return DB.queryDataSet((String)algoKey, (DBRoute)SWCConstants.HSPP_ROUETE, (String)sql, (Object[])params);
    }

    private void saveSalarySlipStatus(Set<Long> calendarSuccessIdSet, Map<Long, Long> waitDealMap, Long encryptId, Long secretKeyId) {
        String updateSql = "UPDATE T_HSPP_SALARYSLIPSTATUS SET FENCRYPTID = " + encryptId + " , FSECRETKEYID = " + secretKeyId + " WHERE FID = ?";
        ArrayList params = new ArrayList(calendarSuccessIdSet.size());
        waitDealMap.forEach((calendarId, id) -> {
            if (calendarSuccessIdSet.contains(calendarId)) {
                Object[] param = new Object[]{id};
                params.add(param);
            }
        });
        if (params.isEmpty()) {
            return;
        }
        SWCDbUtil.executeBatch((DBRoute)SWCConstants.HSPP_ROUETE, (String)updateSql, params);
    }

    class MultiEncryptService {
        private final Log log = LogFactory.getLog(MultiEncryptService.class);
        private String KEY;
        private EncryptTypeEnum encryptType;
        private EncryptLevelEnum encryptLevel;

        MultiEncryptService(EncryptTypeEnum encryptType, EncryptLevelEnum encryptLevel) {
            this.encryptType = encryptType;
            this.encryptLevel = encryptLevel;
            this.initSecretKeyData();
        }

        String decode(List<String> secretKeyList, String content) {
            try {
                if (EncryptLevelEnum.ENCRYPT_LEVEL_HIGH == this.encryptLevel) {
                    content = this.personDecode(secretKeyList, content);
                    content = this.leaderDecode(content);
                }
                content = this.decode(content);
                return content;
            }
            catch (Exception e) {
                this.log.error("decode error\uff1a{} msg \uff1a", (Object)e.getMessage());
                return null;
            }
        }

        String decode(String content) {
            String encryptTypeCode = this.encryptType.getCode();
            String prefix = this.getPrefixAndKey(encryptTypeCode).split(",")[0];
            String key = this.getPrefixAndKey(encryptTypeCode).split(",")[1];
            String result = "";
            try {
                if (!encryptTypeCode.equals("0")) {
                    result = EncrypterFactory.getAesEncrypter().decrypt(content.replace(prefix, ""), key, 128);
                }
            }
            catch (Exception e) {
                this.log.error("decode error\uff1a{} msg \uff1a", (Object)e.getMessage());
                return result;
            }
            return result;
        }

        private String getPrefixAndKey(String encryptType) {
            String keyString = KeyGenerator.getKey();
            String prefix = keyString.split(",")[0];
            String key = keyString.split(",")[1];
            if (encryptType.equals("0")) {
                key = key + keyString.split(",")[2];
            }
            return prefix + "," + key;
        }

        private String getHashcode(String encryptType, String key) {
            String result = "";
            try {
                if (!encryptType.equals("0")) {
                    result = TransferUtil.sha1((String)key);
                }
            }
            catch (Exception e) {
                return "";
            }
            return result.substring(0, 32);
        }

        String getEncryKey(List<String> secretKeyList) {
            try {
                StringBuilder sb = new StringBuilder();
                secretKeyList.forEach(sb::append);
                String encryKey = TransferUtil.sha1((String)sb.toString());
                encryKey = encryKey + TransferUtil.sha1((String)encryKey);
                return encryKey;
            }
            catch (Exception ex) {
                this.log.error("encryKey sha1 error {}", (Object)ex.getMessage());
                return "";
            }
        }

        private Key getAESKeyFromString(String content, int length) throws RuntimeException {
            if (content == null || content.length() < length / 8) {
                throw new RuntimeException("The given AES key is too short.");
            }
            try {
                byte[] keyBytes = content.substring(0, length / 8).getBytes("UTF-8");
                SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
                return key;
            }
            catch (Exception ex) {
                this.log.error("error:", (Throwable)ex);
                return null;
            }
        }

        String decrypt(String encryptStr, String aesKey) throws Exception {
            if (encryptStr == null) {
                return null;
            }
            byte[] content = Base64.decodeBase64((String)encryptStr);
            if (content.length < 28) {
                throw new IllegalArgumentException();
            }
            GCMParameterSpec params = new GCMParameterSpec(128, content, 0, 12);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            Key key = this.getAESKeyFromString(aesKey, 128);
            cipher.init(2, key, params);
            byte[] decryptData = cipher.doFinal(content, 12, content.length - 12);
            return new String(decryptData, "UTF-8");
        }

        private String leaderDecode(String content) throws Exception {
            this.initSecretKeyData();
            return this.decrypt(content, this.KEY);
        }

        private String personDecode(List<String> secretKeyList, String content) throws Exception {
            String key = this.getPersonSecretKey(secretKeyList);
            return this.decrypt(content, key);
        }

        private String getPersonSecretKey(List<String> secretKeyList) {
            if (secretKeyList == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            secretKeyList.forEach(content -> sb.append((String)content));
            String result = this.getHashcode(this.encryptType.getCode(), sb.toString());
            if (EncryptTypeEnum.ENCRYPT_TYPE_INTERNATIONAL == this.encryptType) {
                return result.substring(0, 16);
            }
            return result.substring(0, 32);
        }

        private void initSecretKeyData() {
            if (EncryptLevelEnum.ENCRYPT_LEVEL_HIGH == this.encryptLevel) {
                SWCDataServiceHelper helper;
                DynamicObject dynamicObject;
                if (SWCStringUtils.isEmpty((String)this.KEY) && (dynamicObject = (helper = new SWCDataServiceHelper("hsas_secretkey")).queryOne("secretkey", new QFilter[0])) != null) {
                    String dataSrcretKey = dynamicObject.getString("secretkey");
                    this.KEY = SecretTableUtil.getDecryptKey((String)this.encryptType.getCode(), (String)dataSrcretKey);
                }
                if (EncryptTypeEnum.ENCRYPT_TYPE_INTERNATIONAL == this.encryptType && SWCStringUtils.isNotEmpty((String)this.KEY)) {
                    this.KEY = this.KEY.substring(0, 16);
                }
            }
        }
    }
}

