/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.login;

public class CheckPasswordHelper {
    private static final String REG_NUMBER = ".*\\d+.*";
    private static final String REG_UPPERCASE = ".*[A-Z]+.*";
    private static final String REG_LOWERCASE = ".*[a-z]+.*";
    private static final String REG_SYMBOL = ".*[`~!@#$%^&*()_+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]+.*";
    private static final int INT_EIGHT = 8;
    private static final int INT_TWENTY = 20;

    static boolean checkPasswordLegal(String password) {
        String pattern = "\\s+";
        String[] split = password.split(pattern);
        if (split.length > 1 || !password.equals(password.trim())) {
            return false;
        }
        return !CheckPasswordHelper.isIncludeChinese(password);
    }

    private static boolean isIncludeChinese(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char charAt = str.charAt(i);
            if ('\u4e00' >= charAt || charAt >= '\u9fbb') continue;
            return true;
        }
        return false;
    }

    static boolean checkPasswordRule(String password) {
        if (password == null || password.length() < 8 || password.length() > 20) {
            return false;
        }
        int index = 0;
        if (password.matches(REG_NUMBER)) {
            ++index;
        }
        if (password.matches(REG_LOWERCASE)) {
            ++index;
        }
        if (password.matches(REG_UPPERCASE)) {
            ++index;
        }
        if (password.matches(REG_SYMBOL)) {
            ++index;
        }
        return index >= 3;
    }

    public static void main(String[] args) {
        boolean flag = CheckPasswordHelper.checkPasswordRule("Xie1su4232!A");
    }
}

