/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.login;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Date;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryPwdCacheService {
    private static final String LOGINCODE_SUFFIX = "_loginCode";
    private static final int LOGINERROR_NUM = 5;
    private static final int MIN_ONE_HOUR = 3600;
    private Long userId;
    private String pageCode;
    private SalarySlipCache salarySlipCache;

    public SalaryPwdCacheService(Long userId, String pageCode) {
        this.userId = userId;
        this.pageCode = pageCode;
    }

    public boolean isEnableInputPwd() {
        ISWCAppCache appCache = SWCAppCache.get((String)(this.pageCode + LOGINCODE_SUFFIX));
        String numAndTimeCache = (String)appCache.get(this.userId + LOGINCODE_SUFFIX, String.class);
        if (SWCStringUtils.isEmpty((String)numAndTimeCache)) {
            return true;
        }
        String[] split = numAndTimeCache.split("_");
        if (split.length != 2) {
            return true;
        }
        Integer num = Integer.parseInt(split[0]);
        if (5 > num) {
            return true;
        }
        Long time = Long.parseLong(split[1]);
        long currentTime = System.currentTimeMillis();
        if ((currentTime - time) / 1000L > 3600L) {
            appCache.remove(this.userId + LOGINCODE_SUFFIX);
            return true;
        }
        return false;
    }

    public int setPwdCache() {
        ISWCAppCache appCache = SWCAppCache.get((String)(this.pageCode + LOGINCODE_SUFFIX));
        String numAndTimeCache = (String)appCache.get(this.userId + LOGINCODE_SUFFIX, String.class);
        if (SWCStringUtils.isEmpty((String)numAndTimeCache)) {
            appCache.put(this.userId + LOGINCODE_SUFFIX, (Object)("1_" + System.currentTimeMillis()));
            return 4;
        }
        String[] split = numAndTimeCache.split("_");
        if (split.length != 2) {
            appCache.put(this.userId + LOGINCODE_SUFFIX, (Object)("1_" + System.currentTimeMillis()));
            return 4;
        }
        int num = Integer.parseInt(split[0]);
        appCache.put(this.userId + LOGINCODE_SUFFIX, (Object)(++num + "_" + System.currentTimeMillis()));
        num = 5 - num;
        return num;
    }

    public void setDataCache(String data, Integer residueNum, int duration) {
        ISWCAppCache appCache = SWCAppCache.get((String)(this.pageCode + LOGINCODE_SUFFIX));
        String cacheString = (String)appCache.get(this.userId + LOGINCODE_SUFFIX, String.class);
        SalarySlipCache cache = null;
        if (SWCStringUtils.isNotEmpty((String)cacheString)) {
            cache = (SalarySlipCache)JSON.parseObject((String)cacheString, SalarySlipCache.class);
        }
        if (cache == null) {
            this.setSalarySlipCache(data, residueNum, duration);
            appCache.put(this.userId + LOGINCODE_SUFFIX, (Object)JSON.toJSONString((Object)this.salarySlipCache));
            return;
        }
        cache.setResidueNum(cache.getResidueNum() - 1);
        appCache.put(this.userId + LOGINCODE_SUFFIX, (Object)JSON.toJSONString((Object)cache));
    }

    public int getFailureTime() {
        ISWCAppCache appCache = SWCAppCache.get((String)(this.pageCode + LOGINCODE_SUFFIX));
        String cacheString = (String)appCache.get(this.userId + LOGINCODE_SUFFIX, String.class);
        SalarySlipCache cache = null;
        if (SWCStringUtils.isNotEmpty((String)cacheString)) {
            cache = (SalarySlipCache)JSON.parseObject((String)cacheString, SalarySlipCache.class);
        }
        if (cache == null) {
            return -1;
        }
        long time = SWCDateTimeUtils.dateDiff((Date)new Date(), (Date)cache.getFailureTime());
        if (time < 1000L) {
            this.clearPwdCache();
        }
        return (int)(time / 1000L);
    }

    public String getData() {
        ISWCAppCache appCache = SWCAppCache.get((String)(this.pageCode + LOGINCODE_SUFFIX));
        String cacheString = (String)appCache.get(this.userId + LOGINCODE_SUFFIX, String.class);
        SalarySlipCache cache = null;
        if (SWCStringUtils.isNotEmpty((String)cacheString)) {
            cache = (SalarySlipCache)JSON.parseObject((String)cacheString, SalarySlipCache.class);
        }
        if (cache == null) {
            return "";
        }
        return cache.getData();
    }

    public void clearPwdCache() {
        ISWCAppCache appCache = SWCAppCache.get((String)(this.pageCode + LOGINCODE_SUFFIX));
        appCache.remove(this.userId + LOGINCODE_SUFFIX);
    }

    private void setSalarySlipCache(String data, Integer residueNum, int duration) {
        Date date = new Date();
        this.salarySlipCache = new SalarySlipCache(date, SWCDateTimeUtils.addSecond((Date)date, (long)duration), residueNum, data);
    }

    static class SalarySlipCache
    implements Serializable {
        private static final long serialVersionUID = 4976945634229950268L;
        private Date createTime;
        private Date failureTime;
        private Integer residueNum;
        private String data;

        public SalarySlipCache() {
        }

        SalarySlipCache(Date createTime, Date failureTime, Integer residueNum, String data) {
            this.createTime = createTime;
            this.failureTime = failureTime;
            this.residueNum = residueNum;
            this.data = data;
        }

        public Date getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Date createTime) {
            this.createTime = createTime;
        }

        public Date getFailureTime() {
            return this.failureTime;
        }

        public void setFailureTime(Date failureTime) {
            this.failureTime = failureTime;
        }

        public Integer getResidueNum() {
            return this.residueNum;
        }

        public void setResidueNum(Integer residueNum) {
            this.residueNum = residueNum;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}

