/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.login;

import com.alibaba.fastjson.JSONObject;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.login.utils.LoginUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.PasswordEncryptUtil;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.login.CheckPasswordHelper;
import kd.swc.hspp.business.login.SalaryPwdCacheService;
import kd.swc.hspp.business.mservice.person.IPersonService;
import kd.swc.hspp.common.constants.SalarySlipApiResultStatusEnum;

public class SalaryPwdHelper {
    public static final String TEXTFIELD_NEWPAWD = "newPwd";
    public static final String TEXTFIELD_VERIFYPAWD = "verifyPwd";
    public static final String VERIFYTYPE = "verifyType";
    public static final String VERIFYTYPE_NEW = "1";
    public static final String VERIFYTYPE_SEC = "2";
    public static final String VERIFYTYPE_ALL = "3";
    public static final String PERSONID = "personId";
    private static final String TEXTFIELD_PHONE = "phone";
    private static final String TEXTFIELD_CODE = "code";
    private static final String SENDFLAG_FAIL = "0";
    private static final String SENDFLAG_SUCCESS = "1";
    private static final String STATUS_UNUSED = "0";
    private static final String STATUS_USED = "1";
    private static final String ERR_CSS = "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuXG4kIHtcbiAgYm9yZGVyLXdpZHRoOiAwLjVweDtcbiAgYm9yZGVyLWNvbG9yOiAjRkIyMzIzO1xuICBib3JkZXItc3R5bGU6IHNvbGlkO1xuwqB9XG5cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbiJ9";
    private static final String NORMAL_CSS = "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuXG4kIHtcbiAgYm9yZGVyLXdpZHRoOiAwLjVweDtcbiAgYm9yZGVyLWNvbG9yOiAjRTVFNUU1O1xuICBib3JkZXItc3R5bGU6IHNvbGlkO1xuwqB9XG5cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbiJ9";

    public static boolean isNullPwd(String pwd) {
        return StringUtils.isBlank((CharSequence)pwd);
    }

    public static void redirectPageByFormId(AbstractMobFormPlugin mobFormPlugin, String formId) {
        SalaryPwdHelper.showFormByShowType(mobFormPlugin, formId, ShowType.Floating);
    }

    public static void redirectPageByIsSum(AbstractMobFormPlugin mobFormPlugin) {
        String isSum = (String)mobFormPlugin.getView().getFormShowParameter().getCustomParam("isSum");
        String formId = "1".equals(isSum) ? "hspp_salaryslipdetailsum" : "hspp_mobilesalarycal";
        SalaryPwdHelper.showFormByShowType(mobFormPlugin, formId, ShowType.Floating);
    }

    private static void showFormByShowType(AbstractMobFormPlugin mobFormPlugin, String formId, ShowType showType) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(showType);
        parameter.setCustomParam("personid", mobFormPlugin.getView().getFormShowParameter().getCustomParam("personid"));
        parameter.setCustomParam("isSum", mobFormPlugin.getView().getFormShowParameter().getCustomParam("isSum"));
        parameter.setCustomParam("verifyCertFlag", (Object)"verifyCertFlag");
        mobFormPlugin.getView().showForm((FormShowParameter)parameter);
    }

    public static void redirectPageByFormIdOnReplace(AbstractMobFormPlugin mobFormPlugin, String formId) {
        SalaryPwdHelper.showFormByShowType(mobFormPlugin, formId, ShowType.ReplaceHomePage);
    }

    public static boolean isPersonExist(Long personId) {
        DynamicObject pwdObject = SalaryPwdHelper.getPwdObjectByPersonId(personId);
        return pwdObject != null && !SalaryPwdHelper.isNullPwd(pwdObject.getString("password"));
    }

    public static DynamicObject getPwdObjectByPersonId(Long personId) {
        SWCDataServiceHelper pwdHelper = new SWCDataServiceHelper("hspp_salaryslippwd");
        return pwdHelper.queryOne("password", new QFilter[]{new QFilter("person", "=", (Object)personId)});
    }

    public static boolean checkPassWord(String personId, String oldPassword, String newPassword) {
        return PasswordEncryptUtil.authenticateWithSalt((String)LoginUtils.getCorrectUserIDSalt((String)personId), (String)oldPassword, (String)newPassword);
    }

    public static boolean checkPasswordLegal(String password) {
        return CheckPasswordHelper.checkPasswordLegal(password);
    }

    public static boolean checkPasswordFormat(String password) {
        return CheckPasswordHelper.checkPasswordRule(password);
    }

    public static ApiResult verify(Map<String, String> map) {
        String newPassword = map.getOrDefault(TEXTFIELD_NEWPAWD, "");
        String verifyPassword = map.getOrDefault(TEXTFIELD_VERIFYPAWD, "");
        String verifyType = map.getOrDefault(VERIFYTYPE, "");
        if ("1".equals(verifyType)) {
            return SalaryPwdHelper.verifyNewPassword(newPassword, verifyPassword);
        }
        if (VERIFYTYPE_SEC.equals(verifyType)) {
            return SalaryPwdHelper.verifyNextPassword(newPassword, verifyPassword);
        }
        if (VERIFYTYPE_ALL.equals(verifyType)) {
            ApiResult apiResult = SalaryPwdHelper.verifyNewPassword(newPassword, verifyPassword);
            return apiResult.getSuccess() ? SalaryPwdHelper.verifyNextPassword(newPassword, verifyPassword) : apiResult;
        }
        return SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40018);
    }

    private static ApiResult verifyNewPassword(String newPassword, String verifyPassword) {
        if (StringUtils.isEmpty((CharSequence)newPassword)) {
            ApiResult apiResult = StringUtils.isEmpty((CharSequence)verifyPassword) ? SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40001) : SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40002);
            return apiResult;
        }
        if (!SalaryPwdHelper.checkPasswordLegal(newPassword)) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40003);
            return apiResult;
        }
        if (!SalaryPwdHelper.checkPasswordFormat(newPassword)) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40004);
            return apiResult;
        }
        return ApiResult.success(null);
    }

    private static ApiResult verifyNextPassword(String newPassword, String verifyPassword) {
        if (StringUtils.isEmpty((CharSequence)verifyPassword)) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40001);
            return apiResult;
        }
        if (!newPassword.equals(verifyPassword)) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40005);
            return apiResult;
        }
        return ApiResult.success(null);
    }

    public static ApiResult saveOrUpdatePersonPwd(Map<String, Object> paramMap) {
        String newLoginCode = String.valueOf(paramMap.getOrDefault(TEXTFIELD_NEWPAWD, ""));
        String verifyLoginCode = String.valueOf(paramMap.getOrDefault(TEXTFIELD_VERIFYPAWD, ""));
        Long personId = (Long)paramMap.getOrDefault(PERSONID, 0L);
        if (StringUtils.isEmpty((CharSequence)newLoginCode) || StringUtils.isEmpty((CharSequence)verifyLoginCode)) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40001);
            return apiResult;
        }
        if (!newLoginCode.equals(verifyLoginCode)) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40005);
            return apiResult;
        }
        if (newLoginCode.length() > 20) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40006);
            return apiResult;
        }
        ApiResult apiResult = IPersonService.getInstance().getPersonInfoByPersonId(personId);
        if (!apiResult.getSuccess()) {
            return apiResult;
        }
        SalaryPwdHelper.savePersonPwd(personId, newLoginCode);
        return ApiResult.success(null);
    }

    public static void savePersonPwd(Long personId, String pwd) {
        SWCDataServiceHelper salaryPwdHelper = new SWCDataServiceHelper("hspp_salaryslippwd");
        DynamicObject dynamicObject = salaryPwdHelper.queryOne("person,password,modifier,modifytime", new QFilter[]{new QFilter("person", "=", (Object)personId)});
        String passwordEncrypt = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)pwd, (String)LoginUtils.getCorrectUserIDSalt((String)String.valueOf(personId)));
        if (dynamicObject != null) {
            dynamicObject.set("password", (Object)passwordEncrypt);
            dynamicObject.set("modifytime", (Object)new Date());
            salaryPwdHelper.updateOne(dynamicObject);
            SalaryPwdCacheService service = new SalaryPwdCacheService(personId, "hspp_mobpwdinit");
            service.clearPwdCache();
        } else {
            dynamicObject = salaryPwdHelper.generateEmptyDynamicObject();
            dynamicObject.set("person", (Object)new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hrpi_person"), (Object)personId));
            dynamicObject.set("password", (Object)passwordEncrypt);
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("modifytime", (Object)new Date());
            salaryPwdHelper.saveOne(dynamicObject);
        }
    }

    public static ApiResult authenticatePassword(Map<String, Object> paramMap) {
        String loginCode = String.valueOf(paramMap.getOrDefault(TEXTFIELD_NEWPAWD, ""));
        Long personId = (Long)paramMap.getOrDefault(PERSONID, 0L);
        if (SWCStringUtils.isEmpty((String)loginCode)) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40001);
            return apiResult;
        }
        SalaryPwdCacheService service = new SalaryPwdCacheService(personId, "hspp_mobpwdinit");
        if (!service.isEnableInputPwd()) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40008);
            return apiResult;
        }
        DynamicObject pwdObject = SalaryPwdHelper.getPwdObjectByPersonId(personId);
        if (pwdObject == null || SWCStringUtils.isEmpty((String)pwdObject.getString("password"))) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40019);
            return apiResult;
        }
        if (!SalaryPwdHelper.checkPassWord(String.valueOf(personId), pwdObject.getString("password"), loginCode)) {
            int num = service.setPwdCache();
            if (num <= 0) {
                ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40008);
                return apiResult;
            }
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40009);
            apiResult.setMessage(String.format(Locale.ROOT, apiResult.getMessage(), num));
            return apiResult;
        }
        service.clearPwdCache();
        return ApiResult.success(null);
    }

    public static ApiResult sendCodeMessage(Map<String, Object> paramMap) {
        String phone = String.valueOf(paramMap.getOrDefault(TEXTFIELD_PHONE, ""));
        Long personId = (Long)paramMap.getOrDefault(PERSONID, 0L);
        Integer duration = (Integer)paramMap.getOrDefault("duration", 60);
        if (duration <= 0 || duration > 7200) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40020);
            return apiResult;
        }
        Long userId = SalaryPwdHelper.getUserIdByPersonId(personId);
        ApiResult apiResult = SalaryPwdHelper.isValidPersonPhone(phone, userId);
        if (!apiResult.getSuccess()) {
            return apiResult;
        }
        SalaryPwdCacheService service = new SalaryPwdCacheService(personId, "hspp_mobpwdreset");
        int failureTime = service.getFailureTime();
        if (failureTime > 0) {
            apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40010);
            apiResult.setMessage(String.format(Locale.ROOT, apiResult.getMessage(), failureTime));
            return apiResult;
        }
        DynamicObjectCollection msgInfoCol = SalaryPwdHelper.getMsgInfoCol();
        if (msgInfoCol == null || msgInfoCol.isEmpty()) {
            return SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40022);
        }
        SecureRandom secureRandom = new SecureRandom();
        String code = String.valueOf(secureRandom.nextInt(900000) + 100000);
        String message = MessageFormat.format(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\uff1a{0}({1}\u79d2\u5185\u6709\u6548)\uff0c\u4ec5\u7528\u4e8e\u5de5\u8d44\u6761\u5bc6\u7801\u91cd\u7f6e\u3002\u4e3a\u4fdd\u969c\u4fe1\u606f\u5b89\u5168\uff0c\u8bf7\u52ff\u544a\u8bc9\u4ed6\u4eba\u3002", (String)"SalaryPwdHelper_0", (String)"swc-hspp-business", (Object[])new Object[0]), code, duration);
        Long id = SalaryPwdHelper.saveMessage(personId, phone, message, code, duration);
        service.setDataCache(code, 0, duration);
        SalaryPwdHelper.invokeMsgService(message, userId, id, msgInfoCol);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg", (Object)String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001(%d\u79d2\u5185\u6709\u6548)\u3002", (String)"SalaryPwdHelper_1", (String)"swc-hspp-business", (Object[])new Object[0]), duration));
        jsonObject.put("duration", (Object)duration);
        return ApiResult.success((Object)jsonObject);
    }

    private static void invokeMsgService(String message, Long userId, Long id, DynamicObjectCollection msgInfoCol) {
        ArrayList<MessageInfo> infos = new ArrayList<MessageInfo>(10);
        for (DynamicObject msg : msgInfoCol) {
            MessageInfo info = new MessageInfo();
            info.setNestBillno("hspp_smsmessage");
            info.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
            info.setUserIds(Collections.singletonList(userId));
            info.setType("message");
            info.setEntityNumber("hspp_smsmessage");
            info.setBizDataId(id);
            info.setTplScene(msg.getString("msgscene"));
            info.setNotifyType(msg.getString("msgchannel"));
            info.setTag(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u9a8c\u8bc1\u7801\u901a\u77e5", (String)"SalaryPwdHelper_2", (String)"swc-hspp-business", (Object[])new Object[0]));
            info.setTitle(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u9a8c\u8bc1\u7801\u901a\u77e5", (String)"SalaryPwdHelper_2", (String)"swc-hspp-business", (Object[])new Object[0]));
            info.setContent(message);
            infos.add(info);
        }
        MessageCenterServiceHelper.batchSendMessages(infos);
    }

    private static DynamicObjectCollection getMsgInfoCol() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("msg_template");
        QFilter filter = new QFilter("msgentity", "in", (Object)"hspp_smsmessage");
        return helper.queryOriginalCollection("msgchannel,msgscene", new QFilter[]{filter});
    }

    private static Long saveMessage(Long personId, String phone, String message, String code, int duration) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_smsmessage");
        Long id = DB.genLongId((String)"hspp_smsmessage");
        DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("person", (Object)personId);
        dynamicObject.set(TEXTFIELD_PHONE, (Object)phone);
        dynamicObject.set("businesstype", (Object)"verifycode");
        dynamicObject.set("message", (Object)message);
        dynamicObject.set("issend", (Object)"1");
        dynamicObject.set("status", (Object)"0");
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set(TEXTFIELD_CODE, (Object)code);
        dynamicObject.set("effectivetime", (Object)duration);
        helper.saveOne(dynamicObject);
        return id;
    }

    public static ApiResult isValidPersonPhone(String phone, Long userId) {
        if (SWCStringUtils.isEmpty((String)phone)) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40011);
            return apiResult;
        }
        String existPhone = SalaryPwdHelper.getPhoneByUserId(userId);
        if (SWCStringUtils.isEmpty((String)existPhone)) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40007);
            return apiResult;
        }
        if (!SWCStringUtils.equals((String)phone, (String)existPhone)) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40013);
            return apiResult;
        }
        return ApiResult.success(null);
    }

    private static Long getUserIdByPersonId(Long personId) {
        Long userId = 0L;
        Tuple<Boolean, Map<String, Object>> tuple = IPersonService.getInstance().getUserIdByPersonInfo(personId);
        if (((Boolean)tuple.item1).booleanValue()) {
            Map map = (Map)((Map)tuple.item2).get(personId);
            userId = map.getOrDefault("user", 0L);
        }
        return userId;
    }

    private static String getPhoneByUserId(Long userId) {
        SWCDataServiceHelper phoneHelp = new SWCDataServiceHelper("bos_user");
        DynamicObject phoneObject = phoneHelp.queryOne(TEXTFIELD_PHONE, new QFilter[]{new QFilter("id", "=", (Object)userId)});
        if (phoneObject == null) {
            return "";
        }
        return phoneObject.getString(TEXTFIELD_PHONE);
    }

    public static ApiResult validPhoneCode(Map<String, Object> paramMap) {
        String code = String.valueOf(paramMap.getOrDefault(TEXTFIELD_CODE, ""));
        Long personId = (Long)paramMap.getOrDefault(PERSONID, 0L);
        if (SWCStringUtils.isEmpty((String)code)) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40014);
            return apiResult;
        }
        SalaryPwdCacheService service = new SalaryPwdCacheService(personId, "hspp_mobpwdreset");
        String codeCache = service.getData();
        DynamicObject dynamicObject = SalaryPwdHelper.getVerifyCodeMessageByPersonId(personId);
        if (SWCStringUtils.isEmpty((String)codeCache) || dynamicObject == null) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40015);
            return apiResult;
        }
        int failureTime = service.getFailureTime();
        if (failureTime <= 0) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40016);
            return apiResult;
        }
        if (!SWCStringUtils.equals((String)code, (String)codeCache)) {
            ApiResult apiResult = SalaryPwdHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40017);
            return apiResult;
        }
        service.clearPwdCache();
        SalaryPwdHelper.updateMessageStatus(personId, code);
        return ApiResult.success(null);
    }

    private static DynamicObject getVerifyCodeMessageByPersonId(Long personId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_smsmessage");
        return helper.queryOne("person,phone,message,createtime", new QFilter[]{new QFilter("person", "=", (Object)personId), new QFilter("status", "=", (Object)"0")}, "createtime desc");
    }

    private static void updateMessageStatus(Long personId, String code) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_smsmessage");
        DynamicObject dynamicObject = helper.queryOne("person,status", new QFilter[]{new QFilter("person", "=", (Object)personId), new QFilter("status", "=", (Object)"0"), new QFilter(TEXTFIELD_CODE, "=", (Object)code)}, "createtime desc");
        if (dynamicObject != null) {
            dynamicObject.set("status", (Object)"1");
            helper.updateOne(dynamicObject);
        }
    }

    public static ApiResult getApiResult(SalarySlipApiResultStatusEnum statusEnum) {
        return ApiResult.fail((String)statusEnum.getI18nParamString(), (String)String.valueOf(statusEnum.getCode()));
    }

    public static void setLabelValue(AbstractFormPlugin mobFormPlugin, String key, String value) {
        Label label = (Label)mobFormPlugin.getView().getControl(key);
        label.setText(value);
    }

    public static void setMessageValue(AbstractMobFormPlugin mobFormPlugin, String value) {
        mobFormPlugin.getView().showMessage(value);
    }

    public static void setControlField(AbstractMobFormPlugin mobFormPlugin, String key, Boolean isTrue) {
        Control control = mobFormPlugin.getView().getControl(key);
        control.setCustomeStyles(isTrue != false ? NORMAL_CSS : ERR_CSS);
        mobFormPlugin.getView().updateControlMetadata(key, SalaryPwdHelper.createClientConfig(control));
    }

    private static Map<String, Object> createClientConfig(Control container) {
        HashMap<String, Object> ctl = new HashMap<String, Object>(16);
        if (container.getKey() != null) {
            ctl.put("id", container.getKey().toLowerCase());
        }
        if (container.getCustomeStyles() != null) {
            ctl.put("cstyles", container.getCustomeStyles());
        }
        return ctl;
    }

    public static void deleteSalaryPwd(AbstractMobFormPlugin mobFormPlugin) {
        SWCDataServiceHelper salaryPwdHelper = new SWCDataServiceHelper("hspp_salaryslippwd");
        String personId = (String)mobFormPlugin.getView().getFormShowParameter().getCustomParam("personid");
        salaryPwdHelper.deleteByFilter(new QFilter[]{new QFilter("person", "=", (Object)Long.parseLong(personId))});
    }

    public static void setPageBtnEnableCache(String key, Boolean flag) {
        ISWCAppCache appCache = SWCAppCache.get((String)key);
        appCache.put("btn_enable", (Object)flag);
    }

    public static boolean isBtnEnable(String key) {
        ISWCAppCache appCache = SWCAppCache.get((String)key);
        return (Boolean)appCache.get("btn_enable", Boolean.class);
    }
}

