/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.mservice;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>(16);

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory1_0", (String)"swc-hspp-business", (Object[])new Object[0]), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        SERVICE_MAP.put("IOcrService", "kd.swc.hspp.business.mservice.ocr.impl.OcrServiceImpl");
        SERVICE_MAP.put("IPrivacyService", "kd.swc.hspp.business.mservice.privary.impl.PrivacyServiceImpl");
        SERVICE_MAP.put("IPersonService", "kd.swc.hspp.business.mservice.person.impl.PersonServiceImpl");
        SERVICE_MAP.put("ISalaryPayService", "kd.swc.hspp.business.mservice.salary.impl.SalaryPayService");
    }
}

