/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.salaryslip;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.swc.hsbp.business.encrypt.MultiEncryptNewService;
import kd.swc.hsbp.business.encrypt.util.CompressUtils;
import kd.swc.hsbp.business.servicehelper.SWCCertCommonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCBankCardConstants;
import kd.swc.hsbp.common.dto.salary.SalaryItemInfoDTO;
import kd.swc.hsbp.common.dto.salary.StructureSalaryDTO;
import kd.swc.hsbp.common.enums.EncryptLevelEnum;
import kd.swc.hsbp.common.enums.EncryptTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.salaryslip.context.ContextHolder;
import kd.swc.hspp.business.salaryslip.detaildata.sum.SalarySlipSumDataService;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalarySumDetailVO;
import kd.swc.hspp.common.constants.SalarySlipApiResultStatusEnum;
import kd.swc.hspp.common.model.SalaryCalendarModel;
import kd.swc.hspp.common.model.SalarySlipDataStyleModel;
import kd.swc.hspp.common.model.SalarySlipEncryModel;
import kd.swc.hspp.common.model.SalarySlipSumDetailModel;
import kd.swc.hspp.common.model.sdk.SalarySlipDataGroupSdkModel;
import kd.swc.hspp.common.model.sdk.SalarySlipDataSdkModel;
import kd.swc.hspp.common.utils.ShowPageUtils;

public class SalarySlipHelper {
    private static final String PERSONID = "personId";
    private static final String STARTDATE = "startDate";
    private static final String ENDDATE = "endDate";
    private static final String SUMVIEWID = "sumViewId";

    public static Date getYearFirst(int year) {
        Calendar calendar = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        calendar.clear();
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static Date getYearFirst(Date date) {
        if (date == null) {
            return null;
        }
        int year = SWCDateTimeUtils.getYear((Date)date);
        return SalarySlipHelper.getYearFirst(year);
    }

    public static Date getYearLast(int year) {
        Calendar calendar = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getYearLast(Date date) {
        if (date == null) {
            return null;
        }
        int year = SWCDateTimeUtils.getYear((Date)date);
        return SalarySlipHelper.getYearLast(year);
    }

    public static Date getDateLast(Date date) {
        Calendar calendar = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 59);
        return calendar.getTime();
    }

    public static Date getDateFirst(Date date) {
        Calendar calendar = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Map<String, Boolean> getMonthBetween(Set<Date> dateSet) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(16);
        dateSet.forEach(date -> result.put(SWCDateTimeUtils.format((Date)date, (String)"yyyy.MM"), Boolean.FALSE));
        return result;
    }

    public static Tuple<Date, Date> getDateInterval(Date startDate, Date endDate, Date startOtherDate, Date endOtherDate) {
        if (startDate == null || endDate == null) {
            return new Tuple((Object)startOtherDate, (Object)endOtherDate);
        }
        if (endDate.before(startOtherDate) || startDate.after(endOtherDate)) {
            return null;
        }
        return new Tuple((Object)(startDate.before(startOtherDate) ? startOtherDate : startDate), (Object)(endDate.before(endOtherDate) ? endDate : endOtherDate));
    }

    public static SalarySlipDataStyleModel getStyle(int fontSize, String fontWeight, String foreColor) {
        SalarySlipDataStyleModel styleModel = new SalarySlipDataStyleModel();
        styleModel.setFontSize(fontSize);
        styleModel.setFontWeight(fontWeight);
        styleModel.setForeColor(foreColor);
        return styleModel;
    }

    public static String fmtMicrometer(String text) {
        double number;
        DecimalFormat df;
        if (text.indexOf(46) > 0) {
            int scale = text.length() - text.indexOf(46) - 1;
            if (scale == 0) {
                df = new DecimalFormat("###,##0");
            } else {
                StringBuilder format = new StringBuilder("#,##0.");
                for (int i = 0; i < scale; ++i) {
                    format.append('0');
                }
                df = new DecimalFormat(format.toString());
            }
        } else {
            df = new DecimalFormat("###,##0");
        }
        try {
            number = Double.parseDouble(text);
        }
        catch (Exception e) {
            number = 0.0;
        }
        return df.format(number);
    }

    public static String decode(String encryptLevel, String encryptType, List<String> secretKeyList, String content) {
        MultiEncryptNewService service = SalarySlipHelper.getEncryptService(encryptLevel, encryptType);
        return SalarySlipHelper.decode(service, secretKeyList, content);
    }

    public static MultiEncryptNewService getEncryptService(String encryptLevel, String encryptType) {
        EncryptTypeEnum encryptTypeEnum = EncryptTypeEnum.getEncryptTypeEnumByCode((String)encryptType);
        EncryptLevelEnum encryptLevelEnum = EncryptLevelEnum.getEncryptLevelEnumByCode((String)encryptLevel);
        return new MultiEncryptNewService(encryptTypeEnum, encryptLevelEnum);
    }

    public static String decode(MultiEncryptNewService service, List<String> secretKeyList, String content) {
        return service.decode(secretKeyList, content);
    }

    public static void updateView(IFormView currentView, IFormView targetView, Boolean isEncrypt, Boolean isConfirm) {
        OperateOption operation = OperateOption.create();
        operation.setVariableValue("isEncrypt", isEncrypt == null ? "" : String.valueOf(isEncrypt));
        operation.setVariableValue("isConfirm", isConfirm == null ? "" : String.valueOf(isConfirm));
        targetView.invokeOperation("updatedata", operation);
        currentView.sendFormAction(targetView);
    }

    public static Map<String, String> getBankLogoMapOfRelativePath() {
        Map bankLogoMap = SWCBankCardConstants.getBankLogoMap();
        HashMap<String, String> newBankLogoMap = new HashMap<String, String>(16);
        if (bankLogoMap != null) {
            for (Map.Entry next : bankLogoMap.entrySet()) {
                if (next == null) continue;
                String path = (String)next.getValue();
                String key = (String)next.getKey();
                if (!SWCStringUtils.isNotEmpty((String)path) || !path.startsWith("/")) continue;
                String newPath = path.replaceFirst("/", "");
                newBankLogoMap.put(key, newPath);
            }
        }
        return newBankLogoMap;
    }

    public static Tuple<Boolean, StructureSalaryDTO> getSalarySlipData(SalaryCalendarModel salaryCalendarModel) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_salaryslipdetail");
        String encryptKey = salaryCalendarModel.getEncryptKey();
        QFilter qFilter = new QFilter("encrykey", "=", (Object)encryptKey);
        DynamicObject slipObject = helper.queryOriginalOne("salaryslipdata", new QFilter[]{qFilter}, "createtime desc");
        if (slipObject == null) {
            return new Tuple((Object)Boolean.TRUE, null);
        }
        String slipData = slipObject.getString("salaryslipdata");
        if (SWCStringUtils.isEmpty((String)slipData)) {
            return new Tuple((Object)Boolean.TRUE, null);
        }
        SalarySlipEncryModel salarySlipEncryModel = salaryCalendarModel.getSalarySlipEncryModel();
        String encryptType = salarySlipEncryModel.getEncryptType();
        String encryptLevel = salarySlipEncryModel.getEncryptLevel();
        slipData = SalarySlipHelper.decode(encryptLevel, encryptType, salarySlipEncryModel.getSecretKeyList(), slipData);
        String string = slipData = salarySlipEncryModel.getCompress() != false ? CompressUtils.uncompress((String)slipData) : slipData;
        if (SWCStringUtils.isEmpty((String)slipData)) {
            return new Tuple((Object)Boolean.FALSE, null);
        }
        return new Tuple((Object)Boolean.TRUE, JSON.parseObject((String)slipData, StructureSalaryDTO.class));
    }

    public static void setHeadSummaryData(IFormView view, List<SalarySumDetailVO> summaryDetailList) {
        int index;
        if (summaryDetailList.isEmpty() || summaryDetailList.stream().noneMatch(SalarySumDetailVO::getShow)) {
            view.setVisible(Boolean.FALSE, new String[]{"flexsumall"});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{"flexsumall"});
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        map.put("vi", Boolean.TRUE);
        ArrayList<String> flexList = new ArrayList<String>(summaryDetailList.size());
        for (index = 0; index < summaryDetailList.size(); ++index) {
            SalarySumDetailVO sumDetail = summaryDetailList.get(index);
            if (!sumDetail.getShow().booleanValue()) {
                view.setVisible(Boolean.FALSE, new String[]{"flexsum" + index});
                ShowPageUtils.setLabelValue((IFormView)view, (String)("salarysum" + index), (String)"");
                continue;
            }
            String flexKey = "flexsum" + index;
            flexList.add(flexKey);
            view.updateControlMetadata(flexKey, map);
            String name = sumDetail.getName();
            if (SWCStringUtils.isNotEmpty((String)name)) {
                ShowPageUtils.setLabelValue((IFormView)view, (String)("labsum" + index), (String)name);
            }
            ShowPageUtils.setLabelValue((IFormView)view, (String)("salarysum" + index), (String)sumDetail.getPay());
        }
        for (index = summaryDetailList.size(); index < 10; ++index) {
            view.setVisible(Boolean.FALSE, new String[]{"flexsum" + index});
            ShowPageUtils.setLabelValue((IFormView)view, (String)("labsum" + index), (String)"");
            ShowPageUtils.setLabelValue((IFormView)view, (String)("salarysum" + index), (String)"");
        }
        view.setVisible(Boolean.TRUE, flexList.toArray(new String[0]));
    }

    public static ApiResult querySalarySlipDetail(Map<String, Object> paramMap) throws Exception {
        Long personId = (Long)paramMap.getOrDefault(PERSONID, 0L);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_personhr");
        DynamicObject personHr = helper.queryOne("id,personindexid", new QFilter[]{new QFilter("id", "=", (Object)personId)});
        if (personHr == null) {
            return SalarySlipHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40023);
        }
        Map verifyCert = SWCCertCommonHelper.verifyCert((String)"/US+X3ECAB+C", (String)"hspp_mobilesalarycal", Collections.singletonList(personHr.getLong("personindexid")));
        Boolean result = Optional.ofNullable(verifyCert).map(cert -> (Boolean)cert.get("result")).orElse(Boolean.FALSE);
        if (!result.booleanValue()) {
            return SalarySlipHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40023);
        }
        String startDateString = String.valueOf(paramMap.getOrDefault(STARTDATE, ""));
        String endDateString = String.valueOf(paramMap.getOrDefault(ENDDATE, ""));
        Date startDate = SWCDateTimeUtils.parseDate((String)startDateString, (String)"yyyy-MM-dd HH:mm:ss");
        Date endDate = SWCDateTimeUtils.parseDate((String)endDateString, (String)"yyyy-MM-dd HH:mm:ss");
        if (endDate.before(startDate)) {
            return SalarySlipHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40021);
        }
        String queryDate = String.valueOf(paramMap.getOrDefault("queryDate", "releasetime"));
        ContextHolder.init(startDate, endDate);
        ContextHolder.setPersonId(personId);
        ContextHolder.setQueryDate(queryDate);
        Map<Long, SalaryCalendarModel> salaryCalendarModelMap = ContextHolder.getSalaryCalendarModelMap();
        SalarySlipHelper.setCalendarValue(salaryCalendarModelMap, queryDate);
        List<SalarySlipSumDetailModel> salarySlipDetailList = ContextHolder.getSalarySlipSumDetailModelList();
        SalarySlipHelper.setDetailValue(salarySlipDetailList);
        JSONArray array = new JSONArray();
        SimplePropertyPreFilter calendarFilter = new SimplePropertyPreFilter(new String[0]);
        calendarFilter.getExcludes().addAll(Arrays.asList("calCount", "paymentSubject", "primary", "salarySlipEncryModel", "encryptKey", "showPayFlow"));
        PropertyFilter detailFilter = (object, name, value) -> {
            if (object instanceof SalarySlipSumDetailModel && ("releaseTime".equals(name) || "calCurrencyId".equals(name))) {
                return false;
            }
            return !(object instanceof SalaryItemInfoDTO) || !"boolValue".equals(name);
        };
        salarySlipDetailList.forEach(detailModel -> {
            String calendarId = detailModel.getCalendarId();
            SalaryCalendarModel calendarModel = (SalaryCalendarModel)salaryCalendarModelMap.get(Long.parseLong(calendarId));
            JSONObject data = new JSONObject();
            data.put("calendar", JSON.parse((String)JSON.toJSONString((Object)calendarModel, (SerializeFilter)calendarFilter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty})));
            data.put("detail", JSON.parse((String)JSON.toJSONString((Object)detailModel, (SerializeFilter)detailFilter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty})));
            array.add((Object)data);
        });
        JSONObject json = new JSONObject();
        json.put("totalNum", (Object)array.size());
        json.put("salarySlip", (Object)array);
        ContextHolder.destory();
        return ApiResult.success((Object)json);
    }

    public static ApiResult querySalarySlipSumView(Map<String, Object> paramMap) {
        Long personId = (Long)paramMap.getOrDefault(PERSONID, 0L);
        String queryDate = String.valueOf(paramMap.getOrDefault("queryDate", "releasetime"));
        ContextHolder.init(null, null);
        ContextHolder.setPersonId(personId);
        ContextHolder.setQueryDate(queryDate);
        Map<Long, Set<Long>> sumViewCalendarMap = ContextHolder.getSumViewCalendarMap();
        Map<String, String> sumViewIdNameMap = SalarySlipHelper.getSumViewIdNameMap(sumViewCalendarMap.keySet());
        JSONArray array = new JSONArray();
        sumViewIdNameMap.forEach((id, name) -> {
            JSONObject json = new JSONObject();
            json.put("id", (Object)Long.parseLong(id));
            json.put("name", name);
            array.add((Object)json);
        });
        ContextHolder.destory();
        return ApiResult.success((Object)array);
    }

    public static Map<String, String> getSumViewIdNameMap(Set<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salslipsumview");
        QFilter filter = new QFilter("id", "in", ids);
        filter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObjectCollection sumViewCol = helper.queryOriginalCollection("id,name", new QFilter[]{filter});
        return sumViewCol.stream().collect(Collectors.toMap(data -> data.getString("id"), data -> data.getString("name")));
    }

    public static ApiResult querySalarySlipSumDetail(Map<String, Object> paramMap) throws Exception {
        Long personId = (Long)paramMap.getOrDefault(PERSONID, 0L);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_personhr");
        DynamicObject personHr = helper.queryOne("id,personindexid", new QFilter[]{new QFilter("id", "=", (Object)personId)});
        if (personHr == null) {
            return SalarySlipHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40023);
        }
        Map verifyCert = SWCCertCommonHelper.verifyCert((String)"/US+X3ECAB+C", (String)"hspp_salaryslipdetailsum", Collections.singletonList(personHr.getLong("personindexid")));
        Boolean result = Optional.ofNullable(verifyCert).map(cert -> (Boolean)cert.get("result")).orElse(Boolean.FALSE);
        if (!result.booleanValue()) {
            return SalarySlipHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40023);
        }
        String startDateString = String.valueOf(paramMap.getOrDefault(STARTDATE, ""));
        String endDateString = String.valueOf(paramMap.getOrDefault(ENDDATE, ""));
        Date startDate = SWCDateTimeUtils.parseDate((String)startDateString, (String)"yyyy-MM-dd HH:mm:ss");
        Date endDate = SWCDateTimeUtils.parseDate((String)endDateString, (String)"yyyy-MM-dd HH:mm:ss");
        if (endDate.before(startDate)) {
            return SalarySlipHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40021);
        }
        Long sumViewId = (Long)paramMap.getOrDefault(SUMVIEWID, 0L);
        ContextHolder.init(startDate, endDate);
        ContextHolder.setPersonId(personId);
        String queryDate = String.valueOf(paramMap.getOrDefault("queryDate", "releasetime"));
        ContextHolder.setQueryDate(queryDate);
        Map<Long, Set<Long>> sumViewCalendarMap = ContextHolder.getSumViewCalendarMap();
        if (!sumViewCalendarMap.containsKey(sumViewId)) {
            return SalarySlipHelper.getApiResult(SalarySlipApiResultStatusEnum.ERROR_40024);
        }
        ContextHolder.setCalendarSet(sumViewCalendarMap.getOrDefault(sumViewId, (Set<Long>)new HashSet<Long>(1){
            private static final long serialVersionUID = -2218310769202743139L;
            {
                this.add(0L);
            }
        }));
        List<SalarySlipSumDetailModel> salarySlipSumDetailModelList = ContextHolder.getSalarySlipSumDetailModelList();
        if (salarySlipSumDetailModelList.isEmpty()) {
            return ApiResult.success(null);
        }
        Map<Long, SalaryCalendarModel> salaryCalendarModelMap = ContextHolder.getSalaryCalendarModelMap();
        Map<Long, DynamicObject> currencyMap = ContextHolder.getCurrencyMap();
        SalarySlipSumDataService dataService = new SalarySlipSumDataService(salarySlipSumDetailModelList, salaryCalendarModelMap, currencyMap, sumViewId);
        SalarySlipDataSdkModel slipDataSdkModel = dataService.getSalarySlipDataSdkModel();
        ContextHolder.destory();
        PropertyFilter detailFilter = (object, name, value) -> !(object instanceof SalarySlipDataGroupSdkModel) || !"dataDetailList".equals(name);
        return ApiResult.success((Object)JSON.parse((String)JSON.toJSONString((Object)slipDataSdkModel, (SerializeFilter)detailFilter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty})));
    }

    private static void setCalendarValue(Map<Long, SalaryCalendarModel> salaryCalendarModelMap, String queryDate) {
        DynamicObject[] dynamicObjects;
        Map<Long, DynamicObject> currencyMap = ContextHolder.getCurrencyMap();
        Map<Long, DynamicObject> salarySlipViewMap = ContextHolder.getSalarySlipViewMap();
        for (DynamicObject dynamicObject : dynamicObjects = ContextHolder.getSalarySlipStatus()) {
            DynamicObject currency;
            Date queryTime = dynamicObject.getDate("salarycalendar." + queryDate);
            int queryMonth = SWCDateTimeUtils.getMonth((Date)queryTime);
            SalaryCalendarModel salaryCalendarModel = salaryCalendarModelMap.get(dynamicObject.getLong("salarycalendar.id"));
            salaryCalendarModel.setMonth(String.valueOf(queryMonth));
            DynamicObject salaryViewV = salarySlipViewMap.get(dynamicObject.getLong("salarycalendar.salaryviewv.id"));
            if (salaryViewV != null) {
                boolean isNeedConfirm = salaryViewV.getBoolean("isneedconfirm");
                salaryCalendarModel.setNeedConfirm(isNeedConfirm);
                salaryCalendarModel.setSalarySlipViewVersionId(Long.valueOf(salaryViewV.getLong("id")));
            }
            if ((currency = currencyMap.get(salaryCalendarModel.getCalCurrencyId())) == null) continue;
            salaryCalendarModel.setCalSign(currency.getString("sign"));
            salaryCalendarModel.setScale(currency.getInt("amtprecision"));
        }
    }

    private static void setDetailValue(List<SalarySlipSumDetailModel> salarySlipDetailList) {
        HashSet salaryItemIdSet = new HashSet(16);
        salarySlipDetailList.forEach(detailModel -> {
            List salaryItemInfoList = detailModel.getSalaryItemInfoList();
            salaryItemInfoList.forEach(salaryItemInfo -> salaryItemIdSet.add(salaryItemInfo.getSalaryItemId()));
        });
        QFilter itemFilter = new QFilter("id", "in", salaryItemIdSet);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        DynamicObject[] itemObjects = helper.queryOriginalArray("id,number,name,ispayoutitem,datatype.showtype", new QFilter[]{itemFilter});
        HashMap<Long, DynamicObject> itemMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject salaryItem : itemObjects) {
            itemMap.put(salaryItem.getLong("id"), salaryItem);
        }
        salarySlipDetailList.forEach(detailModel -> {
            List salaryItemInfoList = detailModel.getSalaryItemInfoList();
            salaryItemInfoList.forEach(salaryItemInfo -> {
                DynamicObject salaryItemDy = (DynamicObject)itemMap.get(salaryItemInfo.getSalaryItemId());
                if (salaryItemDy != null) {
                    salaryItemInfo.setShowType(salaryItemDy.getString("datatype.showtype"));
                }
            });
        });
    }

    private static ApiResult getApiResult(SalarySlipApiResultStatusEnum statusEnum) {
        return ApiResult.fail((String)statusEnum.getI18nParamString(), (String)String.valueOf(statusEnum.getCode()));
    }
}

